/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors.api.resource;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midp.actions.GoToSourceSupport;
import org.netbeans.modules.vmd.midp.propertyeditors.CleanUp;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.UserCodeAwareness;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.UserCodeCardPanel;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElementEvent;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElementListener;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResourceEditorPanel
extends JPanel
implements PropertyEditorResourceElementListener,
ListSelectionListener,
ActionListener,
UserCodeAwareness,
CleanUp {
    private static final String ACTION_ADD_RESOURCE = "addResource";
    private static final String ACTION_REMOVE_RESOURCE = "removeResource";
    private static final String COMPONENT_CARD = "componentCard";
    private static final String USER_CODE_CARD = "userCodeCard";
    private static long componentIDCounter = -10000L;
    private PropertyEditorResourceElement element;
    private Map<String, PropertyEditorResourceElement.DesignComponentWrapper> wrappersMap;
    private Set<String> changedComponents;
    private String noneComponentAsText;
    private JList componentsList;
    private JRadioButton radioButton;
    private Icon icon;
    private JPanel ucPanel;
    private CardLayout ucCardLayout;

    ResourceEditorPanel(PropertyEditorResourceElement propertyEditorResourceElement, String string, JRadioButton jRadioButton) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Incorrect value of noneComponentAsText: " + string);
        }
        if (propertyEditorResourceElement == null) {
            throw new IllegalArgumentException("PropertyEditorResourceElement shouls not be null");
        }
        if (jRadioButton == null) {
            throw new IllegalArgumentException("Null radioButton value");
        }
        this.element = propertyEditorResourceElement;
        this.noneComponentAsText = string;
        this.radioButton = jRadioButton;
        this.changedComponents = new HashSet<String>();
        this.initComponents(propertyEditorResourceElement.getJComponent());
    }

    @Override
    public void clean(DesignComponent designComponent) {
        if (this.wrappersMap != null) {
            this.wrappersMap.clear();
        }
        this.element = null;
        this.wrappersMap = null;
        this.changedComponents = null;
        this.componentsList = null;
        this.radioButton = null;
        this.icon = null;
        this.ucCardLayout = null;
        this.ucPanel = null;
        this.removeAll();
    }

    private void initComponents(JComponent jComponent) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.componentsList = new JList(new DefaultListModel());
        this.componentsList.setSelectionMode(0);
        this.componentsList.setCellRenderer(new ComponentsListRenderer());
        this.componentsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ResourceEditorPanel.class, (String)"ASCN_ResourcesList"));
        this.componentsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResourceEditorPanel.class, (String)"ASCD_ResourcesList"));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.componentsList);
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)jScrollPane, gridBagConstraints);
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(ResourceEditorPanel.class, (String)"LBL_ADD_COMPONENT"));
        jButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ResourceEditorPanel.class, (String)"ACSN_ADD_COMPONENT"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResourceEditorPanel.class, (String)"ACSD_ADD_COMPONENT"));
        jButton.setActionCommand(ACTION_ADD_RESOURCE);
        jButton.addActionListener(this);
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        this.add((Component)jButton, gridBagConstraints);
        JButton jButton2 = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)NbBundle.getMessage(ResourceEditorPanel.class, (String)"LBL_REMOVE_COMPONENT"));
        jButton2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ResourceEditorPanel.class, (String)"ACSN_REMOVE_COMPONENT"));
        jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResourceEditorPanel.class, (String)"ACSD_REMOVE_COMPONENT"));
        jButton2.setActionCommand(ACTION_REMOVE_RESOURCE);
        jButton2.addActionListener(this);
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        this.add((Component)jButton2, gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)this.createUCAwarePanel(jComponent), gridBagConstraints);
        this.icon = new ImageIcon(ImageUtilities.loadImage((String)this.element.getIconPath()));
        this.componentsList.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                ResourceEditorPanel.this.radioButton.setSelected(true);
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        });
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                ResourceEditorPanel.this.componentsList.removeListSelectionListener(ResourceEditorPanel.this);
                ResourceEditorPanel.this.componentsList.addListSelectionListener(ResourceEditorPanel.this);
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                ResourceEditorPanel.this.componentsList.removeListSelectionListener(ResourceEditorPanel.this);
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
    }

    private JComponent createUCAwarePanel(JComponent jComponent) {
        UserCodeCardPanel userCodeCardPanel = new UserCodeCardPanel(this);
        this.ucCardLayout = new CardLayout();
        this.ucPanel = new JPanel(this.ucCardLayout);
        this.ucPanel.add((Component)jComponent, COMPONENT_CARD);
        this.ucPanel.add((Component)userCodeCardPanel, USER_CODE_CARD);
        return this.ucPanel;
    }

    private void setUserCode(boolean bl) {
        this.ucCardLayout.show(this.ucPanel, bl ? USER_CODE_CARD : COMPONENT_CARD);
    }

    private boolean isUserCodeInside(PropertyEditorResourceElement.DesignComponentWrapper designComponentWrapper) {
        if (designComponentWrapper == null) {
            return false;
        }
        final DesignComponent designComponent = designComponentWrapper.getComponent();
        if (designComponent == null) {
            return false;
        }
        final List<String> list = this.element.getPropertyValueNames();
        final boolean[] blArray = new boolean[1];
        designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

            public void run() {
                for (String string : list) {
                    PropertyValue propertyValue = designComponent.readProperty(string);
                    if (!PropertyValue.Kind.USERCODE.equals((Object)propertyValue.getKind())) continue;
                    blArray[0] = true;
                    break;
                }
            }
        });
        return blArray[0];
    }

    void update(Map<String, DesignComponent> map, String string) {
        this.wrappersMap = new HashMap<String, PropertyEditorResourceElement.DesignComponentWrapper>(map.size());
        for (String string2 : map.keySet()) {
            DesignComponent designComponent = map.get(string2);
            this.wrappersMap.put(string2, new PropertyEditorResourceElement.DesignComponentWrapper(designComponent));
        }
        this.changedComponents.clear();
        this.sortAndSelect(string);
    }

    private void sortAndSelect(String string) {
        DefaultListModel defaultListModel = (DefaultListModel)this.componentsList.getModel();
        defaultListModel.removeAllElements();
        defaultListModel.addElement(this.noneComponentAsText);
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string2 : this.wrappersMap.keySet()) {
            treeSet.add(string2);
        }
        for (String string2 : treeSet) {
            defaultListModel.addElement(string2);
        }
        this.selectComponent(string);
    }

    private void selectComponent(String string) {
        this.componentsList.setSelectedValue(string, false);
        if (this.noneComponentAsText.equals(string)) {
            this.element.setDesignComponentWrapper(null);
        } else {
            this.element.setDesignComponentWrapper(this.wrappersMap.get(string));
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        Object object = this.getSelectedComponentName();
        if (object == null || this.noneComponentAsText.equals(object)) {
            this.element.setDesignComponentWrapper(null);
            this.setUserCode(false);
        } else {
            PropertyEditorResourceElement.DesignComponentWrapper designComponentWrapper = this.wrappersMap.get(object);
            this.element.setDesignComponentWrapper(designComponentWrapper);
            this.setUserCode(this.isUserCodeInside(designComponentWrapper));
        }
        this.element.listSelectionHappened();
    }

    @Override
    public void elementChanged(PropertyEditorResourceElementEvent propertyEditorResourceElementEvent) {
        long l = propertyEditorResourceElementEvent.getComponentID();
        String string = propertyEditorResourceElementEvent.getPropertyName();
        PropertyValue propertyValue = propertyEditorResourceElementEvent.getPropertyValue();
        PropertyEditorResourceElement.DesignComponentWrapper designComponentWrapper = null;
        for (String string2 : this.wrappersMap.keySet()) {
            designComponentWrapper = this.wrappersMap.get(string2);
            if (designComponentWrapper.getComponentID() != l) continue;
            designComponentWrapper.setChangeRecord(string, propertyValue);
            this.changedComponents.add(string2);
            this.componentsList.invalidate();
            this.componentsList.validate();
            this.componentsList.repaint();
            break;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = this.getSelectedComponentName();
        DefaultListModel defaultListModel = (DefaultListModel)this.componentsList.getModel();
        if (ACTION_ADD_RESOURCE.equals(actionEvent.getActionCommand())) {
            String string = this.getNewComponentName();
            PropertyEditorResourceElement.DesignComponentWrapper designComponentWrapper = new PropertyEditorResourceElement.DesignComponentWrapper(componentIDCounter++, this.element.getTypeID());
            this.wrappersMap.put(string, designComponentWrapper);
            defaultListModel.addElement(string);
            this.sortAndSelect(string);
            this.changedComponents.add(string);
        } else if (ACTION_REMOVE_RESOURCE.equals(actionEvent.getActionCommand()) && object != null && !this.noneComponentAsText.equals(object)) {
            this.wrappersMap.get(object).deleteComponent();
            int n = defaultListModel.indexOf(object);
            defaultListModel.removeElement(object);
            this.componentsList.setSelectedIndex(n - 1);
        }
    }

    private String getNewComponentName() {
        String string = this.element.getResourceNameSuggestion();
        Set<String> set = this.wrappersMap.keySet();
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : this.wrappersMap.keySet()) {
            if (!this.wrappersMap.get(string2).isDeleted()) continue;
            hashSet.add(string2);
        }
        Object object = hashSet.iterator();
        while (object.hasNext()) {
            String string2;
            string2 = object.next();
            this.wrappersMap.remove(string2);
        }
        int n = 1;
        while (set.contains(object = string + n)) {
            ++n;
        }
        return object;
    }

    private Object getSelectedComponentName() {
        return this.componentsList.getSelectedValue();
    }

    String getTextForPropertyValue() {
        String string = (String)this.componentsList.getSelectedValue();
        return string != null ? string : "";
    }

    boolean wasAnyDesignComponentChanged() {
        for (String string : this.wrappersMap.keySet()) {
            if (!this.wrappersMap.get(string).hasChanges()) continue;
            return true;
        }
        return false;
    }

    Map<String, PropertyEditorResourceElement.DesignComponentWrapper> getWrappersMap() {
        return Collections.unmodifiableMap(this.wrappersMap);
    }

    boolean needsUpdate() {
        return true;
    }

    @Override
    public void goToSource() {
        PropertyEditorResourceElement.DesignComponentWrapper designComponentWrapper = this.wrappersMap.get(this.getSelectedComponentName());
        if (designComponentWrapper != null && designComponentWrapper.getComponent() != null) {
            GoToSourceSupport.goToSourceOfComponent(designComponentWrapper.getComponent());
        }
    }

    @Override
    public void resetUserCode() {
        PropertyEditorResourceElement.DesignComponentWrapper designComponentWrapper = this.wrappersMap.get(this.getSelectedComponentName());
        if (designComponentWrapper != null && designComponentWrapper.getComponent() != null) {
            final DesignComponent designComponent = designComponentWrapper.getComponent();
            designComponent.getDocument().getTransactionManager().writeAccess(new Runnable(){

                public void run() {
                    List<String> list = ResourceEditorPanel.this.element.getPropertyValueNames();
                    for (String string : list) {
                        PropertyValue propertyValue = designComponent.readProperty(string);
                        if (!PropertyValue.Kind.USERCODE.equals((Object)propertyValue.getKind())) continue;
                        designComponent.writeProperty(string, designComponent.getComponentDescriptor().getPropertyDescriptor(string).getDefaultValue());
                    }
                }
            });
            this.setUserCode(this.isUserCodeInside(designComponentWrapper));
        }
    }

    private class ComponentsListRenderer
    extends DefaultListCellRenderer {
        private Font changedFont;
        private Font defaultFont;

        private ComponentsListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (this.defaultFont == null) {
                this.defaultFont = jLabel.getFont();
                this.changedFont = this.defaultFont.deriveFont(1);
            }
            if (!ResourceEditorPanel.this.noneComponentAsText.equals(object) && ResourceEditorPanel.this.icon != null) {
                jLabel.setIcon(ResourceEditorPanel.this.icon);
            }
            jLabel.setFont(ResourceEditorPanel.this.changedComponents.contains(object) ? this.changedFont : this.defaultFont);
            return jLabel;
        }
    }
}

