/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.sources;

import java.awt.Image;
import java.util.List;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.api.model.presenters.actions.ActionsPresenter;
import org.netbeans.modules.vmd.api.model.presenters.actions.ActionsSupport;
import org.netbeans.modules.vmd.midp.actions.MidpActionsSupport;
import org.netbeans.modules.vmd.midp.codegen.InstanceNameResolver;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.openide.actions.PropertiesAction;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EventSourceSupport {
    private static final InfoPresenter.Resolver COMMAND_EVENT_SOURCE_RESOLVER = new EventSourceResolver("command", true);
    private static final InfoPresenter.Resolver ITEM_COMMAND_EVENT_SOURCE_RESOLVER = new EventSourceResolver("command", true);
    private static final String PROP_COMMAND = "command";

    static InfoPresenter.Resolver createCommandEventSourceInfoResolver() {
        return COMMAND_EVENT_SOURCE_RESOLVER;
    }

    static InfoPresenter.Resolver createItemCommandEventSourceInfoResolver() {
        return ITEM_COMMAND_EVENT_SOURCE_RESOLVER;
    }

    static void addActionsPresentres(List<Presenter> list) {
        for (Presenter presenter : list.toArray(new Presenter[list.size()])) {
            if (presenter instanceof ActionsPresenter) {
                list.remove(presenter);
            }
            if (!(presenter instanceof ActionsPresenter)) continue;
            list.remove(presenter);
        }
        MidpActionsSupport.addCommonActionsPresenters(list, true, true, true, true, false);
        MidpActionsSupport.addMoveActionPresenter(list, "commands");
        list.addAll(ActionsSupport.createByReference((String)PROP_COMMAND, (Class[])new Class[]{PropertiesAction.class}));
    }

    private static class EventSourceResolver
    implements InfoPresenter.Resolver {
        private String propertyName;
        private boolean editable;

        private EventSourceResolver(String string, boolean bl) {
            this.propertyName = string;
            this.editable = bl;
        }

        public DesignEventFilter getEventFilter(DesignComponent designComponent) {
            return new DesignEventFilter(new DesignEventFilter[0]).addDescentFilter(designComponent, this.propertyName);
        }

        public String getDisplayName(DesignComponent designComponent, InfoPresenter.NameType nameType) {
            switch (nameType) {
                case PRIMARY: {
                    return this.resolveName(designComponent);
                }
                case SECONDARY: {
                    return NbBundle.getMessage(EventSourceSupport.class, (String)"TYPE_Command");
                }
                case TERTIARY: {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("<HTML>");
                    stringBuffer.append(this.resolveName(designComponent));
                    stringBuffer.append(" <font color=\"#808080\">[");
                    stringBuffer.append(((InfoPresenter)designComponent.getParentComponent().getPresenter(InfoPresenter.class)).getEditableName());
                    stringBuffer.append("]");
                    return stringBuffer.toString();
                }
            }
            throw Debug.illegalState((Object[])new Object[0]);
        }

        private String resolveName(DesignComponent designComponent) {
            if ((designComponent = designComponent.readProperty(this.propertyName).getComponent()) == null) {
                return null;
            }
            PropertyValue propertyValue = designComponent.readProperty("instanceName");
            if (propertyValue.getKind() == PropertyValue.Kind.VALUE && MidpTypes.TYPEID_JAVA_LANG_STRING.equals((Object)propertyValue.getType())) {
                return (String)propertyValue.getPrimitiveValue();
            }
            throw Debug.error((Object[])new Object[]{"Invalid instance name", propertyValue, "for component", designComponent});
        }

        public boolean isEditable(DesignComponent designComponent) {
            return this.editable;
        }

        public String getEditableName(DesignComponent designComponent) {
            DesignComponent designComponent2 = designComponent.readProperty(EventSourceSupport.PROP_COMMAND).getComponent();
            if (designComponent2 == null || designComponent2.readProperty("instanceName") == null) {
                Debug.warning((Object[])new Object[]{"EventSource referenced " + designComponent.toString() + " is null "});
                return null;
            }
            String string = (String)designComponent2.readProperty("instanceName").getPrimitiveValue();
            return string;
        }

        public void setEditableName(DesignComponent designComponent, String string) {
            DesignComponent designComponent2 = designComponent.readProperty(EventSourceSupport.PROP_COMMAND).getComponent();
            PropertyValue propertyValue = InstanceNameResolver.createFromSuggested(designComponent2, string);
            designComponent2.writeProperty("instanceName", propertyValue);
        }

        public Image getIcon(DesignComponent designComponent, InfoPresenter.IconType iconType) {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/vmd/midp/resources/components/command_16.png");
        }
    }
}

