/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.model;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import org.netbeans.modules.css.editor.model.CssRuleContent;
import org.netbeans.modules.css.visual.model.CssProperties;
import org.netbeans.modules.css.visual.model.Utils;
import org.openide.util.NbBundle;

public class FontModel {
    Map<String, List<String>> fontFamilyNames = new HashMap<String, List<String>>();
    List<String> fontFaceNames = new ArrayList<String>();

    public FontModel() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fontArray = graphicsEnvironment.getAllFonts();
        for (int i = 0; i < fontArray.length; ++i) {
            String string = fontArray[i].getFamily();
            String string2 = fontArray[i].getName();
            List<String> list = this.fontFamilyNames.get(string);
            if (list == null) {
                list = new ArrayList<String>();
                this.fontFamilyNames.put(string, list);
            }
            list.add(string2);
            this.fontFaceNames.add(string2);
        }
    }

    public DefaultListModel getFontFamilySetList() {
        return new FontFamilySetList();
    }

    public DefaultListModel getFontList() {
        return new FontList();
    }

    public DefaultListModel getWebFontList() {
        return new WebFontList();
    }

    public DefaultListModel getFontFamilyList() {
        return new FontFamilyList();
    }

    public DefaultListModel getFontSizeList() {
        return new FontSizeList();
    }

    public DefaultComboBoxModel getFontSizeUnitList() {
        return new FontSizeUnitList();
    }

    public DefaultComboBoxModel getFontStyleList() {
        return new FontStyleList();
    }

    public DefaultComboBoxModel getFontSelectionList() {
        return new FontSelectionList();
    }

    public DefaultComboBoxModel getFontWeightList() {
        return new FontWeightList();
    }

    public DefaultComboBoxModel getFontVariantList() {
        return new FontVariantList();
    }

    public FontSize getFontSize(String string) {
        return new FontSize(string);
    }

    public Font resolveFont(CssRuleContent cssRuleContent, Font font) {
        String string = cssRuleContent.getProperty("font-family");
        String string2 = cssRuleContent.getProperty("font-size");
        String string3 = cssRuleContent.getProperty("font-style");
        String string4 = cssRuleContent.getProperty("font-variant");
        String string5 = cssRuleContent.getProperty("font-weight");
        String string6 = this.resolveFontName(string, font.getName());
        int n = this.resolveFontStyle(string3, string5, font.getStyle());
        int n2 = this.resolveFontSize(string2, font.getSize());
        return new Font(string6, n, n2);
    }

    private String resolveFontName(String string, String string2) {
        String string3 = string2;
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (this.fontFamilyNames.containsKey(string4 = string4.replaceAll("'", ""))) {
                    List<String> list = this.fontFamilyNames.get(string4);
                    string3 = list.get(0);
                    continue;
                }
                if (!this.fontFaceNames.contains(string4)) continue;
                string3 = string4;
            }
        }
        return string3;
    }

    private int resolveFontStyle(String string, String string2, int n) {
        int n2 = n;
        if (string != null && (string.equals("italic") || string.equals("oblique"))) {
            n2 = 2;
        }
        if (string2 != null && string2.equals(string2)) {
            n2 |= 1;
        }
        return n2;
    }

    private int resolveFontSize(String string, int n) {
        int n2 = n;
        if (string != null) {
            FontSize fontSize = new FontSize(string);
            String string2 = fontSize.getValue();
            if (Utils.isInteger(string2)) {
                n2 = Utils.getInteger(string2);
            } else {
                if (string2.equals("XX-small")) {
                    n2 = 4;
                }
                if (string2.equals("X-small")) {
                    n2 = 6;
                }
                if (string2.equals("small")) {
                    n2 = 8;
                }
                if (string2.equals("medium")) {
                    n2 = 12;
                }
                if (string2.equals("large")) {
                    n2 = 14;
                }
                if (string2.equals("X-large")) {
                    n2 = 16;
                }
                if (string2.equals("XX-large")) {
                    n2 = 20;
                }
            }
            if (n2 < 4) {
                n2 = 4;
            } else if (n2 > 72) {
                n2 = 72;
            }
        }
        return n2;
    }

    public static class FontVariantList
    extends DefaultComboBoxModel {
        public FontVariantList() {
            String[] stringArray = CssProperties.getCssPropertyValues("font-variant");
            this.addElement(CssRuleContent.NOT_SET);
            for (int i = 0; i < stringArray.length; ++i) {
                this.addElement(stringArray[i]);
            }
        }
    }

    public static class FontWeightList
    extends DefaultComboBoxModel {
        public FontWeightList() {
            String[] stringArray = CssProperties.getCssPropertyValues("font-weight");
            this.addElement(CssRuleContent.NOT_SET);
            for (int i = 0; i < stringArray.length; ++i) {
                this.addElement(stringArray[i]);
            }
            this.setSelectedItem("px");
        }
    }

    public static class FontStyleList
    extends DefaultComboBoxModel {
        public FontStyleList() {
            String[] stringArray = CssProperties.getCssPropertyValues("font-style");
            this.addElement(CssRuleContent.NOT_SET);
            for (int i = 0; i < stringArray.length; ++i) {
                this.addElement(stringArray[i]);
            }
        }
    }

    public static class FontSizeUnitList
    extends DefaultComboBoxModel {
        public FontSizeUnitList() {
            String[] stringArray = CssProperties.getCssLengthUnits();
            for (int i = 0; i < stringArray.length; ++i) {
                this.addElement(stringArray[i]);
            }
        }
    }

    public static class FontSizeList
    extends DefaultListModel {
        public FontSizeList() {
            this.addElement(CssRuleContent.NOT_SET);
            String[] stringArray = CssProperties.getFontSizeValues();
            for (int i = 0; i < stringArray.length; ++i) {
                this.addElement(stringArray[i]);
            }
        }
    }

    public static class FontFamilySetList
    extends DefaultListModel {
        public FontFamilySetList() {
            this.addElement(CssRuleContent.NOT_SET);
            String[] stringArray = CssProperties.getFontFamilySetValues();
            for (int i = 0; i < stringArray.length; ++i) {
                this.addElement(stringArray[i]);
            }
        }
    }

    public static class FontFamilyList
    extends DefaultListModel {
        public FontFamilyList() {
            this.addElement(CssRuleContent.NOT_SET);
            String[] stringArray = CssProperties.getFontFamilyValues();
            for (int i = 0; i < stringArray.length; ++i) {
                this.addElement(stringArray[i]);
            }
        }
    }

    public static class WebFontList
    extends DefaultListModel {
        public WebFontList() {
            this.addElement(CssRuleContent.NOT_SET);
            String[] stringArray = CssProperties.getWebFontValues();
            for (int i = 0; i < stringArray.length; ++i) {
                this.addElement(stringArray[i]);
            }
        }
    }

    public static class FontList
    extends DefaultListModel {
        public FontList() {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
            for (int i = 0; i < stringArray.length; ++i) {
                this.addElement(stringArray[i]);
            }
        }
    }

    public static class FontSelectionList
    extends DefaultComboBoxModel {
        public FontSelectionList() {
            this.addElement(NbBundle.getMessage(FontModel.class, (String)"FONTS"));
            this.addElement(NbBundle.getMessage(FontModel.class, (String)"FONT_FAMILIES"));
            this.addElement(NbBundle.getMessage(FontModel.class, (String)"WEB_FONTS"));
        }
    }

    public class FontSize {
        FontSizeUnitList unitList = new FontSizeUnitList();
        String fontSizeUnit = null;
        String fontSize = null;

        public FontSize(String string) {
            this.fontSize = string.trim();
            for (int i = 0; i < this.unitList.getSize(); ++i) {
                String string2 = (String)this.unitList.getElementAt(i);
                if (!this.fontSize.endsWith(string2)) continue;
                this.fontSizeUnit = string2;
                this.fontSize = this.fontSize.replaceAll(string2, "");
            }
        }

        public String getUnit() {
            return this.fontSizeUnit;
        }

        public String getValue() {
            if (Utils.isFloat(this.fontSize)) {
                return this.fontSize;
            }
            return null;
        }
    }
}

