/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.refactoring.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringCustomUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactory;
import org.netbeans.modules.xml.nbprefuse.AnalysisViewer;
import org.netbeans.modules.xml.nbprefuse.View;
import org.netbeans.modules.xml.refactoring.XMLRefactoringTransaction;
import org.netbeans.modules.xml.refactoring.ui.FileRenameRefactoringUI;
import org.netbeans.modules.xml.refactoring.ui.GraphHelper;
import org.netbeans.modules.xml.refactoring.ui.MoveFilePanel;
import org.netbeans.modules.xml.refactoring.ui.WhereUsedQueryUI;
import org.netbeans.modules.xml.refactoring.ui.views.WhereUsedView;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Referenceable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import prefuse.data.Graph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveRefactoringUI
implements RefactoringUI,
RefactoringCustomUI {
    private MoveFilePanel panel;
    private MoveRefactoring refactoring;
    private FileObject targetFile;
    private String oldFileName;
    private Project srcProject;
    private Model target;
    private boolean disable;
    private String targetPkgName = "";

    public MoveRefactoringUI(Model model) {
        this.target = model;
        this.refactoring = new MoveRefactoring(Lookups.singleton((Object)model));
        XMLRefactoringTransaction xMLRefactoringTransaction = new XMLRefactoringTransaction((Referenceable)model, (AbstractRefactoring)this.refactoring);
        this.refactoring.getContext().add((Object)xMLRefactoringTransaction);
        this.targetFile = (FileObject)model.getModelSource().getLookup().lookup(FileObject.class);
        this.srcProject = FileOwnerQuery.getOwner((FileObject)this.targetFile);
        this.oldFileName = this.targetFile.getName();
        try {
            URL uRL = this.targetFile.getParent().getURL();
            this.refactoring.getContext().add((Object)new URL(uRL.toExternalForm()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getName() {
        return new MessageFormat(NbBundle.getMessage(FileRenameRefactoringUI.class, (String)"LBL_FileMove")).format(new Object[]{this.oldFileName});
    }

    public String getDescription() {
        return new MessageFormat(NbBundle.getMessage(FileRenameRefactoringUI.class, (String)"DSC_FileMove")).format(new Object[]{this.oldFileName, this.packageName()});
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener changeListener) {
        if (this.panel == null) {
            String string = this.targetFile.getParent().getName();
            this.panel = new MoveFilePanel(changeListener, string, new MessageFormat(NbBundle.getMessage(MoveFilePanel.class, (String)"LBL_FileMove")).format(new Object[]{this.oldFileName}), this.targetFile);
            this.panel.setCombosEnabled(!this.disable);
        }
        return this.panel;
    }

    private Problem setParameters(boolean bl) {
        if (this.panel == null) {
            return null;
        }
        this.targetPkgName = this.panel.getPackageName();
        URL uRL = URLMapper.findURL((FileObject)this.panel.getRootFolder(), (int)1);
        try {
            this.refactoring.setTarget(Lookups.singleton((Object)new URL(uRL.toExternalForm() + URLEncoder.encode(this.panel.getPackageName().replace('.', '/')))));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        if (bl) {
            return this.refactoring.fastCheckParameters();
        }
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        return this.setParameters(true);
    }

    public Problem setParameters() {
        return this.setParameters(false);
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(MoveRefactoringUI.class);
    }

    private String packageName() {
        return this.targetPkgName.trim().length() == 0 ? NbBundle.getMessage(MoveRefactoringUI.class, (String)"LBL_DefaultPackage") : this.targetPkgName.trim();
    }

    public Component getCustomComponent(Collection<RefactoringElement> collection) {
        RefactoringElement refactoringElement2;
        WhereUsedView whereUsedView = new WhereUsedView((Referenceable)this.target);
        GraphHelper graphHelper = new GraphHelper((Referenceable)this.target);
        ArrayList<TreeElement> arrayList = new ArrayList<TreeElement>();
        for (RefactoringElement refactoringElement2 : collection) {
            TreeElement treeElement = TreeElementFactory.getTreeElement((Object)refactoringElement2);
            if (treeElement == null) continue;
            arrayList.add(treeElement);
        }
        Graph graph = graphHelper.loadGraph(arrayList);
        whereUsedView.setGraph(graph);
        refactoringElement2 = new AnalysisViewer();
        refactoringElement2.setCurrentView((View)whereUsedView);
        refactoringElement2.getPanel().setMinimumSize(new Dimension(10, 10));
        refactoringElement2.getPanel().setPreferredSize(new Dimension(10, 10));
        whereUsedView.showView((AnalysisViewer)refactoringElement2);
        return refactoringElement2.getPanel();
    }

    public Icon getCustomIcon() {
        return new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/xml/refactoring/resources/graphical_view_refactoring.png"));
    }

    public String getCustomToolTip() {
        return NbBundle.getMessage(WhereUsedQueryUI.class, (String)"LBL_ShowGraph");
    }
}

