/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.refactoring.spi;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.netbeans.modules.xml.refactoring.CannotRefactorException;
import org.netbeans.modules.xml.refactoring.ErrorItem;
import org.netbeans.modules.xml.refactoring.XMLRefactoringTransaction;
import org.netbeans.modules.xml.refactoring.spi.RefactoringUtil;
import org.netbeans.modules.xml.refactoring.ui.DeleteRefactoringUI;
import org.netbeans.modules.xml.refactoring.ui.FileRenameRefactoringUI;
import org.netbeans.modules.xml.refactoring.ui.ModelProvider;
import org.netbeans.modules.xml.refactoring.ui.ReferenceableProvider;
import org.netbeans.modules.xml.refactoring.ui.RenameRefactoringUI;
import org.netbeans.modules.xml.retriever.catalog.ProjectCatalogSupport;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.EmbeddableRoot;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Nameable;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.NamedReferenceable;
import org.netbeans.modules.xml.xam.Referenceable;
import org.netbeans.modules.xml.xam.dom.DocumentModel;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedUtils {
    public static final String WSDL_MIME_TYPE = "text/xml-wsdl";
    public static final String SOURCES_TYPE_XML = "xml";
    public static final String SOURCES_TYPE_JAVA = "java";
    public static final String TYPE_DOC_ROOT = "doc_root";
    public static final String TYPE_WEB_INF = "web_inf";
    private static String[] sourceTypes = new String[]{"xml", "java", "doc_root", "web_inf"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameTarget(Nameable nameable, String string) throws IOException {
        if (nameable.getModel() == null) {
            return;
        }
        Model model = nameable.getModel();
        boolean bl = !model.isIntransaction();
        try {
            if (bl) {
                model.startTransaction();
            }
            nameable.setName(string);
        }
        finally {
            if (bl && model.isIntransaction()) {
                model.endTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteTarget(NamedReferenceable namedReferenceable) throws IOException {
        if (namedReferenceable == null || SharedUtils.getModel((Referenceable)namedReferenceable) == null) {
            return;
        }
        Model model = SharedUtils.getModel((Referenceable)namedReferenceable);
        boolean bl = !model.isIntransaction();
        try {
            if (bl) {
                model.startTransaction();
            }
            model.removeChildComponent((Component)namedReferenceable);
        }
        finally {
            if (bl && model.isIntransaction()) {
                model.endTransaction();
            }
        }
    }

    public static List<ErrorItem> addCascadeDeleteErrors(List<Model> list, Class<? extends Model> clazz) {
        ArrayList<ErrorItem> arrayList = new ArrayList<ErrorItem>();
        for (Model model : list) {
            if (!clazz.isAssignableFrom(model.getClass())) continue;
            String string = NbBundle.getMessage(RefactoringUtil.class, (String)"MSG_CascadeDeleteNotSupported");
            arrayList.add(new ErrorItem(model, string));
        }
        return arrayList;
    }

    public static boolean isWritable(FileObject fileObject) {
        boolean bl;
        block2: {
            bl = false;
            FileLock fileLock = null;
            try {
                fileLock = fileObject.lock();
                bl = true;
            }
            catch (IOException iOException) {
                if (fileLock == null) break block2;
                fileLock.releaseLock();
            }
        }
        return fileObject != null && fileObject.canWrite() && bl;
    }

    public static String getURI(FileObject fileObject) {
        return FileUtil.toFile((FileObject)fileObject).toURI().toString();
    }

    public static ProjectCatalogSupport getCatalogSupport(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null) {
            return (ProjectCatalogSupport)project.getLookup().lookup(ProjectCatalogSupport.class);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject renameFile(FileObject fileObject, String string) throws IOException {
        String string2 = fileObject.getExt();
        FileLock fileLock = null;
        try {
            fileLock = fileObject.lock();
            fileObject.rename(fileLock, string, string2);
            FileObject fileObject2 = fileObject;
            return fileObject2;
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
    }

    public static FileObject moveFile(FileObject fileObject, FileObject fileObject2) throws IOException {
        if (fileObject != null) {
            return FileUtil.moveFile((FileObject)fileObject, (FileObject)fileObject2, (String)fileObject.getName());
        }
        return null;
    }

    public static FileObject copyFile(FileObject fileObject, FileObject fileObject2, String string) throws IOException {
        if (fileObject != null) {
            return FileUtil.copyFile((FileObject)fileObject, (FileObject)fileObject2, (String)string);
        }
        return null;
    }

    protected static List<SourceGroup> getSourceGroups(Referenceable referenceable) {
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
        Project project = RefactoringUtil.findCurrentProject(referenceable);
        if (project != null) {
            arrayList.addAll(RefactoringUtil.findSourceRoots(project));
            Set<Project> set = RefactoringUtil.getReferencingProjects(project);
            for (Project project2 : set) {
                arrayList.addAll(RefactoringUtil.findSourceRoots(project2));
            }
        }
        return arrayList;
    }

    public static Set<FileObject> getSearchFiles(Referenceable referenceable) {
        SourceGroup sourceGroup2;
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        for (SourceGroup sourceGroup2 : SharedUtils.getSourceGroups(referenceable)) {
            hashSet.addAll(RefactoringUtil.findSourceFiles(sourceGroup2.getRootFolder()));
        }
        Model model = null;
        if (referenceable instanceof Model) {
            model = (Model)referenceable;
        } else if (referenceable instanceof Component) {
            model = ((Component)referenceable).getModel();
        }
        sourceGroup2 = RefactoringUtil.getDataObject(model);
        if (sourceGroup2 != null) {
            hashSet.add(sourceGroup2.getPrimaryFile());
        }
        return hashSet;
    }

    public static Model getModel(Referenceable referenceable) {
        if (referenceable instanceof Model) {
            return (Model)referenceable;
        }
        if (referenceable instanceof Component) {
            return ((Component)referenceable).getModel();
        }
        return null;
    }

    public static String calculateNewLocationString(String string, RenameRefactoring renameRefactoring) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.lastIndexOf(47);
        if (n > -1) {
            stringBuilder.append(string.substring(0, n + 1));
        }
        stringBuilder.append(renameRefactoring.getNewName());
        stringBuilder.append(".");
        Referenceable referenceable = (Referenceable)renameRefactoring.getRefactoringSource().lookup(Referenceable.class);
        Model model = SharedUtils.getModel(referenceable);
        FileObject fileObject = (FileObject)model.getModelSource().getLookup().lookup(FileObject.class);
        stringBuilder.append(fileObject.getExt());
        return stringBuilder.toString();
    }

    public static String calculateNewLocationString(Model model, MoveRefactoring moveRefactoring) throws IOException, URISyntaxException {
        StringBuilder stringBuilder = new StringBuilder();
        URL uRL = (URL)moveRefactoring.getTarget().lookup(URL.class);
        FileObject fileObject = SharedUtils.getOrCreateFolder(uRL);
        FileObject fileObject2 = (FileObject)model.getModelSource().getLookup().lookup(FileObject.class);
        URI uRI = SharedUtils.getReferenceURI(fileObject2, fileObject);
        stringBuilder.append(uRI.toString());
        Referenceable referenceable = (Referenceable)moveRefactoring.getRefactoringSource().lookup(Referenceable.class);
        Model model2 = SharedUtils.getModel(referenceable);
        FileObject fileObject3 = (FileObject)model2.getModelSource().getLookup().lookup(FileObject.class);
        if (!stringBuilder.toString().endsWith("/")) {
            stringBuilder.append("/");
        }
        stringBuilder.append(fileObject3.getNameExt());
        return stringBuilder.toString();
    }

    public static Map<Model, Set<RefactoringElementImplementation>> getModelMap(List<RefactoringElementImplementation> list) {
        HashMap<Model, Set<RefactoringElementImplementation>> hashMap = new HashMap<Model, Set<RefactoringElementImplementation>>();
        for (RefactoringElementImplementation refactoringElementImplementation : list) {
            Model model = ((Component)refactoringElementImplementation.getLookup().lookup(Component.class)).getModel();
            HashSet<RefactoringElementImplementation> hashSet = (HashSet<RefactoringElementImplementation>)hashMap.get(model);
            if (hashSet == null) {
                hashSet = new HashSet<RefactoringElementImplementation>();
                hashSet.add(refactoringElementImplementation);
                hashMap.put(model, hashSet);
                continue;
            }
            hashSet.add(refactoringElementImplementation);
        }
        return hashMap;
    }

    public static void silentDeleteRefactor(NamedReferenceable namedReferenceable, boolean bl) throws CannotRefactorException, IOException {
        SafeDeleteRefactoring safeDeleteRefactoring = new SafeDeleteRefactoring(Lookups.singleton((Object)namedReferenceable));
        XMLRefactoringTransaction xMLRefactoringTransaction = new XMLRefactoringTransaction((Referenceable)namedReferenceable, (AbstractRefactoring)safeDeleteRefactoring);
        xMLRefactoringTransaction.setLocalScope();
        safeDeleteRefactoring.getContext().add((Object)xMLRefactoringTransaction);
        SharedUtils.refactor((AbstractRefactoring)safeDeleteRefactoring, bl);
    }

    public static void silentRename(Nameable nameable, String string, boolean bl) throws CannotRefactorException, IOException {
        RenameRefactoring renameRefactoring = new RenameRefactoring(Lookups.singleton((Object)nameable));
        renameRefactoring.setNewName(string);
        XMLRefactoringTransaction xMLRefactoringTransaction = new XMLRefactoringTransaction((Referenceable)nameable, (AbstractRefactoring)renameRefactoring);
        xMLRefactoringTransaction.setLocalScope();
        renameRefactoring.getContext().add((Object)xMLRefactoringTransaction);
        renameRefactoring.getContext().add((Object)nameable.getName());
        SharedUtils.refactor((AbstractRefactoring)renameRefactoring, bl);
    }

    public static void silentFileRefactor(Model model, String string, boolean bl) throws CannotRefactorException, IOException {
        RenameRefactoring renameRefactoring = new RenameRefactoring(Lookups.singleton((Object)model));
        renameRefactoring.setNewName(string);
        String string2 = ((FileObject)model.getModelSource().getLookup().lookup(FileObject.class)).getName();
        renameRefactoring.getContext().add((Object)string2);
        XMLRefactoringTransaction xMLRefactoringTransaction = new XMLRefactoringTransaction((Referenceable)model, (AbstractRefactoring)renameRefactoring);
        renameRefactoring.getContext().add((Object)xMLRefactoringTransaction);
        SharedUtils.refactor((AbstractRefactoring)renameRefactoring, bl);
    }

    public static void refactor(AbstractRefactoring abstractRefactoring, boolean bl) throws CannotRefactorException, IOException {
        Problem problem;
        RefactoringSession refactoringSession = RefactoringSession.create((String)NbBundle.getMessage(SharedUtils.class, (String)"LBL_Silent_Refactor"));
        for (problem = abstractRefactoring.checkParameters(); problem != null; problem = problem.getNext()) {
            if (!problem.isFatal()) continue;
            throw new CannotRefactorException(problem.getMessage());
        }
        if (bl && refactoringSession.getRefactoringElements().size() > 0) {
            throw new CannotRefactorException(NbBundle.getMessage(RefactoringUtil.class, (String)"MSG_HasUsages"));
        }
        for (problem = abstractRefactoring.prepare(refactoringSession); problem != null; problem = problem.getNext()) {
            if (!problem.isFatal()) continue;
            throw new CannotRefactorException(problem.getMessage());
        }
        Referenceable referenceable = (Referenceable)abstractRefactoring.getRefactoringSource().lookup(Referenceable.class);
        if (referenceable == null) {
            return;
        }
        HashSet<Model> hashSet = new HashSet<Model>();
        if (referenceable instanceof Model) {
            RefactoringUtil.saveTargetFile((Model)referenceable, hashSet);
        } else if (referenceable instanceof Nameable) {
            RefactoringUtil.saveTargetFile(((Nameable)referenceable).getModel(), hashSet);
        }
        refactoringSession.doRefactoring(true);
    }

    public static void showRefactoringUI(AbstractRefactoring abstractRefactoring) {
        Referenceable referenceable = (Referenceable)abstractRefactoring.getRefactoringSource().lookup(Referenceable.class);
        Object object = null;
        if (referenceable instanceof Model && abstractRefactoring instanceof RenameRefactoring) {
            object = new FileRenameRefactoringUI((Model)referenceable);
        } else if (referenceable instanceof Nameable && abstractRefactoring instanceof RenameRefactoring) {
            object = new RenameRefactoringUI((Nameable)referenceable);
        }
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent instanceof CloneableEditorSupport.Pane) {
            UI.openRefactoringUI((RefactoringUI)object, (TopComponent)topComponent);
        } else {
            UI.openRefactoringUI((RefactoringUI)object);
        }
    }

    public static void showDeleteRefactoringUI(final NamedReferenceable namedReferenceable) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DeleteRefactoringUI deleteRefactoringUI = new DeleteRefactoringUI(namedReferenceable);
                TopComponent topComponent = TopComponent.getRegistry().getActivated();
                if (topComponent instanceof CloneableEditorSupport.Pane) {
                    UI.openRefactoringUI((RefactoringUI)deleteRefactoringUI, (TopComponent)topComponent);
                } else {
                    UI.openRefactoringUI((RefactoringUI)deleteRefactoringUI);
                }
            }
        });
    }

    public static void showRenameRefactoringUI(Nameable nameable) {
        SharedUtils.showRenameRefactoringUI(nameable, null);
    }

    public static void showRenameRefactoringUI(final Nameable nameable, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                RenameRefactoringUI renameRefactoringUI = new RenameRefactoringUI(nameable, string);
                TopComponent topComponent = TopComponent.getRegistry().getActivated();
                if (topComponent instanceof CloneableEditorSupport.Pane) {
                    UI.openRefactoringUI((RefactoringUI)renameRefactoringUI, (TopComponent)topComponent);
                } else {
                    UI.openRefactoringUI((RefactoringUI)renameRefactoringUI);
                }
            }
        });
    }

    public static void showFileRenameRefactoringUI(final Model model) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FileRenameRefactoringUI fileRenameRefactoringUI = new FileRenameRefactoringUI(model);
                TopComponent topComponent = TopComponent.getRegistry().getActivated();
                if (topComponent instanceof CloneableEditorSupport.Pane) {
                    UI.openRefactoringUI((RefactoringUI)fileRenameRefactoringUI, (TopComponent)topComponent);
                } else {
                    UI.openRefactoringUI((RefactoringUI)fileRenameRefactoringUI);
                }
            }
        });
    }

    public static void showFileRenameRefactoringUI(final Model model, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FileRenameRefactoringUI fileRenameRefactoringUI = new FileRenameRefactoringUI(model, string);
                TopComponent topComponent = TopComponent.getRegistry().getActivated();
                if (topComponent instanceof CloneableEditorSupport.Pane) {
                    UI.openRefactoringUI((RefactoringUI)fileRenameRefactoringUI, (TopComponent)topComponent);
                } else {
                    UI.openRefactoringUI((RefactoringUI)fileRenameRefactoringUI);
                }
            }
        });
    }

    public static Image getImage(FileObject fileObject) {
        try {
            return DataObject.find((FileObject)fileObject).getNodeDelegate().getIcon(1);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
            return null;
        }
    }

    public static FileObject getFileObject(Component component) {
        return (FileObject)component.getModel().getModelSource().getLookup().lookup(FileObject.class);
    }

    public static String getXmlFileType(FileObject fileObject) {
        if (fileObject.getExt().equals("xsd")) {
            return "schema-file-type";
        }
        if (WSDL_MIME_TYPE.equals(FileUtil.getMIMEType((FileObject)fileObject))) {
            return "wsdl-file-type";
        }
        if (fileObject.getExt().equals("bpel")) {
            return "bpel-file-type";
        }
        return "";
    }

    public static String getXmlFileTypeDisplayName(String string) {
        if (string.equals("schema-file-type")) {
            return NbBundle.getMessage(SharedUtils.class, (String)"LBL_Schema");
        }
        if (string.equals("wsdl-file-type")) {
            return NbBundle.getMessage(SharedUtils.class, (String)"LBL_WSDL");
        }
        if (string.equals("bpel-file-type")) {
            return NbBundle.getMessage(SharedUtils.class, (String)"LBL_BPEL");
        }
        return "";
    }

    public static Referenceable getReferenceable(Node[] nodeArray) {
        Referenceable referenceable = null;
        ReferenceableProvider referenceableProvider = (ReferenceableProvider)nodeArray[0].getCookie(ReferenceableProvider.class);
        if (referenceableProvider != null) {
            referenceable = referenceableProvider.getReferenceable();
        } else {
            ModelProvider modelProvider = (ModelProvider)nodeArray[0].getCookie(ModelProvider.class);
            if (modelProvider != null) {
                referenceable = modelProvider.getModel();
            }
        }
        return referenceable;
    }

    public static void locallyRenameRefactor(Nameable nameable, String string) {
        RenameRefactoring renameRefactoring = new RenameRefactoring(Lookups.singleton((Object)nameable));
        renameRefactoring.setNewName(string);
        XMLRefactoringTransaction xMLRefactoringTransaction = new XMLRefactoringTransaction((Referenceable)nameable, (AbstractRefactoring)renameRefactoring);
        xMLRefactoringTransaction.setLocalScope();
        renameRefactoring.getContext().add((Object)xMLRefactoringTransaction);
        if (nameable.getName() == null) {
            renameRefactoring.getContext().add((Object)"");
        } else {
            renameRefactoring.getContext().add((Object)nameable.getName());
        }
        SharedUtils.doQuietRefactor((AbstractRefactoring)renameRefactoring);
    }

    public static void doQuietRefactor(AbstractRefactoring abstractRefactoring) {
        block3: {
            try {
                SharedUtils.refactor(abstractRefactoring, false);
            }
            catch (IOException iOException) {
                String string = iOException.getMessage();
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
            catch (CannotRefactorException cannotRefactorException) {
                Referenceable referenceable = (Referenceable)abstractRefactoring.getRefactoringSource().lookup(Referenceable.class);
                if (!(abstractRefactoring instanceof RenameRefactoring)) break block3;
                String string = ((RenameRefactoring)abstractRefactoring).getNewName();
                SharedUtils.showRenameRefactoringUI((Nameable)referenceable, string);
            }
        }
    }

    public static String getName(Referenceable referenceable) {
        if (referenceable instanceof Model) {
            FileObject fileObject = (FileObject)((Model)referenceable).getModelSource().getLookup().lookup(FileObject.class);
            assert (fileObject != null) : "Target model does not contain FileObject in lookkup";
            return fileObject.getName();
        }
        return ((Named)referenceable).getName();
    }

    public static Set<Component> getLocalSearchRoots(Referenceable referenceable) {
        Set<Component> set = null;
        if (referenceable instanceof DocumentModel) {
            set = new HashSet<Component>();
            set.add((Component)((DocumentModel)referenceable).getRootComponent());
        } else if (referenceable instanceof Component) {
            set = Collections.singleton(SharedUtils.getRootOf((Component)referenceable));
        }
        return set;
    }

    public static Component getRootOf(Component component) {
        Component component2;
        Component component3 = component;
        while (component3 != null && (component2 = SharedUtils.getEffectiveParent(component3)) != null) {
            component3 = component2;
        }
        return component3;
    }

    public static Component getEffectiveParent(Component component) {
        if (component instanceof EmbeddableRoot) {
            return ((EmbeddableRoot)component).getForeignParent();
        }
        return component.getParent();
    }

    public static Collection<RefactoringElement> findUsages(Referenceable referenceable, Component component) {
        WhereUsedQuery whereUsedQuery = new WhereUsedQuery(Lookups.singleton((Object)referenceable));
        whereUsedQuery.getContext().add((Object)component);
        RefactoringSession refactoringSession = RefactoringSession.create((String)"Inner Query");
        whereUsedQuery.prepare(refactoringSession);
        return refactoringSession.getRefactoringElements();
    }

    public Node getDisplayNode(Component component) {
        AbstractNode abstractNode = new AbstractNode(Children.LEAF);
        String string = component instanceof Named ? ((Named)component).getName() : component.getClass().getName();
        abstractNode.setName(string);
        return abstractNode;
    }

    public Node getDisplayNode(Model model) {
        AbstractNode abstractNode = new AbstractNode(Children.LEAF);
        FileObject fileObject = (FileObject)model.getModelSource().getLookup().lookup(FileObject.class);
        assert (fileObject != null) : "Model source does not provide FileObject lookup";
        abstractNode.setName(fileObject.getName());
        return abstractNode;
    }

    public static FileObject getOrCreateFolder(URL uRL) throws IOException {
        try {
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            if (fileObject != null) {
                return fileObject;
            }
            File file = new File(uRL.toURI());
            fileObject = FileUtil.createFolder((File)file);
            return fileObject;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (IOException)new IOException().initCause(uRISyntaxException);
        }
    }

    public static String getRelativePath(Model model, Model model2) throws IOException {
        FileObject fileObject = (FileObject)model.getModelSource().getLookup().lookup(FileObject.class);
        FileObject fileObject2 = (FileObject)model2.getModelSource().getLookup().lookup(FileObject.class);
        return SharedUtils.getRelativePath(fileObject, fileObject2);
    }

    public static List<String> getSourceGroups() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(SOURCES_TYPE_JAVA);
        arrayList.add(SOURCES_TYPE_XML);
        return arrayList;
    }

    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dataObject) {
        Node.Cookie cookie = dataObject.getCookie(OpenCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        cookie = dataObject.getCookie(EditorCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        return null;
    }

    public static URI getReferenceURI(FileObject fileObject, FileObject fileObject2) throws URISyntaxException, IOException {
        String string;
        String string2;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject2);
        Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
        FileObject fileObject3 = SharedUtils.getSourceFolder(project2, fileObject);
        if (fileObject3 == null) {
            fileObject3 = fileObject;
        }
        if (!fileObject.isFolder()) {
            fileObject = fileObject.getParent();
        }
        String string3 = string2 = (string = SharedUtils.getRelativePath(fileObject, fileObject3)).trim().equals("") ? "" : string.concat("/");
        if (project2 != project) {
            if (!SharedUtils.getProjectReferences(project2).contains(project)) {
                return fileObject2.getURL().toURI();
            }
            FileObject fileObject4 = SharedUtils.getSourceFolder(project, fileObject2);
            if (fileObject4 == null) {
                fileObject4 = fileObject2;
            }
            String string4 = SharedUtils.getRelativePath(fileObject4, fileObject2);
            return new URI(string2.concat(SharedUtils.getUsableProjectName(project)).concat("/").concat(string4));
        }
        FileObject fileObject5 = SharedUtils.getSourceFolder(project, fileObject2);
        if (fileObject5 == null) {
            throw new IllegalArgumentException(fileObject2.getPath() + " is not in project source");
        }
        String string5 = SharedUtils.getRelativePath(fileObject5, fileObject2);
        return new URI(string2.concat(string5));
    }

    public static String getRelativePath(FileObject fileObject, FileObject fileObject2) {
        File file = FileUtil.toFile((FileObject)fileObject);
        File file2 = FileUtil.toFile((FileObject)fileObject2);
        String string = file.toURI().toString();
        String string2 = file2.toURI().toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "/");
        String string3 = "";
        while (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens()) {
            string3 = stringTokenizer2.nextToken();
            if (!stringTokenizer.nextToken().equals(string3)) break;
            if (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens()) continue;
            if (stringTokenizer.hasMoreElements()) {
                string3 = "..";
                stringTokenizer.nextToken();
                continue;
            }
            if (stringTokenizer2.hasMoreTokens()) {
                string3 = stringTokenizer2.nextToken();
                continue;
            }
            string3 = "";
        }
        while (stringTokenizer.hasMoreTokens()) {
            string3 = "../".concat(string3);
            stringTokenizer.nextToken();
        }
        while (stringTokenizer2.hasMoreTokens()) {
            string3 = string3.concat("/").concat(stringTokenizer2.nextToken());
        }
        return string3;
    }

    public static FileObject getSourceFolder(Project project, FileObject fileObject) {
        Sources sources = ProjectUtils.getSources((Project)project);
        assert (sources != null);
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>();
        for (String string : sourceTypes) {
            SourceGroup[] sourceGroupArray = sources.getSourceGroups(string);
            if (sourceGroupArray == null) continue;
            arrayList.addAll(Arrays.asList(sourceGroupArray));
        }
        assert (arrayList.size() > 0);
        for (SourceGroup sourceGroup : arrayList) {
            if (!FileUtil.isParentOf((FileObject)sourceGroup.getRootFolder(), (FileObject)fileObject)) continue;
            return sourceGroup.getRootFolder();
        }
        FileObject fileObject2 = project.getProjectDirectory().getFileObject("src/conf");
        if (fileObject2 != null && FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject)) {
            return fileObject2;
        }
        return null;
    }

    private static String getUsableProjectName(Project project) {
        return PropertyUtils.getUsablePropertyName((String)ProjectUtils.getInformation((Project)project).getName()).replace('.', '_');
    }

    public static FileObject getFileObject(Model model, URI uRI) {
        File file = null;
        FileObject fileObject = (FileObject)model.getModelSource().getLookup().lookup(FileObject.class);
        File file2 = FileUtil.toFile((FileObject)fileObject);
        if (file2 != null) {
            URI uRI2 = file2.toURI();
            URI uRI3 = uRI2.resolve(uRI);
            try {
                file = new File(uRI3);
                if (file.isFile()) {
                    return FileUtil.toFileObject((File)file);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean inSameProject(FileObject fileObject, FileObject fileObject2) {
        Project project;
        Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject2);
        return project2 == (project = FileOwnerQuery.getOwner((FileObject)fileObject));
    }

    public static Set getProjectReferences(Project project) {
        SubprojectProvider subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
        return subprojectProvider.getSubprojects();
    }
}

