/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.refactoring.spi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.xml.refactoring.ErrorItem;
import org.netbeans.modules.xml.refactoring.ui.GraphHelper;
import org.netbeans.modules.xml.retriever.catalog.ProjectCatalogSupport;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.Nameable;
import org.netbeans.modules.xml.xam.Referenceable;
import org.netbeans.modules.xml.xam.dom.Utils;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefactoringUtil {
    public static final String BUILD = "build";

    public static Project findCurrentProject(Referenceable referenceable) {
        Model model;
        Model model2 = model = referenceable instanceof Model ? (Model)referenceable : ((Component)referenceable).getModel();
        if (model == null) {
            return null;
        }
        return FileOwnerQuery.getOwner((FileObject)((FileObject)model.getModelSource().getLookup().lookup(FileObject.class)));
    }

    public static Set<Project> getReferencingProjects(Project project) {
        HashSet<Project> hashSet = new HashSet<Project>();
        block0: for (Project project2 : OpenProjects.getDefault().getOpenProjects()) {
            SubprojectProvider subprojectProvider;
            if (project2.getLookup().lookup(ProjectCatalogSupport.class) == null || (subprojectProvider = (SubprojectProvider)project2.getLookup().lookup(SubprojectProvider.class)) == null) continue;
            for (Project project3 : subprojectProvider.getSubprojects()) {
                Project project4 = project3;
                if (project4 != project) continue;
                hashSet.add(project2);
                continue block0;
            }
        }
        return hashSet;
    }

    public static List<SourceGroup> findSourceRoots(Project project) {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("generic");
        return Arrays.asList(sourceGroupArray);
    }

    public static List<FileObject> findSourceFiles(FileObject fileObject) {
        Enumeration enumeration = fileObject.getChildren(true);
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        while (enumeration.hasMoreElements()) {
            FileObject fileObject2 = (FileObject)enumeration.nextElement();
            if (!fileObject2.isData() || RefactoringUtil.isBuildDirFile(fileObject2)) continue;
            arrayList.add(fileObject2);
        }
        return arrayList;
    }

    public static boolean isBuildDirFile(FileObject fileObject) {
        while (fileObject != null) {
            if (fileObject.getName().equals(BUILD)) {
                return true;
            }
            fileObject = fileObject.getParent();
        }
        return false;
    }

    public static ErrorItem precheckTarget(Model model, boolean bl) {
        if (model == null) {
            return null;
        }
        if (model.getState() != Model.State.VALID) {
            String string = NbBundle.getMessage(RefactoringUtil.class, (String)"MSG_ModelSourceNotWelformed");
            return new ErrorItem(model, string);
        }
        if (bl && !RefactoringUtil.isWritable(model)) {
            String string = NbBundle.getMessage(RefactoringUtil.class, (String)"MSG_ModelSourceNotWritable");
            return new ErrorItem(model, string);
        }
        return null;
    }

    public static List<ErrorItem> precheckUsageModels(List<Model> list, boolean bl) {
        ArrayList<ErrorItem> arrayList = new ArrayList<ErrorItem>();
        for (Model model : list) {
            String string;
            if (model.getState() != Model.State.VALID) {
                string = NbBundle.getMessage(RefactoringUtil.class, (String)"MSG_ModelSourceNotWelformed");
                arrayList.add(new ErrorItem(model, string));
            }
            if (!bl || RefactoringUtil.isWritable(model)) continue;
            string = NbBundle.getMessage(RefactoringUtil.class, (String)"MSG_ModelSourceNotWritable");
            arrayList.add(new ErrorItem(model, string));
        }
        if (arrayList.size() > 0) {
            return arrayList;
        }
        return null;
    }

    public static String getDescription(AbstractRefactoring abstractRefactoring) {
        Referenceable referenceable = (Referenceable)abstractRefactoring.getRefactoringSource().lookup(Referenceable.class);
        if (abstractRefactoring instanceof RenameRefactoring && referenceable instanceof Nameable) {
            return NbBundle.getMessage(RefactoringUtil.class, (String)"LBL_Rename");
        }
        if (abstractRefactoring instanceof SafeDeleteRefactoring) {
            return NbBundle.getMessage(RefactoringUtil.class, (String)"LBL_Safe_Delete");
        }
        if (abstractRefactoring instanceof RenameRefactoring && referenceable instanceof Model) {
            return NbBundle.getMessage(RefactoringUtil.class, (String)"LBL_File_Rename");
        }
        return "";
    }

    public static boolean isDirty(Model model) {
        DataObject dataObject = (DataObject)model.getModelSource().getLookup().lookup(DataObject.class);
        if (dataObject != null) {
            return dataObject.isModified();
        }
        return false;
    }

    public static DataObject getDataObject(Model model) {
        if (model != null) {
            return (DataObject)model.getModelSource().getLookup().lookup(DataObject.class);
        }
        return null;
    }

    public static void saveTargetFile(Model model, Set<Model> set) {
        HashSet<Model> hashSet = new HashSet<Model>();
        hashSet.addAll(set);
        hashSet.remove(model);
        RefactoringUtil.save(set, model, hashSet);
    }

    public static void save(Set<Model> set, Model model, Set<Model> set2) {
        HashSet<Model> hashSet = new HashSet<Model>();
        hashSet.addAll(set);
        hashSet.add(model);
        for (Model model2 : hashSet) {
            String string;
            if (set2.contains(model2)) continue;
            DataObject dataObject = RefactoringUtil.getDataObject(model2);
            if (dataObject == null) {
                string = NbBundle.getMessage(RefactoringUtil.class, (String)"MSG_CannotFindDataObject");
                continue;
            }
            string = (SaveCookie)dataObject.getCookie(SaveCookie.class);
            FileObject fileObject = dataObject.getPrimaryFile();
            if (string != null) {
                try {
                    string.save();
                    dataObject.setModified(false);
                }
                catch (IOException iOException) {
                    String string2 = NbBundle.getMessage(RefactoringUtil.class, (String)"MSG_ErrorSave", (Object)fileObject.getPath(), (Object)iOException.getMessage());
                }
                continue;
            }
            String string3 = NbBundle.getMessage(RefactoringUtil.class, (String)"MSG_CannotSave", (Object)fileObject.getPath());
        }
    }

    public static String getDescription(GraphHelper.Type type) {
        switch (type) {
            case GENERALIZATION: {
                return NbBundle.getMessage(RefactoringUtil.class, (String)"LBL_Generalization");
            }
            case REFERENCE: {
                return NbBundle.getMessage(RefactoringUtil.class, (String)"LBL_Reference");
            }
        }
        assert (false) : "Invalid type " + (Object)((Object)type);
        return "";
    }

    public static ErrorItem precheck(Nameable nameable, String string) {
        if (string == null || !Utils.isValidNCName((String)string)) {
            return new ErrorItem(nameable, NbBundle.getMessage(RefactoringUtil.class, (String)"MSG_NewNameNullEmpty"), ErrorItem.Level.FATAL);
        }
        if (!RefactoringUtil.checkDuplicateName(nameable, string)) {
            return new ErrorItem(nameable, NbBundle.getMessage(RefactoringUtil.class, (String)"MSG_NewNameDuplicate"), ErrorItem.Level.FATAL);
        }
        return null;
    }

    public static ErrorItem precheck(Model model, String string) {
        FileObject fileObject = (FileObject)model.getModelSource().getLookup().lookup(FileObject.class);
        assert (fileObject != null) : "Failed to lookup for file object in model source";
        FileObject fileObject2 = fileObject.getParent();
        assert (fileObject2 != null) : "Source file has no parent folder";
        boolean bl = false;
        FileObject fileObject3 = fileObject2.getFileObject(string, fileObject.getExt());
        if (fileObject3 != null) {
            if (fileObject3 != fileObject) {
                bl = true;
            } else if (fileObject3.getName().equals(string)) {
                bl = true;
            }
        }
        if (string == null || string.trim().length() == 0 || bl) {
            return new ErrorItem(model, NbBundle.getMessage(RefactoringUtil.class, (String)"MSG_NewNameDuplicate"), ErrorItem.Level.FATAL);
        }
        if (!Utils.isValidNCName((String)string)) {
            return new ErrorItem(model, NbBundle.getMessage(RefactoringUtil.class, (String)"MSG_NewNameNullEmpty"), ErrorItem.Level.FATAL);
        }
        return null;
    }

    public static boolean checkDuplicateName(Nameable nameable, String string) {
        Component component = nameable.getParent();
        List list = component.getChildren(nameable.getClass());
        for (Component component2 : list) {
            Nameable nameable2 = (Nameable)component2;
            if (nameable2.getName() == null || !nameable2.getName().equals(string)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWritable(Model model) {
        FileObject fileObject;
        ModelSource modelSource;
        if (model != null && (modelSource = model.getModelSource()).isEditable() && (fileObject = (FileObject)modelSource.getLookup().lookup(FileObject.class)) != null) {
            return fileObject.canWrite();
        }
        return false;
    }

    public static Set<Model> getDirtyModels(Set<Model> set, Model model) {
        HashSet<Model> hashSet = new HashSet<Model>();
        if (RefactoringUtil.isDirty(model)) {
            hashSet.add(model);
        }
        for (Model model2 : set) {
            if (!RefactoringUtil.isDirty(model2)) continue;
            hashSet.add(model2);
        }
        return hashSet;
    }
}

