/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.lexer;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.groovy.editor.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.editor.lexer.LexUtilities;
import org.netbeans.modules.gsf.api.annotations.NonNull;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Call {
    public static final Call LOCAL = new Call(null, null, false, false);
    public static final Call NONE = new Call(null, null, false, false);
    public static final Call UNKNOWN = new Call(null, null, false, false);
    private final String type;
    private final String lhs;
    private final boolean isStatic;
    private final boolean methodExpected;

    public Call(String string, String string2, boolean bl, boolean bl2) {
        this.type = string;
        this.lhs = string2;
        this.methodExpected = bl2;
        if (string2 == null) {
            string2 = string;
        }
        this.isStatic = bl;
    }

    public String getType() {
        return this.type;
    }

    public String getLhs() {
        return this.lhs;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isSimpleIdentifier() {
        if (this.lhs == null) {
            return false;
        }
        int n = this.lhs.length();
        for (int i = 0; i < n; ++i) {
            char c = this.lhs.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '@' || c == '$') continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this == LOCAL) {
            return "LOCAL";
        }
        if (this == NONE) {
            return "NONE";
        }
        if (this == UNKNOWN) {
            return "UNKNOWN";
        }
        return "Call(" + this.type + "," + this.lhs + "," + this.isStatic + ")";
    }

    public boolean isMethodExpected() {
        return this.methodExpected;
    }

    @NonNull
    public static Call getCallType(BaseDocument baseDocument, TokenHierarchy<Document> tokenHierarchy, int n) {
        Token token;
        TokenSequence tokenSequence = LexUtilities.getGroovyTokenSequence(tokenHierarchy, n);
        if (tokenSequence == null) {
            return NONE;
        }
        tokenSequence.move(n);
        boolean bl = false;
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            return NONE;
        }
        if (tokenSequence.offset() == n) {
            tokenSequence.movePrevious();
        }
        if ((token = tokenSequence.token()) != null) {
            String string;
            int n2;
            String string2;
            TokenId tokenId = token.id();
            if (tokenId == GroovyTokenId.WHITESPACE) {
                return LOCAL;
            }
            if (tokenId == GroovyTokenId.EMBEDDED_GROOVY) {
                tokenSequence = tokenSequence.embedded();
                assert (tokenSequence != null);
                tokenSequence.move(n);
                if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                    return NONE;
                }
                token = tokenSequence.token();
                tokenId = token.id();
            }
            if (tokenId == GroovyTokenId.IDENTIFIER || tokenId == GroovyTokenId.CONSTANT || tokenId.primaryCategory().equals("keyword")) {
                string2 = ((Object)token.text()).toString();
                if (".".equals(string2)) {
                    bl = true;
                } else {
                    bl = true;
                    if (Character.isUpperCase(string2.charAt(0))) {
                        bl = false;
                    }
                    if (!tokenSequence.movePrevious()) {
                        return LOCAL;
                    }
                }
                token = tokenSequence.token();
                tokenId = token.id();
            }
            if (tokenId == GroovyTokenId.DOT) {
                bl = true;
            } else if (tokenId != GroovyTokenId.COLON) {
                if (tokenId == GroovyTokenId.IDENTIFIER) {
                    string2 = ((Object)token.text()).toString();
                    if (string2.equals(".")) {
                        bl = true;
                    }
                } else {
                    return LOCAL;
                }
            }
            int n3 = n2 = tokenSequence.offset();
            int n4 = 0;
            try {
                if (n > baseDocument.getLength()) {
                    n = baseDocument.getLength();
                }
                n4 = org.netbeans.editor.Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            while (tokenSequence.movePrevious() && tokenSequence.offset() >= n4) {
                token = tokenSequence.token();
                tokenId = token.id();
                string = null;
                if (tokenId == GroovyTokenId.ANY_KEYWORD) {
                    string = ((Object)token.text()).toString();
                }
                if (tokenId == GroovyTokenId.WHITESPACE) break;
                if (tokenId == GroovyTokenId.STRING_LITERAL) {
                    return new Call("java.lang.String", null, false, bl);
                }
                if (tokenId == GroovyTokenId.RBRACKET) {
                    return new Call("java.util.ArrayList", null, false, bl);
                }
                if (tokenId == GroovyTokenId.NUM_INT) {
                    return new Call("java.lang.Integer", null, false, bl);
                }
                if (tokenId == GroovyTokenId.NUM_DOUBLE) {
                    return new Call("java.math.BigDecimal", null, false, bl);
                }
                if (tokenId == GroovyTokenId.GLOBAL_VAR || tokenId == GroovyTokenId.INSTANCE_VAR || tokenId == GroovyTokenId.CLASS_VAR || tokenId == GroovyTokenId.IDENTIFIER || tokenId.primaryCategory().equals("keyword") || tokenId == GroovyTokenId.DOT || tokenId == GroovyTokenId.COLON || tokenId == GroovyTokenId.CONSTANT || tokenId == GroovyTokenId.SUPER_CTOR_CALL || tokenId == GroovyTokenId.CTOR_CALL) {
                    n3 = tokenSequence.offset();
                    continue;
                }
                if (tokenId == GroovyTokenId.LPAREN || tokenId == GroovyTokenId.LBRACE || tokenId == GroovyTokenId.LBRACKET) break;
                return UNKNOWN;
            }
            if (n3 < n2) {
                try {
                    string = baseDocument.getText(n3, n2 - n3);
                    if (string.equals("super") || string.equals("this")) {
                        return new Call(string, string, false, true);
                    }
                    if (Character.isUpperCase(string.charAt(0))) {
                        String string3 = null;
                        if (Utilities.isJavaIdentifier((String)string)) {
                            string3 = string;
                        }
                        return new Call(string3, string, true, bl);
                    }
                    return new Call(null, string, false, bl);
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            } else {
                return UNKNOWN;
            }
        }
        return LOCAL;
    }
}

