/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.elements;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.netbeans.modules.groovy.editor.AstUtilities;
import org.netbeans.modules.groovy.editor.elements.AstElement;
import org.netbeans.modules.groovy.editor.elements.CommentElement;
import org.netbeans.modules.groovy.editor.elements.GroovyElement;
import org.netbeans.modules.groovy.editor.elements.IndexedElement;
import org.netbeans.modules.groovy.editor.elements.KeywordElement;
import org.netbeans.modules.groovy.editor.parser.GroovyParserResult;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.ParserResult;
import org.openide.filesystems.FileObject;

public class ElementHandleSupport {
    public static ElementHandle createHandle(CompilationInfo compilationInfo, GroovyElement groovyElement) {
        if (groovyElement instanceof KeywordElement || groovyElement instanceof CommentElement) {
            return new GroovyElementHandle(null, groovyElement, compilationInfo.getFileObject());
        }
        if (groovyElement instanceof IndexedElement) {
            return new GroovyElementHandle(null, groovyElement, ((IndexedElement)groovyElement).getFileObject());
        }
        if (!(groovyElement instanceof AstElement)) {
            return null;
        }
        if (compilationInfo == null) {
            return null;
        }
        GroovyParserResult groovyParserResult = AstUtilities.getParseResult(compilationInfo);
        if (groovyParserResult == null) {
            return null;
        }
        ModuleNode moduleNode = AstUtilities.getRoot(compilationInfo);
        return new GroovyElementHandle(moduleNode, groovyElement, compilationInfo.getFileObject());
    }

    public static ElementHandle createHandle(ParserResult parserResult, AstElement astElement) {
        ModuleNode moduleNode = AstUtilities.getRoot(parserResult);
        return new GroovyElementHandle(moduleNode, astElement, parserResult.getFile().getFileObject());
    }

    public static GroovyElement resolveHandle(CompilationInfo compilationInfo, ElementHandle elementHandle) {
        GroovyElementHandle groovyElementHandle = (GroovyElementHandle)elementHandle;
        ASTNode aSTNode = groovyElementHandle.root;
        if (groovyElementHandle.object instanceof KeywordElement || groovyElementHandle.object instanceof IndexedElement || groovyElementHandle.object instanceof CommentElement) {
            return groovyElementHandle.object;
        }
        if (!(groovyElementHandle.object instanceof AstElement)) {
            return null;
        }
        ASTNode aSTNode2 = ((AstElement)groovyElementHandle.object).getNode();
        ModuleNode moduleNode = AstUtilities.getRoot(compilationInfo);
        if (moduleNode == null) {
            return null;
        }
        ASTNode aSTNode3 = ElementHandleSupport.find(aSTNode, aSTNode2, moduleNode);
        if (aSTNode3 != null) {
            AstElement astElement = AstElement.create(aSTNode3);
            return astElement;
        }
        return null;
    }

    private static ASTNode find(ASTNode aSTNode, ASTNode aSTNode2, ASTNode aSTNode3) {
        List<ASTNode> list = AstUtilities.children(aSTNode);
        List<ASTNode> list2 = AstUtilities.children(aSTNode3);
        Iterator<ASTNode> iterator = list.iterator();
        Iterator<ASTNode> iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            if (!iterator2.hasNext()) {
                return null;
            }
            ASTNode aSTNode4 = iterator.next();
            ASTNode aSTNode5 = iterator2.next();
            if (aSTNode4 == aSTNode2) {
                return aSTNode5;
            }
            ASTNode aSTNode6 = ElementHandleSupport.find(aSTNode4, aSTNode2, aSTNode5);
            if (aSTNode6 == null) continue;
            return aSTNode6;
        }
        if (iterator2.hasNext()) {
            return null;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GroovyElementHandle
    implements ElementHandle {
        private final ASTNode root;
        private final GroovyElement object;
        private final FileObject fileObject;

        private GroovyElementHandle(ASTNode aSTNode, GroovyElement groovyElement, FileObject fileObject) {
            this.root = aSTNode;
            this.object = groovyElement;
            this.fileObject = fileObject;
        }

        public boolean signatureEquals(ElementHandle elementHandle) {
            return false;
        }

        public FileObject getFileObject() {
            if (this.object instanceof IndexedElement) {
                return ((IndexedElement)this.object).getFileObject();
            }
            return this.fileObject;
        }

        public String getMimeType() {
            return "text/x-groovy";
        }

        public String getName() {
            return this.object.getName();
        }

        public String getIn() {
            return this.object.getIn();
        }

        public ElementKind getKind() {
            return this.object.getKind();
        }

        public Set<Modifier> getModifiers() {
            return this.object.getModifiers();
        }
    }
}

