/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.netbeans.modules.groovy.editor.elements.AstMethodElement;
import org.netbeans.modules.groovy.editor.elements.GroovyElement;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.Modifier;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AstElement
extends GroovyElement {
    protected final ASTNode node;
    protected List<AstElement> children;
    protected String name;
    protected Set<Modifier> modifiers;
    protected String in;
    protected String signature;

    public AstElement(ASTNode aSTNode) {
        this.node = aSTNode;
    }

    public List<AstElement> getChildren() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return this.children;
    }

    public void addChild(AstElement astElement) {
        if (this.children == null) {
            this.children = new ArrayList<AstElement>();
        }
        this.children.add(astElement);
    }

    public String getSignature() {
        if (this.signature == null) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.getIn();
            if (string != null && string.length() > 0) {
                stringBuilder.append(string);
                stringBuilder.append(".");
            }
            stringBuilder.append(this.getName());
            this.signature = stringBuilder.toString();
        }
        return this.signature;
    }

    @Override
    public abstract String getName();

    public ASTNode getNode() {
        return this.node;
    }

    @Override
    public String getIn() {
        return this.in;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.OTHER;
    }

    @Override
    public Set<Modifier> getModifiers() {
        if (this.modifiers == null) {
            int n = -1;
            if (this.node instanceof FieldNode) {
                n = ((FieldNode)this.node).getModifiers();
            } else if (this.node instanceof MethodNode) {
                n = ((MethodNode)this.node).getModifiers();
            }
            if (n != -1) {
                EnumSet<Modifier> enumSet = EnumSet.noneOf(Modifier.class);
                if ((n & 1) != 0) {
                    enumSet.add(Modifier.PUBLIC);
                }
                if ((n & 4) != 0) {
                    enumSet.add(Modifier.PROTECTED);
                }
                if ((n & 2) != 0) {
                    enumSet.add(Modifier.PRIVATE);
                }
                if ((n & 8) != 0) {
                    enumSet.add(Modifier.STATIC);
                }
                this.modifiers = enumSet;
            } else {
                this.modifiers = Collections.emptySet();
            }
        }
        return this.modifiers;
    }

    public void setIn(String string) {
        this.in = string;
    }

    @Override
    public boolean signatureEquals(ElementHandle elementHandle) {
        if (elementHandle instanceof AstElement) {
            return this.equals(elementHandle);
        }
        return false;
    }

    @Override
    public FileObject getFileObject() {
        return null;
    }

    @Override
    public String getMimeType() {
        return "text/x-groovy";
    }

    public static AstElement create(ASTNode aSTNode) {
        if (aSTNode instanceof MethodNode) {
            return new AstMethodElement(aSTNode);
        }
        return null;
    }

    public String toString() {
        return this.getKind() + "<" + this.getName() + ">";
    }
}

