/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion;

import groovy.lang.MetaMethod;
import java.util.Collections;
import java.util.Set;
import javax.swing.ImageIcon;
import org.codehaus.groovy.ast.ASTNode;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.modules.groovy.editor.NbUtilities;
import org.netbeans.modules.groovy.editor.completion.CodeCompleter;
import org.netbeans.modules.groovy.editor.completion.GroovyCompletionItem;
import org.netbeans.modules.groovy.editor.elements.AstMethodElement;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.Modifier;
import org.openide.util.ImageUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodItem
extends GroovyCompletionItem {
    MetaMethod method;
    boolean isGDK;
    AstMethodElement methodElement;

    MethodItem(Class clazz, MetaMethod metaMethod, int n, CodeCompleter.CompletionRequest completionRequest, boolean bl) {
        super(null, n, completionRequest);
        this.method = metaMethod;
        this.isGDK = bl;
        this.methodElement = new AstMethodElement(new ASTNode(), clazz, metaMethod, bl);
    }

    public MetaMethod getMethod() {
        return this.method;
    }

    @Override
    public String getName() {
        return this.method.getName() + "()";
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.METHOD;
    }

    public String getLhsHtml(HtmlFormatter htmlFormatter) {
        ElementKind elementKind = this.getKind();
        htmlFormatter.name(elementKind, true);
        if (this.isGDK) {
            htmlFormatter.appendText(this.method.getName());
            String string = this.method.getSignature();
            int n = string.indexOf("(");
            int n2 = string.indexOf(")");
            String string2 = string.substring(n + 1, n2);
            StringBuffer stringBuffer = new StringBuffer();
            for (String string3 : string2.split(",")) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(NbUtilities.stripPackage(string3));
            }
            String string4 = stringBuffer.toString();
            htmlFormatter.appendText("(" + string4 + ")");
        } else {
            htmlFormatter.appendText(CodeCompleter.getMethodSignature(this.method, false, this.isGDK));
        }
        htmlFormatter.name(elementKind, false);
        return htmlFormatter.getText();
    }

    public String getRhsHtml(HtmlFormatter htmlFormatter) {
        String string = this.method.getReturnType().toString();
        string = NbUtilities.stripPackage(string);
        htmlFormatter.appendText(string);
        return htmlFormatter.getText();
    }

    public ImageIcon getIcon() {
        if (!this.isGDK) {
            return (ImageIcon)ElementIcons.getElementIcon((javax.lang.model.element.ElementKind)javax.lang.model.element.ElementKind.METHOD, GroovyCompletionItem.toModel(this.method.getModifiers()));
        }
        if (groovyIcon == null) {
            groovyIcon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/groovy/support/resources/GroovyFile16x16.png"));
        }
        return groovyIcon;
    }

    @Override
    public Set<Modifier> getModifiers() {
        return Collections.emptySet();
    }

    @Override
    public ElementHandle getElement() {
        return this.methodElement;
    }
}

