/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion;

import groovy.lang.GroovySystem;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.reflection.CachedClass;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.groovy.editor.AstPath;
import org.netbeans.modules.groovy.editor.AstUtilities;
import org.netbeans.modules.groovy.editor.GroovyIndex;
import org.netbeans.modules.groovy.editor.NbUtilities;
import org.netbeans.modules.groovy.editor.TypeVisitor;
import org.netbeans.modules.groovy.editor.completion.CaretLocation;
import org.netbeans.modules.groovy.editor.completion.ConstructorItem;
import org.netbeans.modules.groovy.editor.completion.FieldItem;
import org.netbeans.modules.groovy.editor.completion.GroovyKeyword;
import org.netbeans.modules.groovy.editor.completion.HTMLJavadocParser;
import org.netbeans.modules.groovy.editor.completion.JavaMethodItem;
import org.netbeans.modules.groovy.editor.completion.KeywordCategory;
import org.netbeans.modules.groovy.editor.completion.KeywordItem;
import org.netbeans.modules.groovy.editor.completion.LocalVarItem;
import org.netbeans.modules.groovy.editor.completion.MethodItem;
import org.netbeans.modules.groovy.editor.completion.NewVarItem;
import org.netbeans.modules.groovy.editor.completion.PackageItem;
import org.netbeans.modules.groovy.editor.completion.TypeItem;
import org.netbeans.modules.groovy.editor.elements.AstMethodElement;
import org.netbeans.modules.groovy.editor.elements.IndexedClass;
import org.netbeans.modules.groovy.editor.elements.IndexedMethod;
import org.netbeans.modules.groovy.editor.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.editor.lexer.LexUtilities;
import org.netbeans.modules.groovy.support.api.GroovySettings;
import org.netbeans.modules.gsf.api.CodeCompletionContext;
import org.netbeans.modules.gsf.api.CodeCompletionHandler;
import org.netbeans.modules.gsf.api.CodeCompletionResult;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.CompletionProposal;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParameterInfo;
import org.netbeans.modules.gsf.spi.DefaultCompletionResult;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeCompleter
implements CodeCompletionHandler {
    private static volatile boolean testMode = false;
    private int anchor;
    private final Logger LOG = Logger.getLogger(CodeCompleter.class.getName());
    private String jdkJavaDocBase = null;
    private String groovyJavaDocBase = null;
    private String gapiDocBase = null;
    Set<GroovyKeyword> keywords;
    List<String> dfltImports = new ArrayList<String>();

    public CodeCompleter() {
        Object object2;
        JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
        JavaPlatform javaPlatform = javaPlatformManager.getDefaultPlatform();
        List list = javaPlatform.getJavadocFolders();
        for (Object object2 : list) {
            this.LOG.log(Level.FINEST, "JDK Doc path: {0}", ((URL)object2).toString());
            this.jdkJavaDocBase = ((URL)object2).toString();
        }
        GroovySettings groovySettings = new GroovySettings();
        object2 = groovySettings.getGroovyDoc() + "/";
        this.groovyJavaDocBase = this.directoryNameToUrl((String)object2 + "groovy-jdk/");
        this.gapiDocBase = this.directoryNameToUrl((String)object2 + "gapi/");
        this.LOG.log(Level.FINEST, "GDK Doc path: {0}", this.groovyJavaDocBase);
        this.LOG.log(Level.FINEST, "GAPI Doc path: {0}", this.gapiDocBase);
        if (testMode) {
            this.LOG.log(Level.FINEST, "Running in test-mode");
        } else {
            this.LOG.log(Level.FINEST, "Running in the IDE");
        }
        this.dfltImports.add("java.io");
        this.dfltImports.add("java.lang");
        this.dfltImports.add("java.net");
        this.dfltImports.add("java.util");
        this.dfltImports.add("groovy.util");
        this.dfltImports.add("groovy.lang");
    }

    static void setTesting(boolean bl) {
        testMode = bl;
    }

    String directoryNameToUrl(String string) {
        if (string == null) {
            return "";
        }
        File file = new File(string);
        if (file != null && file.exists() && file.isDirectory()) {
            String string2 = "";
            if (org.openide.util.Utilities.isWindows()) {
                string = string.replace("\\", "/");
                string2 = "file:/";
            } else {
                string2 = "file://";
            }
            return string2 + string;
        }
        return "";
    }

    private void printASTNodeInformation(String string, ASTNode aSTNode) {
        this.LOG.log(Level.FINEST, "--------------------------------------------------------");
        this.LOG.log(Level.FINEST, "{0}", string);
        if (aSTNode == null) {
            this.LOG.log(Level.FINEST, "node == null");
        } else {
            this.LOG.log(Level.FINEST, "Node.getText()  : " + aSTNode.getText());
            this.LOG.log(Level.FINEST, "Node.toString() : " + aSTNode.toString());
            this.LOG.log(Level.FINEST, "Node.getClass() : " + aSTNode.getClass());
            this.LOG.log(Level.FINEST, "Node.hashCode() : " + aSTNode.hashCode());
            if (aSTNode instanceof ModuleNode) {
                this.LOG.log(Level.FINEST, "ModuleNode.getClasses() : " + ((ModuleNode)aSTNode).getClasses());
                this.LOG.log(Level.FINEST, "SourceUnit.getName() : " + ((ModuleNode)aSTNode).getContext().getName());
            }
        }
        this.LOG.log(Level.FINEST, "--------------------------------------------------------");
    }

    private void printMethod(MetaMethod metaMethod) {
        this.LOG.log(Level.FINEST, "--------------------------------------------------");
        this.LOG.log(Level.FINEST, "getName()           : " + metaMethod.getName());
        this.LOG.log(Level.FINEST, "toString()          : " + metaMethod.toString());
        this.LOG.log(Level.FINEST, "getDescriptor()     : " + metaMethod.getDescriptor());
        this.LOG.log(Level.FINEST, "getSignature()      : " + metaMethod.getSignature());
        this.LOG.log(Level.FINEST, "getDeclaringClass() : " + metaMethod.getDeclaringClass());
    }

    CompletionContext getCompletionContext(CompletionRequest completionRequest) {
        Token token;
        int n = completionRequest.lexOffset;
        Token token2 = null;
        Token token3 = null;
        Token token4 = null;
        Token token5 = null;
        Token token6 = null;
        Token token7 = null;
        Token token8 = null;
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence(completionRequest.doc, n);
        int n2 = 0;
        n2 = tokenSequence.move(n);
        if (tokenSequence.isValid() && tokenSequence.moveNext() && tokenSequence.offset() >= 0) {
            token5 = tokenSequence.token();
        }
        if (token5 != null) {
            if (token5.id() == GroovyTokenId.WHITESPACE && n2 == 0) {
                this.LOG.log(Level.FINEST, "ts.movePrevious() - 1");
                tokenSequence.movePrevious();
            } else if (token5.id() == GroovyTokenId.NLS) {
                tokenSequence.movePrevious();
                if (tokenSequence.token().id() == GroovyTokenId.DOT) {
                    tokenSequence.moveNext();
                } else {
                    this.LOG.log(Level.FINEST, "ts.movePrevious() - 2");
                }
            }
        }
        int n3 = 0;
        while (tokenSequence.isValid() && tokenSequence.movePrevious() && tokenSequence.offset() >= 0 && (token = tokenSequence.token()).id() != GroovyTokenId.NLS) {
            if (token.id() == GroovyTokenId.WHITESPACE) continue;
            if (n3 == 0) {
                token4 = token;
            } else if (n3 == 1) {
                token3 = token;
            } else if (n3 == 2) break;
            ++n3;
        }
        tokenSequence.move(n);
        while (tokenSequence.isValid() && tokenSequence.movePrevious() && tokenSequence.offset() >= 0 && (token = tokenSequence.token()).id() != GroovyTokenId.NLS && token.id() != GroovyTokenId.LBRACE) {
            if (!((GroovyTokenId)token.id()).primaryCategory().equals("keyword")) continue;
            token2 = token;
            break;
        }
        tokenSequence.move(n);
        while (tokenSequence.isValid() && tokenSequence.moveNext() && tokenSequence.offset() < completionRequest.doc.getLength() && (token = tokenSequence.token()).id() != GroovyTokenId.NLS && token.id() != GroovyTokenId.RBRACE) {
            if (!((GroovyTokenId)token.id()).primaryCategory().equals("keyword")) continue;
            token8 = token;
            break;
        }
        tokenSequence.move(n);
        n3 = 0;
        while (tokenSequence.isValid() && tokenSequence.moveNext() && tokenSequence.offset() < completionRequest.doc.getLength() && (token = tokenSequence.token()).id() != GroovyTokenId.NLS) {
            if (token.id() == GroovyTokenId.WHITESPACE) continue;
            if (n3 == 0) {
                token6 = token;
            } else if (n3 == 1) {
                token7 = token;
            } else if (n3 == 2) break;
            ++n3;
        }
        this.LOG.log(Level.FINEST, "---------------------------------------------------------------");
        this.LOG.log(Level.FINEST, "move() diff   : {0}", n2);
        this.LOG.log(Level.FINEST, "beforeLiteral : {0}", token2);
        this.LOG.log(Level.FINEST, "before2       : {0}", token3);
        this.LOG.log(Level.FINEST, "before1       : {0}", token4);
        this.LOG.log(Level.FINEST, "active        : {0}", token5);
        this.LOG.log(Level.FINEST, "after1        : {0}", token6);
        this.LOG.log(Level.FINEST, "after2        : {0}", token7);
        this.LOG.log(Level.FINEST, "afterLiteral  : {0}", token8);
        return new CompletionContext((Token<? extends GroovyTokenId>)token2, (Token<? extends GroovyTokenId>)token3, (Token<? extends GroovyTokenId>)token4, (Token<? extends GroovyTokenId>)token5, (Token<? extends GroovyTokenId>)token6, (Token<? extends GroovyTokenId>)token7, (Token<? extends GroovyTokenId>)token8, tokenSequence);
    }

    boolean checkForPackageStatement(CompletionRequest completionRequest) {
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence(completionRequest.doc, 1);
        if (tokenSequence != null) {
            tokenSequence.move(1);
            while (tokenSequence.isValid() && tokenSequence.moveNext() && tokenSequence.offset() < completionRequest.doc.getLength()) {
                Token token = tokenSequence.token();
                if (token.id() != GroovyTokenId.LITERAL_package) continue;
                return true;
            }
        }
        return false;
    }

    private CaretLocation getCaretLocationFromRequest(CompletionRequest completionRequest) {
        Token token;
        Token token2;
        int n = completionRequest.lexOffset;
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence(completionRequest.doc, n);
        tokenSequence.move(n);
        if (tokenSequence.isValid() && tokenSequence.moveNext() && tokenSequence.offset() < completionRequest.doc.getLength()) {
            token2 = tokenSequence.token();
            if (token2.id() == GroovyTokenId.LINE_COMMENT || token2.id() == GroovyTokenId.BLOCK_COMMENT) {
                return CaretLocation.INSIDE_COMMENT;
            }
            if (token2.id() == GroovyTokenId.STRING_LITERAL) {
                return CaretLocation.INSIDE_STRING;
            }
            if (token2.id() == GroovyTokenId.NLS && tokenSequence.isValid() && tokenSequence.movePrevious() && tokenSequence.offset() >= 0 && (token = tokenSequence.token()).id() == GroovyTokenId.LINE_COMMENT) {
                return CaretLocation.INSIDE_COMMENT;
            }
        }
        tokenSequence.move(n);
        while (tokenSequence.isValid() && tokenSequence.moveNext() && tokenSequence.offset() < completionRequest.doc.getLength()) {
            token2 = tokenSequence.token();
            if (token2.id() != GroovyTokenId.LITERAL_package) continue;
            return CaretLocation.ABOVE_PACKAGE;
        }
        boolean bl = false;
        tokenSequence.move(n);
        while (tokenSequence.isValid() && tokenSequence.movePrevious() && tokenSequence.offset() >= 0) {
            token = tokenSequence.token();
            if (token.id() != GroovyTokenId.LITERAL_class && token.id() != GroovyTokenId.LITERAL_interface) continue;
            bl = true;
            break;
        }
        boolean bl2 = false;
        tokenSequence.move(n);
        while (tokenSequence.isValid() && tokenSequence.moveNext() && tokenSequence.offset() < completionRequest.doc.getLength()) {
            Token token3 = tokenSequence.token();
            if (token3.id() != GroovyTokenId.LITERAL_class && token3.id() != GroovyTokenId.LITERAL_interface) continue;
            bl2 = true;
            break;
        }
        if (!bl && bl2) {
            return CaretLocation.ABOVE_FIRST_CLASS;
        }
        if (!bl && !bl2) {
            completionRequest.scriptMode = true;
            return CaretLocation.INSIDE_METHOD;
        }
        if (completionRequest.path == null) {
            this.LOG.log(Level.FINEST, "path == null");
            return null;
        }
        for (ASTNode aSTNode : completionRequest.path) {
            if (aSTNode instanceof ClosureExpression) {
                return CaretLocation.INSIDE_CLOSURE;
            }
            if (aSTNode instanceof FieldNode) {
                FieldNode fieldNode = (FieldNode)aSTNode;
                if (!fieldNode.isClosureSharedVariable()) continue;
                return CaretLocation.INSIDE_CLOSURE;
            }
            if (aSTNode instanceof MethodNode) {
                return CaretLocation.INSIDE_METHOD;
            }
            if (aSTNode instanceof ClassNode) {
                return CaretLocation.INSIDE_CLASS;
            }
            if (aSTNode instanceof ModuleNode) {
                return CaretLocation.OUTSIDE_CLASSES;
            }
            if (!(aSTNode instanceof Parameter)) continue;
            return CaretLocation.INSIDE_PARAMETERS;
        }
        return CaretLocation.UNDEFINED;
    }

    private ArgumentListExpression getSurroundingArgumentList(AstPath astPath) {
        if (astPath == null) {
            this.LOG.log(Level.FINEST, "path == null");
            return null;
        }
        this.LOG.log(Level.FINEST, "AEL, Path : {0}", astPath);
        for (ASTNode aSTNode : astPath) {
            if (!(aSTNode instanceof ArgumentListExpression)) continue;
            return (ArgumentListExpression)aSTNode;
        }
        return null;
    }

    private ASTNode getSurroundingMethodOrClosure(CompletionRequest completionRequest) {
        if (completionRequest.path == null) {
            this.LOG.log(Level.FINEST, "path == null");
            return null;
        }
        this.LOG.log(Level.FINEST, "getSurroundingMethodOrClosure() ----------------------------------------");
        this.LOG.log(Level.FINEST, "Path : {0}", completionRequest.path);
        for (ASTNode aSTNode : completionRequest.path) {
            AnnotatedNode annotatedNode;
            if (aSTNode instanceof MethodNode) {
                annotatedNode = (MethodNode)aSTNode;
                this.LOG.log(Level.FINEST, "Found Method: {0}", ((MethodNode)annotatedNode).getName());
                return annotatedNode;
            }
            if (aSTNode instanceof FieldNode) {
                annotatedNode = (FieldNode)aSTNode;
                if (!((FieldNode)annotatedNode).isClosureSharedVariable()) continue;
                this.LOG.log(Level.FINEST, "Found Closure(Field): {0}", ((FieldNode)annotatedNode).getName());
                return annotatedNode;
            }
            if (!(aSTNode instanceof ClosureExpression)) continue;
            this.LOG.log(Level.FINEST, "Found Closure(Expr.): {0}", ((ClosureExpression)aSTNode).getText());
            return aSTNode;
        }
        return null;
    }

    private ClassNode getSurroundingClassNode(CompletionRequest completionRequest) {
        if (completionRequest.path == null) {
            this.LOG.log(Level.FINEST, "path == null");
            return null;
        }
        for (ASTNode aSTNode : completionRequest.path) {
            if (!(aSTNode instanceof ClassNode)) continue;
            ClassNode classNode = (ClassNode)aSTNode;
            this.LOG.log(Level.FINEST, "Found surrounding Class: {0}", classNode.getName());
            return classNode;
        }
        return null;
    }

    private AstPath getPathFromRequest(CompletionRequest completionRequest) {
        ModuleNode moduleNode = AstUtilities.getRoot(completionRequest.info);
        if (moduleNode == null) {
            this.LOG.log(Level.FINEST, "AstUtilities.getRoot(request.info) returned null.");
            this.LOG.log(Level.FINEST, "request.info   = {0}", completionRequest.info);
            this.LOG.log(Level.FINEST, "request.prefix = {0}", completionRequest.prefix);
            return null;
        }
        return new AstPath((ASTNode)moduleNode, completionRequest.astOffset, completionRequest.doc);
    }

    private AstPath getPath(CompilationInfo compilationInfo, BaseDocument baseDocument, int n) {
        ModuleNode moduleNode = AstUtilities.getRoot(compilationInfo);
        if (moduleNode == null) {
            this.LOG.log(Level.FINEST, "AstUtilities.getRoot(request.info) returned null.");
            this.LOG.log(Level.FINEST, "request.info   = {0}", compilationInfo);
            return null;
        }
        return new AstPath((ASTNode)moduleNode, n, baseDocument);
    }

    private AstPath getPathFromInfo(int n, CompilationInfo compilationInfo) {
        assert (compilationInfo != null);
        ModuleNode moduleNode = AstUtilities.getRoot(compilationInfo);
        BaseDocument baseDocument = (BaseDocument)compilationInfo.getDocument();
        return new AstPath((ASTNode)moduleNode, n, baseDocument);
    }

    private boolean completeKeywords(List<CompletionProposal> list, CompletionRequest completionRequest) {
        this.LOG.log(Level.FINEST, "-> completeKeywords");
        String string = completionRequest.prefix;
        if (completionRequest.location == CaretLocation.INSIDE_PARAMETERS) {
            this.LOG.log(Level.FINEST, "no keywords completion inside of parameters");
            return false;
        }
        if (completionRequest.behindDot) {
            this.LOG.log(Level.FINEST, "We are invoked right behind a dot.");
            return false;
        }
        boolean bl = this.checkForPackageStatement(completionRequest);
        this.keywords = EnumSet.allOf(GroovyKeyword.class);
        this.filterPackageStatement(bl);
        this.filterPrefix(string);
        this.filterLocation(completionRequest.location);
        this.filterClassInterfaceOrdering(completionRequest.ctx);
        this.filterMethodDefinitions(completionRequest.ctx);
        this.filterKeywordsNextToEachOther(completionRequest.ctx);
        for (GroovyKeyword groovyKeyword : this.keywords) {
            this.LOG.log(Level.FINEST, "Adding keyword proposal : {0}", groovyKeyword.name);
            list.add((CompletionProposal)new KeywordItem(groovyKeyword.name, null, this.anchor, completionRequest, groovyKeyword.isGroovy));
        }
        return true;
    }

    void filterPackageStatement(boolean bl) {
        for (GroovyKeyword groovyKeyword : this.keywords) {
            if (!groovyKeyword.name.equals("package") || !bl) continue;
            this.keywords.remove((Object)groovyKeyword);
        }
    }

    void filterPrefix(String string) {
        for (GroovyKeyword groovyKeyword : this.keywords) {
            if (groovyKeyword.name.startsWith(string)) continue;
            this.keywords.remove((Object)groovyKeyword);
        }
    }

    void filterLocation(CaretLocation caretLocation) {
        for (GroovyKeyword groovyKeyword : this.keywords) {
            if (this.checkKeywordAllowance(groovyKeyword, caretLocation)) continue;
            this.keywords.remove((Object)groovyKeyword);
        }
    }

    void filterClassInterfaceOrdering(CompletionContext completionContext) {
        if (completionContext == null || completionContext.beforeLiteral == null) {
            return;
        }
        if (completionContext.beforeLiteral.id() == GroovyTokenId.LITERAL_interface) {
            this.keywords.clear();
            this.keywords.add(GroovyKeyword.KEYWORD_extends);
        } else if (completionContext.beforeLiteral.id() == GroovyTokenId.LITERAL_class) {
            this.keywords.clear();
            this.keywords.add(GroovyKeyword.KEYWORD_extends);
            this.keywords.add(GroovyKeyword.KEYWORD_implements);
        }
    }

    void filterMethodDefinitions(CompletionContext completionContext) {
        if (completionContext == null || completionContext.afterLiteral == null) {
            return;
        }
        if (completionContext.afterLiteral.id() == GroovyTokenId.LITERAL_void || completionContext.afterLiteral.id() == GroovyTokenId.IDENTIFIER || ((GroovyTokenId)completionContext.afterLiteral.id()).primaryCategory().equals("number")) {
            for (GroovyKeyword groovyKeyword : this.keywords) {
                if (groovyKeyword.category != KeywordCategory.PRIMITIVE) continue;
                this.LOG.log(Level.FINEST, "filterMethodDefinitions - removing : {0}", groovyKeyword.name);
                this.keywords.remove((Object)groovyKeyword);
            }
        }
    }

    void filterKeywordsNextToEachOther(CompletionContext completionContext) {
        if (completionContext == null) {
            return;
        }
        boolean bl = false;
        if (completionContext.after1 != null && ((GroovyTokenId)completionContext.after1.id()).primaryCategory().equals("keyword")) {
            bl = true;
        }
        if (completionContext.before1 != null && ((GroovyTokenId)completionContext.before1.id()).primaryCategory().equals("keyword")) {
            bl = true;
        }
        if (bl) {
            for (GroovyKeyword groovyKeyword : this.keywords) {
                if (groovyKeyword.category != KeywordCategory.KEYWORD) continue;
                this.LOG.log(Level.FINEST, "filterMethodDefinitions - removing : {0}", groovyKeyword.name);
                this.keywords.remove((Object)groovyKeyword);
            }
        }
    }

    boolean checkKeywordAllowance(GroovyKeyword groovyKeyword, CaretLocation caretLocation) {
        if (caretLocation == null) {
            return false;
        }
        switch (caretLocation) {
            case ABOVE_FIRST_CLASS: {
                if (!groovyKeyword.aboveFistClass) break;
                return true;
            }
            case OUTSIDE_CLASSES: {
                if (!groovyKeyword.outsideClasses) break;
                return true;
            }
            case INSIDE_CLASS: {
                if (!groovyKeyword.insideClass) break;
                return true;
            }
            case INSIDE_METHOD: 
            case INSIDE_CLOSURE: {
                if (!groovyKeyword.insideCode) break;
                return true;
            }
        }
        return false;
    }

    private boolean completeNewVars(List<CompletionProposal> list, CompletionRequest completionRequest, List<String> list2) {
        this.LOG.log(Level.FINEST, "-> completeNewVars");
        if (completionRequest.location == CaretLocation.OUTSIDE_CLASSES) {
            this.LOG.log(Level.FINEST, "outside of any class, bail out.");
            return false;
        }
        if (completionRequest.behindDot) {
            this.LOG.log(Level.FINEST, "We are invoked right behind a dot.");
            return false;
        }
        if (list2 == null) {
            this.LOG.log(Level.FINEST, "Can not propose with newVars == null");
            return false;
        }
        boolean bl = false;
        for (String string : list2) {
            this.LOG.log(Level.FINEST, "Variable candidate: {0}", string);
            if (!string.startsWith(completionRequest.prefix)) continue;
            list.add((CompletionProposal)new NewVarItem(string, this.anchor, completionRequest));
            bl = true;
        }
        return bl;
    }

    private boolean completeFields(List<CompletionProposal> list, CompletionRequest completionRequest) {
        ClassNode classNode;
        Object object;
        Object object2;
        this.LOG.log(Level.FINEST, "-> completeFields");
        if (completionRequest.location == CaretLocation.INSIDE_PARAMETERS && !completionRequest.behindDot) {
            this.LOG.log(Level.FINEST, "no fields completion inside of parameters-list");
            return false;
        }
        if (completionRequest.behindDot) {
            this.LOG.log(Level.FINEST, "We are invoked right behind a dot.");
            object2 = this.getPackageRequest(completionRequest);
            if (((PackageCompletionRequest)object2).basePackage.length() > 0 && this.isValidPackage((ClasspathInfo)(object = this.getClasspathInfoFromRequest(completionRequest)), ((PackageCompletionRequest)object2).basePackage)) {
                this.LOG.log(Level.FINEST, "The string before the dot seems to be a valid package");
                return false;
            }
            classNode = this.getBeforeDotDeclaringClass(completionRequest);
            if (classNode == null) {
                this.LOG.log(Level.FINEST, "No declaring class found");
                return false;
            }
        } else {
            classNode = this.getSurroundingClassNode(completionRequest);
            if (classNode == null) {
                this.LOG.log(Level.FINEST, "No surrounding class found, bail out ...");
                return false;
            }
        }
        this.LOG.log(Level.FINEST, "requestedClass is : {0}", classNode);
        object2 = classNode.getFields();
        object = object2.iterator();
        while (object.hasNext()) {
            Object object3;
            FieldNode fieldNode = (FieldNode)object.next();
            this.LOG.log(Level.FINEST, "-------------------------------------------------------------------------");
            this.LOG.log(Level.FINEST, "Field found       : {0}", fieldNode.getName());
            String string = fieldNode.getType().getNameWithoutPackage();
            if (completionRequest.behindDot) {
                MetaProperty metaProperty;
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(fieldNode.getOwner().getName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.LOG.log(Level.FINEST, "Class.forName() failed: {0}", classNotFoundException.getMessage());
                }
                if (clazz != null && (object3 = GroovySystem.getMetaClassRegistry().getMetaClass(clazz)) != null && (metaProperty = object3.getMetaProperty(fieldNode.getName())) != null) {
                    this.LOG.log(Level.FINEST, "Type from MetaProperty: {0}", metaProperty.getType());
                    string = metaProperty.getType().getSimpleName();
                }
            }
            if (fieldNode.getName().startsWith("__timeStamp")) continue;
            int n = 0;
            object3 = completionRequest.prefix;
            if (completionRequest.prefix.startsWith("$")) {
                object3 = completionRequest.prefix.substring(1);
                n = 1;
            }
            if (!fieldNode.getName().startsWith((String)object3)) continue;
            list.add((CompletionProposal)new FieldItem(fieldNode.getName(), this.anchor + n, completionRequest, ElementKind.FIELD, string));
        }
        return true;
    }

    private boolean completeLocalVars(List<CompletionProposal> list, CompletionRequest completionRequest) {
        this.LOG.log(Level.FINEST, "-> completeLocalVars");
        if (completionRequest.location != CaretLocation.INSIDE_CLOSURE && completionRequest.location != CaretLocation.INSIDE_METHOD) {
            this.LOG.log(Level.FINEST, "not inside method or closure, bail out.");
            return false;
        }
        if (completionRequest.behindDot) {
            this.LOG.log(Level.FINEST, "We are invoked right behind a dot.");
            return false;
        }
        ASTNode aSTNode = this.getSurroundingMethodOrClosure(completionRequest);
        if (completionRequest.scriptMode) {
            this.LOG.log(Level.FINEST, "We are running in script-mode.");
            if (aSTNode == null) {
                aSTNode = AstUtilities.getRoot(completionRequest.info);
            }
        }
        if (aSTNode == null) {
            this.LOG.log(Level.FINEST, "scope == null");
            return false;
        }
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        this.getLocalVars(aSTNode, arrayList, completionRequest);
        if (!arrayList.isEmpty()) {
            for (ASTNode aSTNode2 : arrayList) {
                String string = ((Variable)((Object)aSTNode2)).getName();
                this.LOG.log(Level.FINEST, "Node found: {0}", string);
                if (completionRequest.prefix.length() < 1) {
                    list.add((CompletionProposal)new LocalVarItem((Variable)((Object)aSTNode2), this.anchor, completionRequest));
                    continue;
                }
                if (string.compareTo(completionRequest.prefix) == 0 || !string.startsWith(completionRequest.prefix)) continue;
                list.add((CompletionProposal)new LocalVarItem((Variable)((Object)aSTNode2), this.anchor, completionRequest));
            }
        }
        return true;
    }

    private boolean checkForVariableDefinition(CompletionRequest completionRequest) {
        this.LOG.log(Level.FINEST, "checkForVariableDefinition()");
        CompletionContext completionContext = completionRequest.ctx;
        if (completionContext == null || completionContext.before1 == null) {
            return false;
        }
        GroovyTokenId groovyTokenId = (GroovyTokenId)completionContext.before1.id();
        switch (groovyTokenId) {
            case LITERAL_boolean: 
            case LITERAL_byte: 
            case LITERAL_char: 
            case LITERAL_double: 
            case LITERAL_float: 
            case LITERAL_int: 
            case LITERAL_long: 
            case LITERAL_short: 
            case LITERAL_def: {
                this.LOG.log(Level.FINEST, "LITERAL_* discovered");
                return true;
            }
            case IDENTIFIER: {
                ASTNode aSTNode = this.getASTNodeForToken(completionContext.before1, completionRequest);
                this.LOG.log(Level.FINEST, "getASTNodeForToken(ASTNode) : {0}", aSTNode);
                if (aSTNode != null && (aSTNode instanceof ClassExpression || aSTNode instanceof DeclarationExpression)) {
                    this.LOG.log(Level.FINEST, "ClassExpression or DeclarationExpression discovered");
                    return true;
                }
                return false;
            }
        }
        this.LOG.log(Level.FINEST, "default:");
        return false;
    }

    private ASTNode getASTNodeForToken(Token<? extends GroovyTokenId> token, CompletionRequest completionRequest) {
        this.LOG.log(Level.FINEST, "getASTNodeForToken()");
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)completionRequest.doc);
        int n = token.offset(tokenHierarchy);
        ModuleNode moduleNode = AstUtilities.getRoot(completionRequest.info);
        if (moduleNode == null) {
            return null;
        }
        int n2 = AstUtilities.getAstOffset(completionRequest.info, n);
        if (n2 == -1) {
            return null;
        }
        BaseDocument baseDocument = (BaseDocument)completionRequest.info.getDocument();
        if (baseDocument == null) {
            this.LOG.log(Level.FINEST, "Could not get BaseDocument. It's null");
            return null;
        }
        AstPath astPath = new AstPath((ASTNode)moduleNode, n2, baseDocument);
        ASTNode aSTNode = astPath.leaf();
        this.LOG.log(Level.FINEST, "path = {0}", astPath);
        this.LOG.log(Level.FINEST, "node: {0}", aSTNode);
        return aSTNode;
    }

    private List<String> getNewVarNameSuggestion(CompletionContext completionContext) {
        String string;
        this.LOG.log(Level.FINEST, "getNewVarNameSuggestion()");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (completionContext == null || completionContext.before1 == null) {
            return arrayList;
        }
        if (completionContext.before1.id() == GroovyTokenId.LITERAL_boolean) {
            arrayList.add("b");
        } else if (completionContext.before1.id() == GroovyTokenId.LITERAL_byte) {
            arrayList.add("b");
        } else if (completionContext.before1.id() == GroovyTokenId.LITERAL_char) {
            arrayList.add("c");
        } else if (completionContext.before1.id() == GroovyTokenId.LITERAL_double) {
            arrayList.add("d");
        } else if (completionContext.before1.id() == GroovyTokenId.LITERAL_float) {
            arrayList.add("f");
        } else if (completionContext.before1.id() == GroovyTokenId.LITERAL_int) {
            arrayList.add("i");
        } else if (completionContext.before1.id() == GroovyTokenId.LITERAL_long) {
            arrayList.add("l");
        } else if (completionContext.before1.id() == GroovyTokenId.LITERAL_short) {
            arrayList.add("s");
        }
        if (completionContext.before1.id() == GroovyTokenId.IDENTIFIER && (string = ((Object)completionContext.before1.text()).toString()) != null) {
            this.addIfNotIn(arrayList, string.substring(0, 1).toLowerCase(Locale.ENGLISH));
            this.addIfNotIn(arrayList, string.toLowerCase(Locale.ENGLISH));
            this.addIfNotIn(arrayList, CodeCompleter.camelCaseHunch(string));
            this.addIfNotIn(arrayList, string.substring(0, 1).toLowerCase(Locale.ENGLISH) + string.substring(1));
        }
        return arrayList;
    }

    void addIfNotIn(List<String> list, String string) {
        if (string.length() > 0 && !list.contains(string)) {
            this.LOG.log(Level.FINEST, "Adding new-var suggestion : {0}", string);
            list.add(string);
        }
    }

    void addIfNotInTypeHolderList(List<TypeHolder> list, TypeHolder typeHolder) {
        for (TypeHolder typeHolder2 : list) {
            if (!typeHolder2.getName().equals(typeHolder.getName())) continue;
            return;
        }
        this.LOG.log(Level.FINEST, "Adding Name to list : {0}", typeHolder.getName());
        list.add(typeHolder);
    }

    private static String camelCaseHunch(CharSequence charSequence) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            char c2 = Character.toLowerCase(c);
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private void getLocalVars(ASTNode aSTNode, List<ASTNode> list, CompletionRequest completionRequest) {
        if (aSTNode instanceof ClosureExpression) {
            ClosureExpression closureExpression = (ClosureExpression)aSTNode;
            if (closureExpression.isParameterSpecified()) {
                this.LOG.log(Level.FINEST, "We do have Parameters...");
                Parameter[] parameterArray = closureExpression.getParameters();
                for (int i = 0; i < parameterArray.length; ++i) {
                    Parameter parameter = parameterArray[i];
                    this.LOG.log(Level.FINEST, "Parameter: {0}", parameter.getName());
                    list.add(parameter);
                }
            } else {
                this.LOG.log(Level.FINEST, "Closure without parameters, have to put it in list");
                list.add(new VariableExpression("it"));
            }
            return;
        }
        if (aSTNode instanceof Variable) {
            this.addIfNotInList(list, aSTNode);
        }
        List<ASTNode> list2 = AstUtilities.children(aSTNode);
        for (ASTNode aSTNode2 : list2) {
            if (completionRequest.scriptMode && (aSTNode2 instanceof MethodNode || aSTNode2 instanceof ClosureExpression)) continue;
            this.getLocalVars(aSTNode2, list, completionRequest);
        }
    }

    private void addIfNotInList(List<ASTNode> list, ASTNode aSTNode) {
        String string = aSTNode.getText();
        for (ASTNode aSTNode2 : list) {
            if (!aSTNode2.getText().equals(string)) continue;
            return;
        }
        if (string.length() > 0) {
            list.add(aSTNode);
        }
    }

    boolean checkForRequestBehindImportStatement(CompletionRequest completionRequest) {
        int n = 0;
        int n2 = 0;
        try {
            n = Utilities.getRowStart((BaseDocument)completionRequest.doc, (int)completionRequest.lexOffset);
            n2 = Utilities.getFirstNonWhiteFwd((BaseDocument)completionRequest.doc, (int)n);
        }
        catch (BadLocationException badLocationException) {
            this.LOG.log(Level.FINEST, "Trouble doing getRowStart() or getFirstNonWhiteFwd(): {0}", badLocationException.getMessage());
        }
        Token<? extends GroovyTokenId> token = LexUtilities.getToken(completionRequest.doc, n2);
        if (token != null && token.id() == GroovyTokenId.LITERAL_import) {
            this.LOG.log(Level.FINEST, "Right behind an import statement");
            return true;
        }
        return false;
    }

    boolean checkBehindDot(CompletionRequest completionRequest) {
        boolean bl = false;
        if (completionRequest == null || completionRequest.ctx == null || completionRequest.ctx.before1 == null) {
            bl = false;
        } else if (CharSequenceUtilities.textEquals((CharSequence)completionRequest.ctx.before1.text(), (CharSequence)".") || ((Object)completionRequest.ctx.before1.text()).toString().equals(completionRequest.prefix) && completionRequest.ctx.before2 != null && CharSequenceUtilities.textEquals((CharSequence)completionRequest.ctx.before2.text(), (CharSequence)".")) {
            bl = true;
        }
        return bl;
    }

    PackageCompletionRequest getPackageRequest(CompletionRequest completionRequest) {
        Object object;
        StringBuffer stringBuffer;
        int n = completionRequest.lexOffset;
        PackageCompletionRequest packageCompletionRequest = new PackageCompletionRequest();
        TokenSequence<? extends GroovyTokenId> tokenSequence = LexUtilities.getGroovyTokenSequence(completionRequest.doc, n);
        tokenSequence.move(n);
        StringBuffer stringBuffer2 = null;
        boolean bl = true;
        while (tokenSequence.isValid() && (bl = tokenSequence.movePrevious()) && tokenSequence.offset() >= 0 && ((stringBuffer = tokenSequence.token()).id() == GroovyTokenId.DOT || stringBuffer.id() == GroovyTokenId.IDENTIFIER)) {
            stringBuffer2 = stringBuffer;
        }
        stringBuffer = new StringBuffer();
        CharSequence charSequence = null;
        if (!bl && stringBuffer2 != null && tokenSequence.isValid()) {
            stringBuffer.append(((Object)stringBuffer2.text()).toString());
            charSequence = stringBuffer2;
        }
        while (tokenSequence.isValid() && tokenSequence.moveNext() && tokenSequence.offset() < n && ((object = tokenSequence.token()).id() == GroovyTokenId.DOT || object.id() == GroovyTokenId.IDENTIFIER)) {
            stringBuffer.append(((Object)object.text()).toString());
            charSequence = object;
        }
        packageCompletionRequest.fullString = stringBuffer.toString();
        if (stringBuffer.length() == 0) {
            packageCompletionRequest.basePackage = "";
            packageCompletionRequest.prefix = "";
        } else if (charSequence != null && charSequence.id() == GroovyTokenId.DOT) {
            object = stringBuffer.toString();
            packageCompletionRequest.basePackage = ((String)object).substring(0, ((String)object).length() - 1);
            packageCompletionRequest.prefix = "";
        } else if (charSequence != null && charSequence.id() == GroovyTokenId.IDENTIFIER) {
            object = stringBuffer.toString();
            packageCompletionRequest.prefix = ((Object)charSequence.text()).toString();
            packageCompletionRequest.basePackage = ((String)object).substring(0, ((String)object).length() - packageCompletionRequest.prefix.length());
            if (packageCompletionRequest.basePackage.endsWith(".")) {
                packageCompletionRequest.basePackage = packageCompletionRequest.basePackage.substring(0, packageCompletionRequest.basePackage.length() - 1);
            }
        }
        this.LOG.log(Level.FINEST, "-- fullString : >{0}<", packageCompletionRequest.fullString);
        this.LOG.log(Level.FINEST, "-- basePackage: >{0}<", packageCompletionRequest.basePackage);
        this.LOG.log(Level.FINEST, "-- prefix:      >{0}<", packageCompletionRequest.prefix);
        return packageCompletionRequest;
    }

    private ClasspathInfo getClasspathInfoFromRequest(CompletionRequest completionRequest) {
        FileObject fileObject = completionRequest.info.getFileObject();
        if (fileObject != null) {
            return ClasspathInfo.create((FileObject)fileObject);
        }
        return null;
    }

    private JavaSource getJavaSourceFromRequest(CompletionRequest completionRequest) {
        ClasspathInfo classpathInfo = this.getClasspathInfoFromRequest(completionRequest);
        assert (classpathInfo != null);
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
        if (javaSource == null) {
            this.LOG.log(Level.FINEST, "Problem retrieving JavaSource from ClassPathInfo, exiting.");
            return null;
        }
        return javaSource;
    }

    private boolean completePackages(List<CompletionProposal> list, CompletionRequest completionRequest) {
        this.LOG.log(Level.FINEST, "-> completePackages");
        PackageCompletionRequest packageCompletionRequest = this.getPackageRequest(completionRequest);
        this.LOG.log(Level.FINEST, "Token fullString = >{0}<", packageCompletionRequest.fullString);
        ClasspathInfo classpathInfo = this.getClasspathInfoFromRequest(completionRequest);
        assert (classpathInfo != null) : "Can not get ClasspathInfo";
        if (completionRequest.ctx.before1 != null && CharSequenceUtilities.textEquals((CharSequence)completionRequest.ctx.before1.text(), (CharSequence)"*") && completionRequest.behindImport) {
            return false;
        }
        Set set = classpathInfo.getClassIndex().getPackageNames(packageCompletionRequest.fullString, true, EnumSet.allOf(ClassIndex.SearchScope.class));
        for (String string : set) {
            this.LOG.log(Level.FINEST, "PKG set item: {0}", string);
            if (packageCompletionRequest.prefix.equals("")) {
                string = string.substring(packageCompletionRequest.fullString.length());
            } else if (!packageCompletionRequest.basePackage.equals("")) {
                string = string.substring(packageCompletionRequest.basePackage.length() + 1);
            }
            if (!string.startsWith(packageCompletionRequest.prefix) || string.length() <= 0) continue;
            PackageItem packageItem = new PackageItem(string, this.anchor, completionRequest);
            if (completionRequest.behindImport) {
                packageItem.setSmart(true);
            }
            list.add((CompletionProposal)packageItem);
        }
        return false;
    }

    private boolean isValidPackage(ClasspathInfo classpathInfo, String string) {
        assert (classpathInfo != null) : "ClasspathInfo can not be null";
        Set set = classpathInfo.getClassIndex().getPackageNames(string, true, EnumSet.allOf(ClassIndex.SearchScope.class));
        if (set.size() > 0) {
            this.LOG.log(Level.FINEST, "Packages with prefix : {0}", string);
            this.LOG.log(Level.FINEST, "               found : {0}", set);
            for (String string2 : set) {
                if (!string2.equals(string)) continue;
                this.LOG.log(Level.FINEST, "Exact match found.");
                return true;
            }
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean completeTypes(List<CompletionProposal> list, CompletionRequest completionRequest) {
        Object object4;
        Collection<IndexedClass> collection;
        Object object5;
        ASTNode aSTNode22;
        this.LOG.log(Level.FINEST, "-> completeTypes");
        PackageCompletionRequest packageCompletionRequest = this.getPackageRequest(completionRequest);
        if (packageCompletionRequest.basePackage.length() == 0 && packageCompletionRequest.prefix.length() == 0 && packageCompletionRequest.fullString.equals(".")) {
            return false;
        }
        if (completionRequest.ctx.before1 != null && ((Object)completionRequest.ctx.before1.text()).toString().equals("new") && completionRequest.prefix.length() > 0) {
            return false;
        }
        boolean bl = false;
        if (completionRequest.ctx.beforeLiteral != null && completionRequest.ctx.beforeLiteral.id() == GroovyTokenId.LITERAL_implements) {
            this.LOG.log(Level.FINEST, "Completing only interfaces after implements keyword.");
            bl = true;
        }
        ModuleNode moduleNode = null;
        AstPath astPath = completionRequest.path;
        if (astPath != null) {
            for (ASTNode aSTNode22 : astPath) {
                if (!(aSTNode22 instanceof ModuleNode)) continue;
                this.LOG.log(Level.FINEST, "Found ModuleNode");
                moduleNode = (ModuleNode)aSTNode22;
            }
        }
        Object object6 = null;
        if (moduleNode != null) {
            object6 = moduleNode.getPackageName();
        } else {
            aSTNode22 = this.getSurroundingClassNode(completionRequest);
            if (aSTNode22 != null) {
                object6 = ((ClassNode)aSTNode22).getPackageName();
            }
        }
        aSTNode22 = this.getJavaSourceFromRequest(completionRequest);
        if (packageCompletionRequest.basePackage.length() > 0 || completionRequest.behindImport) {
            if (!completionRequest.behindImport || packageCompletionRequest.basePackage.length() != 0) {
                List<TypeHolder> list2 = this.getElementListForPackageAsTypeHolder((JavaSource)aSTNode22, packageCompletionRequest.basePackage, (String)object6);
                if (list2 == null) {
                    this.LOG.log(Level.FINEST, "Typelist is null for package : {0}", packageCompletionRequest.basePackage);
                    return false;
                }
                this.LOG.log(Level.FINEST, "Number of types found:  {0}", list2.size());
                for (TypeHolder typeHolder : list2) {
                    this.addToProposalUsingFilter(list, completionRequest, typeHolder, bl);
                }
            }
            return true;
        }
        if (completionRequest.behindDot) {
            return false;
        }
        if (moduleNode != null) {
            this.LOG.log(Level.FINEST, "We are living in package : {0} ", object6);
            object5 = new GroovyIndex(completionRequest.info.getIndex("text/x-groovy"));
            if (object5 != null) {
                collection = ((GroovyIndex)object5).getClasses("", NameKind.PREFIX, true, false, false);
                if (collection.size() == 0) {
                    this.LOG.log(Level.FINEST, "Nothing found in GroovyIndex");
                } else {
                    this.LOG.log(Level.FINEST, "Found this number of classes : {0} ", collection.size());
                    object4 = new ArrayList<TypeHolder>();
                    for (IndexedClass indexedClass : collection) {
                        this.LOG.log(Level.FINEST, "FQN classname from index : {0} ", indexedClass.getName());
                        Object object = indexedClass.getKind() == org.netbeans.modules.gsf.api.ElementKind.CLASS ? ElementKind.CLASS : ElementKind.INTERFACE;
                        this.addIfNotInTypeHolderList((List<TypeHolder>)object4, new TypeHolder(indexedClass.getName(), (ElementKind)((Object)object)));
                    }
                    Iterator iterator = object4.iterator();
                    while (iterator.hasNext()) {
                        TypeHolder typeHolder = (TypeHolder)iterator.next();
                        this.addToProposalUsingFilter(list, completionRequest, typeHolder, bl);
                    }
                }
            }
        }
        object5 = new ArrayList<String>();
        if (moduleNode != null) {
            collection = moduleNode.getImports();
            if (collection != null) {
                for (ImportNode importNode : collection) {
                    void var13_29;
                    this.LOG.log(Level.FINEST, "From getImports() : {0} ", importNode.getClassName());
                    if (importNode.getClass().isInterface()) {
                        ElementKind elementKind = ElementKind.INTERFACE;
                    } else {
                        ElementKind elementKind = ElementKind.CLASS;
                    }
                    this.addToProposalUsingFilter(list, completionRequest, new TypeHolder(importNode.getClassName(), (ElementKind)var13_29), bl);
                }
            }
            object4 = moduleNode.getImportPackages();
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                void var13_33;
                String string = (String)iterator.next();
                this.LOG.log(Level.FINEST, "From getImportPackages() : {0} ", string);
                if (string.endsWith(".")) {
                    String string2 = string.substring(0, string.length() - 1);
                }
                object5.add(var13_33);
            }
        }
        object5.addAll(this.dfltImports);
        collection = object5.iterator();
        while (collection.hasNext()) {
            object4 = (String)collection.next();
            List<TypeHolder> list2 = this.getElementListForPackageAsTypeHolder((JavaSource)aSTNode22, (String)object4, (String)object6);
            if (list2 == null) {
                this.LOG.log(Level.FINEST, "Typelist is null for package : {0}", object4);
                continue;
            }
            this.LOG.log(Level.FINEST, "Number of types found:  {0}", list2.size());
            for (Object object : list2) {
                this.addToProposalUsingFilter(list, completionRequest, (TypeHolder)object, bl);
            }
        }
        this.addToProposalUsingFilter(list, completionRequest, new TypeHolder("java.math.BigDecimal", ElementKind.CLASS), bl);
        this.addToProposalUsingFilter(list, completionRequest, new TypeHolder("java.math.BigInteger", ElementKind.CLASS), bl);
        return true;
    }

    void addToProposalUsingFilter(List<CompletionProposal> list, CompletionRequest completionRequest, TypeHolder typeHolder, boolean bl) {
        if (bl && typeHolder.getKind() != ElementKind.INTERFACE) {
            return;
        }
        String string = NbUtilities.stripPackage(typeHolder.getName());
        if (string.toUpperCase(Locale.ENGLISH).startsWith(completionRequest.prefix.toUpperCase(Locale.ENGLISH))) {
            list.add((CompletionProposal)new TypeItem(string, this.anchor, completionRequest, typeHolder.getKind()));
        }
    }

    List<? extends Element> getElementListForPackage(Elements elements, JavaSource javaSource, String string) {
        this.LOG.log(Level.FINEST, "getElementListForPackage(), Package :  {0}", string);
        List<? extends Element> list = null;
        if (elements != null && string != null) {
            this.LOG.log(Level.FINEST, "TypeSearcherHelper.run(), elements retrieved");
            PackageElement packageElement = elements.getPackageElement(string);
            if (packageElement == null) {
                this.LOG.log(Level.FINEST, "packageElement is null");
            } else {
                list = packageElement.getEnclosedElements();
            }
        }
        this.LOG.log(Level.FINEST, "Returning Typlist");
        return list;
    }

    List<TypeHolder> getElementListForPackageAsTypeHolder(JavaSource javaSource, final String string, final String string2) {
        this.LOG.log(Level.FINEST, "getElementListForPackageAsString(), Package :  {0}", string);
        final ArrayList<TypeHolder> arrayList = new ArrayList<TypeHolder>();
        if (javaSource != null) {
            try {
                javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) {
                        List<? extends Element> list = null;
                        Elements elements = compilationController.getElements();
                        if (elements != null && string != null) {
                            CodeCompleter.this.LOG.log(Level.FINEST, "TypeSearcherHelper.run(), elements retrieved");
                            PackageElement packageElement = elements.getPackageElement(string);
                            if (packageElement == null) {
                                CodeCompleter.this.LOG.log(Level.FINEST, "packageElement is null");
                            } else {
                                list = packageElement.getEnclosedElements();
                                boolean bl = string.equals(string2);
                                for (Element element : list) {
                                    Set<Modifier> set = element.getModifiers();
                                    if (!set.contains((Object)Modifier.PUBLIC) && (!bl || !set.contains((Object)Modifier.PROTECTED) && (set.contains((Object)Modifier.PUBLIC) || set.contains((Object)Modifier.PRIVATE)))) continue;
                                    arrayList.add(new TypeHolder(element.toString(), element.getKind()));
                                }
                            }
                        }
                    }
                }, true);
            }
            catch (IOException iOException) {
                this.LOG.log(Level.FINEST, "IOException : {0}", iOException.getMessage());
            }
        }
        return arrayList;
    }

    boolean isPackageAlreadyProposed(Set<String> set, String string) {
        for (String string2 : set) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    private ClassNode getBeforeDotDeclaringClass(CompletionRequest completionRequest) {
        ASTNode aSTNode;
        assert (completionRequest.behindDot);
        if (completionRequest.declaringClass != null && completionRequest.declaringClass instanceof ClassNode) {
            this.LOG.log(Level.FINEST, "returning declaringClass from request.");
            return completionRequest.declaringClass;
        }
        int n = completionRequest.lexOffset - completionRequest.prefix.length() - 1;
        int n2 = AstUtilities.getAstOffset(completionRequest.info, n);
        AstPath astPath = this.getPath(completionRequest.info, completionRequest.doc, n2);
        if (astPath == null) {
            this.LOG.log(Level.FINEST, "path == null");
            return null;
        }
        completionRequest.beforeDotPath = astPath;
        ASTNode aSTNode2 = astPath.leaf();
        this.LOG.log(Level.FINEST, "getDeclaringClass() ----------------------------------------");
        this.LOG.log(Level.FINEST, "Path : {0}", astPath);
        if (aSTNode2 == null) {
            this.LOG.log(Level.FINEST, "closest == null");
            return null;
        }
        if (aSTNode2 instanceof VariableExpression) {
            aSTNode = (ModuleNode)astPath.root();
            TypeVisitor typeVisitor = new TypeVisitor(aSTNode.getContext(), astPath, completionRequest.doc, n2);
            typeVisitor.collect();
            ASTNode aSTNode3 = typeVisitor.getGuessedType();
            if (aSTNode3 != null) {
                return aSTNode3;
            }
        }
        aSTNode = null;
        for (ASTNode aSTNode3 : astPath) {
            this.printASTNodeInformation("Declaring-class, current is:", aSTNode3);
            aSTNode = this.getBeforeDotDeclaringClass(aSTNode3);
            if (aSTNode == null) continue;
            break;
        }
        completionRequest.declaringClass = aSTNode;
        return aSTNode;
    }

    private ClassNode getBeforeDotDeclaringClass(ASTNode aSTNode) {
        this.printASTNodeInformation("Declaring-class, current is:", aSTNode);
        Expression expression = null;
        if (aSTNode instanceof VariableExpression) {
            this.LOG.log(Level.FINEST, "* VariableExpression");
            expression = (VariableExpression)aSTNode;
        } else if (aSTNode instanceof ExpressionStatement) {
            this.LOG.log(Level.FINEST, "* ExpressionStatement");
            expression = ((ExpressionStatement)aSTNode).getExpression();
        } else if (aSTNode instanceof PropertyExpression) {
            this.LOG.log(Level.FINEST, "* PropertyExpression");
            expression = ((PropertyExpression)aSTNode).getObjectExpression();
        } else if (aSTNode instanceof ConstructorCallExpression) {
            this.LOG.log(Level.FINEST, "* ConstructorCallExpression");
            expression = (ConstructorCallExpression)aSTNode;
        } else if (aSTNode instanceof MethodCallExpression) {
            this.LOG.log(Level.FINEST, "* MethodCallExpression");
            expression = ((MethodCallExpression)aSTNode).getObjectExpression();
        } else if (aSTNode instanceof ConstantExpression) {
            this.LOG.log(Level.FINEST, "* ConstantExpression");
            expression = (ConstantExpression)aSTNode;
        } else if (aSTNode instanceof MapExpression) {
            this.LOG.log(Level.FINEST, "* MapExpression");
            expression = (MapExpression)aSTNode;
        } else if (aSTNode instanceof ListExpression) {
            this.LOG.log(Level.FINEST, "* ListExpression");
            expression = (ListExpression)aSTNode;
        } else if (aSTNode instanceof RangeExpression) {
            this.LOG.log(Level.FINEST, "* RangeExpression");
            expression = (RangeExpression)aSTNode;
        }
        if (expression != null) {
            if (expression instanceof RangeExpression && "java.lang.Object".equals(expression.getType().getName())) {
                expression.setType(new ClassNode("groovy.lang.Range", 513, null));
            }
            return expression.getType();
        }
        return null;
    }

    static List<ParamDesc> getParameterList(ExecutableElement executableElement) {
        ArrayList<ParamDesc> arrayList = new ArrayList<ParamDesc>();
        if (executableElement != null) {
            List<? extends VariableElement> list = null;
            try {
                list = executableElement.getParameters();
                int n = 1;
                for (VariableElement variableElement : list) {
                    String string;
                    TypeMirror typeMirror = variableElement.asType();
                    String string2 = string = ((Object)typeMirror).toString();
                    if (typeMirror.getKind() == TypeKind.DECLARED) {
                        string2 = NbUtilities.stripPackage(string);
                    }
                    String string3 = "param" + String.valueOf(n);
                    arrayList.add(new ParamDesc(string, string2, string3));
                    ++n;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    static String getParameterListForMethod(ExecutableElement executableElement) {
        StringBuffer stringBuffer = new StringBuffer();
        if (executableElement != null) {
            List<? extends VariableElement> list = null;
            try {
                list = executableElement.getParameters();
                for (VariableElement variableElement : list) {
                    TypeMirror typeMirror = variableElement.asType();
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(", ");
                    }
                    if (typeMirror.getKind() == TypeKind.DECLARED) {
                        stringBuffer.append(NbUtilities.stripPackage(((Object)typeMirror).toString()));
                        continue;
                    }
                    stringBuffer.append(((Object)typeMirror).toString());
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }

    private boolean completeMethods(final List<CompletionProposal> list, final CompletionRequest completionRequest) {
        Object object;
        this.LOG.log(Level.FINEST, "-> completeMethods");
        if (completionRequest.location == CaretLocation.INSIDE_PARAMETERS) {
            this.LOG.log(Level.FINEST, "no method completion inside of parameters");
            return false;
        }
        if (completionRequest == null || completionRequest.ctx == null || completionRequest.ctx.before1 == null) {
            return false;
        }
        if (((Object)completionRequest.ctx.before1.text()).toString().equals("new") && completionRequest.prefix.length() > 0) {
            this.LOG.log(Level.FINEST, "This looks like a constructor ...");
            final ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(this.dfltImports);
            final JavaSource javaSource = this.getJavaSourceFromRequest(completionRequest);
            if (javaSource != null) {
                try {
                    javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController compilationController) {
                            for (String string : arrayList) {
                                List<? extends Element> list4 = CodeCompleter.this.getElementListForPackage(compilationController.getElements(), javaSource, string);
                                if (list4 == null) {
                                    CodeCompleter.this.LOG.log(Level.FINEST, "Typelist is null for package : {0}", string);
                                    continue;
                                }
                                CodeCompleter.this.LOG.log(Level.FINEST, "Number of types found:  {0}", list4.size());
                                for (Element element : list4) {
                                    if (element.getKind() != ElementKind.CLASS) continue;
                                    TypeElement typeElement = (TypeElement)element;
                                    List<? extends Element> list2 = typeElement.getEnclosedElements();
                                    String string2 = typeElement.getSimpleName().toString();
                                    for (Element element2 : list2) {
                                        if (element2.getKind() != ElementKind.CONSTRUCTOR || !string2.toUpperCase(Locale.ENGLISH).startsWith(completionRequest.prefix.toUpperCase(Locale.ENGLISH))) continue;
                                        CodeCompleter.this.LOG.log(Level.FINEST, "Constructor call candidate added : {0}", string2);
                                        String string3 = CodeCompleter.getParameterListForMethod((ExecutableElement)element2);
                                        List<ParamDesc> list3 = CodeCompleter.getParameterList((ExecutableElement)element2);
                                        list.add(new ConstructorItem(string2, string3, list3, CodeCompleter.this.anchor, completionRequest, false));
                                    }
                                }
                            }
                        }
                    }, true);
                }
                catch (IOException iOException) {
                    this.LOG.log(Level.FINEST, "IOException : {0}", iOException.getMessage());
                }
            }
            return !list.isEmpty();
        }
        if (!completionRequest.behindDot) {
            this.LOG.log(Level.FINEST, "I'm not invoked behind a dot.");
            return false;
        }
        ClassNode classNode = this.getBeforeDotDeclaringClass(completionRequest);
        if (classNode == null) {
            this.LOG.log(Level.FINEST, "No declaring class found");
            return false;
        }
        PackageCompletionRequest packageCompletionRequest = this.getPackageRequest(completionRequest);
        if (packageCompletionRequest.basePackage.length() > 0 && this.isValidPackage((ClasspathInfo)(object = this.getClasspathInfoFromRequest(completionRequest)), packageCompletionRequest.basePackage)) {
            this.LOG.log(Level.FINEST, "The string before the dot seems to be a valid package");
            return false;
        }
        if (classNode.isInterface()) {
            this.populateProposalWithMethodsFromClass(list, completionRequest, classNode.getName(), true);
        } else {
            this.populateProposalWithMethodsFromClass(list, completionRequest, classNode.getName(), false);
        }
        object = new GroovyIndex(completionRequest.info.getIndex("text/x-groovy"));
        if (object != null) {
            Set<IndexedMethod> set;
            String string = "";
            if (completionRequest.prefix != null) {
                string = completionRequest.prefix;
            }
            if ((set = string.equals("") ? ((GroovyIndex)object).getMethods(".*", classNode.getName(), NameKind.REGEXP, EnumSet.allOf(Index.SearchScope.class)) : ((GroovyIndex)object).getMethods(string, classNode.getName(), NameKind.PREFIX, EnumSet.allOf(Index.SearchScope.class))).size() == 0) {
                this.LOG.log(Level.FINEST, "Nothing found in GroovyIndex");
            } else {
                this.LOG.log(Level.FINEST, "Found this number of methods : {0} ", set.size());
                for (IndexedMethod indexedMethod : set) {
                    this.LOG.log(Level.FINEST, "method from index : {0} ", indexedMethod.getName());
                    list.add((CompletionProposal)new JavaMethodItem(indexedMethod.getName(), "", "", this.anchor, completionRequest));
                }
            }
        }
        return true;
    }

    private void populateProposalWithMethodsFromClass(List<CompletionProposal> list, CompletionRequest completionRequest, String string, boolean bl) {
        Object object;
        Object object2;
        this.LOG.log(Level.FINEST, "populateProposalWithMethodsFromClass(): {0}", string);
        if (bl && (object2 = this.getJavaSourceFromRequest(completionRequest)) != null) {
            object = new CountDownLatch(1);
            try {
                object2.runUserActionTask((Task)new MethodCompletionHelper((CountDownLatch)object, (JavaSource)object2, string, completionRequest, list), true);
            }
            catch (IOException iOException) {
                this.LOG.log(Level.FINEST, "Problem in runUserActionTask :  {0}", iOException.getMessage());
                return;
            }
            try {
                ((CountDownLatch)object).await();
            }
            catch (InterruptedException interruptedException) {
                this.LOG.log(Level.FINEST, "InterruptedException while waiting on latch :  {0}", interruptedException.getMessage());
                return;
            }
        }
        try {
            object2 = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.LOG.log(Level.FINEST, "Class.forName() failed: {0}", classNotFoundException.getMessage());
            return;
        }
        if (object2 != null && (object = GroovySystem.getMetaClassRegistry().getMetaClass((Class)object2)) != null) {
            ArrayList<MethodItem> arrayList = new ArrayList<MethodItem>();
            this.LOG.log(Level.FINEST, "Adding groovy methods --------------------------");
            for (Object object3 : object.getMetaMethods()) {
                this.populateProposal((Class)object2, object3, completionRequest, arrayList, true);
            }
            this.LOG.log(Level.FINEST, "Adding JDK methods --------------------------");
            for (Object e : object.getMethods()) {
                this.populateProposal((Class)object2, e, completionRequest, arrayList, false);
            }
            for (MethodItem methodItem : arrayList) {
                list.add((CompletionProposal)methodItem);
            }
        }
    }

    private void populateProposal(Class clazz, Object object, CompletionRequest completionRequest, List<MethodItem> list, boolean bl) {
        MetaMethod metaMethod;
        if (object != null && object instanceof MetaMethod && (metaMethod = (MetaMethod)object).getName().startsWith(completionRequest.prefix)) {
            this.LOG.log(Level.FINEST, "Found matching method: {0}", metaMethod.getName());
            MethodItem methodItem = new MethodItem(clazz, metaMethod, this.anchor, completionRequest, bl);
            this.addOrReplaceItem(list, methodItem);
        }
    }

    private void addOrReplaceItem(List<MethodItem> list, MethodItem methodItem) {
        MetaMethod metaMethod = methodItem.getMethod();
        int n = metaMethod.getDeclaringClass().getSuperClassDistance();
        for (MethodItem methodItem2 : list) {
            MetaMethod metaMethod2 = methodItem2.getMethod();
            if (!metaMethod2.getName().equals(metaMethod.getName()) || !metaMethod2.getSignature().equals(metaMethod.getSignature())) continue;
            if (metaMethod2.getDeclaringClass().getSuperClassDistance() < n) {
                this.LOG.log(Level.FINEST, "Remove existing method: {0}", metaMethod.getName());
                list.remove((Object)methodItem2);
                break;
            }
            this.LOG.log(Level.FINEST, "Not removing existing method: {0}", metaMethod2.getName());
            return;
        }
        list.add(methodItem);
    }

    private boolean completeCamelCase(List<CompletionProposal> list, CompletionRequest completionRequest) {
        this.LOG.log(Level.FINEST, "-> completeCamelCase");
        if (completionRequest.location != CaretLocation.INSIDE_CLASS) {
            this.LOG.log(Level.FINEST, "Not inside a class");
            return false;
        }
        String string = completionRequest.prefix;
        if (string != null && string.length() > 0 && string.equals(string.toUpperCase())) {
            ClassNode classNode = this.getSurroundingClassNode(completionRequest);
            if (classNode == null) {
                this.LOG.log(Level.FINEST, "No surrounding class found, bail out ...");
                return false;
            }
            String string2 = this.computeCamelCaseSignature(classNode.getName());
            this.LOG.log(Level.FINEST, "Class name          : {0}", classNode.getName());
            this.LOG.log(Level.FINEST, "CamelCase signature : {0}", string2);
            if (string2.startsWith(string)) {
                this.LOG.log(Level.FINEST, "Prefix matches Class's CamelCase signature. Adding.");
                list.add((CompletionProposal)new ConstructorItem(classNode.getName(), null, null, this.anchor, completionRequest, true));
                return true;
            }
        }
        return false;
    }

    private String computeCamelCaseSignature(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isUpperCase(string.charAt(i))) continue;
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeCompletionResult complete(CodeCompletionContext codeCompletionContext) {
        CompilationInfo compilationInfo = codeCompletionContext.getInfo();
        String string = codeCompletionContext.getPrefix();
        int n = codeCompletionContext.getCaretOffset();
        int n2 = AstUtilities.getAstOffset(compilationInfo, n);
        this.LOG.log(Level.FINEST, "complete(...), prefix      : {0}", string);
        this.LOG.log(Level.FINEST, "complete(...), lexOffset   : {0}", n);
        this.LOG.log(Level.FINEST, "complete(...), astOffset   : {0}", n2);
        if (string == null) {
            string = "";
        }
        ArrayList<CompletionProposal> arrayList = new ArrayList<CompletionProposal>();
        this.anchor = n - string.length();
        Document document = compilationInfo.getDocument();
        if (document == null) {
            return CodeCompletionResult.NONE;
        }
        BaseDocument baseDocument = (BaseDocument)document;
        baseDocument.readLock();
        try {
            CompletionRequest completionRequest = new CompletionRequest();
            completionRequest.lexOffset = n;
            completionRequest.astOffset = n2;
            completionRequest.doc = baseDocument;
            completionRequest.info = compilationInfo;
            completionRequest.prefix = string;
            completionRequest.scriptMode = false;
            completionRequest.path = this.getPathFromRequest(completionRequest);
            this.LOG.log(Level.FINEST, "complete(...), path        : {0}", completionRequest.path);
            completionRequest.location = this.getCaretLocationFromRequest(completionRequest);
            this.LOG.log(Level.FINEST, "I am here in sourcecode: {0}", (Object)completionRequest.location);
            if (completionRequest.location == CaretLocation.ABOVE_PACKAGE || completionRequest.location == CaretLocation.INSIDE_COMMENT) {
                DefaultCompletionResult defaultCompletionResult = new DefaultCompletionResult(arrayList, false);
                return defaultCompletionResult;
            }
            completionRequest.ctx = this.getCompletionContext(completionRequest);
            assert (completionRequest.ctx != null);
            completionRequest.behindDot = this.checkBehindDot(completionRequest);
            if (completionRequest.behindDot) {
                completionRequest.declaringClass = this.getBeforeDotDeclaringClass(completionRequest);
            }
            boolean bl = this.checkForVariableDefinition(completionRequest);
            completionRequest.behindImport = this.checkForRequestBehindImportStatement(completionRequest);
            List<String> list = null;
            if (bl) {
                list = this.getNewVarNameSuggestion(completionRequest.ctx);
            } else {
                if (completionRequest.location != CaretLocation.OUTSIDE_CLASSES && completionRequest.location != CaretLocation.INSIDE_STRING) {
                    this.completePackages(arrayList, completionRequest);
                    this.completeTypes(arrayList, completionRequest);
                }
                if (!completionRequest.behindImport) {
                    if (completionRequest.location != CaretLocation.INSIDE_STRING) {
                        this.completeKeywords(arrayList, completionRequest);
                        this.completeMethods(arrayList, completionRequest);
                    }
                    this.completeFields(arrayList, completionRequest);
                    this.completeLocalVars(arrayList, completionRequest);
                }
            }
            this.completeNewVars(arrayList, completionRequest, list);
            this.completeCamelCase(arrayList, completionRequest);
            DefaultCompletionResult defaultCompletionResult = new DefaultCompletionResult(arrayList, false);
            return defaultCompletionResult;
        }
        finally {
            baseDocument.readUnlock();
        }
    }

    static String getMethodSignature(MetaMethod metaMethod, boolean bl, boolean bl2) {
        String string = metaMethod.getSignature();
        string = string.trim();
        if (bl2) {
            int n = string.indexOf(" ");
            if (n != -1) {
                string = string.substring(n + 1);
            }
            if (bl) {
                string = string.replaceAll(", ", ",%20");
            }
            return string;
        }
        String[] stringArray = string.split("[()]");
        if (stringArray.length < 2) {
            return "";
        }
        String string2 = CodeCompleter.decodeTypes(stringArray[1], bl);
        return stringArray[0] + "(" + string2 + ")";
    }

    static String decodeTypes(String string, boolean bl) {
        String string2 = ",";
        string2 = bl ? string2 + "%20" : string2 + " ";
        StringBuffer stringBuffer = new StringBuffer("");
        boolean bl2 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '[') {
                bl2 = true;
                continue;
            }
            if (c == 'Z') {
                stringBuffer.append("boolean");
            } else if (c == 'B') {
                stringBuffer.append("byte");
            } else if (c == 'C') {
                stringBuffer.append("char");
            } else if (c == 'D') {
                stringBuffer.append("double");
            } else if (c == 'F') {
                stringBuffer.append("float");
            } else if (c == 'I') {
                stringBuffer.append("int");
            } else if (c == 'J') {
                stringBuffer.append("long");
            } else if (c == 'S') {
                stringBuffer.append("short");
            } else if (c == 'L') {
                int n = string.indexOf(";", ++i);
                String string3 = string.substring(i, n);
                string3 = string3.replace('/', '.');
                if (bl) {
                    stringBuffer.append(string3);
                } else {
                    stringBuffer.append(NbUtilities.stripPackage(string3));
                }
                i = n;
            }
            if (bl2) {
                stringBuffer.append("[]");
                bl2 = false;
            }
            if (i >= string.length() - 1) continue;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public String document(CompilationInfo compilationInfo, ElementHandle elementHandle) {
        this.LOG.log(Level.FINEST, "document(), ElementHandle : {0}", elementHandle);
        String string = "<h2>" + NbBundle.getMessage(CodeCompleter.class, (String)"CodeCompleter_NoJavaDocFound") + "</h2>";
        String string2 = null;
        if (elementHandle instanceof AstMethodElement) {
            Object object;
            Object object2;
            String string3;
            String string4;
            AstMethodElement astMethodElement = (AstMethodElement)elementHandle;
            String string5 = "";
            if (this.jdkJavaDocBase != null && !astMethodElement.isGDK()) {
                string5 = this.jdkJavaDocBase;
            } else if (this.groovyJavaDocBase != null && astMethodElement.isGDK()) {
                string5 = this.groovyJavaDocBase;
            } else {
                this.LOG.log(Level.FINEST, "Neither JDK nor GDK or error locating: {0}", astMethodElement.isGDK());
                return string;
            }
            MetaMethod metaMethod = astMethodElement.getMethod();
            this.printMethod(metaMethod);
            if (astMethodElement.isGDK()) {
                string4 = metaMethod.getDeclaringClass().getCachedClass().getName();
            } else {
                string3 = null;
                if (metaMethod != null && (object2 = metaMethod.getDeclaringClass()) != null && (object = ((CachedClass)object2).getCachedClass()) != null) {
                    string3 = ((Class)object).getName();
                }
                string4 = string3 != null ? string3 : astMethodElement.getClz().getName();
            }
            string3 = string4.replace(".", "/");
            string3 = string3 + ".html";
            if (!astMethodElement.isGDK()) {
                try {
                    object2 = new URL(this.gapiDocBase + string3);
                    object = new File(((URL)object2).toURI());
                }
                catch (MalformedURLException malformedURLException) {
                    this.LOG.log(Level.FINEST, "MalformedURLException: {0}", malformedURLException);
                    return string;
                }
                catch (URISyntaxException uRISyntaxException) {
                    this.LOG.log(Level.FINEST, "URISyntaxException: {0}", uRISyntaxException);
                    return string;
                }
                if (object != null && ((File)object).exists()) {
                    string5 = this.gapiDocBase;
                }
            }
            object2 = CodeCompleter.getMethodSignature(astMethodElement.getMethod(), true, astMethodElement.isGDK());
            object = CodeCompleter.getMethodSignature(astMethodElement.getMethod(), false, astMethodElement.isGDK());
            String string6 = string5 + string3 + "#" + (String)object2;
            try {
                this.LOG.log(Level.FINEST, "Trying to load URL = {0}", string6);
                string2 = HTMLJavadocParser.getJavadocText(new URL(string6), false, astMethodElement.isGDK());
            }
            catch (MalformedURLException malformedURLException) {
                this.LOG.log(Level.FINEST, "document(), URL trouble: {0}", malformedURLException);
                return string;
            }
            if (string2 == null) {
                return string;
            }
            string2 = "<h3>" + string4 + "." + (String)object + "</h3><BR>" + string2;
        }
        return string2;
    }

    public ElementHandle resolveLink(String string, ElementHandle elementHandle) {
        return elementHandle;
    }

    public String getPrefix(CompilationInfo compilationInfo, int n, boolean bl) {
        return null;
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent jTextComponent, String string) {
        char c = string.charAt(0);
        if (c == '.') {
            return CodeCompletionHandler.QueryType.COMPLETION;
        }
        return CodeCompletionHandler.QueryType.NONE;
    }

    public String resolveTemplateVariable(String string, CompilationInfo compilationInfo, int n, String string2, Map map) {
        return null;
    }

    public Set<String> getApplicableTemplates(CompilationInfo compilationInfo, int n, int n2) {
        return Collections.emptySet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ParameterInfo parameters(CompilationInfo compilationInfo, int n, CompletionProposal completionProposal) {
        this.LOG.log(Level.FINEST, "parameters(), caretOffset = {0}", n);
        ArrayList<String> arrayList = new ArrayList<String>();
        AstPath astPath = this.getPathFromInfo(n, compilationInfo);
        BaseDocument baseDocument = (BaseDocument)compilationInfo.getDocument();
        if (astPath != null) {
            ArgumentListExpression argumentListExpression = this.getSurroundingArgumentList(astPath);
            if (argumentListExpression != null) {
                List<ASTNode> list = AstUtilities.children(argumentListExpression);
                int n2 = 1;
                int n3 = -1;
                int n4 = -1;
                for (ASTNode aSTNode : list) {
                    OffsetRange offsetRange = AstUtilities.getRange(aSTNode, baseDocument);
                    arrayList.add(aSTNode.getText());
                    if (offsetRange.containsInclusive(n)) {
                        n4 = offsetRange.getStart();
                        n3 = n2;
                    }
                    ++n2;
                }
                if (arrayList == null || arrayList.isEmpty()) return ParameterInfo.NONE;
                return new ParameterInfo(arrayList, n3, n4);
            }
            this.LOG.log(Level.FINEST, "ArgumentListExpression ==  null");
            return ParameterInfo.NONE;
        }
        this.LOG.log(Level.FINEST, "path ==  null");
        return ParameterInfo.NONE;
    }

    static class ParamDesc {
        String fullTypeName;
        String typeName;
        String name;

        public ParamDesc(String string, String string2, String string3) {
            this.fullTypeName = string;
            this.typeName = string2;
            this.name = string3;
        }
    }

    static class CompletionRequest {
        CompilationInfo info;
        int lexOffset;
        int astOffset;
        BaseDocument doc;
        String prefix = "";
        CaretLocation location;
        boolean behindDot;
        boolean scriptMode;
        boolean behindImport;
        CompletionContext ctx;
        AstPath path;
        AstPath beforeDotPath;
        ClassNode declaringClass;

        CompletionRequest() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MethodCompletionHelper
    implements Task<CompilationController> {
        private final CountDownLatch cnt;
        private final JavaSource javaSource;
        private final String className;
        private final CompletionRequest request;
        private final List<CompletionProposal> proposals;

        public MethodCompletionHelper(CountDownLatch countDownLatch, JavaSource javaSource, String string, CompletionRequest completionRequest, List<CompletionProposal> list) {
            this.cnt = countDownLatch;
            this.javaSource = javaSource;
            this.className = string;
            this.request = completionRequest;
            this.proposals = list;
        }

        public void run(CompilationController compilationController) throws Exception {
            Elements elements = compilationController.getElements();
            if (elements != null) {
                ElementUtilities.ElementAcceptor elementAcceptor = new ElementUtilities.ElementAcceptor(){

                    public boolean accept(Element element, TypeMirror typeMirror) {
                        return element.getKind() == ElementKind.METHOD;
                    }
                };
                TypeElement typeElement = elements.getTypeElement(this.className);
                if (typeElement != null) {
                    for (Element element : compilationController.getElementUtilities().getMembers(typeElement.asType(), elementAcceptor)) {
                        String string = element.getSimpleName().toString();
                        String string2 = CodeCompleter.getParameterListForMethod((ExecutableElement)element);
                        String string3 = ((Object)((ExecutableElement)element).getReturnType()).toString();
                        if (!string.toUpperCase(Locale.ENGLISH).startsWith(this.request.prefix.toUpperCase(Locale.ENGLISH))) continue;
                        this.proposals.add((CompletionProposal)new JavaMethodItem(string, string2, string3, CodeCompleter.this.anchor, this.request));
                    }
                }
            }
            this.cnt.countDown();
        }
    }

    class TypeHolder {
        String name;
        ElementKind kind;

        public TypeHolder(String string, ElementKind elementKind) {
            this.name = string;
            this.kind = elementKind;
        }

        public ElementKind getKind() {
            return this.kind;
        }

        public String getName() {
            return this.name;
        }
    }

    class PackageCompletionRequest {
        String fullString = "";
        String basePackage = "";
        String prefix = "";

        PackageCompletionRequest() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CompletionContext {
        Token<? extends GroovyTokenId> beforeLiteral;
        Token<? extends GroovyTokenId> before2;
        Token<? extends GroovyTokenId> before1;
        Token<? extends GroovyTokenId> active;
        Token<? extends GroovyTokenId> after1;
        Token<? extends GroovyTokenId> after2;
        Token<? extends GroovyTokenId> afterLiteral;
        TokenSequence<?> ts;

        public CompletionContext(Token<? extends GroovyTokenId> token, Token<? extends GroovyTokenId> token2, Token<? extends GroovyTokenId> token3, Token<? extends GroovyTokenId> token4, Token<? extends GroovyTokenId> token5, Token<? extends GroovyTokenId> token6, Token<? extends GroovyTokenId> token7, TokenSequence<?> tokenSequence) {
            this.beforeLiteral = token;
            this.before2 = token2;
            this.before1 = token3;
            this.active = token4;
            this.after1 = token5;
            this.after2 = token6;
            this.afterLiteral = token7;
            this.ts = tokenSequence;
        }
    }
}

