/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.model;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.ruby.debugger.model.VariablesModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.rubyforge.debugcommons.model.RubyVariable;

public final class WatchesModel
extends VariablesModel {
    public static final String WATCH = "org/netbeans/modules/debugger/resources/watchesView/watch_16.png";
    private WatchesListener listener;

    public WatchesModel(ContextProvider contextProvider) {
        super(contextProvider);
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        this.checkListener(object);
        if (object == "Root") {
            return DebuggerManager.getDebuggerManager().getWatches();
        }
        if (object instanceof Watch) {
            RubyVariable rubyVariable = this.resolveVariable((Watch)object);
            return rubyVariable == null ? new Object[]{} : super.getChildren(rubyVariable, n, n2);
        }
        return super.getChildren(object, n, n2);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return false;
        }
        if (object instanceof Watch) {
            RubyVariable rubyVariable = this.resolveVariable((Watch)object);
            return rubyVariable == null ? true : super.isLeaf(rubyVariable);
        }
        return super.isLeaf(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        this.checkListener(object);
        if (object == "Root") {
            return DebuggerManager.getDebuggerManager().getWatches().length;
        }
        if (object instanceof Watch) {
            RubyVariable rubyVariable = this.resolveVariable((Watch)object);
            return rubyVariable == null ? 0 : super.getChildrenCount(rubyVariable);
        }
        return super.getChildrenCount(object);
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return WatchesModel.getMessage("CTL_CallstackModel.Column.Name.Name");
        }
        if (object instanceof Watch) {
            return ((Watch)object).getExpression();
        }
        return super.getDisplayName(object);
    }

    public String getIconBaseWithExtension(Object object) throws UnknownTypeException {
        if (object == "Root" || object instanceof Watch) {
            return WATCH;
        }
        return super.getIconBaseWithExtension(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return WatchesModel.getMessage("CTL_CallstackModel.Column.Name.Desc");
        }
        if (object instanceof Watch) {
            RubyVariable rubyVariable = this.resolveVariable((Watch)object);
            return rubyVariable == null ? WatchesModel.getMessage("CTL_WatchesModel.Unknown.Evaluation") : super.getShortDescription(rubyVariable);
        }
        return super.getShortDescription(object);
    }

    public Object getValueAt(Object object, String string) throws UnknownTypeException {
        if (object instanceof Watch) {
            RubyVariable rubyVariable = this.resolveVariable((Watch)object);
            if (rubyVariable == null) {
                return WatchesModel.getMessage("CTL_WatchesModel.Unknown.Evaluation");
            }
            if ("WatchValue".equals(string)) {
                return super.getValueAt(rubyVariable, "LocalsValue");
            }
            if ("WatchType".equals(string)) {
                return super.getValueAt(rubyVariable, "LocalsType");
            }
        } else {
            if ("WatchValue".equals(string)) {
                return super.getValueAt(object, "LocalsValue");
            }
            if ("WatchType".equals(string)) {
                return super.getValueAt(object, "LocalsType");
            }
            if ("WatchToString".equals(string)) {
                return super.getValueAt(object, "LocalsToString");
            }
        }
        throw new UnknownTypeException(object);
    }

    public boolean isReadOnly(Object object, String string) throws UnknownTypeException {
        return true;
    }

    public void setValueAt(Object object, String string, Object object2) throws UnknownTypeException {
        throw new UnknownTypeException(object);
    }

    private synchronized void checkListener(Object object) {
        if (this.listener == null && (object == "Root" || object instanceof Watch)) {
            this.listener = new WatchesListener(this);
        }
    }

    private void fireWatchPropertyChanged(Watch watch, String string) {
        for (ModelListener modelListener : this.listeners) {
            modelListener.modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)watch));
        }
    }

    private RubyVariable resolveVariable(Watch watch) {
        String string = watch.getExpression();
        return this.rubySession.inspectExpression(string);
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(WatchesModel.class, (String)string);
    }

    private static class WatchesListener
    extends DebuggerManagerAdapter
    implements PropertyChangeListener {
        private WeakReference<WatchesModel> modelRef;

        public WatchesListener(WatchesModel watchesModel) {
            Watch[] watchArray;
            this.modelRef = new WeakReference<WatchesModel>(watchesModel);
            DebuggerManager.getDebuggerManager().addDebuggerListener("watches", (DebuggerManagerListener)this);
            for (Watch watch : watchArray = DebuggerManager.getDebuggerManager().getWatches()) {
                watch.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private WatchesModel getModel() {
            WatchesModel watchesModel = (WatchesModel)this.modelRef.get();
            if (watchesModel == null) {
                Watch[] watchArray;
                DebuggerManager.getDebuggerManager().removeDebuggerListener("watches", (DebuggerManagerListener)this);
                for (Watch watch : watchArray = DebuggerManager.getDebuggerManager().getWatches()) {
                    watch.addPropertyChangeListener((PropertyChangeListener)this);
                }
            }
            return watchesModel;
        }

        public void watchAdded(Watch watch) {
            WatchesModel watchesModel = this.getModel();
            if (watchesModel == null) {
                return;
            }
            watch.addPropertyChangeListener((PropertyChangeListener)this);
            watchesModel.fireChanges();
        }

        public void watchRemoved(Watch watch) {
            WatchesModel watchesModel = this.getModel();
            if (watchesModel == null) {
                return;
            }
            watch.removePropertyChangeListener((PropertyChangeListener)this);
            watchesModel.fireChanges();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            WatchesModel watchesModel = this.getModel();
            if (watchesModel == null) {
                return;
            }
            if (!(propertyChangeEvent.getSource() instanceof Watch)) {
                return;
            }
            Watch watch = (Watch)propertyChangeEvent.getSource();
            watchesModel.fireWatchPropertyChanged(watch, propertyChangeEvent.getPropertyName());
        }
    }
}

