/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.breakpoints;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.ruby.debugger.EditorUtil;
import org.netbeans.modules.ruby.debugger.Util;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpoint;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpointManager;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyExceptionBreakpoint;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyLineBreakpoint;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.text.Line;
import org.openide.util.Exceptions;

public final class BreakpointsReader
implements Properties.Reader {
    private static final String PROPERTY_URL = "url";
    private static final String PROPERTY_LINE_NUMBER = "lineNumber";
    private static final String PROPERTY_CONDITION = "condition";
    private static final String PROPERTY_EXCEPTION = "exception";

    public String[] getSupportedClassNames() {
        return new String[]{RubyBreakpoint.class.getName()};
    }

    public Object read(String string, Properties properties) {
        if (string.equals(RubyLineBreakpoint.class.getName())) {
            Line line = BreakpointsReader.getLine(properties.getString(PROPERTY_URL, null), properties.getInt(PROPERTY_LINE_NUMBER, 1));
            if (line != null) {
                String string2 = properties.getString(PROPERTY_CONDITION, null);
                return RubyBreakpointManager.createLineBreakpoint(line, string2);
            }
        } else if (string.equals(RubyExceptionBreakpoint.class.getName())) {
            String string3 = properties.getString(PROPERTY_EXCEPTION, null);
            return RubyBreakpointManager.createExceptionBreakpoint(string3);
        }
        return null;
    }

    public void write(Object object, Properties properties) {
        if (object instanceof RubyLineBreakpoint) {
            RubyLineBreakpoint rubyLineBreakpoint = (RubyLineBreakpoint)((Object)object);
            FileObject fileObject = rubyLineBreakpoint.getFileObject();
            try {
                properties.setString(PROPERTY_URL, fileObject.getURL().toString());
                properties.setInt(PROPERTY_LINE_NUMBER, rubyLineBreakpoint.getLine().getLineNumber());
                properties.setString(PROPERTY_CONDITION, rubyLineBreakpoint.getCondition());
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
        } else if (object instanceof RubyExceptionBreakpoint) {
            RubyExceptionBreakpoint rubyExceptionBreakpoint = (RubyExceptionBreakpoint)((Object)object);
            properties.setString(PROPERTY_EXCEPTION, rubyExceptionBreakpoint.getException());
        } else {
            throw new IllegalArgumentException("Unknown breakpoint type: " + object);
        }
    }

    private static Line getLine(String string, int n) {
        FileObject fileObject;
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            Util.finer("Did not find FileObject. Malformed URL '" + string + "'");
            return null;
        }
        if (fileObject == null) {
            return null;
        }
        LineCookie lineCookie = EditorUtil.getLineCookie(fileObject);
        if (lineCookie == null) {
            return null;
        }
        Line.Set set = lineCookie.getLineSet();
        if (set == null) {
            return null;
        }
        try {
            return set.getCurrent(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Util.LOGGER.log(Level.FINE, indexOutOfBoundsException.getMessage(), indexOutOfBoundsException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Util.LOGGER.log(Level.FINE, illegalArgumentException.getMessage(), illegalArgumentException);
        }
        return null;
    }
}

