/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.modules.ruby.debugger.DebuggerBreakpointAnnotation;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyBreakpoint;
import org.netbeans.modules.ruby.debugger.breakpoints.RubyLineBreakpoint;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.AnnotationProvider;
import org.openide.text.Line;
import org.openide.util.Lookup;

public final class BreakpointAnnotationListener
extends DebuggerManagerAdapter
implements PropertyChangeListener,
AnnotationProvider {
    private Map<Breakpoint, Annotation> breakpointToAnnotation = new HashMap<Breakpoint, Annotation>();

    public String[] getProperties() {
        return new String[]{"breakpoints"};
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        if (!(breakpoint instanceof RubyLineBreakpoint)) {
            return;
        }
        this.addAnnotation(breakpoint);
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        if (!(breakpoint instanceof RubyBreakpoint)) {
            return;
        }
        this.removeAnnotation(breakpoint);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == "enabled" || string == "updated") {
            this.removeAnnotation((Breakpoint)propertyChangeEvent.getSource());
            this.addAnnotation((Breakpoint)propertyChangeEvent.getSource());
        }
    }

    private void addAnnotation(Breakpoint breakpoint) {
        DebuggerBreakpointAnnotation debuggerBreakpointAnnotation = new DebuggerBreakpointAnnotation(breakpoint.isEnabled() ? "Breakpoint" : "DisabledBreakpoint", (Annotatable)((RubyLineBreakpoint)breakpoint).getLine(), breakpoint);
        this.breakpointToAnnotation.put(breakpoint, (Annotation)debuggerBreakpointAnnotation);
        breakpoint.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void removeAnnotation(Breakpoint breakpoint) {
        Annotation annotation = this.breakpointToAnnotation.remove(breakpoint);
        if (annotation == null) {
            return;
        }
        annotation.detach();
        breakpoint.removePropertyChangeListener((PropertyChangeListener)this);
    }

    public void annotate(Line.Set set, Lookup lookup) {
        DebuggerManager.getDebuggerManager().getBreakpoints();
    }
}

