/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.impl.xref;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;

public class ReferenceContextImpl
implements CsmReferenceContext {
    private final CsmReferenceContext parent;
    private final int parentSize;
    private final List stack;
    private int popCount;

    public ReferenceContextImpl() {
        this(null);
    }

    public ReferenceContextImpl(CsmReferenceContext csmReferenceContext) {
        this(csmReferenceContext, false);
    }

    public ReferenceContextImpl(CsmReferenceContext csmReferenceContext, boolean bl) {
        if (bl && csmReferenceContext != null) {
            this.parent = null;
            this.parentSize = 0;
            this.stack = new ArrayList();
            for (int i = 0; i < csmReferenceContext.size(); ++i) {
                this.stack.add(csmReferenceContext.getToken(i));
                this.stack.add(csmReferenceContext.getReference(i));
            }
        } else {
            this.parent = csmReferenceContext;
            this.parentSize = csmReferenceContext == null ? 0 : csmReferenceContext.size();
            this.stack = new ArrayList();
        }
    }

    public int size() {
        return this.parentSize - this.popCount + this.stack.size() / 2;
    }

    public CsmReference getReference() {
        return this.getReference(this.size() - 1);
    }

    public CsmReference getReference(int n) {
        if (0 <= n && n < this.parentSize - this.popCount) {
            return this.parent.getReference(n);
        }
        return (CsmReference)this.stack.get(2 * (n - this.parentSize + this.popCount) + 1);
    }

    public CppTokenId getToken() {
        return this.getToken(this.size() - 1);
    }

    public CppTokenId getToken(int n) {
        if (0 <= n && n < this.parentSize - this.popCount) {
            return this.parent.getToken(n);
        }
        return (CppTokenId)this.stack.get(2 * (n - this.parentSize + this.popCount));
    }

    void push(CppTokenId cppTokenId, CsmReference csmReference) {
        this.stack.add(cppTokenId);
        this.stack.add(csmReference);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void pop() {
        if (this.stack.isEmpty()) {
            if (this.popCount >= this.parentSize) throw new IllegalStateException("Stack underflow");
            ++this.popCount;
            return;
        } else {
            this.stack.remove(this.stack.size() - 1);
            this.stack.remove(this.stack.size() - 1);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            if (0 < i) {
                stringBuilder.append(' ');
            }
            stringBuilder.append('(');
            stringBuilder.append(this.getToken(i));
            stringBuilder.append(',');
            CsmReference csmReference = this.getReference(i);
            stringBuilder.append(csmReference == null ? null : csmReference.getText());
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }
}

