/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.csm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.services.CsmInheritanceUtilities;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.services.CsmUsingResolver;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmSortUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmContextUtilities;
import org.netbeans.modules.cnd.completion.impl.xref.FileReferencesContext;
import org.netbeans.modules.cnd.modelutil.AntiLoop;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CsmProjectContentResolver {
    private boolean caseSensitive = false;
    private boolean naturalSort = false;
    private boolean sort = false;
    private CsmFile file;
    private CsmProject project;
    private static final NsContentResultsFilter NS_VARIABLE_FILTER = new NsContentResultsFilter(){

        public Collection getResults(CsmProjectContentResolver csmProjectContentResolver, CsmNamespace csmNamespace, String string, boolean bl, boolean bl2) {
            return csmProjectContentResolver.getNamespaceVariables(csmNamespace, string, bl, bl2);
        }
    };
    private static final NsContentResultsFilter NS_FUNCTION_FILTER = new NsContentResultsFilter(){

        public Collection getResults(CsmProjectContentResolver csmProjectContentResolver, CsmNamespace csmNamespace, String string, boolean bl, boolean bl2) {
            return csmProjectContentResolver.getNamespaceFunctions(csmNamespace, string, bl, bl2);
        }
    };
    private static final NsContentResultsFilter NS_CLASS_ENUM_FILTER = new NsContentResultsFilter(){

        public Collection getResults(CsmProjectContentResolver csmProjectContentResolver, CsmNamespace csmNamespace, String string, boolean bl, boolean bl2) {
            return csmProjectContentResolver.getNamespaceClassesEnums(csmNamespace, string, bl, bl2);
        }
    };
    private static final NsContentResultsFilter NS_ENUMERATOR_FILTER = new NsContentResultsFilter(){

        public Collection getResults(CsmProjectContentResolver csmProjectContentResolver, CsmNamespace csmNamespace, String string, boolean bl, boolean bl2) {
            return csmProjectContentResolver.getNamespaceEnumerators(csmNamespace, string, bl, bl2);
        }
    };
    private static final NsContentResultsFilter NS_NAMESPACES_FILTER = new NsContentResultsFilter(){

        public Collection getResults(CsmProjectContentResolver csmProjectContentResolver, CsmNamespace csmNamespace, String string, boolean bl, boolean bl2) {
            return csmProjectContentResolver.getGlobalNamespaces(string, bl);
        }
    };
    private static final int INIT_INHERITANCE_LEVEL = 0;
    private static final int NO_INHERITANCE = 1;
    private static final int EXACT_CLASS = 2;
    private static final int CHILD_INHERITANCE = 3;

    public CsmProjectContentResolver() {
        this(false);
    }

    public CsmProjectContentResolver(boolean bl) {
        this(bl, false, false);
    }

    public CsmProjectContentResolver(boolean bl, boolean bl2) {
        this(bl, true, bl2);
    }

    public CsmProjectContentResolver(boolean bl, boolean bl2, boolean bl3) {
        this.caseSensitive = bl;
        this.naturalSort = bl3;
        this.sort = bl2;
    }

    public CsmProjectContentResolver(CsmProject csmProject) {
        this(csmProject, false);
    }

    public CsmProjectContentResolver(CsmProject csmProject, boolean bl) {
        this(csmProject, bl, false, false);
    }

    public CsmProjectContentResolver(CsmProject csmProject, boolean bl, boolean bl2, boolean bl3) {
        this((CsmFile)null, bl, bl2, bl3);
        this.project = csmProject;
    }

    public CsmProjectContentResolver(CsmFile csmFile) {
        this(csmFile, false, false, false);
    }

    public CsmProjectContentResolver(CsmFile csmFile, boolean bl) {
        this(csmFile, bl, false, false);
    }

    public CsmProjectContentResolver(CsmFile csmFile, boolean bl, boolean bl2, boolean bl3) {
        this.caseSensitive = bl;
        this.naturalSort = bl3;
        this.file = csmFile;
        this.project = csmFile != null ? csmFile.getProject() : null;
        this.sort = bl2;
    }

    private List<CsmEnumerator> getEnumeratorsFromEnumsAndTypedefs(List list, boolean bl, String string, boolean bl2) {
        ArrayList<CsmEnumerator> arrayList = new ArrayList<CsmEnumerator>();
        if (list != null) {
            for (CsmObject csmObject : list) {
                CsmEnum csmEnum = null;
                if (CsmKindUtilities.isEnum((CsmObject)csmObject)) {
                    csmEnum = (CsmEnum)csmObject;
                } else {
                    CsmType csmType;
                    assert (CsmKindUtilities.isTypedef((CsmObject)csmObject));
                    CsmTypedef csmTypedef = (CsmTypedef)csmObject;
                    if (csmTypedef.isTypeUnnamed() && csmTypedef.getType() != null && CsmKindUtilities.isEnum((CsmObject)(csmType = csmTypedef.getType()).getClassifier())) {
                        csmEnum = (CsmEnum)csmType.getClassifier();
                    }
                }
                if (csmEnum == null) continue;
                for (CsmType csmType : csmEnum.getEnumerators()) {
                    if (!this.matchName(((Object)csmType.getName()).toString(), string, bl)) continue;
                    arrayList.add((CsmEnumerator)csmType);
                }
            }
            if (bl2 && arrayList != null) {
                CsmSortUtilities.sortMembers(arrayList, (boolean)this.isCaseSensitive());
            }
        }
        return arrayList;
    }

    private CsmProject getProject() {
        return this.project;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    public boolean isNaturalSort() {
        return this.naturalSort;
    }

    public void setNaturalSort(boolean bl) {
        this.naturalSort = bl;
    }

    public boolean isSortNeeded() {
        return this.sort;
    }

    public void setSortNeeded(boolean bl) {
        this.sort = bl;
    }

    public CsmFile getFile() {
        return this.file;
    }

    public void setFile(CsmFile csmFile) {
        this.file = csmFile;
    }

    public List getGlobalVariables(String string, boolean bl) {
        if (this.project == null) {
            return Collections.EMPTY_LIST;
        }
        CsmNamespace csmNamespace = this.project.getGlobalNamespace();
        List<CsmVariable> list = this.getNamespaceVariables(csmNamespace, string, bl, false, false);
        if (list != null && this.sort) {
            CsmSortUtilities.sortMembers(list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List getGlobalFunctions(String string, boolean bl) {
        if (this.project == null) {
            return Collections.EMPTY_LIST;
        }
        CsmNamespace csmNamespace = this.project.getGlobalNamespace();
        List<CsmFunction> list = this.getNamespaceFunctions(csmNamespace, string, bl, false, false);
        if (list != null && this.sort) {
            CsmSortUtilities.sortMembers(list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List getGlobalNamespaces(String string, boolean bl) {
        if (this.project == null) {
            return Collections.EMPTY_LIST;
        }
        CsmNamespace csmNamespace = this.project.getGlobalNamespace();
        List<CsmNamespace> list = this.getNestedNamespaces(csmNamespace, string, bl);
        if (list != null && this.sort) {
            CsmSortUtilities.sortMembers(list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List<CsmMacro> getFileLocalMacros(CsmContext csmContext, String string, boolean bl) {
        List<CsmMacro> list = CsmContextUtilities.findFileLocalMacros(csmContext, string, bl, this.isCaseSensitive());
        if (list != null && this.isSortNeeded()) {
            CsmSortUtilities.sortMembers(list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List<CsmMacro> getFileIncludedProjectMacros(CsmContext csmContext, String string, boolean bl) {
        List<CsmMacro> list = CsmContextUtilities.findFileIncludedProjectMacros(csmContext, string, bl, this.isCaseSensitive());
        if (list != null && this.isSortNeeded()) {
            CsmSortUtilities.sortMembers(list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List<CsmMacro> getFileIncludeLibMacros(CsmContext csmContext, String string, boolean bl) {
        List<CsmMacro> list = CsmContextUtilities.findFileIncludedLibMacros(csmContext, string, bl, this.isCaseSensitive());
        if (list != null && this.isSortNeeded()) {
            CsmSortUtilities.sortMembers(list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List<CsmMacro> getProjectMacros(CsmContext csmContext, String string, boolean bl) {
        List<CsmMacro> list = CsmContextUtilities.findProjectMacros(csmContext, string, bl, this.isCaseSensitive());
        if (list != null && this.isSortNeeded()) {
            CsmSortUtilities.sortMembers(list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List<CsmMacro> getLibMacros(CsmContext csmContext, String string, boolean bl) {
        List<CsmMacro> list = CsmContextUtilities.findLibMacros(csmContext, string, bl, this.isCaseSensitive());
        if (list != null && this.isSortNeeded()) {
            CsmSortUtilities.sortMembers(list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public Collection<CsmVariable> getLibVariables(String string, boolean bl) {
        return this.getLibElements(NS_VARIABLE_FILTER, string, bl, this.isSortNeeded(), false);
    }

    public Collection<CsmFunction> getLibFunctions(String string, boolean bl) {
        return this.getLibElements(NS_FUNCTION_FILTER, string, bl, this.isSortNeeded(), false);
    }

    public Collection<CsmClassifier> getLibClassesEnums(String string, boolean bl) {
        return this.getLibElements(NS_CLASS_ENUM_FILTER, string, bl, this.isSortNeeded(), false);
    }

    public Collection<CsmEnumerator> getLibEnumerators(String string, boolean bl, boolean bl2) {
        return this.getLibElements(NS_ENUMERATOR_FILTER, string, bl, this.isSortNeeded(), false);
    }

    public Collection<CsmNamespace> getLibNamespaces(String string, boolean bl) {
        return this.getLibElements(NS_NAMESPACES_FILTER, string, bl, this.isSortNeeded(), false);
    }

    private Collection getLibElements(NsContentResultsFilter nsContentResultsFilter, String string, boolean bl, boolean bl2, boolean bl3) {
        if (this.project == null) {
            return Collections.EMPTY_LIST;
        }
        HashSet<CsmProject> hashSet = new HashSet<CsmProject>();
        Map<String, CsmObject> map = new HashMap<String, CsmObject>();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (Object object2 : this.project.getLibraries()) {
            if (hashSet.contains(object2)) continue;
            hashSet.add((CsmProject)object2);
            CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver((CsmProject)object2, this.isCaseSensitive(), this.isSortNeeded(), this.isNaturalSort());
            Collection collection = nsContentResultsFilter.getResults(csmProjectContentResolver, object2.getGlobalNamespace(), string, bl, bl3);
            if (bl) {
                linkedHashSet.addAll(collection);
                continue;
            }
            map = this.mergeByFQN(map, collection);
        }
        Object object = bl ? linkedHashSet : map.values();
        if (map != null && bl2) {
            Object object2;
            object2 = new ArrayList(object);
            CsmSortUtilities.sortMembers((List)object2, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
            object = object2;
        }
        return object;
    }

    public List<CsmDeclaration> findFunctionLocalDeclarations(CsmContext csmContext, String string, boolean bl) {
        List<CsmDeclaration> list = CsmContextUtilities.findFunctionLocalDeclarations(csmContext, string, bl, this.isCaseSensitive());
        if (this.isSortNeeded() && list != null) {
            CsmSortUtilities.sortMembers(list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List<CsmEnumerator> getFileLocalEnumerators(CsmContext csmContext, String string, boolean bl) {
        List<CsmEnumerator> list = CsmContextUtilities.findFileLocalEnumerators(csmContext, string, bl, this.isCaseSensitive());
        if (this.isSortNeeded() && list != null) {
            CsmSortUtilities.sortMembers(list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List<CsmVariable> getFileLocalVariables(CsmContext csmContext, FileReferencesContext fileReferencesContext, String string, boolean bl, boolean bl2) {
        ArrayList<CsmVariable> arrayList = new ArrayList<CsmVariable>();
        if (!csmContext.isEmpty()) {
            Iterator iterator = csmContext.iterator();
            while (iterator.hasNext()) {
                Object object;
                CsmContext.CsmContextEntry csmContextEntry = (CsmContext.CsmContextEntry)iterator.next();
                if (!CsmKindUtilities.isFile((CsmObject)csmContextEntry.getScope())) continue;
                CsmFile csmFile = (CsmFile)csmContextEntry.getScope();
                this.fillFileLocalVariables(string, bl, csmFile, bl2, false, arrayList);
                if (!bl2) {
                    object = null;
                    if (fileReferencesContext != null && !fileReferencesContext.isCleaned() && bl) {
                        object = fileReferencesContext.getFileLocalIncludeVariables(string);
                    }
                    if (object != null) {
                        arrayList.addAll((Collection<CsmVariable>)object);
                    } else {
                        this.fillFileLocalIncludeVariables(string, bl, csmFile, arrayList);
                    }
                }
                object = csmContext.iterator();
                while (object.hasNext()) {
                    CsmContext.CsmContextEntry csmContextEntry2 = (CsmContext.CsmContextEntry)object.next();
                    if (!CsmKindUtilities.isNamespaceDefinition((CsmObject)csmContextEntry2.getScope())) continue;
                    CsmNamespaceDefinition csmNamespaceDefinition = (CsmNamespaceDefinition)csmContextEntry2.getScope();
                    this.fillFileLocalIncludeNamespaceVariables(csmNamespaceDefinition.getNamespace(), string, bl, csmFile, arrayList);
                }
                break block0;
            }
        }
        return arrayList;
    }

    public List<CsmFunction> getFileLocalFunctions(CsmContext csmContext, String string, boolean bl, boolean bl2) {
        HashMap<CharSequence, CsmFunction> hashMap = new HashMap<CharSequence, CsmFunction>();
        if (!csmContext.isEmpty()) {
            Iterator iterator = csmContext.iterator();
            while (iterator.hasNext()) {
                CsmContext.CsmContextEntry csmContextEntry = (CsmContext.CsmContextEntry)iterator.next();
                if (!CsmKindUtilities.isFile((CsmObject)csmContextEntry.getScope())) continue;
                CsmFile csmFile = (CsmFile)csmContextEntry.getScope();
                this.fillFileLocalFunctions(string, bl, csmFile, bl2, false, hashMap);
                Iterator iterator2 = csmContext.iterator();
                while (iterator2.hasNext()) {
                    CsmContext.CsmContextEntry csmContextEntry2 = (CsmContext.CsmContextEntry)iterator2.next();
                    if (!CsmKindUtilities.isNamespaceDefinition((CsmObject)csmContextEntry2.getScope())) continue;
                    ArrayList<CsmFunction> arrayList = new ArrayList<CsmFunction>();
                    CsmNamespaceDefinition csmNamespaceDefinition = (CsmNamespaceDefinition)csmContextEntry2.getScope();
                    this.fillFileLocalIncludeNamespaceFunctions(csmNamespaceDefinition.getNamespace(), string, bl, csmFile, arrayList);
                    for (CsmFunction csmFunction : arrayList) {
                        hashMap.put(csmFunction.getSignature(), csmFunction);
                    }
                }
                break block0;
            }
        }
        return new ArrayList<CsmFunction>(hashMap.values());
    }

    private void fillFileLocalFunctions(String string, boolean bl, CsmFile csmFile, boolean bl2, boolean bl3, Map<CharSequence, CsmFunction> map) {
        CsmDeclaration.Kind[] kindArray = bl2 || bl3 ? new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.NAMESPACE_DEFINITION} : new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION};
        CsmSelect.CsmFilter csmFilter = CsmContextUtilities.createFilter(kindArray, string, bl, this.caseSensitive, bl3 || bl2);
        Iterator iterator = CsmSelect.getDefault().getDeclarations(csmFile, csmFilter);
        while (iterator.hasNext()) {
            CsmOffsetableDeclaration csmOffsetableDeclaration = (CsmOffsetableDeclaration)iterator.next();
            if (CsmKindUtilities.isFunction((CsmObject)csmOffsetableDeclaration)) {
                CsmFunction csmFunction = (CsmFunction)csmOffsetableDeclaration;
                if (!bl3 && !CsmBaseUtilities.isFileLocalFunction((CsmFunction)csmFunction) || csmOffsetableDeclaration.getName().length() == 0 || !this.matchName(csmOffsetableDeclaration.getName(), string, bl)) continue;
                map.put(((Object)csmFunction.getSignature()).toString(), csmFunction);
                continue;
            }
            if (!bl2 || !CsmKindUtilities.isNamespaceDefinition((CsmObject)csmOffsetableDeclaration) || ((CsmNamespaceDefinition)csmOffsetableDeclaration).getName().length() != 0) continue;
            this.fillFileLocalFunctions(string, bl, (CsmNamespaceDefinition)csmOffsetableDeclaration, bl2, true, map);
        }
    }

    private void fillFileLocalFunctions(String string, boolean bl, CsmNamespaceDefinition csmNamespaceDefinition, boolean bl2, boolean bl3, Map<CharSequence, CsmFunction> map) {
        CsmDeclaration.Kind[] kindArray = bl3 || bl2 ? new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION, CsmDeclaration.Kind.NAMESPACE_DEFINITION} : new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION};
        CsmSelect.CsmFilter csmFilter = CsmContextUtilities.createFilter(kindArray, string, bl, this.caseSensitive, bl3 || bl2);
        Iterator iterator = CsmSelect.getDefault().getDeclarations(csmNamespaceDefinition, csmFilter);
        while (iterator.hasNext()) {
            CsmOffsetableDeclaration csmOffsetableDeclaration = (CsmOffsetableDeclaration)iterator.next();
            if (CsmKindUtilities.isFunction((CsmObject)csmOffsetableDeclaration)) {
                CsmFunction csmFunction = (CsmFunction)csmOffsetableDeclaration;
                if (!bl3 && !CsmBaseUtilities.isFileLocalFunction((CsmFunction)csmFunction) || csmOffsetableDeclaration.getName().length() == 0 || !this.matchName(csmOffsetableDeclaration.getName(), string, bl)) continue;
                map.put(csmFunction.getSignature(), csmFunction);
                continue;
            }
            if (!bl2 || !CsmKindUtilities.isNamespaceDefinition((CsmObject)csmOffsetableDeclaration) || ((CsmNamespaceDefinition)csmOffsetableDeclaration).getName().length() != 0) continue;
            this.fillFileLocalFunctions(string, bl, (CsmNamespaceDefinition)csmOffsetableDeclaration, bl2, true, map);
        }
    }

    private void fillFileLocalVariables(String string, boolean bl, CsmFile csmFile, boolean bl2, boolean bl3, Collection<CsmVariable> collection) {
        CsmDeclaration.Kind[] kindArray = bl3 || bl2 ? new CsmDeclaration.Kind[]{CsmDeclaration.Kind.VARIABLE, CsmDeclaration.Kind.VARIABLE_DEFINITION, CsmDeclaration.Kind.NAMESPACE_DEFINITION} : new CsmDeclaration.Kind[]{CsmDeclaration.Kind.VARIABLE, CsmDeclaration.Kind.VARIABLE_DEFINITION};
        CsmSelect.CsmFilter csmFilter = CsmContextUtilities.createFilter(kindArray, string, bl, this.caseSensitive, true);
        Iterator iterator = CsmSelect.getDefault().getDeclarations(csmFile, csmFilter);
        this.fillFileLocalVariables(string, bl, iterator, bl2, bl3, collection);
    }

    private void fillUnionVariables(String string, boolean bl, CsmClass csmClass, Collection<CsmVariable> collection) {
        Iterator iterator = CsmSelect.getDefault().getClassMembers(csmClass, CsmSelect.getDefault().getFilterBuilder().createNameFilter(string, bl, this.caseSensitive, true));
        List list = CsmSortUtilities.filterList((Iterator)iterator, (CharSequence)string, (boolean)bl, (boolean)this.caseSensitive);
        collection.addAll(list);
    }

    private void fillNamespaceVariables(String string, boolean bl, CsmNamespaceDefinition csmNamespaceDefinition, boolean bl2, boolean bl3, Collection<CsmVariable> collection) {
        CsmDeclaration.Kind[] kindArray = bl3 || bl2 ? new CsmDeclaration.Kind[]{CsmDeclaration.Kind.VARIABLE, CsmDeclaration.Kind.VARIABLE_DEFINITION, CsmDeclaration.Kind.NAMESPACE_DEFINITION} : new CsmDeclaration.Kind[]{CsmDeclaration.Kind.VARIABLE, CsmDeclaration.Kind.VARIABLE_DEFINITION};
        CsmSelect.CsmFilter csmFilter = CsmContextUtilities.createFilter(kindArray, string, bl, this.caseSensitive, true);
        Iterator iterator = CsmSelect.getDefault().getDeclarations(csmNamespaceDefinition, csmFilter);
        this.fillFileLocalVariables(string, bl, iterator, bl2, bl3, collection);
    }

    private void fillFileLocalVariables(String string, boolean bl, Iterator<CsmOffsetableDeclaration> iterator, boolean bl2, boolean bl3, Collection<CsmVariable> collection) {
        while (iterator.hasNext()) {
            CsmOffsetableDeclaration csmOffsetableDeclaration = iterator.next();
            if (CsmKindUtilities.isVariable((CsmObject)csmOffsetableDeclaration)) {
                CsmClassifier csmClassifier;
                CharSequence charSequence = csmOffsetableDeclaration.getName();
                if (!bl3 && !CsmKindUtilities.isFileLocalVariable((CsmObject)csmOffsetableDeclaration)) continue;
                if (charSequence.length() != 0) {
                    if (!this.matchName(charSequence, string, bl)) continue;
                    collection.add((CsmVariable)csmOffsetableDeclaration);
                    continue;
                }
                CsmVariable csmVariable = (CsmVariable)csmOffsetableDeclaration;
                CsmType csmType = csmVariable.getType();
                if (csmType == null || (csmClassifier = csmType.getClassifier()) == null || !CsmKindUtilities.isUnion((CsmObject)csmClassifier)) continue;
                this.fillUnionVariables(string, bl, (CsmClass)csmClassifier, collection);
                continue;
            }
            if (!bl2 || !CsmKindUtilities.isNamespaceDefinition((CsmObject)csmOffsetableDeclaration) || ((CsmNamespaceDefinition)csmOffsetableDeclaration).getName().length() != 0) continue;
            this.fillNamespaceVariables(string, bl, (CsmNamespaceDefinition)csmOffsetableDeclaration, bl2, true, collection);
        }
    }

    private void fillFileLocalIncludeVariables(String string, boolean bl, CsmFile csmFile, Collection<CsmVariable> collection) {
        CsmDeclaration.Kind[] kindArray = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.VARIABLE, CsmDeclaration.Kind.VARIABLE_DEFINITION};
        CsmSelect.CsmFilter csmFilter = CsmContextUtilities.createFilter(kindArray, string, bl, this.caseSensitive, false);
        this.fillFileLocalIncludeVariables(csmFilter, csmFile, collection, new HashSet<CsmFile>(), true);
    }

    private void fillFileLocalIncludeVariables(CsmSelect.CsmFilter csmFilter, CsmFile csmFile, Collection<CsmVariable> collection, Set<CsmFile> set, boolean bl) {
        if (set.contains(csmFile)) {
            return;
        }
        set.add(csmFile);
        for (CsmInclude csmInclude : csmFile.getIncludes()) {
            CsmFile csmFile2 = csmInclude.getIncludeFile();
            if (csmFile2 == null) continue;
            this.fillFileLocalIncludeVariables(csmFilter, csmFile2, collection, set, false);
        }
        if (!bl) {
            Iterator iterator = CsmSelect.getDefault().getStaticVariables(csmFile, csmFilter);
            while (iterator.hasNext()) {
                CsmInclude csmInclude;
                csmInclude = (CsmOffsetableDeclaration)iterator.next();
                if (!CsmKindUtilities.isFileLocalVariable((CsmObject)csmInclude)) continue;
                collection.add((CsmVariable)csmInclude);
            }
        }
    }

    private void fillFileLocalIncludeNamespaceVariables(CsmNamespace csmNamespace, String string, boolean bl, CsmFile csmFile, Collection<CsmVariable> collection) {
        CsmDeclaration.Kind[] kindArray = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.VARIABLE, CsmDeclaration.Kind.VARIABLE_DEFINITION};
        ArrayList arrayList = new ArrayList();
        this.getFileLocalIncludeNamespaceMembers(csmNamespace, csmFile, arrayList);
        List<CsmVariable> list = new ArrayList<CsmVariable>();
        this.filterDeclarations(arrayList.iterator(), list, kindArray, string, bl, false);
        list = this.filterVariables(list);
        collection.addAll(list);
    }

    private void fillFileLocalIncludeNamespaceFunctions(CsmNamespace csmNamespace, String string, boolean bl, CsmFile csmFile, List<CsmFunction> list) {
        CsmDeclaration.Kind[] kindArray = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION};
        ArrayList arrayList = new ArrayList();
        this.getFileLocalIncludeNamespaceMembers(csmNamespace, csmFile, arrayList);
        List<Object> list2 = new ArrayList();
        this.filterDeclarations(arrayList.iterator(), list2, kindArray, string, bl, false);
        list2 = this.filterFunctionDefinitions(list2);
        list.addAll(list2);
    }

    private void getFileLocalIncludeNamespaceMembers(CsmNamespace csmNamespace, CsmFile csmFile, Collection collection) {
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : csmFile.getDeclarations()) {
            if (!CsmKindUtilities.isNamespaceDefinition((CsmObject)csmOffsetableDeclaration)) continue;
            CsmNamespaceDefinition csmNamespaceDefinition = (CsmNamespaceDefinition)csmOffsetableDeclaration;
            if (csmNamespaceDefinition.getQualifiedName().equals(csmNamespace.getQualifiedName())) {
                collection.addAll(csmNamespaceDefinition.getScopeElements());
                continue;
            }
            if (!((Object)csmNamespace.getQualifiedName()).toString().startsWith(((Object)csmNamespaceDefinition.getQualifiedName()).toString())) continue;
            this.getFileLocalIncludeNamespaceMembersFromNested(csmNamespace.getQualifiedName(), csmNamespaceDefinition, collection);
        }
    }

    private void getFileLocalIncludeNamespaceMembersFromNested(CharSequence charSequence, CsmNamespaceDefinition csmNamespaceDefinition, Collection collection) {
        for (CsmOffsetableDeclaration csmOffsetableDeclaration : csmNamespaceDefinition.getDeclarations()) {
            if (!CsmKindUtilities.isNamespaceDefinition((CsmObject)csmOffsetableDeclaration)) continue;
            CsmNamespaceDefinition csmNamespaceDefinition2 = (CsmNamespaceDefinition)csmOffsetableDeclaration;
            if (csmNamespaceDefinition2.getQualifiedName().equals(charSequence)) {
                collection.addAll(csmNamespaceDefinition2.getScopeElements());
                continue;
            }
            if (!((Object)charSequence).toString().startsWith(((Object)csmNamespaceDefinition2.getQualifiedName()).toString())) continue;
            this.getFileLocalIncludeNamespaceMembersFromNested(charSequence, csmNamespaceDefinition2, collection);
        }
    }

    public List<CsmVariable> getNamespaceVariables(CsmNamespace csmNamespace, String string, boolean bl, boolean bl2) {
        return this.getNamespaceVariables(csmNamespace, string, bl, this.isSortNeeded(), bl2);
    }

    private List<CsmVariable> getNamespaceVariables(CsmNamespace csmNamespace, String string, boolean bl, boolean bl2, boolean bl3) {
        List<CsmVariable> list = this.getNamespaceMembers(csmNamespace, CsmDeclaration.Kind.VARIABLE, string, bl, bl3, false);
        Collection collection = CsmUsingResolver.getDefault().findUsedDeclarations(csmNamespace);
        this.filterDeclarations(collection.iterator(), (Collection)list, new CsmDeclaration.Kind[]{CsmDeclaration.Kind.VARIABLE}, string, bl, false);
        list = this.filterVariables(list);
        if (bl2 && list != null) {
            CsmSortUtilities.sortMembers(list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List<CsmVariable> getFileLocalNamespaceVariables(CsmNamespace csmNamespace, CsmFile csmFile, String string, boolean bl) {
        ArrayList<CsmVariable> arrayList = new ArrayList<CsmVariable>();
        this.fillFileLocalIncludeNamespaceVariables(csmNamespace, string, bl, csmFile, arrayList);
        if (this.isSortNeeded() && arrayList != null) {
            CsmSortUtilities.sortMembers(arrayList, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return arrayList;
    }

    public List<CsmFunction> getFileLocalNamespaceFunctions(CsmNamespace csmNamespace, CsmFile csmFile, String string, boolean bl) {
        ArrayList<CsmFunction> arrayList = new ArrayList<CsmFunction>();
        this.fillFileLocalIncludeNamespaceFunctions(csmNamespace, string, bl, csmFile, arrayList);
        if (this.isSortNeeded() && arrayList != null) {
            CsmSortUtilities.sortMembers(arrayList, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return arrayList;
    }

    public List<CsmFunction> getNamespaceFunctions(CsmNamespace csmNamespace, String string, boolean bl, boolean bl2) {
        return this.getNamespaceFunctions(csmNamespace, string, bl, this.isSortNeeded(), bl2);
    }

    private List<CsmFunction> getNamespaceFunctions(CsmNamespace csmNamespace, String string, boolean bl, boolean bl2, boolean bl3) {
        CsmDeclaration.Kind[] kindArray = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION};
        List<CsmFunction> list = this.getNamespaceMembers(csmNamespace, kindArray, string, bl, bl3, false);
        Collection collection = CsmUsingResolver.getDefault().findUsedDeclarations(csmNamespace);
        this.filterDeclarations(collection.iterator(), (Collection)list, kindArray, string, bl, false);
        list = this.filterFunctionDefinitions(list);
        if (bl2 && list != null) {
            CsmSortUtilities.sortMembers(list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List<CsmNamespace> getNestedNamespaces(CsmNamespace csmNamespace, String string, boolean bl) {
        ArrayList<CsmNamespace> arrayList = new ArrayList<CsmNamespace>();
        for (CsmNamespace csmNamespace2 : csmNamespace.getNestedNamespaces()) {
            if (csmNamespace2.getName().length() == 0 || !this.matchName(csmNamespace2.getName(), string, bl)) continue;
            arrayList.add(csmNamespace2);
        }
        if (this.sort && arrayList != null) {
            CsmSortUtilities.sortMembers(arrayList, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return arrayList;
    }

    public List<CsmClassifier> getNamespaceClassesEnums(CsmNamespace csmNamespace, String string, boolean bl, boolean bl2) {
        CsmDeclaration.Kind[] kindArray = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.CLASS, CsmDeclaration.Kind.STRUCT, CsmDeclaration.Kind.UNION, CsmDeclaration.Kind.ENUM, CsmDeclaration.Kind.TYPEDEF};
        List list = this.getNamespaceMembers(csmNamespace, kindArray, string, bl, bl2, false);
        Collection collection = CsmUsingResolver.getDefault().findUsedDeclarations(csmNamespace);
        this.filterDeclarations(collection.iterator(), (Collection)list, kindArray, string, bl, false);
        if (this.isSortNeeded() && list != null) {
            CsmSortUtilities.sortClasses((List)list, (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List<CsmEnumerator> getNamespaceEnumerators(CsmNamespace csmNamespace, String string, boolean bl, boolean bl2) {
        CsmDeclaration.Kind[] kindArray = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.ENUM, CsmDeclaration.Kind.TYPEDEF};
        List list = this.getNamespaceMembers(csmNamespace, kindArray, "", false, bl2, true);
        Collection collection = CsmUsingResolver.getDefault().findUsedDeclarations(csmNamespace);
        this.filterDeclarations(collection.iterator(), (Collection)list, kindArray, "", false, true);
        List<CsmEnumerator> list2 = this.getEnumeratorsFromEnumsAndTypedefs(list, bl, string, this.sort);
        return list2;
    }

    public List<CsmClassifier> getNestedClassifiers(CsmClass csmClass, CsmOffsetableDeclaration csmOffsetableDeclaration, String string, boolean bl, boolean bl2) {
        CsmDeclaration.Kind[] kindArray = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.TYPEDEF, CsmDeclaration.Kind.UNION, CsmDeclaration.Kind.STRUCT, CsmDeclaration.Kind.CLASS, CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION, CsmDeclaration.Kind.ENUM};
        List<CsmMember> list = this.getClassMembers(csmClass, csmOffsetableDeclaration, kindArray, string, false, bl, bl2, true, false);
        if (list != null && this.isSortNeeded()) {
            CsmSortUtilities.sortMembers(list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List<CsmMethod> getMethods(CsmClass csmClass, CsmOffsetableDeclaration csmOffsetableDeclaration, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        CsmDeclaration.Kind[] kindArray = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION};
        List<CsmMember> list = this.getClassMembers(csmClass, csmOffsetableDeclaration, kindArray, string, bl, bl2, bl3, bl4, false);
        if (list != null && this.isSortNeeded()) {
            CsmSortUtilities.sortMembers(list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List<CsmClass> getBaseClasses(CsmClass csmClass, CsmOffsetableDeclaration csmOffsetableDeclaration, String string, boolean bl) {
        assert (csmClass != null);
        CsmVisibility csmVisibility = csmOffsetableDeclaration == null ? CsmInheritanceUtilities.MAX_VISIBILITY : CsmInheritanceUtilities.getContextVisibility((CsmClass)csmClass, (CsmOffsetableDeclaration)csmOffsetableDeclaration, (CsmVisibility)CsmVisibility.PUBLIC, (boolean)true);
        Map<CharSequence, CsmClass> map = this.getBaseClasses(csmClass, csmOffsetableDeclaration, string, bl, new AntiLoop(), csmVisibility, 0);
        ArrayList<CsmClass> arrayList = map != null && map.size() > 0 ? new ArrayList<CsmClass>(map.values()) : new ArrayList<CsmClass>();
        return arrayList;
    }

    public List getFields(CsmClass csmClass, boolean bl) {
        return this.getFields(csmClass, (CsmOffsetableDeclaration)csmClass, "", bl, false, true, false);
    }

    public List<CsmField> getFields(CsmClass csmClass, CsmOffsetableDeclaration csmOffsetableDeclaration, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        List list = this.getClassMembers(csmClass, csmOffsetableDeclaration, CsmDeclaration.Kind.VARIABLE, string, bl, bl2, bl3, bl4);
        if (this.isSortNeeded() && list != null) {
            CsmSortUtilities.sortMembers((List)list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    public List<CsmEnumerator> getEnumerators(CsmClass csmClass, CsmOffsetableDeclaration csmOffsetableDeclaration, String string, boolean bl, boolean bl2, boolean bl3) {
        CsmDeclaration.Kind[] kindArray = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.ENUM, CsmDeclaration.Kind.TYPEDEF};
        List<CsmMember> list = this.getClassMembers(csmClass, csmOffsetableDeclaration, kindArray, "", false, false, bl2, bl3, true);
        List<CsmEnumerator> list2 = this.getEnumeratorsFromEnumsAndTypedefs(list, bl, string, this.sort);
        return list2;
    }

    public List getFieldsAndMethods(CsmClass csmClass, CsmOffsetableDeclaration csmOffsetableDeclaration, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        CsmDeclaration.Kind[] kindArray = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.VARIABLE, CsmDeclaration.Kind.FUNCTION, CsmDeclaration.Kind.FUNCTION_DEFINITION};
        List<CsmMember> list = this.getClassMembers(csmClass, csmOffsetableDeclaration, kindArray, string, bl, bl2, bl3, bl4, false);
        if (this.isSortNeeded() && list != null) {
            CsmSortUtilities.sortMembers(list, (boolean)this.isNaturalSort(), (boolean)this.isCaseSensitive());
        }
        return list;
    }

    private List getClassMembers(CsmClass csmClass, CsmOffsetableDeclaration csmOffsetableDeclaration, CsmDeclaration.Kind kind, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return this.getClassMembers(csmClass, csmOffsetableDeclaration, new CsmDeclaration.Kind[]{kind}, string, bl, bl2, bl3, bl4, false);
    }

    private List<CsmMember> getClassMembers(CsmClass csmClass, CsmOffsetableDeclaration csmOffsetableDeclaration, CsmDeclaration.Kind[] kindArray, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        CsmVisibility csmVisibility;
        assert (csmClass != null);
        if (csmOffsetableDeclaration == null) {
            csmVisibility = CsmInheritanceUtilities.MAX_VISIBILITY;
        } else if (bl4) {
            csmVisibility = CsmInheritanceUtilities.getContextVisibility((CsmClass)csmClass, (CsmOffsetableDeclaration)csmOffsetableDeclaration, (CsmVisibility)CsmVisibility.PUBLIC, (boolean)bl3);
            if (csmVisibility == CsmVisibility.NONE) {
                bl = true;
                csmVisibility = CsmInheritanceUtilities.getContextVisibility((CsmClass)csmClass, (CsmOffsetableDeclaration)csmOffsetableDeclaration);
            }
        } else {
            csmVisibility = CsmInheritanceUtilities.getContextVisibility((CsmClass)csmClass, (CsmOffsetableDeclaration)csmOffsetableDeclaration);
        }
        Map<CharSequence, CsmMember> map = this.getClassMembers(csmClass, csmOffsetableDeclaration, kindArray, string, bl, bl2, new AntiLoop(), csmVisibility, 0, bl3, bl5);
        ArrayList<CsmMember> arrayList = map != null && map.size() > 0 ? new ArrayList<CsmMember>(map.values()) : new ArrayList<CsmMember>();
        return arrayList;
    }

    private Map<CharSequence, CsmMember> getClassMembers(CsmClass csmClass, CsmOffsetableDeclaration csmOffsetableDeclaration, CsmDeclaration.Kind[] kindArray, String string, boolean bl, boolean bl2, AntiLoop antiLoop, CsmVisibility csmVisibility, int n, boolean bl3, boolean bl4) {
        assert (csmClass != null);
        if (antiLoop.contains((CsmClassifier)csmClass)) {
            return Collections.emptyMap();
        }
        if (csmVisibility == CsmVisibility.NONE) {
            return Collections.emptyMap();
        }
        VisibilityInfoPair visibilityInfoPair = this.getContextVisibility(csmClass, csmOffsetableDeclaration, csmVisibility, n);
        csmVisibility = visibilityInfoPair.visibility;
        n = visibilityInfoPair.inheritanceLevel;
        Map<CharSequence, CsmMember> map = new HashMap<CharSequence, CsmMember>();
        CsmSelect.CsmFilter csmFilter = CsmContextUtilities.createFilter(kindArray, string, bl2, this.caseSensitive, bl4);
        ArrayList<CsmClass> arrayList = new ArrayList<CsmClass>(1);
        arrayList.add(csmClass);
        CsmScope csmScope = csmClass.getScope();
        while (CsmKindUtilities.isClass((CsmObject)csmScope)) {
            if (!antiLoop.contains((CsmClassifier)((CsmClass)csmScope))) {
                arrayList.add((CsmClass)csmScope);
            }
            csmScope = ((CsmClass)csmScope).getScope();
        }
        for (CsmClass csmClass2 : arrayList) {
            Object object;
            Object object2;
            CharSequence charSequence;
            CsmDeclaration.Kind[] kindArray2;
            antiLoop.add((CsmClassifier)csmClass2);
            Iterator iterator = CsmSelect.getDefault().getClassMembers(csmClass2, csmFilter);
            int n2 = 0;
            while (iterator.hasNext()) {
                kindArray2 = (CsmDeclaration.Kind[])iterator.next();
                if (!CsmProjectContentResolver.isKindOf(kindArray2.getKind(), kindArray) || bl && !kindArray2.isStatic() || !this.matchVisibility((CsmMember)kindArray2, csmVisibility) || !this.matchName(charSequence = kindArray2.getName(), string, bl2) && (charSequence.length() != 0 || !bl4)) continue;
                if (CsmKindUtilities.isFunction((CsmObject)kindArray2)) {
                    object2 = ((CsmFunction)kindArray2).getSignature();
                } else {
                    object2 = kindArray2.getQualifiedName();
                    if (kindArray2.getName().length() == 0 && CsmKindUtilities.isEnum((CsmObject)kindArray2)) {
                        object2 = new StringBuilder((CharSequence)object2).append('$').append(++n2).toString();
                    }
                }
                if (map.containsKey(object2)) continue;
                map.put((CharSequence)object2, (CsmMember)kindArray2);
            }
            kindArray2 = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.UNION, CsmDeclaration.Kind.STRUCT, CsmDeclaration.Kind.CLASS};
            charSequence = CsmContextUtilities.createFilter(kindArray2, "*", true, false, true);
            iterator = CsmSelect.getDefault().getClassMembers(csmClass2, (CsmSelect.CsmFilter)charSequence);
            while (iterator.hasNext()) {
                Object object3;
                object2 = (CsmMember)iterator.next();
                if (!CsmProjectContentResolver.isKindOf(object2.getKind(), kindArray2) || !this.matchVisibility((CsmMember)object2, csmVisibility) || (object3 = object2.getName()).length() != 0 || (object = this.getClassMembers((CsmClass)object2, csmOffsetableDeclaration, kindArray, string, bl, bl2, antiLoop, CsmVisibility.PUBLIC, 0, bl3, bl4)) == null || object.size() <= 0) continue;
                object.putAll(map);
                map = object;
            }
            if (!bl3) continue;
            for (Object object3 : csmClass2.getBaseClasses()) {
                int n3;
                VisibilityInfoPair visibilityInfoPair2;
                CsmVisibility csmVisibility2;
                Map<CharSequence, CsmMember> map2;
                object = CsmInheritanceUtilities.getCsmClass((CsmInheritance)object3);
                if (object == null || (map2 = this.getClassMembers((CsmClass)object, csmOffsetableDeclaration, kindArray, string, bl, bl2, antiLoop, csmVisibility2 = (visibilityInfoPair2 = this.getNextInheritanceInfo(csmVisibility, (CsmInheritance)object3, n)).visibility, n3 = visibilityInfoPair2.inheritanceLevel, bl3, bl4)) == null || map2.size() <= 0) continue;
                map2.putAll(map);
                map = map2;
            }
        }
        return map;
    }

    private Map<CharSequence, CsmClass> getBaseClasses(CsmClass csmClass, CsmOffsetableDeclaration csmOffsetableDeclaration, String string, boolean bl, AntiLoop antiLoop, CsmVisibility csmVisibility, int n) {
        assert (csmClass != null);
        if (antiLoop.contains((CsmClassifier)csmClass)) {
            return new HashMap<CharSequence, CsmClass>();
        }
        if (csmVisibility == CsmVisibility.NONE) {
            return new HashMap<CharSequence, CsmClass>();
        }
        VisibilityInfoPair visibilityInfoPair = this.getContextVisibility(csmClass, csmOffsetableDeclaration, csmVisibility, n);
        csmVisibility = visibilityInfoPair.visibility;
        n = visibilityInfoPair.inheritanceLevel;
        Map<CharSequence, CsmClass> map = new HashMap<CharSequence, CsmClass>();
        for (CsmInheritance csmInheritance : csmClass.getBaseClasses()) {
            CsmClass csmClass2 = CsmInheritanceUtilities.getCsmClass((CsmInheritance)csmInheritance);
            if (csmClass2 == null) continue;
            VisibilityInfoPair visibilityInfoPair2 = this.getNextInheritanceInfo(csmVisibility, csmInheritance, n);
            CsmVisibility csmVisibility2 = visibilityInfoPair2.visibility;
            int n2 = visibilityInfoPair2.inheritanceLevel;
            if (csmVisibility2 == CsmVisibility.NONE) continue;
            Map<CharSequence, CsmClass> map2 = this.getBaseClasses(csmClass2, csmOffsetableDeclaration, string, bl, antiLoop, csmVisibility2, n2);
            if (this.matchName(csmClass2.getName(), string, bl)) {
                map2.put(csmClass2.getQualifiedName(), csmClass2);
            }
            map2.putAll(map);
            map = map2;
        }
        return map;
    }

    private List getNamespaceMembers(CsmNamespace csmNamespace, CsmDeclaration.Kind kind, String string, boolean bl, boolean bl2, boolean bl3) {
        return this.getNamespaceMembers(csmNamespace, new CsmDeclaration.Kind[]{kind}, string, bl, bl2, bl3);
    }

    private List getNamespaceMembers(CsmNamespace csmNamespace, CsmDeclaration.Kind[] kindArray, String string, boolean bl, boolean bl2, boolean bl3) {
        List list = this.getNamespaceMembers(csmNamespace, kindArray, string, bl, new HashSet(), bl2, bl3);
        return list;
    }

    private List getNamespaceMembers(CsmNamespace csmNamespace, CsmDeclaration.Kind[] kindArray, String string, boolean bl, Set set, boolean bl2, boolean bl3) {
        if (set.contains(csmNamespace)) {
            return Collections.EMPTY_LIST;
        }
        set.add(csmNamespace);
        ArrayList arrayList = new ArrayList();
        this.filterDeclarations(csmNamespace, arrayList, kindArray, string, bl, bl3);
        if (!csmNamespace.getProject().isArtificial() && !csmNamespace.isGlobal()) {
            for (CsmProject csmProject : csmNamespace.getProject().getLibraries()) {
                CsmNamespace csmNamespace2 = csmProject.findNamespace(csmNamespace.getQualifiedName());
                if (csmNamespace2 == null || set.contains(csmNamespace2)) continue;
                this.filterDeclarations(csmNamespace2, arrayList, kindArray, string, bl, bl3);
                set.add(csmNamespace2);
            }
        }
        if (bl2) {
            for (CsmNamespace csmNamespace3 : csmNamespace.getNestedNamespaces()) {
                arrayList.addAll(this.getNamespaceMembers(csmNamespace3, kindArray, string, bl, set, true, bl3));
            }
        }
        return arrayList;
    }

    void filterDeclarations(CsmNamespace csmNamespace, Collection collection, CsmDeclaration.Kind[] kindArray, String string, boolean bl, boolean bl2) {
        CsmSelect.CsmFilter csmFilter = CsmContextUtilities.createFilter(kindArray, string, bl, this.caseSensitive, bl2);
        Iterator iterator = CsmSelect.getDefault().getDeclarations(csmNamespace, csmFilter);
        while (iterator.hasNext()) {
            CharSequence charSequence;
            CsmDeclaration csmDeclaration = (CsmDeclaration)iterator.next();
            if (!CsmProjectContentResolver.isKindOf(csmDeclaration.getKind(), kindArray) || !this.matchName(charSequence = csmDeclaration.getName(), string, bl) && (charSequence.length() != 0 || !bl2)) continue;
            collection.add(csmDeclaration);
        }
    }

    void filterDeclarations(Iterator iterator, Collection collection, CsmDeclaration.Kind[] kindArray, String string, boolean bl, boolean bl2) {
        while (iterator.hasNext()) {
            CharSequence charSequence;
            CsmDeclaration csmDeclaration = (CsmDeclaration)iterator.next();
            if (!CsmProjectContentResolver.isKindOf(csmDeclaration.getKind(), kindArray) || !this.matchName(charSequence = csmDeclaration.getName(), string, bl) && (charSequence.length() != 0 || !bl2)) continue;
            collection.add(csmDeclaration);
        }
    }

    private static boolean isKindOf(CsmDeclaration.Kind kind, CsmDeclaration.Kind[] kindArray) {
        for (int i = 0; i < kindArray.length; ++i) {
            if (kind != kindArray[i]) continue;
            return true;
        }
        return false;
    }

    private boolean matchName(CharSequence charSequence, String string, boolean bl) {
        return CsmSortUtilities.matchName((CharSequence)charSequence, (CharSequence)string, (boolean)bl, (boolean)this.caseSensitive);
    }

    public boolean matchVisibility(CsmMember csmMember, CsmVisibility csmVisibility) {
        return CsmInheritanceUtilities.matchVisibility((CsmMember)csmMember, (CsmVisibility)csmVisibility);
    }

    private Map<String, CsmObject> mergeByFQN(Map<String, CsmObject> map, Collection<CsmObject> collection) {
        assert (map != null);
        if (collection != null && collection.size() > 0) {
            for (CsmObject csmObject : collection) {
                assert (CsmKindUtilities.isQualified((CsmObject)csmObject));
                String string = ((Object)((CsmQualifiedNamedElement)csmObject).getQualifiedName()).toString();
                map.put(string, csmObject);
            }
        }
        return map;
    }

    private <T> Collection<T> merge(Collection<T> collection, Collection<T> collection2) {
        return CsmUtilities.merge(collection, collection2);
    }

    private List<CsmFunction> filterFunctionDefinitions(List list) {
        ArrayList<CsmFunction> arrayList = new ArrayList<CsmFunction>();
        if (list != null && list.size() > 0) {
            for (CsmObject csmObject : list) {
                if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmObject) && ((CsmFunctionDefinition)csmObject).getDeclaration() != csmObject) continue;
                arrayList.add((CsmFunction)csmObject);
            }
        }
        return arrayList;
    }

    private List<CsmVariable> filterVariables(List<CsmVariable> list) {
        HashMap<String, CsmVariable> hashMap = new HashMap<String, CsmVariable>(list.size());
        for (CsmVariable csmVariable : list) {
            String string = ((Object)csmVariable.getQualifiedName()).toString();
            CsmVariable csmVariable2 = (CsmVariable)hashMap.get(string);
            if (csmVariable2 != null && CsmKindUtilities.isExternVariable((CsmDeclaration)csmVariable)) continue;
            hashMap.put(string, csmVariable);
        }
        return new ArrayList<CsmVariable>(hashMap.values());
    }

    private VisibilityInfoPair getContextVisibility(CsmClass csmClass, CsmOffsetableDeclaration csmOffsetableDeclaration, CsmVisibility csmVisibility, int n) {
        if (n == 0) {
            n = 1;
            CsmClass csmClass2 = CsmBaseUtilities.getContextClass((CsmOffsetableDeclaration)csmOffsetableDeclaration);
            if (csmClass.equals(csmClass2)) {
                n = 2;
            } else if (csmClass2 != null && CsmInheritanceUtilities.isAssignableFrom((CsmClass)csmClass2, (CsmClass)csmClass)) {
                n = 3;
            }
        } else if (csmOffsetableDeclaration != null) {
            csmVisibility = CsmInheritanceUtilities.getContextVisibility((CsmClass)csmClass, (CsmOffsetableDeclaration)csmOffsetableDeclaration, (CsmVisibility)csmVisibility, (n == 3 ? 1 : 0) != 0);
        }
        return new VisibilityInfoPair(n, csmVisibility);
    }

    private VisibilityInfoPair getNextInheritanceInfo(CsmVisibility csmVisibility, CsmInheritance csmInheritance, int n) {
        CsmVisibility csmVisibility2;
        int n2 = n;
        if (n == 1) {
            csmVisibility2 = CsmInheritanceUtilities.mergeExtInheritedVisibility((CsmVisibility)csmVisibility, (CsmVisibility)csmInheritance.getVisibility());
            n2 = 1;
        } else if (n == 2) {
            csmVisibility2 = CsmInheritanceUtilities.mergeInheritedVisibility((CsmVisibility)csmVisibility, (CsmVisibility)csmInheritance.getVisibility());
            n2 = 3;
        } else {
            assert (n == 3);
            csmVisibility2 = CsmInheritanceUtilities.mergeChildInheritanceVisibility((CsmVisibility)csmVisibility, (CsmVisibility)csmInheritance.getVisibility());
            n2 = 3;
        }
        return new VisibilityInfoPair(n2, csmVisibility2);
    }

    private static final class VisibilityInfoPair {
        private final int inheritanceLevel;
        private final CsmVisibility visibility;

        public VisibilityInfoPair(int n, CsmVisibility csmVisibility) {
            this.inheritanceLevel = n;
            this.visibility = csmVisibility;
        }
    }

    private static interface NsContentResultsFilter {
        public Collection getResults(CsmProjectContentResolver var1, CsmNamespace var2, String var3, boolean var4, boolean var5);
    }
}

