/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.deep.CsmLabel;
import org.netbeans.modules.cnd.api.model.services.CsmClassifierResolver;
import org.netbeans.modules.cnd.api.model.services.CsmUsingResolver;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmSortUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmLabelResolver;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.completion.cplusplus.CsmCompletionUtils;
import org.netbeans.modules.cnd.completion.cplusplus.ext.CsmFinder;
import org.netbeans.modules.cnd.completion.csm.CsmProjectContentResolver;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsmFinderImpl
implements CsmFinder {
    private boolean caseSensitive = false;
    private FileObject fo;
    private CsmFile csmFile;
    private String mimeType;

    public CsmFinderImpl(FileObject fileObject, String string) {
        this.fo = fileObject;
        this.mimeType = string;
        this.caseSensitive = this._getCaseSensitive();
    }

    public CsmFinderImpl(CsmFile csmFile, String string) {
        this.csmFile = csmFile;
        this.mimeType = string;
        this.caseSensitive = this._getCaseSensitive();
    }

    public CsmFinderImpl(CsmFile csmFile, String string, boolean bl) {
        this.csmFile = csmFile;
        this.mimeType = string;
        this.caseSensitive = bl;
    }

    @Override
    public CsmFile getCsmFile() {
        return this.csmFile;
    }

    private boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    private boolean _getCaseSensitive() {
        return CsmCompletionUtils.isCaseSensitive(this.mimeType);
    }

    private boolean getNaturalSort() {
        return CsmCompletionUtils.isNaturalSort(this.mimeType);
    }

    private CsmNamespace resolveNamespace(String string, boolean bl) {
        LinkedList<CsmProject> linkedList = new LinkedList<CsmProject>();
        HashSet<CsmProject> hashSet = new HashSet<CsmProject>();
        linkedList.add(this.csmFile.getProject());
        CsmNamespace csmNamespace = this.resolveNamespaceBfs(linkedList, hashSet, string);
        if (csmNamespace != null) {
            return csmNamespace;
        }
        for (CsmProject csmProject : CsmModelAccessor.getModel().projects()) {
            if (hashSet.contains(csmProject)) continue;
            linkedList.add(csmProject);
        }
        return this.resolveNamespaceBfs(linkedList, hashSet, string);
    }

    private CsmNamespace resolveNamespaceBfs(Queue<CsmProject> queue, Set<CsmProject> set, String string) {
        while (!queue.isEmpty()) {
            CsmProject csmProject = queue.poll();
            CsmNamespace csmNamespace = csmProject.findNamespace((CharSequence)string);
            if (csmNamespace != null) {
                return csmNamespace;
            }
            set.add(csmProject);
            for (CsmProject csmProject2 : csmProject.getLibraries()) {
                if (set.contains(csmProject2)) continue;
                queue.offer(csmProject2);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CsmNamespace getExactNamespace(String string) {
        CsmNamespace csmNamespace;
        CsmNamespace csmNamespace2 = csmNamespace = this.resolveNamespace(string, true);
        return csmNamespace2;
    }

    @Override
    public CsmClassifier getExactClassifier(String string) {
        CsmClassifier csmClassifier = CsmClassifierResolver.getDefault().findClassifierUsedInFile((CharSequence)string, this.csmFile, true);
        return csmClassifier;
    }

    public List findNamespaces(String string, boolean bl, boolean bl2) {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    @Override
    public List findNestedNamespaces(CsmNamespace csmNamespace, String string, boolean bl, boolean bl2) {
        List<Object> list = new ArrayList();
        CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        list = csmProjectContentResolver.getNestedNamespaces(csmNamespace, string, bl);
        return list;
    }

    @Override
    public List findNamespaceElements(CsmNamespace csmNamespace, String string, boolean bl, boolean bl2, boolean bl3) {
        ArrayList arrayList = new ArrayList();
        CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        HashSet<CsmNamespace> hashSet = new HashSet<CsmNamespace>();
        if (this.csmFile != null && this.csmFile.getProject() != null) {
            CsmNamespace csmNamespace2;
            CsmProject csmProject = this.csmFile.getProject();
            CsmNamespace csmNamespace3 = csmNamespace2 = csmNamespace == null ? csmProject.getGlobalNamespace() : csmNamespace;
            if (this.checkStopAfterAppendAllNamespaceElements(csmNamespace2, string, bl, bl2, bl3, true, this.csmFile, csmProjectContentResolver, arrayList, false, new HashSet<CharSequence>(), hashSet)) {
                return arrayList;
            }
            if (!csmProject.isArtificial()) {
                HashSet<CharSequence> hashSet2 = new HashSet<CharSequence>();
                for (Object object : arrayList) {
                    if (!CsmKindUtilities.isQualified((CsmObject)((CsmObject)object))) continue;
                    hashSet2.add(((CsmQualifiedNamedElement)object).getQualifiedName());
                }
                for (Object object : csmProject.getLibraries()) {
                    CsmNamespace csmNamespace4 = csmNamespace2.isGlobal() ? object.getGlobalNamespace() : object.findNamespace(csmNamespace2.getQualifiedName());
                    if (csmNamespace4 == null || !this.checkStopAfterAppendAllNamespaceElements(csmNamespace4, string, bl, bl2, bl3, false, null, csmProjectContentResolver, arrayList, true, hashSet2, hashSet)) continue;
                    return arrayList;
                }
            }
        }
        return arrayList;
    }

    private boolean checkStopAfterAppendAllNamespaceElements(CsmNamespace csmNamespace, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, CsmFile csmFile, CsmProjectContentResolver csmProjectContentResolver, List list, boolean bl5, Set<CharSequence> set, HashSet<CsmNamespace> hashSet) {
        if (hashSet.contains(csmNamespace)) {
            return false;
        }
        hashSet.add(csmNamespace);
        List<CsmClassifier> list2 = csmProjectContentResolver.getNamespaceClassesEnums(csmNamespace, string, bl, bl2);
        if (this.checkStopAfterAppendElements(list, list2, set, bl5, bl3)) {
            return true;
        }
        list2 = csmProjectContentResolver.getNamespaceEnumerators(csmNamespace, string, bl, bl2);
        if (this.checkStopAfterAppendElements(list, list2, set, bl5, bl3)) {
            return true;
        }
        list2 = csmProjectContentResolver.getNamespaceVariables(csmNamespace, string, bl, bl2);
        if (this.checkStopAfterAppendElements(list, list2, set, bl5, bl3)) {
            return true;
        }
        list2 = csmProjectContentResolver.getNamespaceFunctions(csmNamespace, string, bl, bl2);
        if (this.checkStopAfterAppendElements(list, list2, set, bl5, bl3)) {
            return true;
        }
        if (bl4) {
            assert (csmFile != null) : "file must be passed if needFileLocal is true";
            list2 = csmProjectContentResolver.getFileLocalNamespaceVariables(csmNamespace, csmFile, string, bl);
            if (this.checkStopAfterAppendElements(list, list2, set, bl5, bl3)) {
                return true;
            }
            list2 = csmProjectContentResolver.getFileLocalNamespaceFunctions(csmNamespace, csmFile, string, bl);
            if (this.checkStopAfterAppendElements(list, list2, set, bl5, bl3)) {
                return true;
            }
        }
        for (CsmNamespace csmNamespace2 : CsmUsingResolver.extractNamespaces((Collection)CsmUsingResolver.getDefault().findUsingDirectives(csmNamespace))) {
            if (!this.checkStopAfterAppendAllNamespaceElements(csmNamespace2, string, bl, bl2, bl3, bl4, csmFile, csmProjectContentResolver, list, bl5, set, hashSet)) continue;
            return true;
        }
        return false;
    }

    private boolean checkStopAfterAppendElements(List list, Collection collection, Set<CharSequence> set, boolean bl, boolean bl2) {
        if (bl) {
            this.merge(set, list, collection);
        } else {
            list.addAll(collection);
        }
        return bl2 && list.size() > 0;
    }

    private void merge(Set<CharSequence> set, List list, Collection collection) {
        if (collection != null) {
            for (Object e : collection) {
                if (!CsmKindUtilities.isQualified((CsmObject)((CsmObject)e)) || set.contains(((CsmQualifiedNamedElement)e).getQualifiedName())) continue;
                list.add(e);
                set.add(((CsmQualifiedNamedElement)e).getQualifiedName());
            }
        }
    }

    @Override
    public List findClasses(CsmNamespace csmNamespace, String string, boolean bl, boolean bl2) {
        ArrayList<CsmClassifier> arrayList = new ArrayList<CsmClassifier>();
        CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        if (this.csmFile != null && this.csmFile.getProject() != null) {
            CsmProject csmProject = this.csmFile.getProject();
            CsmNamespace csmNamespace2 = csmNamespace == null ? csmProject.getGlobalNamespace() : csmNamespace;
            List<CsmClassifier> list = csmProjectContentResolver.getNamespaceClassesEnums(csmNamespace2, string, bl, bl2);
            if (list != null) {
                arrayList.addAll(list);
            }
            Collection<CsmClassifier> collection = list = csmProject.getGlobalNamespace() == csmNamespace2 ? null : csmProjectContentResolver.getLibClassesEnums(string, bl);
            if (list != null) {
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }

    private void addNestedNamespaces(List list, CsmNamespace csmNamespace) {
        for (CsmNamespace csmNamespace2 : csmNamespace.getNestedNamespaces()) {
            list.add(csmNamespace2);
            this.addNestedNamespaces(list, csmNamespace2);
        }
    }

    private List getClassListForList(List list) {
        Iterator iterator = list.iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.addAll(this.getClassList((CsmClass)iterator.next()));
        }
        return arrayList;
    }

    private List getClassList(CsmClass csmClass) {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    private List getOuterClasses(CsmClass csmClass) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(csmClass);
        while (csmClass != null) {
            Collection collection = csmClass.getBaseClasses();
            if (collection == null) continue;
            arrayList.add(collection);
        }
        return arrayList;
    }

    @Override
    public List findFields(CsmOffsetableDeclaration csmOffsetableDeclaration, CsmClass csmClass, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        List<CsmField> list = csmProjectContentResolver.getFields(csmClass, csmOffsetableDeclaration, string, bl2, bl, bl4, bl5);
        return list;
    }

    @Override
    public List findEnumerators(CsmOffsetableDeclaration csmOffsetableDeclaration, CsmClass csmClass, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        List<CsmEnumerator> list = csmProjectContentResolver.getEnumerators(csmClass, csmOffsetableDeclaration, string, bl, bl3, bl4);
        return list;
    }

    @Override
    public List findMethods(CsmOffsetableDeclaration csmOffsetableDeclaration, CsmClass csmClass, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        CsmClass csmClass2 = csmClass;
        CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        if (csmOffsetableDeclaration == null) {
            csmOffsetableDeclaration = csmClass2;
        }
        List<CsmMethod> list = csmProjectContentResolver.getMethods(csmClass2, csmOffsetableDeclaration, string, bl2, bl, bl4, bl5);
        return list;
    }

    @Override
    public List findNestedClassifiers(CsmOffsetableDeclaration csmOffsetableDeclaration, CsmClass csmClass, String string, boolean bl, boolean bl2, boolean bl3) {
        CsmClass csmClass2 = csmClass;
        CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver(this.getCaseSensitive());
        List<CsmClassifier> list = csmProjectContentResolver.getNestedClassifiers(csmClass2, csmOffsetableDeclaration, string, bl, bl2);
        return list;
    }

    @Override
    public List findLabel(CsmOffsetableDeclaration csmOffsetableDeclaration, String string, boolean bl, boolean bl2) {
        ArrayList<CsmLabel> arrayList = new ArrayList<CsmLabel>();
        if (CsmKindUtilities.isFunctionDefinition((CsmObject)csmOffsetableDeclaration)) {
            Collection collection = CsmLabelResolver.getDefault().getLabels((CsmFunctionDefinition)csmOffsetableDeclaration, null, CsmLabelResolver.LabelKind.Definiton);
            for (CsmReference csmReference : collection) {
                CsmLabel csmLabel;
                if (!(csmReference.getReferencedObject() instanceof CsmLabel) || !CsmSortUtilities.matchName((CharSequence)(csmLabel = (CsmLabel)csmReference.getReferencedObject()).getLabel(), (CharSequence)string, (boolean)bl, (boolean)this.caseSensitive)) continue;
                arrayList.add(csmLabel);
            }
        }
        return arrayList;
    }

    @Override
    public List<CsmClass> findBaseClasses(CsmOffsetableDeclaration csmOffsetableDeclaration, CsmClassifier csmClassifier, String string, boolean bl, boolean bl2) {
        if (CsmKindUtilities.isClass((CsmObject)(csmClassifier = CsmBaseUtilities.getOriginalClassifier((CsmClassifier)csmClassifier)))) {
            CsmClass csmClass = (CsmClass)csmClassifier;
            CsmProjectContentResolver csmProjectContentResolver = new CsmProjectContentResolver(this.getCaseSensitive());
            List<CsmClass> list = csmProjectContentResolver.getBaseClasses(csmClass, csmOffsetableDeclaration, string, bl);
            return list;
        }
        return new ArrayList<CsmClass>();
    }
}

