/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.wizards;

import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.wizards.TagHandlerPanelGUI;
import org.netbeans.modules.web.wizards.TargetChooserPanelGUI;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.TemplateWizard;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class TagInfoPanel
implements WizardDescriptor.Panel {
    private TagHandlerPanelGUI component;
    private transient TemplateWizard wizard;
    private transient Project proj;
    private transient SourceGroup[] sourceGroups;
    private String className;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public TagInfoPanel(TemplateWizard templateWizard, Project project, SourceGroup[] sourceGroupArray) {
        this.wizard = templateWizard;
        this.proj = project;
        this.sourceGroups = sourceGroupArray;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new TagHandlerPanelGUI(this.wizard, this, this.proj, this.sourceGroups);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        if (this.writeToTLD() && this.getTLDFile() == null) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TagInfoPanel.class, (String)"MSG_noTldSelected"));
            return false;
        }
        if (TargetChooserPanelGUI.isTagNameEmpty(this.getTagName())) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TagInfoPanel.class, (String)"TXT_missingTagName"));
            return false;
        }
        if (!TargetChooserPanelGUI.isValidTagName(this.getTagName())) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TagInfoPanel.class, (String)"TXT_wrongTagName", (Object)this.getTagName()));
            return false;
        }
        if (this.tagNameExists(this.getTagName())) {
            this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(TagInfoPanel.class, (String)"TXT_tagNameExists", (Object)this.getTagName()));
            return false;
        }
        this.wizard.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> iterator;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        object = new ChangeEvent(this);
        while (iterator.hasNext()) {
            iterator.next().stateChanged((ChangeEvent)object);
        }
    }

    public void readSettings(Object object) {
        Boolean bl;
        TemplateWizard templateWizard = (TemplateWizard)object;
        String string = templateWizard.getTargetName();
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)templateWizard);
        Project project = Templates.getProject((WizardDescriptor)templateWizard);
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        String string2 = null;
        for (int i = 0; i < sourceGroupArray.length && string2 == null; ++i) {
            string2 = FileUtil.getRelativePath((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject);
        }
        if (string2 == null) {
            string2 = "";
        }
        string2 = string2.replace('/', '.');
        if (string != null) {
            this.className = string2.length() > 0 ? string2 + "." + string : string;
            this.component.setClassName(this.className);
            if (this.component.getTagName().length() == 0) {
                this.component.setTagName(string);
            }
        }
        if ((bl = (Boolean)templateWizard.getProperty("BODY_SUPPORT")) != null && bl.booleanValue()) {
            this.component.setBodySupport(true);
        } else {
            this.component.setBodySupport(false);
        }
    }

    public void storeSettings(Object object) {
    }

    public String getClassName() {
        return this.className;
    }

    public String getTagName() {
        return this.component.getTagName();
    }

    public FileObject getTLDFile() {
        return this.component.getTLDFile();
    }

    public boolean isEmpty() {
        return this.component.isEmpty();
    }

    public boolean isScriptless() {
        return this.component.isScriptless();
    }

    public boolean isTegdependent() {
        return this.component.isTegdependent();
    }

    public boolean writeToTLD() {
        return this.component.writeToTLD();
    }

    public Object[][] getAttributes() {
        return this.component.getAttributes();
    }

    private boolean tagNameExists(String string) {
        Set set = this.component.getTagValues();
        return set != null && set.contains(string);
    }
}

