/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.ui;

import java.io.IOException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import javax.swing.Icon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.classpath.GlobalPathRegistryListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.TypeElementFinder;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.java.BinaryElementOpen;
import org.netbeans.modules.java.source.ui.JavaTypeDescription;
import org.netbeans.modules.java.source.usages.RepositoryUpdater;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.jumpto.type.SearchType;
import org.netbeans.spi.jumpto.type.TypeProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class JavaTypeProvider
implements TypeProvider {
    private static final Logger LOGGER = Logger.getLogger(JavaTypeProvider.class.getName());
    private static final ClassPath EMPTY_CLASSPATH = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
    private Set<CacheItem> cache;
    private volatile boolean isCanceled = false;
    private final TypeElementFinder.Customizer customizer;
    private ClasspathInfo cpInfo;
    private GlobalPathRegistryListener pathListener;

    public String name() {
        return "java";
    }

    public String getDisplayName() {
        return "Java Classes";
    }

    public void cleanup() {
        this.isCanceled = false;
        this.cache = null;
        if (this.pathListener != null) {
            GlobalPathRegistry.getDefault().removeGlobalPathRegistryListener(this.pathListener);
        }
    }

    public void cancel() {
        this.isCanceled = true;
    }

    public JavaTypeProvider() {
        this(null, null);
    }

    public JavaTypeProvider(ClasspathInfo classpathInfo, TypeElementFinder.Customizer customizer) {
        this.cpInfo = classpathInfo;
        this.customizer = customizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTypeNames(TypeProvider.Context context, final TypeProvider.Result result) {
        Object object;
        Object object2;
        Object object3;
        AbstractCollection abstractCollection;
        ClassIndex.NameKind nameKind;
        this.isCanceled = false;
        String string = context.getText();
        SearchType searchType = context.getSearchType();
        boolean bl = Lookup.getDefault().lookup(BinaryElementOpen.class) != null;
        switch (searchType) {
            case EXACT_NAME: {
                nameKind = ClassIndex.NameKind.SIMPLE_NAME;
                break;
            }
            case CASE_INSENSITIVE_EXACT_NAME: {
                nameKind = ClassIndex.NameKind.CASE_INSENSITIVE_REGEXP;
                break;
            }
            case PREFIX: {
                nameKind = ClassIndex.NameKind.PREFIX;
                break;
            }
            case CASE_INSENSITIVE_PREFIX: {
                nameKind = ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX;
                break;
            }
            case REGEXP: {
                nameKind = ClassIndex.NameKind.REGEXP;
                break;
            }
            case CASE_INSENSITIVE_REGEXP: {
                nameKind = ClassIndex.NameKind.CASE_INSENSITIVE_REGEXP;
                break;
            }
            case CAMEL_CASE: {
                nameKind = ClassIndex.NameKind.CAMEL_CASE;
                break;
            }
            default: {
                throw new RuntimeException("Unexpected search type: " + searchType);
            }
        }
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        Future future = OpenProjects.getDefault().openProjects();
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
            LOGGER.fine(interruptedException.getMessage());
        }
        catch (ExecutionException executionException) {
            LOGGER.fine(executionException.getMessage());
        }
        if (this.cache == null) {
            int n;
            ClassPath classPath;
            abstractCollection = null;
            if (this.cpInfo == null) {
                l = System.currentTimeMillis();
                classPath = RepositoryUpdater.getDefault().getScannedSources();
                object3 = classPath.getRoots();
                l7 += System.currentTimeMillis() - l;
                object2 = new FileObject[1];
                abstractCollection = new HashSet(((FileObject[])object3).length);
                for (n = 0; n < ((FileObject[])object3).length; ++n) {
                    object2[0] = object3[n];
                    l = System.currentTimeMillis();
                    object = ClasspathInfo.create((ClassPath)EMPTY_CLASSPATH, (ClassPath)EMPTY_CLASSPATH, (ClassPath)ClassPathSupport.createClassPath((FileObject[])object2));
                    if (this.isCanceled) {
                        return;
                    }
                    abstractCollection.add(new CacheItem(object3[n], (ClasspathInfo)object, false));
                    l8 += System.currentTimeMillis() - l;
                }
                l = System.currentTimeMillis();
                classPath = RepositoryUpdater.getDefault().getScannedBinaries();
                object3 = classPath.getRoots();
                l6 += System.currentTimeMillis() - l;
                object2 = new FileObject[1];
                for (n = 0; n < ((FileObject[])object3).length; ++n) {
                    try {
                        if (this.isCanceled) {
                            return;
                        }
                        l = System.currentTimeMillis();
                        if (!bl && (object = SourceForBinaryQuery.findSourceRoots((URL)object3[n].getURL())).getRoots().length == 0) continue;
                        l5 += System.currentTimeMillis() - l;
                        l = System.currentTimeMillis();
                        object2[0] = object3[n];
                        object = ClasspathInfo.create((ClassPath)ClassPathSupport.createClassPath((FileObject[])object2), (ClassPath)EMPTY_CLASSPATH, (ClassPath)EMPTY_CLASSPATH);
                        abstractCollection.add(new CacheItem(object3[n], (ClasspathInfo)object, true));
                        l8 += System.currentTimeMillis() - l;
                        continue;
                    }
                    catch (FileStateInvalidException fileStateInvalidException) {
                        if (!this.isCanceled) continue;
                        return;
                    }
                    finally {
                        if (this.isCanceled) {
                            return;
                        }
                    }
                }
            } else {
                classPath = this.cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT).getRoots();
                object3 = this.cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE).getRoots();
                object2 = this.cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE).getRoots();
                abstractCollection = new HashSet(((FileObject[])classPath).length + ((FileObject[])object3).length + ((FileObject[])object2).length);
                for (n = 0; n < ((ClassPath)classPath).length; ++n) {
                    l = System.currentTimeMillis();
                    object = ClasspathInfo.create((ClassPath)ClassPathSupport.createClassPath((FileObject[])new FileObject[]{classPath[n]}), (ClassPath)EMPTY_CLASSPATH, (ClassPath)EMPTY_CLASSPATH);
                    if (this.isCanceled) {
                        return;
                    }
                    abstractCollection.add(new CacheItem((FileObject)classPath[n], (ClasspathInfo)object, true));
                    l8 += System.currentTimeMillis() - l;
                }
                for (n = 0; n < ((FileObject[])object3).length; ++n) {
                    l = System.currentTimeMillis();
                    object = ClasspathInfo.create((ClassPath)EMPTY_CLASSPATH, (ClassPath)ClassPathSupport.createClassPath((FileObject[])new FileObject[]{object3[n]}), (ClassPath)EMPTY_CLASSPATH);
                    if (this.isCanceled) {
                        return;
                    }
                    abstractCollection.add(new CacheItem(object3[n], (ClasspathInfo)object, true));
                    l8 += System.currentTimeMillis() - l;
                }
                for (n = 0; n < ((Object)object2).length; ++n) {
                    l = System.currentTimeMillis();
                    object = ClasspathInfo.create((ClassPath)EMPTY_CLASSPATH, (ClassPath)EMPTY_CLASSPATH, (ClassPath)ClassPathSupport.createClassPath((FileObject[])new FileObject[]{object2[n]}));
                    if (this.isCanceled) {
                        return;
                    }
                    abstractCollection.add(new CacheItem((FileObject)object2[n], (ClasspathInfo)object, false));
                    l8 += System.currentTimeMillis() - l;
                }
            }
            if (!this.isCanceled) {
                this.cache = abstractCollection;
            } else {
                return;
            }
        }
        abstractCollection = new ArrayList(this.cache.size() * 20);
        boolean bl2 = RepositoryUpdater.getDefault().isScanInProgress();
        if (bl2) {
            object3 = NbBundle.getMessage(JavaTypeProvider.class, (String)"LBL_ScanInProgress_warning");
            result.setMessage((String)object3);
        } else {
            result.setMessage(null);
        }
        switch (nameKind) {
            case REGEXP: 
            case CASE_INSENSITIVE_REGEXP: {
                string = JavaTypeProvider.removeNonJavaChars(string);
                object2 = searchType == SearchType.CASE_INSENSITIVE_EXACT_NAME ? string : string + "*";
                object2 = ((String)object2).replace("*", ".*").replace('?', '.');
                object3 = object2;
                break;
            }
            default: {
                object3 = string;
            }
        }
        LOGGER.fine("Text For Query '" + string + "'.");
        if (this.customizer != null) {
            for (CacheItem cacheItem : this.cache) {
                l = System.currentTimeMillis();
                object = this.customizer.query(cacheItem.classpathInfo, (String)object3, nameKind, EnumSet.of(cacheItem.isBinary ? ClassIndex.SearchScope.DEPENDENCIES : ClassIndex.SearchScope.SOURCE));
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    ElementHandle elementHandle = (ElementHandle)iterator.next();
                    JavaTypeDescription javaTypeDescription = new JavaTypeDescription(cacheItem, (ElementHandle<TypeElement>)elementHandle);
                    ((ArrayList)abstractCollection).add(javaTypeDescription);
                    if (!this.isCanceled) continue;
                    return;
                }
            }
        } else {
            Object object4;
            for (CacheItem cacheItem : this.cache) {
                object = cacheItem.classpathInfo.getClassIndex().getDeclaredTypes((String)object3, nameKind, EnumSet.of(cacheItem.isBinary ? ClassIndex.SearchScope.DEPENDENCIES : ClassIndex.SearchScope.SOURCE));
                object4 = object.iterator();
                while (object4.hasNext()) {
                    ElementHandle elementHandle = (ElementHandle)object4.next();
                    JavaTypeDescription javaTypeDescription = new JavaTypeDescription(cacheItem, (ElementHandle<TypeElement>)elementHandle);
                    ((ArrayList)abstractCollection).add(javaTypeDescription);
                    if (!this.isCanceled) continue;
                    return;
                }
            }
            if (((ArrayList)abstractCollection).isEmpty() && bl2) {
                try {
                    object2 = ClassPathSupport.createClassPath((URL[])new URL[0]);
                    ClasspathInfo classpathInfo = ClasspathInfo.create((ClassPath)object2, (ClassPath)object2, (ClassPath)object2);
                    object = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
                    object4 = object.runWhenScanFinished((Task)new Task<CompilationController>(){

                        public void run(CompilationController compilationController) throws Exception {
                            LOGGER.fine("Restarting search...");
                            result.setMessage(null);
                        }
                    }, false);
                    object4.get();
                    this.cache = null;
                    this.cpInfo = null;
                    this.computeTypeNames(context, result);
                    return;
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
                catch (ExecutionException executionException) {
                    Exceptions.printStackTrace((Throwable)executionException);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            if (this.isCanceled) {
                return;
            }
            l4 += System.currentTimeMillis() - l;
            l = System.currentTimeMillis();
            l3 += System.currentTimeMillis() - l;
        }
        if (!this.isCanceled) {
            l = System.currentTimeMillis();
            LOGGER.fine("PERF -  GSS:  " + l7 + " GSB " + l6 + " CP: " + l8 + " SFB: " + l5 + " GTN: " + l4 + "  ADD: " + l3 + "  SORT: " + (l2 += System.currentTimeMillis() - l));
            result.addResult((List)((Object)abstractCollection));
        }
    }

    private static boolean isAllUpper(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isUpperCase(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static String removeNonJavaChars(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isJavaIdentifierPart(c) && c != '*' && c != '?') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    static class CacheItem {
        public final boolean isBinary;
        public final FileObject fileObject;
        public final ClasspathInfo classpathInfo;
        public String projectName;
        public Icon projectIcon;
        private ClassPath.Entry defEntry;

        public CacheItem(FileObject fileObject, ClasspathInfo classpathInfo, boolean bl) {
            this.isBinary = bl;
            this.fileObject = fileObject;
            this.classpathInfo = classpathInfo;
        }

        public int hashCode() {
            return this.fileObject == null ? 0 : this.fileObject.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof CacheItem) {
                CacheItem cacheItem = (CacheItem)object;
                return this.fileObject == null ? cacheItem.fileObject == null : this.fileObject.equals(cacheItem.fileObject);
            }
            return false;
        }

        public FileObject getRoot() {
            return this.fileObject;
        }

        public boolean isBinary() {
            return this.isBinary;
        }

        public synchronized String getProjectName() {
            if (!this.isBinary && this.projectName == null) {
                this.initProjectInfo();
            }
            return this.projectName;
        }

        public synchronized Icon getProjectIcon() {
            if (!this.isBinary && this.projectIcon == null) {
                this.initProjectInfo();
            }
            return this.projectIcon;
        }

        private void initProjectInfo() {
            Project project = FileOwnerQuery.getOwner((FileObject)this.fileObject);
            if (project != null) {
                ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
                this.projectName = projectInformation.getDisplayName();
                this.projectIcon = projectInformation.getIcon();
            }
        }
    }
}

