/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.debugger.psm;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.netbeans.modules.bpel.debugger.api.psm.ProcessStaticModel;
import org.netbeans.modules.bpel.debugger.bdiclient.impl.BpelProcessImpl;
import org.netbeans.modules.bpel.debugger.psm.PsmEntityImpl;
import org.netbeans.modules.bpel.debuggerbdi.rmi.api.XMLElementRef;

public class ProcessStaticModelImpl
implements ProcessStaticModel {
    private transient Map<String, AbstractBuilder> myBuilders;
    private final BpelProcessImpl myBpelProcess;
    private PsmEntityImpl myRoot;

    public static ProcessStaticModelImpl build(BpelProcessImpl bpelProcessImpl) {
        ProcessStaticModelImpl processStaticModelImpl = new ProcessStaticModelImpl(bpelProcessImpl);
        processStaticModelImpl.build();
        return processStaticModelImpl;
    }

    private ProcessStaticModelImpl(BpelProcessImpl bpelProcessImpl) {
        this.myBpelProcess = bpelProcessImpl;
    }

    public QName getProcessQName() {
        return this.myBpelProcess.getQName();
    }

    public PsmEntityImpl getRoot() {
        return this.myRoot;
    }

    public PsmEntityImpl find(String string) {
        if (this.myRoot == null) {
            return null;
        }
        if (!string.startsWith("/")) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/", false);
        PsmEntityImpl psmEntityImpl = null;
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            String string2;
            int n2;
            String string3 = stringTokenizer.nextToken();
            String string4 = string3.substring(string3.indexOf(58) + 1);
            if (string4.endsWith("]")) {
                n2 = string4.indexOf(91);
                string2 = string4.substring(0, n2);
                n = Integer.parseInt(string4.substring(n2 + 1, string4.length() - 1));
            } else {
                string2 = string4;
                n = 1;
            }
            if (psmEntityImpl == null && string2.equals("process") && n == 1) {
                psmEntityImpl = this.myRoot;
                continue;
            }
            if (psmEntityImpl == null) {
                return null;
            }
            n2 = 0;
            for (PsmEntityImpl psmEntityImpl2 : psmEntityImpl.getChildren()) {
                if (!psmEntityImpl2.getQName().getLocalPart().equals(string2) || ++n2 != n) continue;
                psmEntityImpl = psmEntityImpl2;
                break;
            }
            if (n2 == n) continue;
            return null;
        }
        return psmEntityImpl;
    }

    private void build() {
        XMLElementRef xMLElementRef = this.myBpelProcess.getProcessRef().getXMLElement();
        assert ("process".equals(xMLElementRef.getLocalName()));
        this.initBuilders();
        EntityBuilder entityBuilder = new EntityBuilder();
        this.myRoot = entityBuilder.build(null, xMLElementRef, 1);
        this.myBuilders = null;
    }

    private void initBuilders() {
        ActivityBuilder activityBuilder = new ActivityBuilder();
        LoopActivityBuilder loopActivityBuilder = new LoopActivityBuilder();
        EventHandlerBuilder eventHandlerBuilder = new EventHandlerBuilder();
        EventHandlersContainerBuilder eventHandlersContainerBuilder = new EventHandlersContainerBuilder();
        EntityBuilder entityBuilder = new EntityBuilder();
        this.myBuilders = new HashMap<String, AbstractBuilder>();
        this.myBuilders.put("assign", activityBuilder);
        this.myBuilders.put("catch", entityBuilder);
        this.myBuilders.put("catchAll", entityBuilder);
        this.myBuilders.put("compensate", activityBuilder);
        this.myBuilders.put("compensateScope", activityBuilder);
        this.myBuilders.put("compensationHandler", entityBuilder);
        this.myBuilders.put("empty", activityBuilder);
        this.myBuilders.put("exit", activityBuilder);
        this.myBuilders.put("flow", activityBuilder);
        this.myBuilders.put("forEach", loopActivityBuilder);
        this.myBuilders.put("if", activityBuilder);
        this.myBuilders.put("invoke", activityBuilder);
        this.myBuilders.put("onMessage", entityBuilder);
        this.myBuilders.put("pick", activityBuilder);
        this.myBuilders.put("receive", activityBuilder);
        this.myBuilders.put("reply", activityBuilder);
        this.myBuilders.put("repeatUntil", loopActivityBuilder);
        this.myBuilders.put("rethrow", activityBuilder);
        this.myBuilders.put("scope", activityBuilder);
        this.myBuilders.put("sequence", activityBuilder);
        this.myBuilders.put("terminate", activityBuilder);
        this.myBuilders.put("terminationHandler", entityBuilder);
        this.myBuilders.put("throw", activityBuilder);
        this.myBuilders.put("validate", activityBuilder);
        this.myBuilders.put("wait", activityBuilder);
        this.myBuilders.put("while", loopActivityBuilder);
        this.myBuilders.put("condition", entityBuilder);
        this.myBuilders.put("copy", entityBuilder);
        this.myBuilders.put("else", entityBuilder);
        this.myBuilders.put("elseif", entityBuilder);
        this.myBuilders.put("faultHandlers", entityBuilder);
        this.myBuilders.put("eventHandlers", eventHandlersContainerBuilder);
        this.myBuilders.put("eventHandlers.onEvent", eventHandlerBuilder);
        this.myBuilders.put("eventHandlers.onAlarm", eventHandlerBuilder);
    }

    private class EventHandlersContainerBuilder
    extends EntityBuilder {
        private EventHandlersContainerBuilder() {
        }

        protected void buildChildren(PsmEntityImpl psmEntityImpl, XMLElementRef xMLElementRef) {
            int n = xMLElementRef.getChildrenCount();
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (int i = 0; i < n; ++i) {
                XMLElementRef xMLElementRef2 = xMLElementRef.getChild(i);
                String string = xMLElementRef2.getLocalName();
                AbstractBuilder abstractBuilder = (AbstractBuilder)ProcessStaticModelImpl.this.myBuilders.get("eventHandlers." + string);
                if (abstractBuilder == null) continue;
                int n2 = hashMap.containsKey(string) ? (Integer)hashMap.get(string) + 1 : 1;
                hashMap.put(string, n2);
                abstractBuilder.build(psmEntityImpl, xMLElementRef2, n2);
            }
        }
    }

    private class EntityBuilder
    extends AbstractBuilder {
        private EntityBuilder() {
        }

        protected PsmEntityImpl createPsmEntity(String string, QName qName, String string2) {
            return new PsmEntityImpl(string, qName, string2, false, false, ProcessStaticModelImpl.this);
        }
    }

    private class EventHandlerBuilder
    extends AbstractBuilder {
        private EventHandlerBuilder() {
        }

        protected PsmEntityImpl createPsmEntity(String string, QName qName, String string2) {
            return new PsmEntityImpl(string, qName, string2, false, true, ProcessStaticModelImpl.this);
        }
    }

    private class LoopActivityBuilder
    extends AbstractBuilder {
        private LoopActivityBuilder() {
        }

        protected PsmEntityImpl createPsmEntity(String string, QName qName, String string2) {
            return new PsmEntityImpl(string, qName, string2, true, true, ProcessStaticModelImpl.this);
        }
    }

    private class ActivityBuilder
    extends AbstractBuilder {
        private ActivityBuilder() {
        }

        protected PsmEntityImpl createPsmEntity(String string, QName qName, String string2) {
            return new PsmEntityImpl(string, qName, string2, true, false, ProcessStaticModelImpl.this);
        }
    }

    private abstract class AbstractBuilder {
        private AbstractBuilder() {
        }

        public PsmEntityImpl build(PsmEntityImpl psmEntityImpl, XMLElementRef xMLElementRef, int n) {
            String string = xMLElementRef.getLocalName();
            String string2 = xMLElementRef.getNameAttribute();
            QName qName = new QName("http://docs.oasis-open.org/wsbpel/2.0/process/executable", string);
            String string3 = psmEntityImpl != null ? psmEntityImpl.getXpath() : "";
            String string4 = string3 + "/" + "bpws" + ":" + string + "[" + n + "]";
            PsmEntityImpl psmEntityImpl2 = this.createPsmEntity(string4, qName, string2);
            if (psmEntityImpl != null) {
                psmEntityImpl.addChild(psmEntityImpl2);
            }
            this.buildChildren(psmEntityImpl2, xMLElementRef);
            return psmEntityImpl2;
        }

        protected void buildChildren(PsmEntityImpl psmEntityImpl, XMLElementRef xMLElementRef) {
            int n = xMLElementRef.getChildrenCount();
            XMLElementRef xMLElementRef2 = null;
            XMLElementRef xMLElementRef3 = null;
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (int i = 0; i < n; ++i) {
                XMLElementRef xMLElementRef4 = xMLElementRef.getChild(i);
                String string = xMLElementRef4.getLocalName();
                if ("eventHandlers".equals(string)) {
                    xMLElementRef2 = xMLElementRef4;
                    continue;
                }
                if ("faultHandlers".equals(string)) {
                    xMLElementRef3 = xMLElementRef4;
                    continue;
                }
                AbstractBuilder abstractBuilder = (AbstractBuilder)ProcessStaticModelImpl.this.myBuilders.get(string);
                if (abstractBuilder == null) continue;
                int n2 = hashMap.containsKey(string) ? (Integer)hashMap.get(string) + 1 : 1;
                hashMap.put(string, n2);
                abstractBuilder.build(psmEntityImpl, xMLElementRef4, n2);
            }
            if (xMLElementRef3 != null) {
                ((AbstractBuilder)ProcessStaticModelImpl.this.myBuilders.get("faultHandlers")).build(psmEntityImpl, xMLElementRef3, 1);
            }
            if (xMLElementRef2 != null) {
                ((AbstractBuilder)ProcessStaticModelImpl.this.myBuilders.get("eventHandlers")).build(psmEntityImpl, xMLElementRef2, 1);
            }
        }

        protected abstract PsmEntityImpl createPsmEntity(String var1, QName var2, String var3);
    }
}

