/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.props.editors;

import java.awt.Component;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.InvocationTargetException;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Expression;
import org.netbeans.modules.bpel.model.api.events.VetoException;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.properties.props.PropertyUtils;
import org.netbeans.modules.bpel.properties.props.editors.StringPropertyCustomizer;
import org.netbeans.modules.soa.ui.form.ReusablePropertyCustomizer;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExpressionPropEditor<T extends Expression>
extends PropertyEditorSupport
implements ExPropertyEditor {
    protected Component customizer = null;
    protected PropertyEnv myPropertyEnv;

    protected abstract T createNewExpression(BpelModel var1);

    protected ExpressionPropEditor() {
    }

    @Override
    public String getAsText() {
        Expression expression = (Expression)this.getValue();
        if (expression == null) {
            return "";
        }
        return expression.getContent().trim();
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            PropertyUtils.Reflection reflection;
            FeatureDescriptor featureDescriptor = this.myPropertyEnv.getFeatureDescriptor();
            if (featureDescriptor instanceof PropertyUtils.Reflection && !(reflection = (PropertyUtils.Reflection)((Object)featureDescriptor)).canRemove()) {
                try {
                    Expression expression = (Expression)reflection.getValue();
                    if (expression == null) {
                        return;
                    }
                    String string2 = expression.getContent();
                    if (string2 == null || string2.length() == 0) {
                        return;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    ErrorManager.getDefault().notify((Throwable)illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    ErrorManager.getDefault().notify((Throwable)invocationTargetException);
                }
            }
            this.setValue(null);
        } else {
            Expression expression = (Expression)this.getValue();
            try {
                if (expression != null) {
                    expression.setContent(string);
                } else {
                    BpelModel bpelModel;
                    BpelNode bpelNode = this.getNode();
                    BpelEntity bpelEntity = (BpelEntity)bpelNode.getReference();
                    if (bpelEntity != null && (bpelModel = bpelEntity.getBpelModel()) != null) {
                        T t = this.createNewExpression(bpelModel);
                        t.setContent(string);
                        this.setValue(t);
                    }
                }
            }
            catch (VetoException vetoException) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(vetoException);
                throw illegalArgumentException;
            }
        }
    }

    public void attachEnv(PropertyEnv propertyEnv) {
        this.myPropertyEnv = propertyEnv;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        if (this.customizer == null) {
            Class clazz = this.getCustomizerClass();
            this.customizer = clazz != null && ReusablePropertyCustomizer.class.isAssignableFrom(clazz) ? (Component)PropertyUtils.propertyCustomizerPool.getObjectByClass(clazz) : this.createCustomizer();
        }
        if (this.customizer instanceof ReusablePropertyCustomizer) {
            ((ReusablePropertyCustomizer)this.customizer).init(this.myPropertyEnv, (PropertyEditor)this);
        }
        return this.customizer;
    }

    protected Class getCustomizerClass() {
        return StringPropertyCustomizer.class;
    }

    protected Component createCustomizer() {
        return new StringPropertyCustomizer();
    }

    public BpelNode getNode() {
        Object[] objectArray = this.myPropertyEnv.getBeans();
        BpelNode bpelNode = (BpelNode)((Object)objectArray[0]);
        return bpelNode;
    }
}

