/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.bpel.editors.api.ui.valid.ErrorMessagesBundle;
import org.netbeans.modules.bpel.editors.api.ui.valid.NodeEditorDescriptor;
import org.netbeans.modules.bpel.model.api.BPELElementsBuilder;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Correlation;
import org.netbeans.modules.bpel.model.api.CorrelationContainer;
import org.netbeans.modules.bpel.model.api.CorrelationSet;
import org.netbeans.modules.bpel.model.api.CorrelationsHolder;
import org.netbeans.modules.bpel.model.api.references.BpelReference;
import org.netbeans.modules.bpel.model.api.references.BpelReferenceable;
import org.netbeans.modules.bpel.model.api.support.Initiate;
import org.netbeans.modules.bpel.model.api.support.VisibilityScope;
import org.netbeans.modules.bpel.nodes.CorrelationSetNode;
import org.netbeans.modules.bpel.properties.Constants;
import org.netbeans.modules.bpel.properties.PropertyType;
import org.netbeans.modules.bpel.properties.choosers.CorrelationSetChooserPanel;
import org.netbeans.modules.bpel.properties.editors.CorrelationSetMainPanel;
import org.netbeans.modules.bpel.properties.editors.FormBundle;
import org.netbeans.modules.bpel.properties.editors.controls.BaseTablePanel;
import org.netbeans.modules.bpel.properties.editors.controls.ObjectListTableModel;
import org.netbeans.modules.bpel.properties.editors.controls.SimpleCustomEditor;
import org.netbeans.modules.bpel.properties.editors.controls.TreeNodeChooser;
import org.netbeans.modules.soa.ui.ExtendedLookup;
import org.netbeans.modules.soa.ui.form.CustomNodeEditor;
import org.netbeans.modules.soa.ui.form.valid.DefaultDialogDescriptor;
import org.netbeans.modules.soa.ui.form.valid.DefaultValidator;
import org.netbeans.modules.soa.ui.form.valid.SoaDialogDisplayer;
import org.netbeans.modules.soa.ui.form.valid.ValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.ValidationExtension;
import org.netbeans.modules.soa.ui.form.valid.Validator;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Children;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelationTablePanel
extends BaseTablePanel
implements Validator.Provider,
HelpCtx.Provider {
    static final long serialVersionUID = 1L;
    private CustomNodeEditor<? extends CorrelationsHolder> myEditor;
    private DefaultValidator myValidator;
    private TableColumnModel columnModel;
    private MyTableModel tableModel;

    public CorrelationTablePanel(CustomNodeEditor<? extends CorrelationsHolder> customNodeEditor) {
        this.myEditor = customNodeEditor;
        this.createContent();
    }

    @Override
    public void createContent() {
        super.createContent();
        this.columnModel = new MyColumnModel();
        CorrelationsHolder correlationsHolder = (CorrelationsHolder)this.myEditor.getEditedObject();
        this.tableModel = new MyTableModel(correlationsHolder, this.columnModel);
        JTable jTable = new JTable(this.tableModel, this.columnModel);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.setRowHeight((int)new JComboBox().getPreferredSize().getHeight());
        Dimension dimension = jTable.getPreferredSize();
        dimension.setSize(dimension.getWidth(), 100.0);
        jTable.setPreferredScrollableViewportSize(dimension);
        JScrollPane jScrollPane = new JScrollPane(jTable, 22, 30);
        this.add(jScrollPane, "Center");
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_Correlations_Tab"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_Correlations_Tab"));
        this.setTableView(jTable);
    }

    @Override
    protected void addRow(ActionEvent actionEvent) {
        Set<CorrelationSet> set = this.chooseCorrelationSet(this.tableModel.getRowsList());
        if (set != null) {
            for (CorrelationSet correlationSet : set) {
                CorrelationLocal correlationLocal = new CorrelationLocal(correlationSet, Initiate.NO);
                this.tableModel.addRow(correlationLocal);
            }
        }
    }

    private Set<CorrelationSet> chooseCorrelationSet(final List<CorrelationLocal> list) {
        Lookup lookup = this.myEditor.getLookup();
        BpelEntity bpelEntity = (BpelEntity)this.myEditor.getEditedObject();
        final CorrelationSetChooserPanel correlationSetChooserPanel = new CorrelationSetChooserPanel();
        ValidationExtension validationExtension = new ValidationExtension(){

            public Validator getExtensionValidator() {
                DefaultValidator defaultValidator = new DefaultValidator(correlationSetChooserPanel, ErrorMessagesBundle.class){

                    public void doFastValidation() {
                    }

                    public void doDetailedValidation() {
                        Object object = correlationSetChooserPanel.getSelectedValue();
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            CorrelationSet correlationSet = (CorrelationSet)iterator.next();
                            if (correlationSet == null) continue;
                            for (CorrelationLocal correlationLocal : list) {
                                CorrelationSet correlationSet2 = correlationLocal.getSet();
                                if (!correlationSet.equals(correlationSet2)) continue;
                                this.addReasonKey(Validator.Severity.ERROR, "ERR_NOT_UNIQUE_CORR_SET", new String[]{correlationSet2.getName()});
                            }
                        }
                    }
                };
                return defaultValidator;
            }
        };
        VisibilityScope visibilityScope = new VisibilityScope(bpelEntity, lookup);
        ExtendedLookup extendedLookup = new ExtendedLookup(lookup, new Object[]{visibilityScope, validationExtension});
        correlationSetChooserPanel.setLookup((Lookup)extendedLookup);
        TreeNodeChooser treeNodeChooser = new TreeNodeChooser(correlationSetChooserPanel);
        treeNodeChooser.initControls();
        String string = NbBundle.getMessage(FormBundle.class, (String)"DLG_CorrelationSetChooser");
        DefaultDialogDescriptor defaultDialogDescriptor = new DefaultDialogDescriptor((Object)treeNodeChooser, string);
        SoaDialogDisplayer.getDefault().notify((NotifyDescriptor)defaultDialogDescriptor);
        if (defaultDialogDescriptor.isOkHasPressed()) {
            Object object = correlationSetChooserPanel.getSelectedValue();
            return object;
        }
        return null;
    }

    @Override
    protected void editRow(ActionEvent actionEvent) {
        int n = this.getTableView().getSelectedRow();
        if (n == -1) {
            return;
        }
        CorrelationLocal correlationLocal = (CorrelationLocal)this.tableModel.getRowObject(n);
        if (correlationLocal.getSet() == null) {
            Set<CorrelationSet> set = this.chooseCorrelationSet(this.tableModel.getRowsList());
            if (set != null && !set.isEmpty()) {
                CorrelationSet correlationSet = set.iterator().next();
                correlationLocal.setSet(correlationSet);
            }
        } else {
            CorrelationSet correlationSet = correlationLocal.getSet();
            if (this.editCorrelationSet(correlationSet)) {
                this.tableModel.updateRow(n);
            }
        }
    }

    private boolean editCorrelationSet(CorrelationSet correlationSet) {
        Lookup lookup = this.myEditor.getLookup();
        if (correlationSet != null) {
            CorrelationSetNode.MyChildren myChildren = new CorrelationSetNode.MyChildren(correlationSet, lookup);
            CorrelationSetNode correlationSetNode = new CorrelationSetNode(correlationSet, (Children)myChildren, lookup);
            SimpleCustomEditor<CorrelationSet> simpleCustomEditor = new SimpleCustomEditor<CorrelationSet>(correlationSetNode, CorrelationSetMainPanel.class, CustomNodeEditor.EditingMode.EDIT_INSTANCE);
            String string = NbBundle.getMessage(FormBundle.class, (String)"DLG_EditCorrelationSet");
            NodeEditorDescriptor nodeEditorDescriptor = new NodeEditorDescriptor(simpleCustomEditor, string);
            SoaDialogDisplayer.getDefault().notify((NotifyDescriptor)nodeEditorDescriptor);
            return nodeEditorDescriptor.isOkHasPressed();
        }
        return false;
    }

    @Override
    protected void deleteRowImpl(ActionEvent actionEvent) {
        int[] nArray = this.getTableView().getSelectedRows();
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n = nArray[i];
            this.tableModel.deleteRow(n);
        }
    }

    private BpelModel getModel() {
        Lookup lookup = this.myEditor.getLookup();
        return (BpelModel)lookup.lookup(BpelModel.class);
    }

    public boolean applyNewValues() {
        block6: {
            List list;
            CorrelationContainer correlationContainer;
            CorrelationsHolder correlationsHolder;
            block5: {
                correlationsHolder = (CorrelationsHolder)this.myEditor.getEditedObject();
                correlationContainer = correlationsHolder.getCorrelationContainer();
                list = this.tableModel.getRowsList();
                if (list != null && list.size() != 0) break block5;
                if (correlationContainer == null) break block6;
                correlationsHolder.removeCorrelationContainer();
                break block6;
            }
            if (correlationContainer == null) {
                BPELElementsBuilder bPELElementsBuilder = this.getModel().getBuilder();
                correlationContainer = bPELElementsBuilder.createCorrelationContainer();
                correlationsHolder.setCorrelationContainer(correlationContainer);
                correlationContainer = correlationsHolder.getCorrelationContainer();
                for (CorrelationLocal correlationLocal : list) {
                    correlationLocal.createObjectInModel(correlationContainer);
                }
            } else {
                int n = correlationContainer.sizeOfCorrelations();
                for (int i = n - 1; i >= 0; --i) {
                    correlationContainer.removeCorrelation(i);
                }
                for (CorrelationLocal correlationLocal : list) {
                    correlationLocal.createObjectInModel(correlationContainer);
                }
            }
        }
        return false;
    }

    public Validator getValidator() {
        if (this.myValidator == null) {
            this.myValidator = new DefaultValidator((ValidStateManager.Provider)this.myEditor, ErrorMessagesBundle.class){

                public void doFastValidation() {
                }

                public void doDetailedValidation() {
                    List list = CorrelationTablePanel.this.tableModel.getRowsList();
                    if (list != null && list.size() != 0) {
                        for (CorrelationLocal correlationLocal : list) {
                            CorrelationSet correlationSet = correlationLocal.getSet();
                            if (correlationSet != null) continue;
                            this.addReasonKey(Validator.Severity.ERROR, "ERR_INVALID_REF_CORR_TO_SET");
                            break;
                        }
                    }
                }
            };
        }
        return this.myValidator;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(((Object)((Object)this)).getClass());
    }

    class CorrelationLocal {
        private Initiate myInitiate;
        private CorrelationSet mySet;

        public CorrelationLocal(CorrelationSet correlationSet, Initiate initiate) {
            this.mySet = correlationSet;
            this.myInitiate = initiate;
        }

        public CorrelationLocal(Correlation correlation) {
            assert (correlation != null);
            BpelReference bpelReference = correlation.getSet();
            if (bpelReference != null) {
                this.mySet = (CorrelationSet)bpelReference.get();
            }
            this.myInitiate = correlation.getInitiate();
        }

        public Initiate getInitiate() {
            return this.myInitiate;
        }

        public CorrelationSet getSet() {
            return this.mySet;
        }

        public void removeInitiate() {
            this.myInitiate = null;
        }

        public void setInitiate(Initiate initiate) {
            this.myInitiate = initiate;
        }

        public void setSet(CorrelationSet correlationSet) {
            this.mySet = correlationSet;
        }

        public Correlation createObjectInModel(CorrelationContainer correlationContainer) {
            Correlation correlation = correlationContainer.getBpelModel().getBuilder().createCorrelation();
            correlationContainer.addCorrelation(correlation);
            if (this.mySet == null) {
                assert (false) : "The CorrelationSet has to be specified";
            } else {
                BpelReference bpelReference = correlation.createReference((BpelReferenceable)this.mySet, CorrelationSet.class);
                correlation.setSet(bpelReference);
            }
            if (this.myInitiate == null) {
                correlation.removeInitiate();
            } else {
                correlation.setInitiate(this.myInitiate);
            }
            return correlation;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyTableModel
    extends ObjectListTableModel<CorrelationLocal> {
        private CorrelationsHolder corrHolder;

        public MyTableModel(CorrelationsHolder correlationsHolder, TableColumnModel tableColumnModel) {
            super(tableColumnModel);
            assert (correlationsHolder != null);
            this.corrHolder = correlationsHolder;
            this.reload();
        }

        @Override
        public void reload() {
            CorrelationContainer correlationContainer = this.corrHolder.getCorrelationContainer();
            if (correlationContainer != null) {
                Correlation[] correlationArray;
                for (Correlation correlation : correlationArray = correlationContainer.getCorrelations()) {
                    CorrelationLocal correlationLocal = new CorrelationLocal(correlation);
                    this.addRow(correlationLocal);
                }
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            CorrelationLocal correlationLocal = (CorrelationLocal)this.getRowObject(n);
            TableColumn tableColumn = CorrelationTablePanel.this.columnModel.getColumn(n2);
            PropertyType propertyType = (PropertyType)((Object)tableColumn.getIdentifier());
            switch (propertyType) {
                case CORRELATION_SET: {
                    return correlationLocal.getSet();
                }
                case CORRELATION_INITIATE: {
                    return correlationLocal.getInitiate();
                }
            }
            assert (false) : "The property: \"" + (Object)((Object)propertyType) + "\" isn't supported by the getValueAt()";
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            CorrelationLocal correlationLocal = (CorrelationLocal)this.getRowObject(n);
            TableColumn tableColumn = CorrelationTablePanel.this.columnModel.getColumn(n2);
            PropertyType propertyType = (PropertyType)((Object)tableColumn.getIdentifier());
            switch (propertyType) {
                case CORRELATION_SET: {
                    break;
                }
                case CORRELATION_INITIATE: {
                    assert (object == null || object instanceof Initiate);
                    correlationLocal.setInitiate((Initiate)object);
                    break;
                }
                default: {
                    assert (false) : "The property: \"" + (Object)((Object)propertyType) + "\" isn't supported by the getValueAt()";
                    break;
                }
            }
        }
    }

    class MyColumnModel
    extends DefaultTableColumnModel {
        static final long serialVersionUID = 1L;

        public MyColumnModel() {
            TableColumn tableColumn = new TableColumn(0);
            tableColumn.setPreferredWidth(150);
            tableColumn.setIdentifier((Object)PropertyType.CORRELATION_SET);
            tableColumn.setHeaderValue(PropertyType.CORRELATION_SET.getDisplayName());
            tableColumn.setCellRenderer(new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (object != null) {
                        assert (object instanceof CorrelationSet);
                        CorrelationSet correlationSet = (CorrelationSet)object;
                        String string = correlationSet.getName();
                        this.setText(string);
                        this.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 2));
                    }
                    return this;
                }
            });
            this.addColumn(tableColumn);
            tableColumn = new TableColumn(1);
            tableColumn.setIdentifier((Object)PropertyType.CORRELATION_INITIATE);
            tableColumn.setHeaderValue(PropertyType.CORRELATION_INITIATE.getDisplayName());
            Initiate[] initiateArray = new Initiate[]{Initiate.NO, Initiate.YES, Initiate.JOIN};
            final JComboBox<Initiate> jComboBox = new JComboBox<Initiate>(initiateArray);
            jComboBox.setEditable(true);
            tableColumn.setCellRenderer(new TableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    assert (object == null || object instanceof Initiate);
                    if (object == null) {
                        ((JTextComponent)jComboBox.getEditor().getEditorComponent()).setText(Constants.NOT_ASSIGNED);
                    } else if (((Initiate)object).isInvalid()) {
                        ((JTextComponent)jComboBox.getEditor().getEditorComponent()).setText(Constants.INVALID);
                    } else {
                        jComboBox.setSelectedItem(object);
                    }
                    return jComboBox;
                }
            });
            tableColumn.setCellEditor(new DefaultCellEditor(new JComboBox<Initiate>(initiateArray)));
            tableColumn.setPreferredWidth(40);
            this.addColumn(tableColumn);
        }
    }
}

