/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.bpel.editors.api.ui.valid.ErrorMessagesBundle;
import org.netbeans.modules.bpel.editors.api.ui.valid.NodeEditorDescriptor;
import org.netbeans.modules.bpel.model.api.BPELElementsBuilder;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.CorrelationSet;
import org.netbeans.modules.bpel.model.api.Invoke;
import org.netbeans.modules.bpel.model.api.PatternedCorrelation;
import org.netbeans.modules.bpel.model.api.PatternedCorrelationContainer;
import org.netbeans.modules.bpel.model.api.references.BpelReference;
import org.netbeans.modules.bpel.model.api.references.BpelReferenceable;
import org.netbeans.modules.bpel.model.api.support.Initiate;
import org.netbeans.modules.bpel.model.api.support.Pattern;
import org.netbeans.modules.bpel.model.api.support.VisibilityScope;
import org.netbeans.modules.bpel.nodes.CorrelationSetNode;
import org.netbeans.modules.bpel.properties.Constants;
import org.netbeans.modules.bpel.properties.PropertyType;
import org.netbeans.modules.bpel.properties.choosers.CorrelationSetChooserPanel;
import org.netbeans.modules.bpel.properties.editors.CorrelationSetMainPanel;
import org.netbeans.modules.bpel.properties.editors.FormBundle;
import org.netbeans.modules.bpel.properties.editors.controls.BaseTablePanel;
import org.netbeans.modules.bpel.properties.editors.controls.MessageConfigurationController;
import org.netbeans.modules.bpel.properties.editors.controls.ObjectListTableModel;
import org.netbeans.modules.bpel.properties.editors.controls.SimpleCustomEditor;
import org.netbeans.modules.bpel.properties.editors.controls.TreeNodeChooser;
import org.netbeans.modules.soa.ui.ExtendedLookup;
import org.netbeans.modules.soa.ui.form.CustomNodeEditor;
import org.netbeans.modules.soa.ui.form.valid.DefaultDialogDescriptor;
import org.netbeans.modules.soa.ui.form.valid.DefaultValidator;
import org.netbeans.modules.soa.ui.form.valid.SoaDialogDisplayer;
import org.netbeans.modules.soa.ui.form.valid.ValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.Validator;
import org.netbeans.modules.xml.wsdl.model.OneWayOperation;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.RequestResponseOperation;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Children;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelationPTablePanel
extends BaseTablePanel
implements Validator.Provider,
HelpCtx.Provider {
    static final long serialVersionUID = 1L;
    private CustomNodeEditor<Invoke> myEditor;
    private MessageConfigurationController myMcc;
    private DefaultValidator myValidator;
    private TableColumnModel columnModel;
    private MyTableModel tableModel;

    public CorrelationPTablePanel(CustomNodeEditor<Invoke> customNodeEditor, MessageConfigurationController messageConfigurationController) {
        this.myEditor = customNodeEditor;
        this.myMcc = messageConfigurationController;
        this.createContent();
    }

    @Override
    public void createContent() {
        super.createContent();
        this.columnModel = new MyColumnModel();
        Invoke invoke = (Invoke)this.myEditor.getEditedObject();
        this.tableModel = new MyTableModel(invoke, this.columnModel);
        JTable jTable = new JTable(this.tableModel, this.columnModel);
        jTable.getTableHeader().setReorderingAllowed(false);
        jTable.setRowHeight((int)new JComboBox().getPreferredSize().getHeight());
        Dimension dimension = jTable.getPreferredSize();
        dimension.setSize(dimension.getWidth(), 100.0);
        jTable.setPreferredScrollableViewportSize(dimension);
        JScrollPane jScrollPane = new JScrollPane(jTable, 22, 30);
        this.add(jScrollPane, "Center");
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FormBundle.class, (String)"ACSN_LBL_Correlations_Tab"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FormBundle.class, (String)"ACSD_LBL_Correlations_Tab"));
        this.setTableView(jTable);
    }

    @Override
    protected void addRow(ActionEvent actionEvent) {
        Set<CorrelationSet> set = this.chooseCorrelationSet();
        if (set != null) {
            for (CorrelationSet correlationSet : set) {
                PatternedCorrelationLocal patternedCorrelationLocal = new PatternedCorrelationLocal(correlationSet, Initiate.NO, Pattern.NOT_SPECIFIED);
                this.tableModel.addRow(patternedCorrelationLocal);
            }
        }
    }

    private Set<CorrelationSet> chooseCorrelationSet() {
        Lookup lookup = this.myEditor.getLookup();
        BpelEntity bpelEntity = (BpelEntity)this.myEditor.getEditedObject();
        CorrelationSetChooserPanel correlationSetChooserPanel = new CorrelationSetChooserPanel();
        VisibilityScope visibilityScope = new VisibilityScope(bpelEntity, lookup);
        ExtendedLookup extendedLookup = new ExtendedLookup(lookup, new Object[]{visibilityScope});
        correlationSetChooserPanel.setLookup((Lookup)extendedLookup);
        TreeNodeChooser treeNodeChooser = new TreeNodeChooser(correlationSetChooserPanel);
        treeNodeChooser.initControls();
        String string = NbBundle.getMessage(FormBundle.class, (String)"DLG_CorrelationSetChooser");
        DefaultDialogDescriptor defaultDialogDescriptor = new DefaultDialogDescriptor((Object)treeNodeChooser, string);
        SoaDialogDisplayer.getDefault().notify((NotifyDescriptor)defaultDialogDescriptor);
        if (defaultDialogDescriptor.isOkHasPressed()) {
            Object object = correlationSetChooserPanel.getSelectedValue();
            return object;
        }
        return null;
    }

    @Override
    protected void editRow(ActionEvent actionEvent) {
        int n = this.getTableView().getSelectedRow();
        if (n == -1) {
            return;
        }
        PatternedCorrelationLocal patternedCorrelationLocal = (PatternedCorrelationLocal)this.tableModel.getRowObject(n);
        if (patternedCorrelationLocal.getSet() == null) {
            Set<CorrelationSet> set = this.chooseCorrelationSet();
            if (set != null && !set.isEmpty()) {
                CorrelationSet correlationSet = set.iterator().next();
                patternedCorrelationLocal.setSet(correlationSet);
            }
        } else {
            CorrelationSet correlationSet = patternedCorrelationLocal.getSet();
            if (this.editCorrelationSet(correlationSet)) {
                this.tableModel.updateRow(n);
            }
        }
    }

    private boolean editCorrelationSet(CorrelationSet correlationSet) {
        Lookup lookup = this.myEditor.getLookup();
        if (correlationSet != null) {
            CorrelationSetNode.MyChildren myChildren = new CorrelationSetNode.MyChildren(correlationSet, lookup);
            CorrelationSetNode correlationSetNode = new CorrelationSetNode(correlationSet, (Children)myChildren, lookup);
            SimpleCustomEditor<CorrelationSet> simpleCustomEditor = new SimpleCustomEditor<CorrelationSet>(correlationSetNode, CorrelationSetMainPanel.class, CustomNodeEditor.EditingMode.EDIT_INSTANCE);
            String string = NbBundle.getMessage(FormBundle.class, (String)"DLG_EditCorrelationSet");
            NodeEditorDescriptor nodeEditorDescriptor = new NodeEditorDescriptor(simpleCustomEditor, string);
            SoaDialogDisplayer.getDefault().notify((NotifyDescriptor)nodeEditorDescriptor);
            return nodeEditorDescriptor.isOkHasPressed();
        }
        return false;
    }

    @Override
    protected void deleteRowImpl(ActionEvent actionEvent) {
        int[] nArray = this.getTableView().getSelectedRows();
        for (int i = nArray.length - 1; i >= 0; --i) {
            int n = nArray[i];
            this.tableModel.deleteRow(n);
        }
    }

    private BpelModel getModel() {
        Lookup lookup = this.myEditor.getLookup();
        return (BpelModel)lookup.lookup(BpelModel.class);
    }

    public boolean applyNewValues() {
        block6: {
            List list;
            PatternedCorrelationContainer patternedCorrelationContainer;
            Invoke invoke;
            block5: {
                invoke = (Invoke)this.myEditor.getEditedObject();
                patternedCorrelationContainer = invoke.getPatternedCorrelationContainer();
                list = this.tableModel.getRowsList();
                if (list != null && list.size() != 0) break block5;
                if (patternedCorrelationContainer == null) break block6;
                invoke.removePatternedCorrelationContainer();
                break block6;
            }
            if (patternedCorrelationContainer == null) {
                BPELElementsBuilder bPELElementsBuilder = this.getModel().getBuilder();
                patternedCorrelationContainer = bPELElementsBuilder.createPatternedCorrelationContainer();
                invoke.setPatternedCorrelationContainer(patternedCorrelationContainer);
                patternedCorrelationContainer = invoke.getPatternedCorrelationContainer();
                for (PatternedCorrelationLocal patternedCorrelationLocal : list) {
                    patternedCorrelationLocal.createObjectInModel(patternedCorrelationContainer);
                }
            } else {
                int n = patternedCorrelationContainer.sizeOfPatternedCorrelation();
                for (int i = n - 1; i >= 0; --i) {
                    patternedCorrelationContainer.removePatternedCorrelation(i);
                }
                for (PatternedCorrelationLocal patternedCorrelationLocal : list) {
                    patternedCorrelationLocal.createObjectInModel(patternedCorrelationContainer);
                }
            }
        }
        return false;
    }

    public Boolean isOneWayOperation() {
        Operation operation = this.myMcc.getCurrentOperation();
        if (operation != null) {
            if (operation instanceof OneWayOperation) {
                return Boolean.TRUE;
            }
            if (operation instanceof RequestResponseOperation) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public Validator getValidator() {
        if (this.myValidator == null) {
            this.myValidator = new MyValidator((ValidStateManager.Provider)this.myEditor);
        }
        return this.myValidator;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(((Object)((Object)this)).getClass());
    }

    private class MyValidator
    extends DefaultValidator {
        public MyValidator(ValidStateManager.Provider provider) {
            super(provider, ErrorMessagesBundle.class);
        }

        public void doFastValidation() {
        }

        public void doDetailedValidation() {
            Object object;
            List list = CorrelationPTablePanel.this.tableModel.getRowsList();
            if (list != null && list.size() != 0) {
                object = list.iterator();
                while (object.hasNext()) {
                    PatternedCorrelationLocal patternedCorrelationLocal = (PatternedCorrelationLocal)object.next();
                    CorrelationSet correlationSet = patternedCorrelationLocal.getSet();
                    if (correlationSet != null) continue;
                    this.addReasonKey(Validator.Severity.ERROR, "ERR_INVALID_REF_CORR_TO_SET");
                    break;
                }
            }
            if ((object = CorrelationPTablePanel.this.isOneWayOperation()) != null) {
                this.checkDuplicates((Boolean)object);
                this.checkPatterns((Boolean)object);
            }
        }

        private void checkPatterns(boolean bl) {
            List list = CorrelationPTablePanel.this.tableModel.getRowsList();
            ArrayList arrayList = new ArrayList(list);
            for (int i = 0; i < arrayList.size(); ++i) {
                PatternedCorrelationLocal patternedCorrelationLocal = (PatternedCorrelationLocal)arrayList.get(i);
                Pattern pattern = patternedCorrelationLocal.getPattern();
                if (bl && pattern != null && pattern != Pattern.NOT_SPECIFIED) {
                    this.addReasonKey(Validator.Severity.ERROR, "ERR_CORR_SET_PATTERN_DISALLOWED");
                    break;
                }
                if (bl || pattern != null && pattern != Pattern.NOT_SPECIFIED) continue;
                this.addReasonKey(Validator.Severity.ERROR, "ERR_CORR_SET_PATTERN_REQUIRED");
                break;
            }
        }

        private void checkDuplicates(boolean bl) {
            List list = CorrelationPTablePanel.this.tableModel.getRowsList();
            ArrayList arrayList = new ArrayList(list);
            for (int i = 0; i < arrayList.size(); ++i) {
                PatternedCorrelationLocal patternedCorrelationLocal = (PatternedCorrelationLocal)arrayList.get(i);
                CorrelationSet correlationSet = patternedCorrelationLocal.getSet();
                if (correlationSet == null) continue;
                for (int j = i + 1; j < arrayList.size(); ++j) {
                    PatternedCorrelationLocal patternedCorrelationLocal2 = (PatternedCorrelationLocal)arrayList.get(j);
                    CorrelationSet correlationSet2 = patternedCorrelationLocal2.getSet();
                    if (correlationSet2 == null || !correlationSet.equals(correlationSet2) || bl) continue;
                    Pattern pattern = patternedCorrelationLocal.getPattern();
                    Pattern pattern2 = patternedCorrelationLocal2.getPattern();
                    if (pattern == Pattern.REQUEST && pattern2 == Pattern.RESPONSE || pattern == Pattern.RESPONSE && pattern2 == Pattern.REQUEST) continue;
                    String string = correlationSet.getName();
                    this.addReasonKey(Validator.Severity.ERROR, "ERR_NOT_UNIQUE_PATTERNED_CORR_SET", new String[]{string});
                    return;
                }
            }
        }
    }

    class PatternedCorrelationLocal {
        private Initiate myInitiate;
        private Pattern myPattern;
        private CorrelationSet mySet;

        public PatternedCorrelationLocal(CorrelationSet correlationSet, Initiate initiate, Pattern pattern) {
            this.mySet = correlationSet;
            this.myInitiate = initiate;
            this.myPattern = pattern;
        }

        public PatternedCorrelationLocal(PatternedCorrelation patternedCorrelation) {
            assert (patternedCorrelation != null);
            BpelReference bpelReference = patternedCorrelation.getSet();
            if (bpelReference != null) {
                this.mySet = (CorrelationSet)bpelReference.get();
            }
            this.myInitiate = patternedCorrelation.getInitiate();
            this.myPattern = patternedCorrelation.getPattern();
        }

        public Initiate getInitiate() {
            return this.myInitiate;
        }

        public Pattern getPattern() {
            return this.myPattern;
        }

        public CorrelationSet getSet() {
            return this.mySet;
        }

        public void removeInitiate() {
            this.myInitiate = null;
        }

        public void removePattern() {
            this.myPattern = null;
        }

        public void setInitiate(Initiate initiate) {
            this.myInitiate = initiate;
        }

        public void setPattern(Pattern pattern) {
            this.myPattern = pattern;
        }

        public void setSet(CorrelationSet correlationSet) {
            this.mySet = correlationSet;
        }

        public PatternedCorrelation createObjectInModel(PatternedCorrelationContainer patternedCorrelationContainer) {
            PatternedCorrelation patternedCorrelation = patternedCorrelationContainer.getBpelModel().getBuilder().createPatternedCorrelation();
            patternedCorrelationContainer.addPatternedCorrelation(patternedCorrelation);
            if (this.mySet == null) {
                assert (false) : "The CorrelationSet has to be specified";
            } else {
                BpelReference bpelReference = patternedCorrelation.createReference((BpelReferenceable)this.mySet, CorrelationSet.class);
                patternedCorrelation.setSet(bpelReference);
            }
            if (this.myInitiate == null) {
                patternedCorrelation.removeInitiate();
            } else {
                patternedCorrelation.setInitiate(this.myInitiate);
            }
            if (this.myPattern == null || this.myPattern == Pattern.NOT_SPECIFIED) {
                patternedCorrelation.removePattern();
            } else {
                patternedCorrelation.setPattern(this.myPattern);
            }
            return patternedCorrelation;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyTableModel
    extends ObjectListTableModel<PatternedCorrelationLocal> {
        private Invoke invoke;

        public MyTableModel(Invoke invoke, TableColumnModel tableColumnModel) {
            super(tableColumnModel);
            assert (invoke != null);
            this.invoke = invoke;
            this.reload();
        }

        @Override
        public void reload() {
            PatternedCorrelationContainer patternedCorrelationContainer = this.invoke.getPatternedCorrelationContainer();
            if (patternedCorrelationContainer != null) {
                PatternedCorrelation[] patternedCorrelationArray;
                for (PatternedCorrelation patternedCorrelation : patternedCorrelationArray = patternedCorrelationContainer.getPatternedCorrelations()) {
                    PatternedCorrelationLocal patternedCorrelationLocal = new PatternedCorrelationLocal(patternedCorrelation);
                    this.addRow(patternedCorrelationLocal);
                }
            }
        }

        @Override
        public Object getValueAt(int n, int n2) {
            PatternedCorrelationLocal patternedCorrelationLocal = (PatternedCorrelationLocal)this.getRowObject(n);
            TableColumn tableColumn = CorrelationPTablePanel.this.columnModel.getColumn(n2);
            PropertyType propertyType = (PropertyType)((Object)tableColumn.getIdentifier());
            switch (propertyType) {
                case CORRELATION_SET: {
                    return patternedCorrelationLocal.getSet();
                }
                case CORRELATION_INITIATE: {
                    return patternedCorrelationLocal.getInitiate();
                }
                case CORRELATION_PATTERN: {
                    return patternedCorrelationLocal.getPattern();
                }
            }
            assert (false) : "The property: \"" + (Object)((Object)propertyType) + "\" isn't supported by the getValueAt()";
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            PatternedCorrelationLocal patternedCorrelationLocal = (PatternedCorrelationLocal)this.getRowObject(n);
            TableColumn tableColumn = CorrelationPTablePanel.this.columnModel.getColumn(n2);
            PropertyType propertyType = (PropertyType)((Object)tableColumn.getIdentifier());
            switch (propertyType) {
                case CORRELATION_SET: {
                    break;
                }
                case CORRELATION_INITIATE: {
                    assert (object == null || object instanceof Initiate);
                    patternedCorrelationLocal.setInitiate((Initiate)object);
                    break;
                }
                case CORRELATION_PATTERN: {
                    assert (object == null || object instanceof Pattern);
                    patternedCorrelationLocal.setPattern((Pattern)object);
                    break;
                }
                default: {
                    assert (false) : "The property: \"" + (Object)((Object)propertyType) + "\" isn't supported by the getValueAt()";
                    break;
                }
            }
        }
    }

    class MyColumnModel
    extends DefaultTableColumnModel {
        static final long serialVersionUID = 1L;

        public MyColumnModel() {
            TableColumn tableColumn = new TableColumn(0);
            tableColumn.setPreferredWidth(150);
            tableColumn.setIdentifier((Object)PropertyType.CORRELATION_SET);
            tableColumn.setHeaderValue(PropertyType.CORRELATION_SET.getDisplayName());
            tableColumn.setCellRenderer(new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (object != null) {
                        assert (object instanceof CorrelationSet);
                        CorrelationSet correlationSet = (CorrelationSet)object;
                        String string = correlationSet.getName();
                        this.setText(string);
                        this.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 2));
                    }
                    return this;
                }
            });
            this.addColumn(tableColumn);
            tableColumn = new TableColumn(1);
            tableColumn.setIdentifier((Object)PropertyType.CORRELATION_INITIATE);
            tableColumn.setHeaderValue(PropertyType.CORRELATION_INITIATE.getDisplayName());
            Initiate[] initiateArray = new Initiate[]{null, Initiate.NO, Initiate.YES, Initiate.JOIN};
            final JComboBox<Initiate> jComboBox = new JComboBox<Initiate>(initiateArray);
            jComboBox.setEditable(true);
            tableColumn.setCellRenderer(new TableCellRenderer(){

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    assert (object == null || object instanceof Initiate);
                    if (object == null) {
                        ((JTextComponent)jComboBox.getEditor().getEditorComponent()).setText(Constants.NOT_ASSIGNED);
                    } else if (((Initiate)object).isInvalid()) {
                        ((JTextComponent)jComboBox.getEditor().getEditorComponent()).setText(Constants.INVALID);
                    } else {
                        jComboBox.setSelectedItem(object);
                    }
                    return jComboBox;
                }
            });
            tableColumn.setCellEditor(new DefaultCellEditor(new JComboBox<Initiate>(initiateArray)));
            tableColumn.setPreferredWidth(40);
            this.addColumn(tableColumn);
            tableColumn = new TableColumn(2);
            tableColumn.setIdentifier((Object)PropertyType.CORRELATION_PATTERN);
            tableColumn.setHeaderValue(PropertyType.CORRELATION_PATTERN.getDisplayName());
            final Pattern[] patternArray = new Pattern[]{Pattern.NOT_SPECIFIED, Pattern.REQUEST, Pattern.RESPONSE, Pattern.REQUEST_RESPONSE};
            tableColumn.setCellRenderer(new TableCellRenderer(){
                JComboBox cb;
                {
                    this.cb = new JComboBox<Pattern>(patternArray);
                }

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    if (object != null && object instanceof Pattern) {
                        this.cb.setSelectedItem(object);
                    } else {
                        this.cb.setSelectedIndex(0);
                    }
                    return this.cb;
                }
            });
            tableColumn.setCellEditor(new DefaultCellEditor(new JComboBox<Pattern>(patternArray)));
            tableColumn.setPreferredWidth(40);
            this.addColumn(tableColumn);
        }
    }
}

