/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.model.patterns;

import java.awt.event.ActionEvent;
import java.awt.geom.Area;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.bpel.design.CopyPasteHandler;
import org.netbeans.modules.bpel.design.DiagramView;
import org.netbeans.modules.bpel.design.actions.ScrollToOperationAction;
import org.netbeans.modules.bpel.design.geometry.FBounds;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.layout.LayoutManager;
import org.netbeans.modules.bpel.design.model.DiagramModel;
import org.netbeans.modules.bpel.design.model.connections.Connection;
import org.netbeans.modules.bpel.design.model.connections.MessageConnection;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.patterns.CompositePattern;
import org.netbeans.modules.bpel.design.selection.PlaceHolder;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.NamedElement;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.support.UniqueId;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.nodes.actions.AddBasicActivitiesAction;
import org.netbeans.modules.bpel.nodes.actions.AddFromPaletteAction;
import org.netbeans.modules.bpel.nodes.actions.AddPaletteActivityAction;
import org.netbeans.modules.bpel.nodes.actions.AddStructuredActivitiesAction;
import org.netbeans.modules.bpel.nodes.actions.AddWebServiceActivitiesAction;
import org.netbeans.modules.bpel.nodes.actions.BpelNodeAction;
import org.netbeans.modules.bpel.nodes.actions.GoToAction;
import org.netbeans.modules.bpel.nodes.actions.GoToDiagrammAction;
import org.netbeans.modules.bpel.nodes.actions.WrapAction;
import org.openide.actions.NewAction;
import org.openide.awt.Actions;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Pattern {
    private UniqueId omReference;
    private List<VisualElement> elements = new ArrayList<VisualElement>();
    private List<Connection> connections = new ArrayList<Connection>();
    private DiagramModel model;
    private BpelModel bpelModel;
    private CompositePattern parent;
    private VisualElement textElement;
    private FPoint origin;
    private FBounds bounds;

    public FPoint getOrigin() {
        return this.origin;
    }

    public DiagramView getView() {
        return this.model.getView().getProcessView();
    }

    public void setOrigin(double d, double d2) {
        this.origin = new FPoint(d, d2);
    }

    public Pattern(DiagramModel diagramModel) {
        this.model = diagramModel;
    }

    public DiagramModel getModel() {
        return this.model;
    }

    public BpelModel getBpelModel() {
        return this.bpelModel;
    }

    public void initPattern(BpelEntity bpelEntity) {
        this.omReference = bpelEntity.getUID();
        this.bpelModel = bpelEntity.getBpelModel();
        this.createElementsImpl();
        this.updateName();
    }

    public FBounds getBounds() {
        assert (this.bounds != null) : "Layout manager failed to set bounds for pattern " + this;
        return this.bounds;
    }

    public void setBounds(FBounds fBounds) {
        this.bounds = fBounds;
    }

    public boolean isSelectable() {
        return true;
    }

    public boolean isDraggable() {
        return true;
    }

    public boolean isCollapsable() {
        return false;
    }

    public BpelEntity getOMReference() {
        if (this.omReference != null) {
            return this.bpelModel.getEntity(this.omReference);
        }
        return null;
    }

    public void setParent(CompositePattern compositePattern) {
        CompositePattern compositePattern2 = this.parent;
        if (compositePattern2 != null) {
            compositePattern2.removePattern(this);
        }
        if (compositePattern != null) {
            compositePattern.appendPattern(this);
        }
        this.parent = compositePattern;
    }

    public CompositePattern getParent() {
        return this.parent;
    }

    public Collection<VisualElement> getElements() {
        return this.elements;
    }

    public void removeAllElements() {
        this.elements.clear();
    }

    public void appendElement(VisualElement visualElement) {
        this.elements.add(visualElement);
        visualElement.setPattern(this);
    }

    public void removeElement(VisualElement visualElement) {
        this.elements.remove(visualElement);
        visualElement.setPattern(null);
    }

    public void addConnection(Connection connection) {
        if (!this.connections.contains(connection)) {
            this.connections.add(connection);
        }
    }

    public void clearConnections() {
        for (int i = this.connections.size() - 1; i >= 0; --i) {
            this.connections.get(i).remove();
        }
    }

    public void clearConnectionsExcept(Connection connection) {
        for (int i = this.connections.size() - 1; i >= 0; --i) {
            Connection connection2 = this.connections.get(i);
            if (connection2 == connection) continue;
            connection2.remove();
        }
    }

    public void removeConnection(Connection connection) {
        this.connections.remove(connection);
    }

    public void reconnectElements() {
    }

    public abstract VisualElement getFirstElement();

    public abstract VisualElement getLastElement();

    public abstract FBounds layoutPattern(LayoutManager var1);

    protected abstract void createElementsImpl();

    public void createPlaceholders(Pattern pattern, Collection<PlaceHolder> collection) {
    }

    public JPopupMenu createPopupMenu() {
        Node node = this.getModel().getView().getNodeForPattern(this);
        if (node != null) {
            Action[] actionArray;
            JMenuItem jMenuItem;
            JMenuItem jMenuItem2;
            JPopupMenu jPopupMenu = new JPopupMenu(node.getDisplayName());
            CopyPasteHandler copyPasteHandler = this.getModel().getView().getCopyPasteHandler();
            jPopupMenu.add(new JMenuItem(copyPasteHandler.getCopyAction()));
            jPopupMenu.add(new JMenuItem(copyPasteHandler.getCutAction()));
            jPopupMenu.addSeparator();
            Action action = this.getModel().getView().getCollapseExpandDecorationProvider().createCollapseExpandAction(this);
            if (action != null) {
                jMenuItem2 = jPopupMenu.add(action);
                jMenuItem2.setIcon(null);
            }
            if ((jMenuItem2 = this.createScrollToPartnerLinkMenuItem()) != null) {
                jPopupMenu.add(jMenuItem2);
            }
            if ((jMenuItem = this.createScrollToOperationMenuItem()) != null) {
                jPopupMenu.add(jMenuItem);
            }
            if ((actionArray = node.getActions(true)) != null) {
                for (Action action2 : actionArray) {
                    Object object;
                    BpelNodeAction[] bpelNodeActionArray;
                    if (action2 instanceof BpelNodeAction) {
                        action2.setEnabled(((BpelNodeAction)((Object)action2)).enable(new Node[]{node}));
                    }
                    if (action2 instanceof NewAction) {
                        bpelNodeActionArray = new JMenu(NbBundle.getMessage(Pattern.class, (String)"LBL_Add"));
                        object = ((BpelNode)node).getAddActions();
                        BpelNodeAction[] bpelNodeActionArray2 = object.iterator();
                        while (bpelNodeActionArray2.hasNext()) {
                            BpelNodeAction bpelNodeAction = bpelNodeActionArray2.next();
                            bpelNodeActionArray.add((JMenuItem)new Actions.MenuItem((SystemAction)bpelNodeAction, false));
                        }
                        jPopupMenu.add((JMenuItem)bpelNodeActionArray);
                        continue;
                    }
                    if (action2 instanceof WrapAction) {
                        WrapAction cfr_ignored_0 = (WrapAction)((Object)action2);
                        bpelNodeActionArray = WrapAction.getWrapActions(new Node[]{node});
                        if (bpelNodeActionArray.length == 1) {
                            jPopupMenu.add((JMenuItem)new Actions.MenuItem(action2, false));
                            continue;
                        }
                        object = new JMenu(((WrapAction)((Object)action2)).getBundleName());
                        for (BpelNodeAction bpelNodeAction : bpelNodeActionArray) {
                            ((JMenu)object).add((JMenuItem)new Actions.MenuItem((SystemAction)bpelNodeAction, false));
                        }
                        jPopupMenu.add((JMenuItem)object);
                        continue;
                    }
                    if (action2 instanceof GoToAction) {
                        GoToAction cfr_ignored_1 = (GoToAction)((Object)action2);
                        bpelNodeActionArray = GoToAction.getGoToActions(new Node[]{node});
                        if (bpelNodeActionArray.length == 1 && !(action2 instanceof GoToDiagrammAction)) {
                            jPopupMenu.add((JMenuItem)new Actions.MenuItem(action2, false));
                            continue;
                        }
                        object = new JMenu(((GoToAction)((Object)action2)).getBundleName());
                        for (BpelNodeAction bpelNodeAction : bpelNodeActionArray) {
                            if (bpelNodeAction instanceof GoToDiagrammAction) continue;
                            ((JMenu)object).add((JMenuItem)new Actions.MenuItem((SystemAction)bpelNodeAction, false));
                        }
                        jPopupMenu.add((JMenuItem)object);
                        continue;
                    }
                    if (action2 instanceof AddFromPaletteAction) {
                        AddFromPaletteAction cfr_ignored_2 = (AddFromPaletteAction)((Object)action2);
                        bpelNodeActionArray = AddFromPaletteAction.getCategoriesAction(new Node[]{node});
                        if (bpelNodeActionArray == null || bpelNodeActionArray.length <= 0) continue;
                        object = new JMenu(((AddFromPaletteAction)((Object)action2)).getBundleName());
                        for (BpelNodeAction bpelNodeAction : bpelNodeActionArray) {
                            AddPaletteActivityAction[] addPaletteActivityActionArray = null;
                            if (bpelNodeAction instanceof AddBasicActivitiesAction) {
                                AddBasicActivitiesAction cfr_ignored_3 = (AddBasicActivitiesAction)bpelNodeAction;
                                addPaletteActivityActionArray = AddBasicActivitiesAction.getPaletteActions(new Node[]{node});
                            } else if (bpelNodeAction instanceof AddStructuredActivitiesAction) {
                                AddStructuredActivitiesAction cfr_ignored_4 = (AddStructuredActivitiesAction)bpelNodeAction;
                                addPaletteActivityActionArray = AddStructuredActivitiesAction.getPaletteActions(new Node[]{node});
                            } else if (bpelNodeAction instanceof AddWebServiceActivitiesAction) {
                                AddWebServiceActivitiesAction cfr_ignored_5 = (AddWebServiceActivitiesAction)bpelNodeAction;
                                addPaletteActivityActionArray = AddWebServiceActivitiesAction.getPaletteActions(new Node[]{node});
                            }
                            if (addPaletteActivityActionArray != null && addPaletteActivityActionArray.length == 1) {
                                ((JMenu)object).add((JMenuItem)new Actions.MenuItem((SystemAction)bpelNodeAction, false));
                                continue;
                            }
                            if (addPaletteActivityActionArray == null) continue;
                            JMenu jMenu = new JMenu(bpelNodeAction.getName());
                            for (AddPaletteActivityAction addPaletteActivityAction : addPaletteActivityActionArray) {
                                jMenu.add((JMenuItem)new Actions.MenuItem((SystemAction)addPaletteActivityAction, false));
                            }
                            ((JMenu)object).add(jMenu);
                        }
                        jPopupMenu.add((JMenuItem)object);
                        continue;
                    }
                    if (action2 != null) {
                        if (action2 instanceof GoToDiagrammAction) continue;
                        jPopupMenu.add((JMenuItem)new Actions.MenuItem(action2, false));
                        continue;
                    }
                    jPopupMenu.addSeparator();
                }
            }
            return jPopupMenu;
        }
        return null;
    }

    public boolean isNestedIn(Pattern pattern) {
        for (CompositePattern compositePattern = this.getParent(); compositePattern != null; compositePattern = compositePattern.getParent()) {
            if (compositePattern != pattern) continue;
            return true;
        }
        return false;
    }

    public boolean isInModel() {
        Pattern pattern = this.model.getRootPattern();
        return this == pattern || this.isNestedIn(pattern);
    }

    public String getDefaultName() {
        return "";
    }

    public void registerTextElement(VisualElement visualElement) {
        this.textElement = visualElement;
    }

    public VisualElement getTextElement() {
        return this.textElement;
    }

    public boolean isTextElement(VisualElement visualElement) {
        return visualElement != null ? visualElement == this.textElement : false;
    }

    public void setText(String string) {
        if (this.textElement == null) {
            return;
        }
        this.textElement.setText(string);
    }

    public String getText() {
        return this.textElement != null ? this.textElement.getText() : null;
    }

    public void updateName() {
        if (this.getOMReference() instanceof NamedElement) {
            String string = ((NamedElement)this.getOMReference()).getName();
            this.setText(string);
        } else {
            this.setText(this.getDefaultName());
        }
    }

    public String toString() {
        return this.getClass().getName() + this.hashCode();
    }

    public NodeType getNodeType() {
        return NodeType.UNKNOWN_TYPE;
    }

    public List<Connection> getConnections() {
        return this.connections;
    }

    public List<MessageConnection> getMessageConnections() {
        ArrayList<MessageConnection> arrayList = new ArrayList<MessageConnection>();
        for (Connection connection : this.getConnections()) {
            if (!(connection instanceof MessageConnection)) continue;
            arrayList.add((MessageConnection)connection);
        }
        return arrayList;
    }

    public Set<Pattern> getConnectedParnerLinkPatterns() {
        HashSet<Pattern> hashSet = new HashSet<Pattern>();
        for (Connection connection : this.getConnections()) {
            if (!(connection instanceof MessageConnection)) continue;
            Pattern pattern = connection.getTarget().getPattern();
            Pattern pattern2 = connection.getSource().getPattern();
            if (pattern.getOMReference() instanceof PartnerLink && pattern2 == this) {
                hashSet.add(pattern);
                continue;
            }
            if (!(pattern2.getOMReference() instanceof PartnerLink) || pattern != this) continue;
            hashSet.add(pattern2);
        }
        return hashSet;
    }

    public Area createSelection() {
        return this.createOutline();
    }

    public Area createOutline() {
        Area area = new Area();
        for (VisualElement visualElement : this.getElements()) {
            if (visualElement.getWidth() < 2.0 && visualElement.getHeight() < 2.0) continue;
            area.add(visualElement.getShape().createArea());
        }
        return area;
    }

    public boolean refersTo(UniqueId uniqueId) {
        return this.omReference.equals(uniqueId);
    }

    private JMenuItem createScrollToPartnerLinkMenuItem() {
        Set<Pattern> set = this.getConnectedParnerLinkPatterns();
        if (set.isEmpty()) {
            return null;
        }
        if (set.size() == 1) {
            return new JMenuItem(new ScrollToPattern(set.iterator().next(), NbBundle.getMessage(Pattern.class, (String)"LBL_ScrollToPartnerLink")));
        }
        JMenu jMenu = new JMenu(NbBundle.getMessage(Pattern.class, (String)"LBL_ScrollToPartnerLink"));
        for (Pattern pattern : set) {
            jMenu.add(new ScrollToPattern(pattern));
        }
        return jMenu;
    }

    private JMenuItem createScrollToOperationMenuItem() {
        for (Connection connection : this.getConnections()) {
            if (!(connection instanceof MessageConnection)) continue;
            return new JMenuItem(new ScrollToOperation((MessageConnection)connection));
        }
        return null;
    }

    static class ScrollToPattern
    extends AbstractAction {
        private Pattern pattern;

        public ScrollToPattern(Pattern pattern) {
            this(pattern, null);
        }

        public ScrollToPattern(Pattern pattern, String string) {
            if (string == null && ((string = pattern.getText()) == null || string.trim().equals(""))) {
                string = NbBundle.getMessage(Pattern.class, (String)"LBL_Unnamed");
            }
            this.pattern = pattern;
            this.putValue("Name", string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.pattern.getView().scrollPatternToView(this.pattern);
        }
    }

    static class ScrollToOperation
    extends AbstractAction {
        private MessageConnection messageConnection;

        public ScrollToOperation(MessageConnection messageConnection) {
            super(ScrollToOperationAction.ACTION_NAME);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 576));
            this.messageConnection = messageConnection;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.messageConnection.getSource().getPattern().getModel().getView().scrollToOperation(this.messageConnection);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AddActionSubMenuModel
    implements Actions.SubMenuModel {
        private List<BpelNodeAction> addActions;
        private BpelNode node;

        public AddActionSubMenuModel(List<BpelNodeAction> list, BpelNode bpelNode) {
            this.addActions = list;
            this.node = bpelNode;
        }

        public int getCount() {
            return this.addActions == null ? -1 : this.addActions.size();
        }

        public String getLabel(int n) {
            if (n < 0 || n > this.getCount() - 1 || this.addActions.get(n) == null) {
                return null;
            }
            return this.addActions.get(n).getName();
        }

        public HelpCtx getHelpCtx(int n) {
            if (n < 0 || n > this.getCount() - 1 || this.addActions.get(n) == null) {
                return null;
            }
            return this.addActions.get(n).getHelpCtx();
        }

        public void performActionAt(int n) {
            if (n < 0 || n > this.getCount() - 1 || this.addActions.get(n) == null) {
                return;
            }
            this.addActions.get(n).performAction(new Node[]{this.node});
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }
    }

    private class AddAction
    implements Action {
        private NewAction na;

        public AddAction(NewAction newAction) {
            this.na = newAction;
        }

        public Object getValue(String string) {
            return this.na.getValue(string);
        }

        public void putValue(String string, Object object) {
            this.na.putValue(string, object);
        }

        public void setEnabled(boolean bl) {
        }

        public boolean isEnabled() {
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }
}

