/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.model.elements;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.bpel.design.ViewProperties;
import org.netbeans.modules.bpel.design.decoration.Decoration;
import org.netbeans.modules.bpel.design.decoration.TextstyleDescriptor;
import org.netbeans.modules.bpel.design.geometry.FBounds;
import org.netbeans.modules.bpel.design.geometry.FShape;
import org.netbeans.modules.bpel.design.model.connections.Connection;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VisualElement {
    protected FShape shape;
    private FBounds textBounds;
    private List<Connection> inputConnections = new ArrayList<Connection>();
    private List<Connection> outputConnections = new ArrayList<Connection>();
    private String text;
    private Pattern pattern;
    private static final double COS_45 = Math.sqrt(2.0) / 2.0;
    public static final Color GRADIENT_TEXTURE_COLOR = new Color(15199476);
    public static final BufferedImage GRADIENT_TEXTURE;

    public VisualElement(FShape fShape) {
        this.shape = fShape;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean hasPattern() {
        return this.pattern != null;
    }

    public void addInputConnection(Connection connection) {
        this.inputConnections.add(connection);
    }

    public void addOutputConnection(Connection connection) {
        this.outputConnections.add(connection);
    }

    public void removeInputConnection(Connection connection) {
        this.inputConnections.remove(connection);
    }

    public void removeOutputConnection(Connection connection) {
        this.outputConnections.remove(connection);
    }

    public List<Connection> getIncomingConnections() {
        return this.inputConnections;
    }

    public List<Connection> getOutcomingConnections() {
        return this.outputConnections;
    }

    public void setLabelText(String string) {
        this.text = string;
    }

    public String getLabelText() {
        return this.text;
    }

    public abstract void paint(Graphics2D var1);

    public abstract void paintThumbnail(Graphics2D var1);

    public FShape getShape() {
        return this.shape;
    }

    public FBounds getBounds() {
        return this.shape;
    }

    public void translate(double d, double d2) {
        this.shape = this.shape.translate(d, d2);
    }

    public void setLocation(double d, double d2) {
        this.shape = this.shape.move(d, d2);
    }

    public void setCenter(double d, double d2) {
        this.shape = this.shape.moveCenter(d, d2);
    }

    public double getX() {
        return this.shape.getX();
    }

    public double getY() {
        return this.shape.getY();
    }

    public double getCenterX() {
        return this.shape.getCenterX();
    }

    public double getCenterY() {
        return this.shape.getCenterY();
    }

    public double getMinX() {
        return this.shape.getMinX();
    }

    public double getMinY() {
        return this.shape.getMinY();
    }

    public double getMaxX() {
        return this.shape.getMaxX();
    }

    public double getMaxY() {
        return this.shape.getMaxY();
    }

    public double getWidth() {
        return this.shape.getWidth();
    }

    public double getHeight() {
        return this.shape.getHeight();
    }

    public boolean textContains(double d, double d2) {
        return this.textBounds != null && this.textBounds.contains(d, d2);
    }

    public boolean contains(double d, double d2) {
        return this.textContains(d, d2) || this.shape.contains(d, d2);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string != null ? string.trim() : null;
    }

    public boolean isEmptyText() {
        return this.text == null || this.text.length() == 0;
    }

    public boolean isTextElement() {
        return this.getPattern() == null ? false : this.getPattern().isTextElement(this);
    }

    public boolean isPaintText() {
        return !this.isEmptyText();
    }

    public Color getTextColor() {
        Pattern pattern = this.getPattern();
        Decoration decoration = pattern.getModel().getView().getDecoration(pattern);
        TextstyleDescriptor textstyleDescriptor = decoration == null ? null : decoration.getTextstyle();
        boolean bl = this.isTextElement();
        if (textstyleDescriptor == null) {
            return bl ? ViewProperties.EDITABLE_TEXT_COLOR : ViewProperties.UNEDITABLE_TEXT_COLOR;
        }
        return bl ? textstyleDescriptor.getEditableTextColor() : textstyleDescriptor.getNotEditableTextColor();
    }

    protected void drawString(Graphics2D graphics2D, String string, double d, double d2, double d3) {
        if (string == null || string.length() == 0) {
            this.setTextBounds(null);
        }
        string = VisualElement.clipString(string, graphics2D, d3);
        Rectangle2D rectangle2D = graphics2D.getFont().getStringBounds(string, graphics2D.getFontRenderContext());
        double d4 = rectangle2D.getWidth();
        double d5 = rectangle2D.getHeight();
        double d6 = d - rectangle2D.getX();
        double d7 = d2 - rectangle2D.getY();
        graphics2D.translate(d6, d7);
        graphics2D.drawString(string, 0, 0);
        graphics2D.translate(-d6, -d7);
        this.setTextBounds(new FBounds(d6, d7 + rectangle2D.getY(), d4, d5));
    }

    protected void drawXCenteredString(Graphics2D graphics2D, String string, double d, double d2, double d3) {
        if (string == null || string.length() == 0) {
            this.setTextBounds(null);
        }
        string = VisualElement.clipString(string, graphics2D, d3);
        Rectangle2D rectangle2D = graphics2D.getFont().getStringBounds(string, graphics2D.getFontRenderContext());
        double d4 = rectangle2D.getWidth();
        double d5 = rectangle2D.getHeight();
        double d6 = d - d4 / 2.0 - rectangle2D.getX();
        double d7 = d2 - rectangle2D.getY();
        graphics2D.translate(d6, d7);
        graphics2D.drawString(string, 0, 0);
        graphics2D.translate(-d6, -d7);
        this.setTextBounds(new FBounds(d6, d7 + rectangle2D.getY(), d4, d5));
    }

    protected void drawCenteredString(Graphics2D graphics2D, String string, double d, double d2, double d3) {
        if (string == null || string.length() == 0) {
            this.setTextBounds(null);
        }
        string = VisualElement.clipString(string, graphics2D, d3);
        Rectangle2D rectangle2D = graphics2D.getFont().getStringBounds(string, graphics2D.getFontRenderContext());
        double d4 = rectangle2D.getWidth();
        double d5 = rectangle2D.getHeight();
        double d6 = d - d4 / 2.0 - rectangle2D.getX();
        double d7 = d2 - d5 / 2.0 - rectangle2D.getY();
        graphics2D.translate(d6, d7);
        graphics2D.drawString(string, 0, 0);
        graphics2D.translate(-d6, -d7);
        this.setTextBounds(new FBounds(d6, d7 + rectangle2D.getY(), d4, d5));
    }

    private static String clipString(String string, Graphics2D graphics2D, double d) {
        FontRenderContext fontRenderContext;
        Font font = graphics2D.getFont();
        double d2 = font.getStringBounds(string, fontRenderContext = graphics2D.getFontRenderContext()).getWidth();
        if (d2 <= d) {
            return string;
        }
        if ((d -= font.getStringBounds("...", fontRenderContext).getWidth()) <= 0.0) {
            return "...";
        }
        int n = string.length();
        while ((d2 -= font.getStringBounds(string.substring(--n, n + 1), fontRenderContext).getWidth()) > d && n > 0) {
        }
        return string.substring(0, n) + "...";
    }

    public static double getScale(AffineTransform affineTransform) {
        if (affineTransform == null) {
            return 1.0;
        }
        double[] dArray = new double[]{1.0, 1.0};
        affineTransform.deltaTransform(dArray, 0, dArray, 0, 1);
        double d = dArray[0];
        double d2 = dArray[1];
        return Math.sqrt(d * d + d2 * d2) / 2.0;
    }

    public FBounds getTextBounds() {
        if (this.isEmptyText()) {
            return null;
        }
        return this.textBounds;
    }

    protected void setTextBounds(FBounds fBounds) {
        this.textBounds = fBounds;
    }

    public List<Connection> getAllConnections() {
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        arrayList.addAll(this.inputConnections);
        arrayList.addAll(this.outputConnections);
        return arrayList;
    }

    static {
        double[] dArray = new double[]{0.0, 0.0843, 0.1798, 0.7416, 0.9045, 1.0674};
        int[] nArray = new int[]{11128296, 14543862, 0xFFFFFF, 14476271, 15200761, 14476271};
        BufferedImage bufferedImage = new BufferedImage(1, 100, 1);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, 1.0f, 100.0f);
        for (int i = 1; i < dArray.length; ++i) {
            float f = (float)(dArray[i - 1] * 100.0 - 0.5);
            float f2 = (float)(dArray[i] * 100.0 + 0.5);
            float_.y = f;
            float_.height = f2 - f;
            GradientPaint gradientPaint = new GradientPaint(0.0f, f, new Color(nArray[i - 1]), 0.0f, f2, new Color(nArray[i]));
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(float_);
        }
        GRADIENT_TEXTURE = bufferedImage;
    }
}

