/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.model.connections;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.model.connections.Connection;
import org.netbeans.modules.bpel.design.model.connections.ConnectionComparator;
import org.netbeans.modules.bpel.design.model.connections.Direction;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.patterns.CompositePattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionManager {
    private Map<Connection, FPoint> startPoints = new HashMap<Connection, FPoint>();
    private Map<Connection, FPoint> endPoints = new HashMap<Connection, FPoint>();

    public void layoutConnections(Pattern pattern) {
        this.calculatePoints(pattern);
        this.applyPoints();
        this.startPoints.clear();
        this.endPoints.clear();
    }

    private void calculatePoints(Pattern pattern) {
        for (VisualElement visualElement : pattern.getElements()) {
            this.processVisualElement(visualElement);
        }
        if (pattern instanceof CompositePattern) {
            VisualElement visualElement;
            CompositePattern compositePattern = (CompositePattern)pattern;
            visualElement = compositePattern.getBorder();
            if (visualElement != null) {
                this.processVisualElement(visualElement);
            }
            for (Pattern pattern2 : compositePattern.getNestedPatterns()) {
                this.calculatePoints(pattern2);
            }
        }
    }

    private Set<Connection> getConnectionsSet() {
        Set<Connection> set = this.startPoints.keySet();
        Set<Connection> set2 = this.endPoints.keySet();
        HashSet<Connection> hashSet = new HashSet<Connection>();
        HashSet<Connection> hashSet2 = new HashSet<Connection>();
        for (Connection connection : set) {
            if (set2.contains(connection)) {
                hashSet.add(connection);
                continue;
            }
            hashSet2.add(connection);
        }
        for (Connection connection : set2) {
            if (set.contains(connection)) {
                hashSet.add(connection);
                continue;
            }
            hashSet2.add(connection);
        }
        for (Connection connection : hashSet2) {
            connection.remove();
        }
        return hashSet;
    }

    private void applyPoints() {
        for (Connection connection : this.getConnectionsSet()) {
            FPoint fPoint = this.startPoints.get(connection);
            FPoint fPoint2 = this.endPoints.get(connection);
            connection.setStartAndEndPoints(fPoint, fPoint2);
        }
    }

    private void processVisualElement(VisualElement visualElement) {
        double d;
        double d2;
        double d3;
        SortedSet<Connection> sortedSet = this.createConnectionSortedSet(visualElement, Direction.TOP);
        SortedSet<Connection> sortedSet2 = this.createConnectionSortedSet(visualElement, Direction.RIGHT);
        SortedSet<Connection> sortedSet3 = this.createConnectionSortedSet(visualElement, Direction.BOTTOM);
        SortedSet<Connection> sortedSet4 = this.createConnectionSortedSet(visualElement, Direction.LEFT);
        block10: for (Connection connection : visualElement.getOutcomingConnections()) {
            switch (connection.getSourceDirection()) {
                case TOP: {
                    sortedSet.add(connection);
                    continue block10;
                }
                case RIGHT: {
                    sortedSet2.add(connection);
                    continue block10;
                }
                case BOTTOM: {
                    sortedSet3.add(connection);
                    continue block10;
                }
            }
            sortedSet4.add(connection);
        }
        block11: for (Connection connection : visualElement.getIncomingConnections()) {
            switch (connection.getTargetDirection()) {
                case TOP: {
                    sortedSet.add(connection);
                    continue block11;
                }
                case RIGHT: {
                    sortedSet2.add(connection);
                    continue block11;
                }
                case BOTTOM: {
                    sortedSet3.add(connection);
                    continue block11;
                }
            }
            sortedSet4.add(connection);
        }
        int n = sortedSet.size();
        int n2 = sortedSet2.size();
        int n3 = sortedSet3.size();
        int n4 = sortedSet4.size();
        if (n > 0) {
            d3 = visualElement.getWidth() / (double)(n + 1);
            d2 = visualElement.getX() + d3;
            d = visualElement.getY();
            if (n == 1) {
                this.storeConnectionPoint(visualElement, sortedSet.first(), d2, d);
            } else {
                for (Connection connection : sortedSet) {
                    this.storeConnectionPoint(visualElement, connection, d2, d);
                    d2 += d3;
                }
            }
        }
        if (n2 > 0) {
            d3 = visualElement.getHeight() / (double)(n2 + 1);
            d2 = visualElement.getX() + visualElement.getWidth();
            d = visualElement.getY() + d3;
            if (n2 == 1) {
                this.storeConnectionPoint(visualElement, sortedSet2.first(), d2, d);
            } else {
                for (Connection connection : sortedSet2) {
                    this.storeConnectionPoint(visualElement, connection, d2, d);
                    d += d3;
                }
            }
        }
        if (n3 > 0) {
            d3 = visualElement.getWidth() / (double)(n3 + 1);
            d2 = visualElement.getX() + d3;
            d = visualElement.getY() + visualElement.getHeight();
            if (n3 == 1) {
                this.storeConnectionPoint(visualElement, sortedSet3.first(), d2, d);
            } else {
                for (Connection connection : sortedSet3) {
                    this.storeConnectionPoint(visualElement, connection, d2, d);
                    d2 += d3;
                }
            }
        }
        if (n4 > 0) {
            d3 = visualElement.getHeight() / (double)(n4 + 1);
            d2 = visualElement.getX();
            d = visualElement.getY() + d3;
            if (n4 == 1) {
                this.storeConnectionPoint(visualElement, sortedSet4.first(), d2, d);
            } else {
                for (Connection connection : sortedSet4) {
                    this.storeConnectionPoint(visualElement, connection, d2, d);
                    d += d3;
                }
            }
        }
    }

    private void storeConnectionPoint(VisualElement visualElement, Connection connection, double d, double d2) {
        FPoint fPoint = new FPoint(d, d2);
        if (connection.getSource() == visualElement) {
            this.startPoints.put(connection, fPoint);
        } else {
            this.endPoints.put(connection, fPoint);
        }
    }

    private SortedSet<Connection> createConnectionSortedSet(VisualElement visualElement, Direction direction) {
        return new TreeSet<Connection>(new ConnectionComparator(visualElement, direction));
    }

    public void reconnectAll(Pattern pattern) {
        this.reconnectDownFrom(pattern);
    }

    public void reconnectUpFrom(CompositePattern compositePattern) {
        for (CompositePattern compositePattern2 = compositePattern; compositePattern2 != null; compositePattern2 = compositePattern2.getParent()) {
            compositePattern2.reconnectElements();
        }
    }

    public void reconnectDownFrom(Pattern pattern) {
        pattern.reconnectElements();
        if (pattern instanceof CompositePattern) {
            for (Pattern pattern2 : ((CompositePattern)pattern).getNestedPatterns()) {
                this.reconnectDownFrom(pattern2);
            }
        }
    }

    public static void connectVerticaly(VisualElement visualElement, Connection connection, Pattern pattern, Connection connection2, VisualElement visualElement2) {
        ConnectionManager.connectVerticaly(visualElement, connection, pattern.getFirstElement(), pattern.getLastElement(), connection2, visualElement2);
    }

    public static void connectVerticaly(VisualElement visualElement, Connection connection, VisualElement visualElement2, Connection connection2, VisualElement visualElement3) {
        ConnectionManager.connectVerticaly(visualElement, connection, visualElement2, visualElement2, connection2, visualElement3);
    }

    public static void connectVerticaly(VisualElement visualElement, Connection connection, VisualElement visualElement2, VisualElement visualElement3, Connection connection2, VisualElement visualElement4) {
        double d = visualElement.getX();
        double d2 = d + visualElement.getWidth();
        double d3 = visualElement4.getX();
        double d4 = d3 + visualElement4.getWidth();
        Direction direction = visualElement2.getX() >= d2 ? Direction.RIGHT : (visualElement2.getX() + visualElement2.getWidth() <= d ? Direction.LEFT : Direction.BOTTOM);
        Direction direction2 = visualElement3.getX() >= d4 ? Direction.RIGHT : (visualElement3.getX() + visualElement3.getWidth() <= d3 ? Direction.LEFT : Direction.TOP);
        connection.connect(visualElement, direction, visualElement2, Direction.TOP);
        connection2.connect(visualElement3, Direction.BOTTOM, visualElement4, direction2);
    }
}

