/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.decoration.providers;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.decoration.ComponentsDescriptor;
import org.netbeans.modules.bpel.design.decoration.Decoration;
import org.netbeans.modules.bpel.design.decoration.DecorationProvider;
import org.netbeans.modules.bpel.design.decoration.Descriptor;
import org.netbeans.modules.bpel.design.decoration.StripeDescriptor;
import org.netbeans.modules.bpel.design.decoration.TextstyleDescriptor;
import org.netbeans.modules.bpel.design.decoration.components.ShowGlassPaneButton;
import org.netbeans.modules.bpel.design.model.DiagramModel;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.editors.api.EditorUtil;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.soa.validation.core.Controller;
import org.netbeans.modules.soa.validation.core.Listener;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationDecorationProvider
extends DecorationProvider
implements Listener {
    private Object list_key = new Object();
    private Object decoration_key = new Object();
    private List<Validator.ResultItem> results = new ArrayList<Validator.ResultItem>();
    Descriptor TEXT_STYLE = new TextstyleDescriptor(new Color(0xFF0000));

    public ValidationDecorationProvider(DesignView designView) {
        super(designView);
        final Controller controller = this.getDesignView().getValidationController();
        controller.addListener((Listener)this);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                controller.triggerValidation();
            }
        });
    }

    @Override
    public void release() {
        this.getDesignView().getValidationController().removeListener((Listener)this);
        this.list_key = null;
        this.decoration_key = null;
    }

    @Override
    public Decoration getDecoration(BpelEntity bpelEntity) {
        return (Decoration)bpelEntity.getCookie(this.decoration_key);
    }

    public void updateDecorations() {
        final List list = EditorUtil.filterBpelResultItems(this.results);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (ValidationDecorationProvider.this.getDesignView().getBPELModel().getState() != Model.State.VALID) {
                    return;
                }
                final Object object = new Object();
                for (Validator.ResultItem resultItem : list) {
                    org.netbeans.modules.xml.xam.Component component = resultItem.getComponents();
                    BpelEntity bpelEntity = ValidationDecorationProvider.this.getDiagramEntity((BpelEntity)component);
                    if (bpelEntity == null) continue;
                    ArrayList<Validator.ResultItem> arrayList = (ArrayList<Validator.ResultItem>)bpelEntity.getCookie(object);
                    if (arrayList == null) {
                        arrayList = new ArrayList<Validator.ResultItem>();
                        bpelEntity.setCookie(object, arrayList);
                    }
                    arrayList.add(resultItem);
                }
                new ModelIterator(){

                    public void visit(BpelEntity bpelEntity) {
                        ArrayList arrayList = (ArrayList)bpelEntity.getCookie(object);
                        ArrayList arrayList2 = (ArrayList)bpelEntity.getCookie(ValidationDecorationProvider.this.list_key);
                        if (arrayList == null) {
                            bpelEntity.removeCookie(ValidationDecorationProvider.this.decoration_key);
                            bpelEntity.removeCookie(ValidationDecorationProvider.this.list_key);
                        } else if (!ValidationDecorationProvider.this.compareLists(arrayList2, arrayList)) {
                            Descriptor[] descriptorArray;
                            ShowGlassPaneButton showGlassPaneButton = ValidationDecorationProvider.this.getShowGlassPaneButton(bpelEntity);
                            if (showGlassPaneButton == null) {
                                showGlassPaneButton = new ShowGlassPaneButton(arrayList);
                            } else {
                                showGlassPaneButton.setResultItems(arrayList);
                            }
                            ComponentsDescriptor componentsDescriptor = new ComponentsDescriptor();
                            componentsDescriptor.add(showGlassPaneButton, ComponentsDescriptor.RIGHT_TB);
                            StripeDescriptor stripeDescriptor = StripeDescriptor.createValidation(arrayList);
                            if (stripeDescriptor != null) {
                                Descriptor[] descriptorArray2 = new Descriptor[3];
                                descriptorArray2[0] = componentsDescriptor;
                                descriptorArray2[1] = ValidationDecorationProvider.this.TEXT_STYLE;
                                descriptorArray = descriptorArray2;
                                descriptorArray2[2] = stripeDescriptor;
                            } else {
                                Descriptor[] descriptorArray3 = new Descriptor[2];
                                descriptorArray3[0] = componentsDescriptor;
                                descriptorArray = descriptorArray3;
                                descriptorArray3[1] = ValidationDecorationProvider.this.TEXT_STYLE;
                            }
                            Decoration decoration = new Decoration(descriptorArray);
                            bpelEntity.setCookie(ValidationDecorationProvider.this.decoration_key, (Object)decoration);
                            bpelEntity.setCookie(ValidationDecorationProvider.this.list_key, (Object)arrayList);
                        }
                    }
                }.run((BpelEntity)ValidationDecorationProvider.this.getDesignView().getProcessModel());
                ValidationDecorationProvider.this.fireDecorationChanged();
            }
        });
    }

    private ShowGlassPaneButton getShowGlassPaneButton(BpelEntity bpelEntity) {
        Decoration decoration = (Decoration)bpelEntity.getCookie(this.decoration_key);
        if (decoration == null) {
            return null;
        }
        ComponentsDescriptor componentsDescriptor = decoration.getComponents();
        if (componentsDescriptor == null) {
            return null;
        }
        for (int i = componentsDescriptor.getComponentCount() - 1; i >= 0; --i) {
            Component component = componentsDescriptor.getComponent(i);
            if (!(component instanceof ShowGlassPaneButton)) continue;
            return (ShowGlassPaneButton)component;
        }
        return null;
    }

    public void validationUpdated(List<Validator.ResultItem> list) {
        this.results = list;
        this.updateDecorations();
    }

    private boolean compareLists(ArrayList<Validator.ResultItem> arrayList, ArrayList<Validator.ResultItem> arrayList2) {
        if (arrayList == null || arrayList2 == null) {
            return false;
        }
        if (arrayList.size() != arrayList2.size()) {
            return false;
        }
        for (Validator.ResultItem resultItem : arrayList) {
            boolean bl = false;
            for (Validator.ResultItem resultItem2 : arrayList2) {
                if (!EditorUtil.equals((Validator.ResultItem)resultItem, (Validator.ResultItem)resultItem2)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private BpelEntity getDiagramEntity(BpelEntity bpelEntity) {
        if (bpelEntity == null || bpelEntity.getModel() == null) {
            return null;
        }
        DesignView designView = this.getDesignView();
        DiagramModel diagramModel = null;
        while (bpelEntity != null && (diagramModel = designView.getModel()) != null) {
            Pattern pattern = diagramModel.getPattern(bpelEntity);
            if (pattern != null && pattern.isSelectable() && pattern.isInModel()) {
                return bpelEntity;
            }
            bpelEntity = bpelEntity.getParent();
        }
        return null;
    }

    private abstract class ModelIterator {
        private ModelIterator() {
        }

        public abstract void visit(BpelEntity var1);

        public void run(BpelEntity bpelEntity) {
            this.visit(bpelEntity);
            for (BpelEntity bpelEntity2 : bpelEntity.getChildren()) {
                this.run(bpelEntity2);
            }
        }
    }
}

