/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.decoration.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ButtonRenderer {
    public static final float ARC_SIZE = 8.0f;
    public static final Color NORMAL_BORDER_COLOR = new Color(0x999999);
    public static final Color NORMAL_FILL_COLOR = null;
    public static final float NORMAL_STROKE_WIDTH = 1.0f;
    public static final Color DISABLED_BORDER_COLOR = new Color(0xCCCCCC);
    public static final Color DISABLED_FILL_COLOR = null;
    public static final float DISABLED_STROKE_WIDTH = 1.0f;
    public static final Color PRESSED_BORDER_COLOR = new Color(0x999999);
    public static final Color PRESSED_FILL_COLOR = new Color(0xDDDDDD);
    public static final float PRESSED_STROKE_WIDTH = 1.3f;
    public static final Color ROLLOVER_BORDER_COLOR = new Color(0x999999);
    public static final Color ROLLOVER_FILL_COLOR = new Color(0xF4F4F4);
    public static final float ROLLOVER_STROKE_WIDTH = 1.0f;

    public static void paintButton(Component component, Graphics graphics, Color color, boolean bl, Color color2, float f, Icon icon) {
        int n;
        int n2;
        if (color == null && color2 == null && icon == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        float f2 = Math.max(0.0f, 8.0f - f);
        float f3 = f / 2.0f;
        int n3 = component.getWidth();
        int n4 = component.getHeight();
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(f3, f3, (float)n3 - f, (float)n4 - f, f2, f2);
        if (color != null) {
            if (bl && color2 != null) {
                graphics2D.setPaint(color);
                graphics2D.fill(float_);
                graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
                n2 = color2.getRed();
                n = color2.getGreen();
                int n5 = color2.getBlue();
                graphics2D.setPaint(new Color(n2, n, n5, 95));
                graphics2D.drawLine(1, n4 - 2, n3 - 2, n4 - 2);
                graphics2D.setPaint(new Color(n2, n, n5, 63));
                graphics2D.drawLine(2, n4 - 3, n3 - 3, n4 - 3);
                graphics2D.setPaint(new Color(n2, n, n5, 31));
                graphics2D.drawLine(3, n4 - 4, n3 - 4, n4 - 4);
                graphics2D.setPaint(new Color(n2, n, n5, 63));
                graphics2D.drawLine(n3 - 2, 1, n3 - 2, n4 - 2);
                graphics2D.setPaint(new Color(n2, n, n5, 31));
                graphics2D.drawLine(n3 - 3, 2, n3 - 3, n4 - 3);
                graphics2D.setPaint(new Color(n2, n, n5, 15));
                graphics2D.drawLine(n3 - 4, 3, n3 - 4, n4 - 4);
                graphics2D.setPaint(new Color(255, 255, 255, 191));
                graphics2D.drawLine(1, 1, n3 - 2, 1);
                graphics2D.drawLine(1, 1, 1, n4 - 2);
                graphics2D.setPaint(new Color(255, 255, 255, 127));
                graphics2D.drawLine(2, 2, n3 - 3, 2);
                graphics2D.drawLine(2, 2, 2, n4 - 3);
                graphics2D.setPaint(new Color(255, 255, 255, 63));
                graphics2D.drawLine(3, 3, n3 - 4, 3);
                graphics2D.drawLine(3, 3, 3, n4 - 4);
                graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            } else {
                graphics2D.setPaint(color);
                graphics2D.fill(float_);
            }
        }
        if (color2 != null) {
            graphics2D.setStroke(new BasicStroke(f));
            graphics2D.setPaint(color2);
            graphics2D.draw(float_);
        }
        if (icon != null) {
            n2 = (n3 - icon.getIconWidth()) / 2;
            n = (n4 - icon.getIconHeight()) / 2;
            icon.paintIcon(component, graphics, n2, n);
        }
        graphics2D.dispose();
    }

    public static Icon createDisabledIcon(Component component, Icon icon) {
        Image image;
        if (icon instanceof ImageIcon) {
            image = ((ImageIcon)icon).getImage();
        } else {
            image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            icon.paintIcon(component, image.getGraphics(), 0, 0);
        }
        return new ImageIcon(GrayFilter.createDisabledImage(image));
    }
}

