/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.decoration;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.decoration.ComponentDecorationsUpdater;
import org.netbeans.modules.bpel.design.decoration.Decoration;
import org.netbeans.modules.bpel.design.decoration.DecorationProvider;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.xml.xam.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecorationManager {
    private Object cacheKey = new Object();
    public static final Decoration emptyDecoration = new Decoration();
    private ArrayList<DecorationProvider> providersList = new ArrayList();
    private DesignView designView;
    private DecorationUpdater decorationUpdater = new DecorationUpdater();

    public DecorationManager(DesignView designView) {
        this.designView = designView;
    }

    public Decoration getDecoration(Pattern pattern) {
        BpelEntity bpelEntity = pattern.getOMReference();
        Decoration decoration = null;
        if (bpelEntity != null) {
            decoration = (Decoration)bpelEntity.getCookie(this.cacheKey);
        }
        return decoration != null ? decoration : emptyDecoration;
    }

    public List<DecorationProvider> getProviders() {
        return this.providersList;
    }

    public void attachProvider(DecorationProvider decorationProvider) {
        this.providersList.add(decorationProvider);
    }

    public void release() {
        for (DecorationProvider decorationProvider : this.providersList) {
            decorationProvider.release();
        }
        this.cacheKey = null;
    }

    public void decorationChanged() {
        this.decorationUpdater.start();
    }

    private void updateResult(BpelEntity bpelEntity) {
        Decoration decoration = new Decoration();
        for (DecorationProvider decorationProvider : this.providersList) {
            Decoration decoration2 = decorationProvider.getDecoration(bpelEntity);
            if (decoration2 == null || decoration2 == emptyDecoration) continue;
            decoration.combineWith(decoration2);
        }
        bpelEntity.setCookie(this.cacheKey, (Object)decoration);
        for (DecorationProvider decorationProvider : bpelEntity.getChildren()) {
            this.updateResult((BpelEntity)decorationProvider);
        }
    }

    private class DecorationUpdater
    implements Runnable {
        private boolean activated = false;

        private DecorationUpdater() {
        }

        public void start() {
            this.activated = true;
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            if (!this.activated) {
                return;
            }
            if (DecorationManager.this.designView.getModel() == null) {
                return;
            }
            if (DecorationManager.this.designView.getBPELModel().getState() != Model.State.VALID) {
                return;
            }
            DecorationManager.this.updateResult((BpelEntity)DecorationManager.this.designView.getBPELModel().getProcess());
            new ComponentDecorationsUpdater(DecorationManager.this.designView).update();
            DecorationManager.this.designView.revalidate();
            DecorationManager.this.designView.repaint();
            DecorationManager.this.designView.getRightStripe().repaint();
            this.activated = false;
        }
    }
}

