/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.model.ViewFilters;
import org.openide.util.NbBundle;

public class PartnerLinkFilterButton
extends JToggleButton
implements ActionListener {
    private DesignView designView;
    private static final Icon ICON = new ImageIcon(DesignView.class.getResource("resources/partner_link_filter.png"));

    public PartnerLinkFilterButton(DesignView designView) {
        super(ICON);
        this.designView = designView;
        this.setSelected(this.getViewFilters().showPartnerlinks());
        this.setToolTipText(NbBundle.getMessage(DesignView.class, (String)"LBL_PartnerLinksFilterButton"));
        this.setFocusable(false);
        this.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.getViewFilters().setShowPartnerlinks(this.isSelected());
        this.updateView();
    }

    private void updateView() {
        boolean bl = this.isSelected();
        this.designView.getConsumersView().setVisible(bl);
        this.designView.getProvidersView().setVisible(bl);
        this.designView.reloadModel();
        this.designView.diagramChanged();
        this.designView.getValidationDecorationProvider().updateDecorations();
    }

    private ViewFilters getViewFilters() {
        return this.designView.getModel().getFilters();
    }
}

