/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.Autoscroll;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.netbeans.modules.bpel.design.BWGraphics2D;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.DiagramFontUtil;
import org.netbeans.modules.bpel.design.DiagramViewLayout;
import org.netbeans.modules.bpel.design.GUtils;
import org.netbeans.modules.bpel.design.MouseHandler;
import org.netbeans.modules.bpel.design.NameEditor;
import org.netbeans.modules.bpel.design.decoration.Decoration;
import org.netbeans.modules.bpel.design.geometry.FBounds;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.model.connections.Connection;
import org.netbeans.modules.bpel.design.model.elements.BorderElement;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.patterns.CompositePattern;
import org.netbeans.modules.bpel.design.model.patterns.PartnerlinkPattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.design.selection.PlaceHolder;
import org.netbeans.modules.bpel.design.selection.PlaceHolderManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DiagramView
extends JPanel
implements Autoscroll {
    private DesignView designView;
    private PlaceHolderManager placeholderManager;
    private NameEditor nameEditor;
    private MouseHandler mouseHandler;
    private int offsetX;
    private int offsetY;
    private static final Color BACKGROUND_COLOR = new Color(16579317);
    private static int AUTOSCROLL_INSETS = 20;

    public DiagramView(DesignView designView) {
        super(new DiagramViewLayout());
        this.designView = designView;
        this.setBackground(BACKGROUND_COLOR);
        this.placeholderManager = new PlaceHolderManager(this);
        this.nameEditor = new NameEditor(this);
        this.mouseHandler = new MouseHandler(this);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public abstract FBounds getContentSize();

    public abstract Iterator<Pattern> getPatterns();

    public abstract void getPlaceholders(Pattern var1, List<PlaceHolder> var2);

    public DesignView getDesignView() {
        return this.designView;
    }

    public PlaceHolderManager getPlaceholderManager() {
        return this.placeholderManager;
    }

    public NameEditor getNameEditor() {
        return this.nameEditor;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.paintContent(graphics, this.getDesignView().getCorrectedZoom(), false);
    }

    @Override
    public void print(Graphics graphics) {
        this.designView.setPrintMode(true);
        super.print(graphics);
        this.designView.setPrintMode(false);
    }

    public void setOffsets(int n, int n2) {
        this.offsetX = n;
        this.offsetY = n2;
    }

    @Override
    protected void printComponent(Graphics graphics) {
        this.paintContent(graphics, this.getDesignView().getCorrectedZoom(), true);
    }

    @Override
    protected void printChildren(Graphics graphics) {
    }

    private void paintContent(Graphics graphics, double d, boolean bl) {
        Cloneable cloneable;
        Pattern pattern = this.getDesignView().getModel().getRootPattern();
        Graphics2D graphics2D = GUtils.createGraphics(graphics);
        BWGraphics2D bWGraphics2D = new BWGraphics2D(graphics2D);
        if (!bl) {
            cloneable = this.convertDiagramToScreen(new FPoint(0.0, 0.0));
            graphics2D.translate(cloneable.x, cloneable.y);
        }
        graphics2D.scale(d, d);
        if (pattern != null) {
            cloneable = graphics2D.getClipBounds();
            double d2 = 12.0 * d;
            double d3 = 18.0 * d;
            FBounds fBounds = new FBounds((double)((Rectangle)cloneable).x - d2, (double)((Rectangle)cloneable).y - d3, (double)((Rectangle)cloneable).width + 2.0 * d2, (double)((Rectangle)cloneable).height + 2.0 * d3);
            graphics2D.setFont(DiagramFontUtil.getFont());
            this.paintPattern(graphics2D, bWGraphics2D, pattern, fBounds, bl);
            this.paintPatternConnections(graphics2D, bWGraphics2D, pattern, bl);
            if (!bl) {
                this.placeholderManager.paint(graphics2D);
            }
        }
    }

    public FPoint convertScreenToDiagram(Point point) {
        return this.convertScreenToDiagram(point, this.designView.getCorrectedZoom());
    }

    public Point convertDiagramToScreen(FPoint fPoint) {
        return this.convertDiagramToScreen(fPoint, this.designView.getCorrectedZoom());
    }

    public void scrollPlaceholderToView(PlaceHolder placeHolder) {
        if (placeHolder == null) {
            return;
        }
        Rectangle rectangle = placeHolder.getShape().getBounds();
        this.scrollRectToVisible(rectangle);
    }

    public void scrollPatternToView(Pattern pattern) {
        if (pattern == null) {
            return;
        }
        FBounds fBounds = pattern.getBounds();
        Point point = this.convertDiagramToScreen(fBounds.getTopLeft());
        Point point2 = this.convertDiagramToScreen(fBounds.getBottomRight());
        int n = Math.max(0, point.x - 8);
        int n2 = Math.max(0, point.y - 32);
        int n3 = Math.min(this.getWidth(), point2.x + 8);
        int n4 = Math.min(this.getHeight(), point2.y + 8);
        int n5 = Math.max(1, n3 - n);
        int n6 = Math.max(1, n4 - n2);
        this.scrollRectToVisible(new Rectangle(n, n2, n5, n6));
    }

    protected void paintPattern(Graphics2D graphics2D, Graphics2D graphics2D2, Pattern pattern, FBounds fBounds, boolean bl) {
        if (!pattern.getBounds().isIntersects(fBounds)) {
            return;
        }
        Decoration decoration = this.getDesignView().getDecoration(pattern);
        if (pattern instanceof CompositePattern) {
            Graphics2D graphics2D3;
            CompositePattern compositePattern = (CompositePattern)pattern;
            BorderElement borderElement = compositePattern.getBorder();
            Graphics2D graphics2D4 = graphics2D3 = decoration.hasDimmed() && !bl ? graphics2D2 : graphics2D;
            if (decoration.hasGlow() && !bl) {
                decoration.getGlow().paint(graphics2D, compositePattern.createOutline());
            }
            if (borderElement != null) {
                borderElement.paint(graphics2D3);
            }
            for (VisualElement object : compositePattern.getElements()) {
                object.paint(graphics2D3);
            }
            for (Pattern pattern2 : compositePattern.getNestedPatterns()) {
                this.paintPattern(graphics2D, graphics2D2, pattern2, fBounds, bl);
            }
            if (decoration.hasStroke() && !bl) {
                decoration.getStroke().paint(graphics2D, compositePattern.createSelection());
            }
        } else {
            Graphics2D graphics2D5;
            Graphics2D graphics2D6 = graphics2D5 = decoration.hasDimmed() && !bl ? graphics2D2 : graphics2D;
            if (decoration.hasGlow() && !bl) {
                decoration.getGlow().paint(graphics2D, pattern.createOutline());
            }
            for (VisualElement visualElement : pattern.getElements()) {
                visualElement.paint(graphics2D5);
            }
            if (decoration.hasStroke() && !bl) {
                decoration.getStroke().paint(graphics2D, pattern.createSelection());
            }
        }
    }

    protected void paintPatternConnections(Graphics2D graphics2D, Graphics2D graphics2D2, Pattern pattern, boolean bl) {
        Object object;
        if (pattern == null) {
            return;
        }
        if (pattern instanceof CompositePattern) {
            object = (CompositePattern)pattern;
            for (Pattern object2 : ((CompositePattern)object).getNestedPatterns()) {
                this.paintPatternConnections(graphics2D, graphics2D2, object2, bl);
            }
        }
        object = this.getDesignView().getDecoration(pattern).hasDimmed() && !bl ? graphics2D2 : graphics2D;
        for (Connection connection : pattern.getConnections()) {
            connection.paint((Graphics2D)object);
        }
    }

    public Point convertPointToParent(FPoint fPoint) {
        Point point = this.convertDiagramToScreen(fPoint);
        if (this.designView.getPrintMode()) {
            return point;
        }
        for (Container container = this; container != this.getDesignView(); container = container.getParent()) {
            point.x += ((Component)container).getX();
            point.y += ((Component)container).getY();
        }
        return point;
    }

    public FPoint convertPointFromParent(Point point) {
        Point point2 = new Point(point);
        if (this.designView.getPrintMode()) {
            return this.convertScreenToDiagram(point2);
        }
        for (Container container = this; container != this.getDesignView(); container = container.getParent()) {
            point2.x -= ((Component)container).getX();
            point2.y -= ((Component)container).getY();
        }
        return this.convertScreenToDiagram(point2);
    }

    @Override
    public Insets getAutoscrollInsets() {
        Rectangle rectangle = this.getVisibleRect();
        int n = this.getWidth();
        int n2 = this.getHeight();
        Insets insets = new Insets(rectangle.y + AUTOSCROLL_INSETS, rectangle.x + AUTOSCROLL_INSETS, Math.max(0, n2 - rectangle.y - rectangle.height + AUTOSCROLL_INSETS), Math.max(0, n - rectangle.x - rectangle.width + AUTOSCROLL_INSETS));
        return insets;
    }

    @Override
    public void autoscroll(Point point) {
        Rectangle rectangle = this.getVisibleRect();
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = point.x;
        int n4 = point.y;
        Insets insets = this.getAutoscrollInsets();
        int n5 = 0;
        int n6 = 0;
        if (n3 < insets.left) {
            n5 -= (insets.left - n3) * 5;
        }
        if (n3 > n - insets.right) {
            n5 += (n3 - n + insets.right) * 5;
        }
        if (n4 < insets.top) {
            n6 -= (insets.top - n4) * 5;
        }
        if (n4 > n2 - insets.bottom) {
            n6 += (n4 - n2 + insets.bottom) * 5;
        }
        if (n5 != 0 || n6 != 0) {
            rectangle.x += n5;
            rectangle.y += n6;
            this.scrollRectToVisible(rectangle);
        }
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        Pattern pattern;
        Point point = this.getMousePosition();
        if (point == null) {
            point = mouseEvent.getPoint();
        }
        String string = null;
        VisualElement visualElement = this.findElement(point);
        Pattern pattern2 = pattern = visualElement == null ? null : visualElement.getPattern();
        if (pattern != null) {
            if (pattern instanceof PartnerlinkPattern && !(visualElement instanceof BorderElement)) {
                string = visualElement.getText();
                string = (string != null ? string.trim() : "") + " " + NbBundle.getMessage(DesignView.class, (String)"LBL_Operation");
            } else {
                Node node = this.getDesignView().getNodeForPattern(pattern);
                if (node != null) {
                    string = node.getDisplayName();
                }
                if (string == null) {
                    string = pattern.getText();
                }
            }
        }
        if (string != null && string.trim().length() == 0) {
            string = null;
        }
        if (string == null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ToolTipManager.sharedInstance().setEnabled(false);
                    ToolTipManager.sharedInstance().setEnabled(true);
                }
            });
        }
        return string;
    }

    public FPoint convertScreenToDiagram(Point point, double d) {
        double d2 = (double)(point.x - this.offsetX) / d + 1.0;
        double d3 = (double)(point.y - this.offsetY) / d + 1.0;
        if (this.designView.getPrintMode()) {
            d2 = (double)(point.x - this.getWidth() / 2) / d + 1.0;
            d3 = (double)point.y / d + 1.0;
        }
        return new FPoint(d2, d3);
    }

    public Point convertDiagramToScreen(FPoint fPoint, double d) {
        double d2 = (double)(fPoint.x - 1.0f) * d + (double)this.offsetX;
        double d3 = (double)(fPoint.y - 1.0f) * d + (double)this.offsetY;
        if (this.designView.getPrintMode()) {
            d2 = (double)(fPoint.x - 1.0f) * d + (double)(this.getWidth() / 2);
            d3 = (double)(fPoint.y - 1.0f) * d;
        }
        return new Point((int)Math.round(d2), (int)Math.round(d3));
    }

    public Pattern findPattern(Point point) {
        FPoint fPoint = this.convertScreenToDiagram(point);
        return this.findPattern(fPoint.x, fPoint.y);
    }

    public Pattern findPattern(double d, double d2) {
        VisualElement visualElement = this.findElement(d, d2);
        return visualElement != null ? visualElement.getPattern() : null;
    }

    public VisualElement findElement(Point point) {
        FPoint fPoint = this.convertScreenToDiagram(point);
        return this.findElement(fPoint.x, fPoint.y);
    }

    public VisualElement findElement(double d, double d2) {
        Iterator<Pattern> iterator = this.getPatterns();
        while (iterator.hasNext()) {
            Pattern pattern = iterator.next();
            VisualElement visualElement = this.findElementInPattern(pattern, d, d2);
            if (visualElement == null) continue;
            return visualElement;
        }
        return null;
    }

    protected VisualElement findElementInPattern(Pattern pattern, double d, double d2) {
        Object object = pattern.getElements().iterator();
        while (object.hasNext()) {
            VisualElement visualElement = object.next();
            if (!visualElement.contains(d, d2)) continue;
            return visualElement;
        }
        if (pattern instanceof CompositePattern && (object = ((CompositePattern)pattern).getBorder()) != null && ((VisualElement)object).getShape().contains(d, d2)) {
            return object;
        }
        return null;
    }
}

