/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.javascript.ui;

import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.event.ChangeListener;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.javascript.JsElementCtx;
import org.netbeans.modules.refactoring.javascript.RetoucheUtils;
import org.netbeans.modules.refactoring.javascript.ui.RenamePanel;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUIBypass;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.netbeans.napi.gsfret.source.ClasspathInfo;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class RenameRefactoringUI
implements RefactoringUI,
RefactoringUIBypass {
    private final AbstractRefactoring refactoring;
    private String oldName = null;
    private String dispOldName;
    private String newName;
    private RenamePanel panel;
    private boolean fromListener = false;
    private JsElementCtx jmiObject;
    private FileObject byPassFolder;
    private boolean byPassPakageRename;
    private boolean pkgRename = true;
    private String stripPrefix;

    public RenameRefactoringUI(JsElementCtx jsElementCtx, CompilationInfo compilationInfo) {
        this.jmiObject = jsElementCtx;
        this.stripPrefix = jsElementCtx.getStripPrefix();
        this.refactoring = new RenameRefactoring(Lookups.singleton((Object)jsElementCtx));
        this.oldName = jsElementCtx.getSimpleName();
        ClasspathInfo classpathInfo = RetoucheUtils.getClasspathInfoFor(jsElementCtx);
        if (classpathInfo != null) {
            this.refactoring.getContext().add((Object)classpathInfo);
        }
        this.dispOldName = this.oldName;
        this.refactoring.getContext().add((Object)UI.Constants.REQUEST_PREVIEW);
    }

    public RenameRefactoringUI(FileObject fileObject, JsElementCtx jsElementCtx, CompilationInfo compilationInfo) {
        ClasspathInfo classpathInfo;
        if (jsElementCtx != null) {
            this.jmiObject = jsElementCtx;
            this.refactoring = new RenameRefactoring(Lookups.fixed((Object[])new Object[]{fileObject, jsElementCtx}));
            this.oldName = this.jmiObject.getSimpleName();
        } else {
            this.refactoring = new RenameRefactoring(Lookups.fixed((Object[])new Object[]{fileObject}));
            this.oldName = fileObject.getName();
        }
        this.dispOldName = this.oldName;
        ClasspathInfo classpathInfo2 = classpathInfo = jsElementCtx == null ? RetoucheUtils.getClasspathInfoFor(fileObject) : RetoucheUtils.getClasspathInfoFor(jsElementCtx);
        if (classpathInfo != null) {
            this.refactoring.getContext().add((Object)classpathInfo);
        }
        this.refactoring.getContext().add((Object)UI.Constants.REQUEST_PREVIEW);
    }

    public RenameRefactoringUI(NonRecursiveFolder nonRecursiveFolder) {
        this.refactoring = new RenameRefactoring(Lookups.singleton((Object)nonRecursiveFolder));
        this.oldName = RetoucheUtils.getPackageName(nonRecursiveFolder.getFolder());
        ClasspathInfo classpathInfo = RetoucheUtils.getClasspathInfoFor(nonRecursiveFolder.getFolder());
        if (classpathInfo != null) {
            this.refactoring.getContext().add((Object)classpathInfo);
        }
        this.dispOldName = this.oldName;
        this.pkgRename = true;
        this.refactoring.getContext().add((Object)UI.Constants.REQUEST_PREVIEW);
    }

    RenameRefactoringUI(FileObject fileObject, String string, JsElementCtx jsElementCtx, CompilationInfo compilationInfo) {
        ClasspathInfo classpathInfo;
        this.refactoring = jsElementCtx != null ? new RenameRefactoring(Lookups.fixed((Object[])new Object[]{fileObject, jsElementCtx})) : new RenameRefactoring(Lookups.fixed((Object[])new Object[]{fileObject}));
        this.oldName = string;
        this.dispOldName = string;
        ClasspathInfo classpathInfo2 = classpathInfo = jsElementCtx == null ? RetoucheUtils.getClasspathInfoFor(fileObject) : RetoucheUtils.getClasspathInfoFor(jsElementCtx);
        if (classpathInfo != null) {
            this.refactoring.getContext().add((Object)classpathInfo);
        }
        this.fromListener = true;
        this.refactoring.getContext().add((Object)true);
    }

    RenameRefactoringUI(NonRecursiveFolder nonRecursiveFolder, String string) {
        this.refactoring = new RenameRefactoring(Lookups.singleton((Object)nonRecursiveFolder));
        ClasspathInfo classpathInfo = RetoucheUtils.getClasspathInfoFor(nonRecursiveFolder.getFolder());
        if (classpathInfo != null) {
            this.refactoring.getContext().add((Object)classpathInfo);
        }
        this.oldName = string;
        this.dispOldName = string;
        this.fromListener = true;
        this.pkgRename = true;
        this.refactoring.getContext().add((Object)UI.Constants.REQUEST_PREVIEW);
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener changeListener) {
        if (this.panel == null) {
            String string = this.oldName;
            if (this.stripPrefix != null && string.startsWith(this.stripPrefix)) {
                string = string.substring(this.stripPrefix.length());
            }
            String string2 = "";
            if (this.jmiObject != null) {
                ElementKind elementKind = RetoucheUtils.getElementKind(this.jmiObject);
                if (elementKind == ElementKind.CLASS) {
                    string2 = RenameRefactoringUI.getString("LBL_Class");
                } else if (elementKind == ElementKind.METHOD) {
                    string2 = RenameRefactoringUI.getString("LBL_Method");
                } else if (elementKind == ElementKind.FIELD) {
                    string2 = RenameRefactoringUI.getString("LBL_Field");
                } else if (elementKind == ElementKind.VARIABLE) {
                    string2 = RenameRefactoringUI.getString("LBL_LocalVar");
                } else if (elementKind == ElementKind.MODULE || this.jmiObject == null && this.fromListener) {
                    string2 = this.pkgRename ? RenameRefactoringUI.getString("LBL_Package") : RenameRefactoringUI.getString("LBL_Folder");
                } else if (elementKind == ElementKind.PARAMETER) {
                    string2 = RenameRefactoringUI.getString("LBL_Parameter");
                }
            }
            string2 = string2 + " " + string;
            this.panel = new RenamePanel(string, changeListener, NbBundle.getMessage(RenamePanel.class, (String)"LBL_Rename") + " " + string2, !this.fromListener, this.fromListener && !this.byPassPakageRename);
        }
        return this.panel;
    }

    private static String getString(String string) {
        return NbBundle.getMessage(RenameRefactoringUI.class, (String)string);
    }

    private String getPanelName() {
        String string = this.panel.getNameValue();
        if (this.stripPrefix != null && !string.startsWith(this.stripPrefix)) {
            string = this.stripPrefix + string;
        }
        return string;
    }

    public Problem setParameters() {
        this.newName = this.getPanelName();
        if (this.refactoring instanceof RenameRefactoring) {
            ((RenameRefactoring)this.refactoring).setNewName(this.newName);
            ((RenameRefactoring)this.refactoring).setSearchInComments(this.panel.searchJavadoc());
        }
        return this.refactoring.checkParameters();
    }

    public Problem checkParameters() {
        if (!this.panel.isUpdateReferences()) {
            return null;
        }
        this.newName = this.getPanelName();
        if (this.refactoring instanceof RenameRefactoring) {
            ((RenameRefactoring)this.refactoring).setNewName(this.newName);
        }
        return this.refactoring.fastCheckParameters();
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public String getDescription() {
        return new MessageFormat(NbBundle.getMessage(RenamePanel.class, (String)"DSC_Rename")).format(new Object[]{this.dispOldName, this.newName});
    }

    public String getName() {
        return NbBundle.getMessage(RenamePanel.class, (String)"LBL_Rename");
    }

    public boolean hasParameters() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public boolean isRefactoringBypassRequired() {
        return !this.panel.isUpdateReferences();
    }

    public void doRefactoringBypass() throws IOException {
        Object object = null;
        object = this.byPassFolder != null ? DataFolder.findFolder((FileObject)this.byPassFolder) : DataObject.find((FileObject)((FileObject)this.refactoring.getRefactoringSource().lookup(FileObject.class)));
        object.rename(this.getPanelName());
    }
}

