/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.javascript.plugins;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.mozilla.nb.javascript.Node;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.Severity;
import org.netbeans.modules.javascript.editing.AstElement;
import org.netbeans.modules.javascript.editing.AstPath;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.Element;
import org.netbeans.modules.javascript.editing.JsAnalyzer;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.JsUtils;
import org.netbeans.modules.javascript.editing.ParseTreeVisitor;
import org.netbeans.modules.javascript.editing.ParseTreeWalker;
import org.netbeans.modules.javascript.editing.VariableVisitor;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.javascript.DiffElement;
import org.netbeans.modules.refactoring.javascript.JsElementCtx;
import org.netbeans.modules.refactoring.javascript.RetoucheUtils;
import org.netbeans.modules.refactoring.javascript.plugins.JsRefactoringPlugin;
import org.netbeans.modules.refactoring.javascript.plugins.RetoucheCommit;
import org.netbeans.modules.refactoring.javascript.plugins.SearchVisitor;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.napi.gsfret.source.ClasspathInfo;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.ModificationResult;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.napi.gsfret.source.WorkingCopy;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameRefactoringPlugin
extends JsRefactoringPlugin {
    private JsElementCtx treePathHandle = null;
    private Collection overriddenByMethods = null;
    private Collection overridesMethods = null;
    private boolean doCheckName = true;
    private RenameRefactoring refactoring;
    private Set<JsElementCtx> allMethods;

    public RenameRefactoringPlugin(RenameRefactoring renameRefactoring) {
        this.refactoring = renameRefactoring;
        JsElementCtx jsElementCtx = (JsElementCtx)renameRefactoring.getRefactoringSource().lookup(JsElementCtx.class);
        if (jsElementCtx != null) {
            this.treePathHandle = jsElementCtx;
        } else {
            Source source = RetoucheUtils.getSource((FileObject)renameRefactoring.getRefactoringSource().lookup(FileObject.class));
            try {
                source.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        JsAnalyzer.AnalysisResult analysisResult;
                        List list;
                        JsParseResult jsParseResult;
                        compilationController.toPhase(Phase.RESOLVED);
                        Node node = AstUtilities.getRoot((CompilationInfo)compilationController);
                        if (node != null && (jsParseResult = AstUtilities.getParseResult((CompilationInfo)compilationController)) != null && (list = (analysisResult = jsParseResult.getStructure()).getElements()).size() > 0) {
                            AstElement astElement = (AstElement)list.get(0);
                            Node node2 = astElement.getNode();
                            RenameRefactoringPlugin.this.treePathHandle = new JsElementCtx(node, node2, (Element)astElement, compilationController.getFileObject(), (org.netbeans.napi.gsfret.source.CompilationInfo)compilationController);
                            RenameRefactoringPlugin.this.refactoring.getContext().add((Object)compilationController);
                        }
                    }
                }, false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    @Override
    protected Source getJsSource(JsRefactoringPlugin.Phase phase) {
        if (this.treePathHandle == null) {
            return null;
        }
        switch (phase) {
            case PRECHECK: 
            case CHECKPARAMETERS: {
                if (this.treePathHandle == null) {
                    return null;
                }
                ClasspathInfo classpathInfo = this.getClasspathInfo((AbstractRefactoring)this.refactoring);
                return RetoucheUtils.createSource(classpathInfo, this.treePathHandle.getFileObject());
            }
            case FASTCHECKPARAMETERS: {
                return RetoucheUtils.getSource(this.treePathHandle.getFileObject());
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected Problem preCheck(CompilationController compilationController) throws IOException {
        Problem problem = null;
        this.fireProgressListenerStart(1, 4);
        compilationController.toPhase(Phase.RESOLVED);
        this.fireProgressListenerStop();
        return problem;
    }

    @Override
    protected Problem fastCheckParameters(CompilationController compilationController) throws IOException {
        boolean bl;
        Problem problem = null;
        compilationController.toPhase(Phase.RESOLVED);
        ElementKind elementKind = this.treePathHandle.getKind();
        String string = this.refactoring.getNewName();
        String string2 = this.treePathHandle.getSimpleName();
        if (string2 == null) {
            return new Problem(true, "Cannot determine target name. Please file a bug with detailed information on how to reproduce (preferably including the current source file and the cursor position)");
        }
        if (string2.equals(string) && (bl = true)) {
            problem = RenameRefactoringPlugin.createProblem(problem, true, RenameRefactoringPlugin.getString("ERR_NameNotChanged"));
            return problem;
        }
        if (elementKind == ElementKind.METHOD && !JsUtils.isValidJsMethodName((String)string)) {
            String string3 = RenameRefactoringPlugin.getString("ERR_InvalidMethodName");
            String string4 = new MessageFormat(string3).format(new Object[]{string});
            problem = RenameRefactoringPlugin.createProblem(problem, true, string4);
            return problem;
        }
        if (!JsUtils.isValidJsIdentifier((String)string)) {
            String string5 = RenameRefactoringPlugin.getString("ERR_InvalidIdentifier");
            String string6 = new MessageFormat(string5).format(new Object[]{string});
            problem = RenameRefactoringPlugin.createProblem(problem, true, string6);
            return problem;
        }
        String string7 = JsUtils.getIdentifierWarning((String)string, (int)0);
        if (string7 != null) {
            problem = RenameRefactoringPlugin.createProblem(problem, false, string7);
        }
        return problem;
    }

    @Override
    protected Problem checkParameters(CompilationController compilationController) throws IOException {
        Problem problem = null;
        int n = 0;
        if (this.overriddenByMethods != null) {
            n += this.overriddenByMethods.size();
        }
        if (this.overridesMethods != null) {
            n += this.overridesMethods.size();
        }
        this.fireProgressListenerStart(2, 8 + 3 * n);
        compilationController.toPhase(Phase.RESOLVED);
        this.fireProgressListenerStep();
        this.fireProgressListenerStep();
        this.fireProgressListenerStop();
        return problem;
    }

    @Override
    public Problem preCheck() {
        if (this.treePathHandle == null) {
            return null;
        }
        if (!this.treePathHandle.getFileObject().isValid()) {
            return new Problem(true, NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"DSC_ElNotAvail"));
        }
        return null;
    }

    private Set<FileObject> getRelevantFiles() {
        ClasspathInfo classpathInfo = this.getClasspathInfo((AbstractRefactoring)this.refactoring);
        final HashSet<FileObject> hashSet = new HashSet<FileObject>();
        Source source = RetoucheUtils.createSource(classpathInfo, this.treePathHandle.getFileObject());
        try {
            source.runUserActionTask((CancellableTask)new CancellableTask<CompilationController>(){

                public void cancel() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public void run(CompilationController compilationController) throws Exception {
                    if (RenameRefactoringPlugin.this.treePathHandle.getKind() == ElementKind.VARIABLE || RenameRefactoringPlugin.this.treePathHandle.getKind() == ElementKind.PARAMETER) {
                        hashSet.add(compilationController.getFileObject());
                    } else {
                        hashSet.addAll(RetoucheUtils.getJsFilesInProject(compilationController.getFileObject()));
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            throw (RuntimeException)new RuntimeException().initCause(iOException);
        }
        return hashSet;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        if (this.treePathHandle == null) {
            return null;
        }
        Set<FileObject> set = this.getRelevantFiles();
        this.fireProgressListenerStart(1, set.size());
        if (!set.isEmpty()) {
            JsRefactoringPlugin.TransformTask transformTask = new JsRefactoringPlugin.TransformTask(new RenameTransformer(this.refactoring.getNewName(), this.allMethods), this.treePathHandle);
            Collection<ModificationResult> collection = this.processFiles(set, transformTask);
            refactoringElementsBag.registerTransaction((Transaction)new RetoucheCommit(collection));
            for (ModificationResult modificationResult : collection) {
                for (FileObject fileObject : modificationResult.getModifiedFileObjects()) {
                    for (ModificationResult.Difference difference : modificationResult.getDifferences(fileObject)) {
                        String string = difference.getOldText();
                        if (string == null) continue;
                        refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)DiffElement.create(difference, fileObject, modificationResult));
                    }
                }
            }
        }
        this.fireProgressListenerStop();
        return null;
    }

    private static final String getString(String string) {
        return NbBundle.getMessage(RenameRefactoringPlugin.class, (String)string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RenameTransformer
    extends SearchVisitor {
        private Set<JsElementCtx> allMethods;
        private String newName;
        private String oldName;
        private CloneableEditorSupport ces;
        private List<ModificationResult.Difference> diffs;

        @Override
        public void setWorkingCopy(WorkingCopy workingCopy) {
            this.ces = null;
            assert (this.diffs == null);
            super.setWorkingCopy(workingCopy);
        }

        public RenameTransformer(String string, Set<JsElementCtx> set) {
            this.newName = string;
            this.oldName = RenameRefactoringPlugin.this.treePathHandle.getSimpleName();
            this.allMethods = set;
        }

        @Override
        public void scan() {
            Error error;
            Object object;
            List list;
            Object object2;
            Object object3;
            this.diffs = new ArrayList<ModificationResult.Difference>();
            JsElementCtx jsElementCtx = RenameRefactoringPlugin.this.treePathHandle;
            Error error2 = null;
            Node node2 = AstUtilities.getRoot((CompilationInfo)this.workingCopy);
            if (node2 != null) {
                object3 = AstElement.getElement((CompilationInfo)this.workingCopy, (Node)node2);
                Node node3 = jsElementCtx.getNode();
                object2 = new JsElementCtx(node2, node3, (Element)object3, this.workingCopy.getFileObject(), (org.netbeans.napi.gsfret.source.CompilationInfo)this.workingCopy);
                list = null;
                if (this.workingCopy.getFileObject() == jsElementCtx.getFileObject() && (node3.getType() == 38 || node3.getType() == 48 || node3.getType() == 155)) {
                    object = node3;
                    while (object.getParentNode() != null) {
                        object = object.getParentNode();
                    }
                    error = new VariableVisitor();
                    new ParseTreeWalker((ParseTreeVisitor)error).walk((Node)object);
                    list = error.getDefiningScope(node3);
                }
                if (list != null) {
                    this.findLocal(jsElementCtx, (JsElementCtx)object2, (Node)list, this.oldName);
                } else {
                    object = new AstPath();
                    object.descend(node2);
                    this.find((AstPath)object, jsElementCtx, (JsElementCtx)object2, node2, this.oldName);
                    object.ascend();
                }
            } else if (this.workingCopy.getText().indexOf(this.oldName) != -1) {
                int n;
                if (this.ces == null) {
                    this.ces = RetoucheUtils.findCloneableEditorSupport((org.netbeans.napi.gsfret.source.CompilationInfo)this.workingCopy);
                }
                int n2 = 0;
                boolean n22 = false;
                object2 = NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ParseErrorFile", (Object)this.oldName);
                list = this.workingCopy.getErrors();
                if (list.size() > 0) {
                    object = list.iterator();
                    while (object.hasNext()) {
                        error = (Error)object.next();
                        if (error.getSeverity() != Severity.ERROR) continue;
                        error2 = error;
                        break;
                    }
                    if (error2 == null) {
                        error2 = (Error)list.get(0);
                    }
                    if (((String)(object = error2.getDisplayName())).length() > 80) {
                        object = ((String)object).substring(0, 77) + "...";
                    }
                    object2 = (String)object2 + "; " + (String)object;
                    n2 = error2.getStartPosition();
                    if ((n2 = LexUtilities.getLexerOffset((CompilationInfo)this.workingCopy, (int)n2)) == -1) {
                        n2 = 0;
                    }
                    n = n2;
                }
                object = this.ces.createPositionRef(n2, Position.Bias.Forward);
                error = this.ces.createPositionRef(n, Position.Bias.Forward);
                ModificationResult.Difference difference = new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, (PositionRef)object, (PositionRef)error, "", "", (String)object2);
                this.diffs.add(difference);
            }
            if (error2 == null && RenameRefactoringPlugin.this.refactoring.isSearchInComments() && (object3 = RetoucheUtils.getDocument((org.netbeans.napi.gsfret.source.CompilationInfo)this.workingCopy, this.workingCopy.getFileObject())) != null) {
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)object3);
                object2 = tokenHierarchy.tokenSequence();
                object2.move(0);
                this.searchTokenSequence((TokenSequence<?>)object2);
            }
            if (this.diffs.size() > 0) {
                Collections.sort(this.diffs, new Comparator<ModificationResult.Difference>(){

                    @Override
                    public int compare(ModificationResult.Difference difference, ModificationResult.Difference difference2) {
                        return difference.getStartPosition().getOffset() - difference2.getStartPosition().getOffset();
                    }
                });
                for (ModificationResult.Difference difference : this.diffs) {
                    this.workingCopy.addDiff(difference);
                }
            }
            this.diffs = null;
            this.ces = null;
        }

        private void searchTokenSequence(TokenSequence<?> tokenSequence) {
            if (tokenSequence.moveNext()) {
                do {
                    CharSequence charSequence;
                    Token token;
                    TokenId tokenId;
                    String string;
                    if ("comment".equals(string = (tokenId = (token = tokenSequence.token()).id()).primaryCategory()) || "block-comment".equals(string)) {
                        int n;
                        charSequence = token.text();
                        if (charSequence == null || this.oldName == null || (n = TokenUtilities.indexOf((CharSequence)charSequence, (CharSequence)this.oldName)) == -1) continue;
                        String string2 = ((Object)charSequence).toString();
                        if (n != 0 && Character.isLetterOrDigit(string2.charAt(n - 1)) || n + this.oldName.length() < string2.length() && Character.isLetterOrDigit(string2.charAt(n + this.oldName.length()))) continue;
                        int n2 = tokenSequence.offset() + n;
                        int n3 = n2 + this.oldName.length();
                        if (this.ces == null) {
                            this.ces = RetoucheUtils.findCloneableEditorSupport((org.netbeans.napi.gsfret.source.CompilationInfo)this.workingCopy);
                        }
                        PositionRef positionRef = this.ces.createPositionRef(n2, Position.Bias.Forward);
                        PositionRef positionRef2 = this.ces.createPositionRef(n3, Position.Bias.Forward);
                        String string3 = RenameRefactoringPlugin.getString("ChangeComment");
                        ModificationResult.Difference difference = new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, positionRef, positionRef2, this.oldName, this.newName, string3);
                        this.diffs.add(difference);
                        continue;
                    }
                    charSequence = tokenSequence.embedded();
                    if (charSequence == null) continue;
                    this.searchTokenSequence((TokenSequence<?>)charSequence);
                } while (tokenSequence.moveNext());
            }
        }

        private void rename(Node node, String string, String string2, String string3) {
            BaseDocument baseDocument;
            OffsetRange offsetRange = AstUtilities.getNameRange((Node)node);
            assert (offsetRange != OffsetRange.NONE);
            int n = offsetRange.getStart();
            if (string3 == null) {
                switch (node.getType()) {
                    case 157: {
                        if (!AstUtilities.isLabelledFunction((Node)node)) {
                            string3 = NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"UpdateRef", (Object)string);
                            break;
                        }
                    }
                    case 105: 
                    case 156: {
                        string3 = RenameRefactoringPlugin.getString("UpdateMethodDef");
                        break;
                    }
                    case 30: 
                    case 37: {
                        string3 = RenameRefactoringPlugin.getString("UpdateCall");
                        break;
                    }
                    case 38: {
                        if (node.getParentNode() != null && (node.getParentNode().getType() == 37 || node.getParentNode().getType() == 30)) {
                            string3 = RenameRefactoringPlugin.getString("UpdateCall");
                            break;
                        }
                    }
                    case 48: {
                        if (string != null && string.length() > 0 && Character.isUpperCase(string.charAt(0))) {
                            string3 = RenameRefactoringPlugin.getString("UpdateClass");
                            break;
                        }
                        string3 = RenameRefactoringPlugin.getString("UpdateLocalvar");
                        break;
                    }
                    case 155: {
                        string3 = RenameRefactoringPlugin.getString("UpdateParameter");
                        break;
                    }
                    default: {
                        string3 = NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"UpdateRef", (Object)string);
                    }
                }
            }
            if (this.ces == null) {
                this.ces = RetoucheUtils.findCloneableEditorSupport((org.netbeans.napi.gsfret.source.CompilationInfo)this.workingCopy);
            }
            if ((n = LexUtilities.getLexerOffset((CompilationInfo)this.workingCopy, (int)n)) == -1) {
                return;
            }
            int n2 = n;
            int n3 = n + string.length();
            try {
                baseDocument = (BaseDocument)this.ces.openDocument();
                if (n2 > baseDocument.getLength()) {
                    n2 = n3 = baseDocument.getLength();
                }
                if (n3 > baseDocument.getLength()) {
                    n3 = baseDocument.getLength();
                }
                if (!string.equals(baseDocument.getText(n2, n3 - n2))) {
                    int n4 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n2);
                    int n5 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n2) + 1;
                    if (n4 == -1 || n5 == -1) {
                        System.out.println("Empty line entry in " + FileUtil.getFileDisplayName((FileObject)this.workingCopy.getFileObject()) + "; no match for " + string + " in line " + n2 + " referenced by node " + node + " of type " + node.getClass().getName());
                        return;
                    }
                    if (n4 < 0 || n5 - n4 < 0) {
                        return;
                    }
                    String string4 = baseDocument.getText(n4, n5 - n4);
                    if (string4.indexOf(string) == -1) {
                        System.out.println("Skipping entry in " + FileUtil.getFileDisplayName((FileObject)this.workingCopy.getFileObject()) + "; no match for " + string + " in line " + string4 + " referenced by node " + node + " of type " + node.getClass().getName());
                    } else {
                        int n6 = n2 - n4;
                        int n7 = -1;
                        for (int i = 1; i < string4.length(); ++i) {
                            if (n6 + i + string.length() <= string4.length() && string.equals(string4.substring(n6 + i, n6 + i + string.length()))) {
                                n7 = n6 + i;
                                break;
                            }
                            if (n6 - i < 0 || n6 - i + string.length() > string4.length() || !string.equals(string4.substring(n6 - i, n6 - i + string.length()))) continue;
                            n7 = n6 - i;
                            break;
                        }
                        if (n7 != -1) {
                            n2 = n7 + n4;
                            n3 = n2 + string.length();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            if (string2 == null) {
                string2 = RenameRefactoringPlugin.this.refactoring.getNewName();
            }
            baseDocument = this.ces.createPositionRef(n2, Position.Bias.Forward);
            PositionRef positionRef = this.ces.createPositionRef(n3, Position.Bias.Forward);
            ModificationResult.Difference difference = new ModificationResult.Difference(ModificationResult.Difference.Kind.CHANGE, (PositionRef)baseDocument, positionRef, string, string2, string3);
            this.diffs.add(difference);
        }

        private void findLocal(JsElementCtx jsElementCtx, JsElementCtx jsElementCtx2, Node node, String string) {
            switch (node.getType()) {
                case 155: {
                    if (!node.getString().equals(string)) break;
                    this.rename(node, string, null, RenameRefactoringPlugin.getString("RenameParam"));
                    break;
                }
                case 38: {
                    if ((node.getParentNode() != null && node.getParentNode().getType() == 37 || node.getParentNode() != null && node.getParentNode().getType() == 30) && node.getParentNode().getFirstChild() == node) break;
                }
                case 48: {
                    if (!node.getString().equals(string)) break;
                    this.rename(node, string, null, Character.isUpperCase(string.charAt(0)) ? RenameRefactoringPlugin.getString("UpdateClass") : RenameRefactoringPlugin.getString("UpdateLocalvar"));
                }
            }
            if (node.hasChildren()) {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                    this.findLocal(jsElementCtx, jsElementCtx2, node2, string);
                }
            }
        }

        private void find(AstPath astPath, JsElementCtx jsElementCtx, JsElementCtx jsElementCtx2, Node node, String string) {
            switch (node.getType()) {
                case 157: {
                    if (node.getString().equals(string) && AstUtilities.isLabelledFunction((Node)node)) {
                        this.rename(node, string, null, RenameRefactoringPlugin.getString("UpdateMethodDef"));
                    }
                    return;
                }
                case 156: {
                    int n;
                    if (!node.getString().equals(string) || (n = 0) != 0) break;
                    this.rename(node, string, null, RenameRefactoringPlugin.getString("UpdateMethodDef"));
                    break;
                }
                case 30: 
                case 37: {
                    String string2 = AstUtilities.getCallName((Node)node, (boolean)false);
                    if (!string2.equals(string)) break;
                    this.rename(node, string, null, null);
                    break;
                }
                case 38: {
                    if (node.getParentNode().getType() == 37 || node.getParentNode().getType() == 30) break;
                }
                case 40: {
                    int n = node.getParentNode().getType();
                    if (n != 33 && n != 34) break;
                }
                case 48: {
                    if (!node.getString().equals(string)) break;
                    this.rename(node, string, null, null);
                }
            }
            if (node.hasChildren()) {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNext()) {
                    this.find(astPath, jsElementCtx, jsElementCtx2, node2, string);
                }
            }
        }
    }
}

