/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.javascript;

import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.text.Position;
import org.mozilla.nb.javascript.Node;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.netbeans.modules.refactoring.javascript.JsElementCtx;
import org.netbeans.modules.refactoring.javascript.RetoucheUtils;
import org.netbeans.modules.refactoring.javascript.ui.tree.ElementGrip;
import org.netbeans.modules.refactoring.javascript.ui.tree.ElementGripFactory;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.netbeans.napi.gsfret.source.UiUtils;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class WhereUsedElement
extends SimpleRefactoringElementImplementation {
    private PositionBounds bounds;
    private String displayText;
    private FileObject parentFile;

    public WhereUsedElement(PositionBounds positionBounds, String string, FileObject fileObject, String string2, OffsetRange offsetRange, Icon icon) {
        this.bounds = positionBounds;
        this.displayText = string;
        this.parentFile = fileObject;
        ElementGripFactory.getDefault().put(fileObject, string2, offsetRange, icon);
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public Lookup getLookup() {
        ElementGrip elementGrip = ElementGripFactory.getDefault().get(this.parentFile, this.bounds.getBegin().getOffset());
        if (elementGrip == null) {
            elementGrip = this.parentFile;
        }
        return Lookups.singleton((Object)elementGrip);
    }

    public PositionBounds getPosition() {
        return this.bounds;
    }

    public String getText() {
        return this.displayText;
    }

    public void performChange() {
    }

    public FileObject getParentFile() {
        return this.parentFile;
    }

    public static WhereUsedElement create(JsElementCtx jsElementCtx) {
        CompilationInfo compilationInfo = jsElementCtx.getInfo();
        OffsetRange offsetRange = AstUtilities.getNameRange((Node)jsElementCtx.getNode());
        assert (offsetRange != OffsetRange.NONE);
        offsetRange = LexUtilities.getLexerOffsets((org.netbeans.modules.gsf.api.CompilationInfo)compilationInfo, (OffsetRange)offsetRange);
        assert (offsetRange != OffsetRange.NONE);
        Set<Object> set = Collections.emptySet();
        if (jsElementCtx.getElement() != null) {
            set = jsElementCtx.getElement().getName() == null ? Collections.emptySet() : jsElementCtx.getElement().getModifiers();
        }
        Icon icon = UiUtils.getElementIcon((ElementKind)jsElementCtx.getKind(), set);
        return WhereUsedElement.create(compilationInfo, jsElementCtx.getName(), offsetRange, icon);
    }

    public static WhereUsedElement create(CompilationInfo compilationInfo, String string, OffsetRange offsetRange, Icon icon) {
        Object object;
        FileObject fileObject = compilationInfo.getFileObject();
        int n = offsetRange.getStart();
        int n2 = offsetRange.getEnd();
        int n3 = n;
        int n4 = n;
        String string2 = null;
        try {
            object = RetoucheUtils.getDocument(compilationInfo, compilationInfo.getFileObject());
            string2 = object.getText(0, object.getLength());
            n3 = Utilities.getRowFirstNonWhite((BaseDocument)object, (int)n);
            if (n3 == -1) {
                n3 = Utilities.getRowStart((BaseDocument)object, (int)n);
            }
            n4 = (n4 = Utilities.getRowLastNonWhite((BaseDocument)object, (int)n)) == -1 ? Utilities.getRowEnd((BaseDocument)object, (int)n) : ++n4;
            if (n2 > n4 && (n2 = n + string.length()) > object.getLength()) {
                n2 = object.getLength();
            }
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
        object = new StringBuilder();
        if (n2 < n3) {
            n3 = n2;
        }
        if (n < n3) {
            n = n3;
        }
        if (n4 < n2) {
            n4 = n2;
        }
        ((StringBuilder)object).append(RetoucheUtils.getHtml(((Object)string2.subSequence(n3, n)).toString()));
        ((StringBuilder)object).append("<b>");
        ((StringBuilder)object).append(string2.subSequence(n, n2));
        ((StringBuilder)object).append("</b>");
        ((StringBuilder)object).append(RetoucheUtils.getHtml(((Object)string2.subSequence(n2, n4)).toString()));
        CloneableEditorSupport cloneableEditorSupport = RetoucheUtils.findCloneableEditorSupport(compilationInfo);
        PositionRef positionRef = cloneableEditorSupport.createPositionRef(n, Position.Bias.Forward);
        PositionRef positionRef2 = cloneableEditorSupport.createPositionRef(n2, Position.Bias.Forward);
        PositionBounds positionBounds = new PositionBounds(positionRef, positionRef2);
        return new WhereUsedElement(positionBounds, ((StringBuilder)object).toString().trim(), fileObject, string, new OffsetRange(n, n2), icon);
    }

    public static WhereUsedElement create(CompilationInfo compilationInfo, String string, String string2, OffsetRange offsetRange, Icon icon) {
        FileObject fileObject = compilationInfo.getFileObject();
        int n = offsetRange.getStart();
        int n2 = offsetRange.getEnd();
        CloneableEditorSupport cloneableEditorSupport = RetoucheUtils.findCloneableEditorSupport(compilationInfo);
        PositionRef positionRef = cloneableEditorSupport.createPositionRef(n, Position.Bias.Forward);
        PositionRef positionRef2 = cloneableEditorSupport.createPositionRef(n2, Position.Bias.Forward);
        PositionBounds positionBounds = new PositionBounds(positionRef, positionRef2);
        return new WhereUsedElement(positionBounds, string2, fileObject, string, new OffsetRange(n, n2), icon);
    }
}

