/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.editor.BaseDocument;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;

public abstract class WSCompletionItem
implements CompletionItem {
    private static final String COLOR_END = "</font>";
    private static final String STRIKE = "<s>";
    private static final String STRIKE_END = "</s>";
    int substitutionOffset;

    public static final WSCompletionItem createWsdlFileItem(FileObject fileObject, FileObject fileObject2, int n) {
        String string = FileUtil.getRelativePath((FileObject)fileObject.getParent().getParent(), (FileObject)fileObject2);
        if (string.startsWith("conf/")) {
            string = "META-INF/" + string.substring(5);
        }
        String string2 = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
        return new WsdlFileItem(string, string2, n);
    }

    public static final WSCompletionItem createEnumItem(String string, String string2, int n) {
        return new EnumItem(string, string2, n);
    }

    public WSCompletionItem(int n) {
        this.substitutionOffset = n;
    }

    public void defaultAction(JTextComponent jTextComponent) {
        if (jTextComponent != null) {
            Completion.get().hideDocumentation();
            Completion.get().hideCompletion();
            int n = jTextComponent.getSelectionEnd();
            this.substituteText(jTextComponent, this.substitutionOffset, n - this.substitutionOffset, null);
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
    }

    public int getPreferredWidth(Graphics graphics, Font font) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)graphics, (Font)font);
    }

    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)graphics, (Font)font, (Color)color, (int)n, (int)n2, (boolean)bl);
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent jTextComponent) {
        return false;
    }

    public int getSortPriority() {
        return 100;
    }

    public abstract CharSequence getSortText();

    public abstract CharSequence getInsertPrefix();

    protected abstract String getLeftHtmlText();

    protected String getRightHtmlText() {
        return null;
    }

    protected ImageIcon getIcon() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void substituteText(JTextComponent jTextComponent, int n, int n2, String string) {
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        String string2 = ((Object)this.getInsertPrefix()).toString();
        if (string2 != null) {
            baseDocument.atomicLock();
            try {
                String string3 = baseDocument.getText(n, n2);
                if (string2.equals(string3)) {
                    return;
                }
                Position position = baseDocument.createPosition(n);
                baseDocument.remove(n, n2);
                baseDocument.insertString(position.getOffset(), string2, null);
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                baseDocument.atomicUnlock();
            }
        }
    }

    private static class EnumItem
    extends WSCompletionItem {
        private static final String ENUM_ICON = "org/netbeans/modules/websvc/editor/completion/resources/field_static_16.png";
        private static final String COLOR = "<font color=#0000b2>";
        private String leftText;
        private String itemName;
        private String itemType;
        private ImageIcon icon;

        private EnumItem(String string, String string2, int n) {
            super(n);
            this.itemName = string;
            this.itemType = string2;
        }

        protected ImageIcon getIcon() {
            if (this.icon == null) {
                this.icon = new ImageIcon(ImageUtilities.loadImage((String)ENUM_ICON));
            }
            return this.icon;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(COLOR);
                stringBuilder.append(this.itemName);
                stringBuilder.append(WSCompletionItem.COLOR_END);
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        protected String getRightHtmlText() {
            return this.itemType;
        }

        public CharSequence getSortText() {
            return this.itemName;
        }

        public CharSequence getInsertPrefix() {
            return this.itemName;
        }

        public int getSortPriority() {
            return 10;
        }
    }

    private static class WsdlFileItem
    extends WSCompletionItem {
        private static final String FILE_ICON = "org/netbeans/modules/websvc/editor/completion/resources/fileProtocol.gif";
        private static final String COLOR = "<font color=#005600>";
        private String leftText;
        String wsdlPath;
        String displayPath;
        private static ImageIcon icon;

        private WsdlFileItem(String string, String string2, int n) {
            super(n);
            this.wsdlPath = string;
            this.displayPath = string2;
        }

        protected ImageIcon getIcon() {
            if (icon == null) {
                icon = new ImageIcon(ImageUtilities.loadImage((String)FILE_ICON));
            }
            return icon;
        }

        protected String getLeftHtmlText() {
            if (this.leftText == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(COLOR);
                stringBuilder.append(this.displayPath);
                stringBuilder.append(WSCompletionItem.COLOR_END);
                this.leftText = stringBuilder.toString();
            }
            return this.leftText;
        }

        public CharSequence getSortText() {
            return this.displayPath;
        }

        public CharSequence getInsertPrefix() {
            return this.wsdlPath;
        }
    }
}

