/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.webservices.action;

import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.SetSoapVersionCookie;
import org.netbeans.modules.websvc.core.jaxws.actions.SetSoapVersionCookieImpl;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class SetSoapVersionEditorAction
extends NodeAction {
    private SetSoapVersionCookie cookie;

    public String getName() {
        String string = "LBL_SetSoap12";
        Node[] nodeArray = this.getActivatedNodes();
        FileObject fileObject = this.getFileObjectFromNode(nodeArray[0]);
        if (fileObject != null && JaxWsUtils.isSoap12(fileObject)) {
            string = "LBL_SetSoap11";
        }
        return NbBundle.getMessage(SetSoapVersionEditorAction.class, (String)string);
    }

    private boolean changeToSoap12(FileObject fileObject) {
        return !JaxWsUtils.isSoap12(fileObject);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private FileObject getFileObjectFromNode(Node node) {
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject != null) {
            return dataObject.getPrimaryFile();
        }
        return null;
    }

    protected void performAction(Node[] nodeArray) {
        FileObject fileObject = this.getFileObjectFromNode(nodeArray[0]);
        if (this.cookie == null) {
            this.cookie = new SetSoapVersionCookieImpl();
        }
        this.cookie.setSoapVersion(fileObject, this.changeToSoap12(fileObject));
    }

    private Service getService() {
        FileObject fileObject = this.getFileObjectFromNode(this.getActivatedNodes()[0]);
        JAXWSSupport jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)fileObject);
        if (jAXWSSupport != null) {
            List list = jAXWSSupport.getServices();
            for (int i = 0; i < list.size(); ++i) {
                Service service = (Service)list.get(i);
                String string = service.getImplementationClass();
                ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
                if (classPath == null || !classPath.getResourceName(fileObject).equals(string.replaceAll("\\.", "/") + ".java")) continue;
                return service;
            }
        }
        return null;
    }

    private boolean isFromWSDL() {
        Service service = this.getService();
        if (service != null) {
            return service.getWsdlUrl() != null;
        }
        return false;
    }

    protected boolean enable(Node[] nodeArray) {
        return !this.isFromWSDL() && this.getFileObjectFromNode(nodeArray[0]) != null;
    }
}

