/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsClientNode;
import org.netbeans.modules.websvc.core.jaxws.nodes.ServiceNode;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsClientChildren
extends Children.Keys<WsdlService> {
    Client client;
    WsdlModel wsdlModel;
    FileObject srcRoot;

    public JaxWsClientChildren(Client client, FileObject fileObject) {
        this.client = client;
        this.srcRoot = fileObject;
    }

    protected void addNotify() {
        final WsdlModeler wsdlModeler = ((JaxWsClientNode)this.getNode()).getWsdlModeler();
        if (wsdlModeler != null) {
            JAXWSClientSupport jAXWSClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)this.srcRoot);
            if (jAXWSClientSupport != null) {
                wsdlModeler.setCatalog(jAXWSClientSupport.getCatalog());
            }
            this.wsdlModel = wsdlModeler.getWsdlModel();
            if (this.wsdlModel == null) {
                wsdlModeler.generateWsdlModel(new WsdlModelListener(){

                    public void modelCreated(WsdlModel wsdlModel) {
                        JaxWsClientChildren.this.wsdlModel = wsdlModel;
                        ((JaxWsClientNode)JaxWsClientChildren.this.getNode()).changeIcon();
                        if (wsdlModel == null) {
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new JaxWsUtils.WsImportClientFailedMessage(wsdlModeler.getCreationException()));
                        }
                        JaxWsClientChildren.this.updateKeys();
                    }
                });
            } else {
                this.updateKeys();
            }
        }
    }

    protected void removeNotify() {
        this.setKeys(Collections.emptySet());
    }

    private void updateKeys() {
        List list = null;
        if (this.wsdlModel != null) {
            list = this.wsdlModel.getServices();
        }
        this.setKeys(list == null ? new ArrayList() : list);
    }

    protected Node[] createNodes(WsdlService wsdlService) {
        return new Node[]{new ServiceNode(wsdlService)};
    }

    void refreshKeys(boolean bl) {
        this.refreshKeys(bl, "");
    }

    void refreshKeys(boolean bl, String string) {
        Object object;
        String string2;
        FileObject fileObject;
        String string3;
        Object object2;
        super.addNotify();
        JAXWSClientSupport jAXWSClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)this.srcRoot);
        final JaxWsClientNode jaxWsClientNode = (JaxWsClientNode)this.getNode();
        if (bl) {
            try {
                FileObject fileObject2;
                object2 = jaxWsClientNode.getName();
                string3 = this.client.getWsdlUrl();
                boolean bl2 = false;
                fileObject = null;
                if (string.length() > 0 && !string3.equals(string)) {
                    fileObject = WSUtils.retrieveResource((FileObject)jAXWSClientSupport.getLocalWsdlFolderForClient((String)object2, true), (URI)new URI(string));
                    bl2 = true;
                } else {
                    WSUtils.retrieveResource((FileObject)jAXWSClientSupport.getLocalWsdlFolderForClient((String)object2, true), (URI)new URI(string3));
                }
                if (bl2) {
                    this.client.setWsdlUrl(string);
                    string2 = jAXWSClientSupport.getLocalWsdlFolderForClient((String)object2, false);
                    if (string2 != null) {
                        object = FileUtil.getRelativePath((FileObject)string2, (FileObject)fileObject);
                        this.client.setLocalWsdlFile((String)object);
                    }
                    jaxWsClientNode.getJaxWsModel().write();
                }
                string2 = (FileObject)this.getNode().getLookup().lookup(FileObject.class);
                object = FileOwnerQuery.getOwner((FileObject)this.srcRoot);
                if (object.getLookup().lookup(J2eeModuleProvider.class) != null && (fileObject2 = jAXWSClientSupport.getLocalWsdlFolderForClient((String)object2, false)) != null) {
                    FileObject fileObject3 = this.getWsdlFolderForClient(jAXWSClientSupport, (String)object2);
                    WSUtils.copyFiles((FileObject)fileObject2, (FileObject)fileObject3);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                ErrorManager.getDefault().notify((Throwable)uRISyntaxException);
            }
            catch (UnknownHostException unknownHostException) {
                ErrorManager.getDefault().annotate((Throwable)unknownHostException, NbBundle.getMessage(JaxWsClientChildren.class, (String)"MSG_ConnectionProblem"));
                return;
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().annotate((Throwable)iOException, NbBundle.getMessage(JaxWsClientChildren.class, (String)"MSG_ConnectionProblem"));
                return;
            }
        }
        object2 = jaxWsClientNode.getWsdlModeler();
        jaxWsClientNode.setModelGenerationFinished(false);
        jaxWsClientNode.changeIcon();
        if (object2 != null) {
            object2.generateWsdlModel(new WsdlModelListener((WsdlModeler)object2){
                final /* synthetic */ WsdlModeler val$wsdlModeler;
                {
                    this.val$wsdlModeler = wsdlModeler;
                }

                public void modelCreated(WsdlModel wsdlModel) {
                    Client client;
                    JaxWsClientChildren.this.wsdlModel = wsdlModel;
                    jaxWsClientNode.setModelGenerationFinished(true);
                    jaxWsClientNode.changeIcon();
                    if (wsdlModel == null) {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new JaxWsUtils.WsImportClientFailedMessage(this.val$wsdlModeler.getCreationException()));
                    }
                    JaxWsClientChildren.this.updateKeys();
                    if (wsdlModel != null && (client = jaxWsClientNode.getJaxWsModel().findClientByName(jaxWsClientNode.getName())) != null) {
                        String string;
                        int n;
                        WsdlService wsdlService = null;
                        boolean bl = false;
                        List list = wsdlModel.getServices();
                        if (list != null && list.size() > 0) {
                            wsdlService = (WsdlService)list.get(0);
                        }
                        String string2 = client.getPackageName();
                        if (wsdlService != null && !client.isPackageNameForceReplace() && (n = (string = wsdlService.getJavaName()).lastIndexOf(".")) >= 0) {
                            String string3 = string.substring(0, n);
                            if (string2 == null && string3 != null || !string2.equals(string3)) {
                                client.setPackageName(string3);
                                bl = true;
                            }
                        }
                        if (bl) {
                            try {
                                jaxWsClientNode.getJaxWsModel().write();
                            }
                            catch (IOException iOException) {
                                ErrorManager.getDefault().notify(65536, (Throwable)iOException);
                            }
                        }
                    }
                }
            });
        }
        string3 = (FileObject)this.getNode().getLookup().lookup(FileObject.class);
        Project project = FileOwnerQuery.getOwner((FileObject)this.srcRoot);
        if (project != null) {
            fileObject = project.getProjectDirectory().getFileObject("build.xml");
            try {
                string2 = this.client.getName();
                object = ActionUtils.runTarget((FileObject)fileObject, (String[])new String[]{"wsimport-client-clean-" + string2, "wsimport-client-" + string2}, null);
                object.waitFinished();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().log(iOException.getLocalizedMessage());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorManager.getDefault().log(illegalArgumentException.getLocalizedMessage());
            }
            string2 = this.client.getPackageName();
            if (string2 != null) {
                string2 = string2.replace(".", "/");
                object = project.getProjectDirectory().getFileObject("build/generated/wsimport/client/" + string2);
                if (object != null) {
                    object.refresh();
                }
            }
        }
    }

    WsdlModel getWsdlModel() {
        return this.wsdlModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject getWsdlFolderForClient(JAXWSClientSupport jAXWSClientSupport, String string) throws IOException {
        FileLock fileLock;
        FileObject fileObject = jAXWSClientSupport.getWsdlFolder(true);
        FileObject fileObject2 = fileObject.getFileObject("client/" + string);
        if (fileObject2 != null) {
            fileLock = fileObject2.lock();
            try {
                fileObject2.delete(fileLock);
            }
            finally {
                fileLock.releaseLock();
            }
        }
        if ((fileLock = fileObject.getFileObject("client")) == null) {
            fileLock = fileObject.createFolder("client");
        }
        return fileLock.createFolder(string);
    }
}

