/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core;

import java.util.Collection;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.core.ClientCreator;
import org.netbeans.modules.websvc.core.ClientCreatorProvider;
import org.netbeans.modules.websvc.core.HandlerCreator;
import org.netbeans.modules.websvc.core.HandlerCreatorProvider;
import org.netbeans.modules.websvc.core.ServiceCreator;
import org.netbeans.modules.websvc.core.ServiceCreatorProvider;
import org.openide.WizardDescriptor;
import org.openide.util.Lookup;

public class CreatorProvider {
    private static final Lookup.Result<ClientCreatorProvider> clientProviders = Lookup.getDefault().lookup(new Lookup.Template(ClientCreatorProvider.class));
    private static final Lookup.Result<ServiceCreatorProvider> serviceProviders = Lookup.getDefault().lookup(new Lookup.Template(ServiceCreatorProvider.class));
    private static final Lookup.Result<HandlerCreatorProvider> handlerProviders = Lookup.getDefault().lookup(new Lookup.Template(HandlerCreatorProvider.class));

    public static ClientCreator getClientCreator(Project project, WizardDescriptor wizardDescriptor) {
        Collection collection = clientProviders.allInstances();
        for (ClientCreatorProvider clientCreatorProvider : collection) {
            ClientCreator clientCreator = clientCreatorProvider.getClientCreator(project, wizardDescriptor);
            if (clientCreator == null) continue;
            return clientCreator;
        }
        return null;
    }

    public static ServiceCreator getServiceCreator(Project project, WizardDescriptor wizardDescriptor) {
        Collection collection = serviceProviders.allInstances();
        for (ServiceCreatorProvider serviceCreatorProvider : collection) {
            ServiceCreator serviceCreator = serviceCreatorProvider.getServiceCreator(project, wizardDescriptor);
            if (serviceCreator == null) continue;
            return serviceCreator;
        }
        return null;
    }

    public static HandlerCreator getHandlerCreator(Project project, WizardDescriptor wizardDescriptor) {
        Collection collection = handlerProviders.allInstances();
        for (HandlerCreatorProvider handlerCreatorProvider : collection) {
            HandlerCreator handlerCreator = handlerCreatorProvider.getHandlerCreator(project, wizardDescriptor);
            if (handlerCreator == null) continue;
            return handlerCreator;
        }
        return null;
    }
}

