/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.util;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class ErrorInfoPanel
extends JPanel {
    private static final String EMPTYCARD = "emptyCard";
    private static final String CONTENTCARD = "contentCard";
    private static final String ERRORICON = "org/netbeans/modules/db/resources/errorIcon.png";
    private static final String INFOICON = "org/netbeans/modules/db/resources/infoIcon.png";
    private ImageIcon errorIcon;
    private ImageIcon infoIcon;
    private Color errorColor;
    private Color infoColor;
    private JPanel contentPanel;
    private JPanel emptyPanel;
    private JLabel iconLabel;
    private JLabel msgLabel;

    public ErrorInfoPanel() {
        this.initComponents();
        this.add((Component)this.emptyPanel, EMPTYCARD);
    }

    public void setup() {
        this.errorColor = UIManager.getColor("nb.errorForeground");
        if (this.errorColor == null) {
            this.errorColor = new Color(255, 0, 0);
        }
        this.infoColor = UIManager.getColor("nb.warningForeground");
        if (this.infoColor == null) {
            this.infoColor = UIManager.getColor("Label.foreground");
        }
        this.errorIcon = new ImageIcon(ImageUtilities.loadImage((String)ERRORICON));
        this.infoIcon = new ImageIcon(ImageUtilities.loadImage((String)INFOICON));
    }

    public void clear() {
        ((CardLayout)this.getLayout()).show(this, EMPTYCARD);
    }

    public void setError(String string) {
        ((CardLayout)this.getLayout()).show(this, CONTENTCARD);
        this.msgLabel.setText(string);
        this.msgLabel.setForeground(this.errorColor);
        this.iconLabel.setIcon(this.errorIcon);
    }

    public void setInfo(String string) {
        ((CardLayout)this.getLayout()).show(this, CONTENTCARD);
        this.msgLabel.setText(string);
        this.msgLabel.setForeground(this.infoColor);
        this.iconLabel.setIcon(this.infoIcon);
    }

    public void set(String string, boolean bl) {
        if (bl) {
            this.setError(string);
        } else {
            this.setInfo(string);
        }
    }

    private void initComponents() {
        this.emptyPanel = new JPanel();
        this.contentPanel = new JPanel();
        this.iconLabel = new JLabel();
        this.msgLabel = new JLabel();
        GroupLayout groupLayout = new GroupLayout((Container)this.emptyPanel);
        this.emptyPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 278, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(0, 18, Short.MAX_VALUE));
        this.setLayout(new CardLayout());
        this.iconLabel.setText(NbBundle.getMessage(ErrorInfoPanel.class, (String)"ErrorInfoPanel.iconLabel.text"));
        this.msgLabel.setText(NbBundle.getMessage(ErrorInfoPanel.class, (String)"ErrorInfoPanel.msgLabel.text"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.contentPanel);
        this.contentPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.iconLabel, -2, 20, -2).addPreferredGap(0).add((Component)this.msgLabel, -1, 372, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.iconLabel, -2, 16, -2).add((Component)this.msgLabel, -2, 16, -2)));
        this.add((Component)this.contentPanel, CONTENTCARD);
    }
}

