/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.nodes;

import java.awt.Image;
import java.beans.PropertyEditor;
import java.util.List;
import javax.swing.Action;
import javax.xml.namespace.QName;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaConnection;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaEndpoint;
import org.netbeans.modules.compapp.casaeditor.nodes.CasaNode;
import org.netbeans.modules.compapp.casaeditor.nodes.CasaNodeFactory;
import org.netbeans.modules.compapp.casaeditor.nodes.ExtensionPropertyHelper;
import org.netbeans.modules.compapp.casaeditor.nodes.actions.ClearConfigExtensionsAction;
import org.netbeans.modules.compapp.casaeditor.properties.NamespaceEditor;
import org.netbeans.modules.compapp.casaeditor.properties.PropertyUtils;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionNode
extends CasaNode {
    private static final Image ICON = ImageUtilities.loadImage((String)"org/netbeans/modules/compapp/casaeditor/nodes/resources/ConnectionNode.png");

    public ConnectionNode(CasaConnection casaConnection, CasaNodeFactory casaNodeFactory) {
        super((Object)casaConnection, Children.LEAF, casaNodeFactory);
    }

    @Override
    protected void setupPropertySheet(Sheet sheet) {
        CasaConnection casaConnection = (CasaConnection)this.getData();
        if (casaConnection == null) {
            return;
        }
        final CasaEndpoint casaEndpoint = (CasaEndpoint)casaConnection.getConsumer().get();
        final CasaEndpoint casaEndpoint2 = (CasaEndpoint)casaConnection.getProvider().get();
        Sheet.Set set = this.getPropertySet(sheet, PropertyUtils.PropertiesGroups.CONSUMER_SET);
        PropertySupport.ReadOnly<QName> readOnly = new PropertySupport.ReadOnly<QName>("serviceName", QName.class, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"PROP_ServiceName"), ""){

            public QName getValue() {
                return casaEndpoint.getServiceQName();
            }

            public PropertyEditor getPropertyEditor() {
                return new NamespaceEditor(ConnectionNode.this.getModel(), this.getValue(), this.getDisplayName(), false);
            }
        };
        PropertySupport.ReadOnly<String> readOnly2 = new PropertySupport.ReadOnly<String>("endpointName", String.class, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"PROP_EndpointName"), ""){

            public String getValue() {
                return casaEndpoint.getEndpointName();
            }
        };
        set.put((Node.Property)readOnly);
        set.put((Node.Property)readOnly2);
        Sheet.Set set2 = this.getPropertySet(sheet, PropertyUtils.PropertiesGroups.PROVIDER_SET);
        PropertySupport.ReadOnly<QName> readOnly3 = new PropertySupport.ReadOnly<QName>("serviceName", QName.class, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"PROP_ServiceName"), ""){

            public QName getValue() {
                return casaEndpoint2.getServiceQName();
            }

            public PropertyEditor getPropertyEditor() {
                return new NamespaceEditor(ConnectionNode.this.getModel(), this.getValue(), this.getDisplayName(), false);
            }
        };
        PropertySupport.ReadOnly<String> readOnly4 = new PropertySupport.ReadOnly<String>("endpointName", String.class, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"PROP_EndpointName"), ""){

            public String getValue() {
                return casaEndpoint2.getEndpointName();
            }
        };
        set2.put((Node.Property)readOnly3);
        set2.put((Node.Property)readOnly4);
        ExtensionPropertyHelper.setupExtensionPropertySheet(this, casaConnection, sheet, "connection", "all");
    }

    public String getName() {
        CasaConnection casaConnection = (CasaConnection)this.getData();
        if (casaConnection != null) {
            try {
                return ((CasaEndpoint)casaConnection.getConsumer().get()).getEndpointName() + "<->" + ((CasaEndpoint)casaConnection.getProvider().get()).getEndpointName();
            }
            catch (Throwable throwable) {
                return this.getBadName();
            }
        }
        return super.getName();
    }

    private String getEncodingName() {
        CasaConnection casaConnection = (CasaConnection)this.getData();
        if (casaConnection != null) {
            return ((CasaEndpoint)casaConnection.getConsumer().get()).getEndpointName() + "&#60;-&#62;" + ((CasaEndpoint)casaConnection.getProvider().get()).getEndpointName();
        }
        return super.getName();
    }

    public String getHtmlDisplayName() {
        try {
            String string;
            String string2 = this.getEncodingName();
            CasaConnection casaConnection = (CasaConnection)this.getData();
            String string3 = null;
            if (casaConnection != null && (string = casaConnection.getState()) != null && string.equalsIgnoreCase("deleted")) {
                string3 = "<font color='#999999'><DEL>" + string2 + "</DEL></font>";
            }
            if (string3 == null) {
                return string2;
            }
            return string3;
        }
        catch (Throwable throwable) {
            return this.getBadName();
        }
    }

    public Image getIcon(int n) {
        return ICON;
    }

    public Image getOpenedIcon(int n) {
        return ICON;
    }

    @Override
    public boolean isDeletable() {
        CasaConnection casaConnection = (CasaConnection)this.getData();
        if (casaConnection != null) {
            return this.getModel().isDeletable(casaConnection);
        }
        return false;
    }

    @Override
    public boolean isEditable(String string) {
        return string.equals("[WRITABLE]");
    }

    @Override
    protected void addCustomActions(List<Action> list) {
        CasaConnection casaConnection = (CasaConnection)this.getData();
        if (this.isConnectionConfiguredWithQoS(casaConnection)) {
            list.add(new ClearConfigExtensionsAction(NbBundle.getMessage(ConnectionNode.class, (String)"CLEAR_QOS_CONFIG"), this));
        }
    }

    private boolean isConnectionConfiguredWithQoS(CasaConnection casaConnection) {
        return casaConnection.getChildren().size() != 0;
    }
}

