/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.nodes;

import java.awt.Image;
import java.awt.Point;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.CasaDataObject;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaComponent;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaWrapperModel;
import org.netbeans.modules.compapp.casaeditor.nodes.CasaNodeFactory;
import org.netbeans.modules.compapp.casaeditor.nodes.actions.NodeDeleteAction;
import org.netbeans.modules.compapp.casaeditor.properties.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CasaNode
extends AbstractNode {
    protected static final String ALWAYS_WRITABLE_PROPERTY = "[WRITABLE]";
    private WeakReference mDataReference;
    private static Map<Object, Image> mImageMap = new HashMap<Object, Image>();
    private InstanceContent content;

    public CasaNode() {
        super(Children.LEAF);
    }

    public CasaNode(Object object, Children children, CasaNodeFactory casaNodeFactory) {
        this(object, children, casaNodeFactory.createInstanceContent());
    }

    private CasaNode(Object object, Children children, InstanceContent instanceContent) {
        super(children, (Lookup)new AbstractLookup((AbstractLookup.Content)instanceContent));
        this.mDataReference = new WeakReference<Object>(object);
        instanceContent.add((Object)new SaveCookieDelegate());
        this.content = instanceContent;
    }

    protected Sheet.Set getPropertySet(Sheet sheet, PropertyUtils.PropertiesGroups propertiesGroups) {
        return this.getPropertySet(sheet, propertiesGroups.getDisplayName());
    }

    protected Sheet.Set getPropertySet(Sheet sheet, String string) {
        Sheet.Set set = sheet.get(string);
        if (set == null) {
            set = new Sheet.Set();
            set.setName(string);
            sheet.put(set);
        }
        return set;
    }

    public Object getData() {
        if (this.mDataReference != null) {
            Object t = this.mDataReference.get();
            if (t instanceof CasaComponent && !((CasaComponent)t).isInDocumentModel()) {
                return null;
            }
            return t;
        }
        return null;
    }

    public CasaDataObject getDataObject() {
        return (CasaDataObject)((Object)this.getLookup().lookup(CasaDataObject.class));
    }

    public CasaWrapperModel getModel() {
        return (CasaWrapperModel)((Object)this.getLookup().lookup(CasaWrapperModel.class));
    }

    public boolean isEditable(String string) {
        return false;
    }

    public boolean isDeletable() {
        return false;
    }

    protected void addCustomActions(List<Action> list) {
    }

    public final Action[] getActions(boolean bl) {
        Action[] actionArray;
        ArrayList<Action> arrayList = new ArrayList<Action>();
        this.addCustomActions(arrayList);
        if (arrayList.size() > 0) {
            arrayList.add(null);
        }
        if (this.isDeletable()) {
            arrayList.add(new NodeDeleteAction(this));
            arrayList.add(null);
        }
        for (Action action : actionArray = super.getActions(bl)) {
            arrayList.add(action);
        }
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    public boolean isValidSceneActionForLocation(Action action, Widget widget, Point point) {
        return true;
    }

    protected String getBadName() {
        return NbBundle.getMessage(PropertyUtils.class, (String)"PROP_ERROR_VALUE");
    }

    protected final Sheet createSheet() {
        Sheet sheet = super.createSheet();
        try {
            this.setupPropertySheet(sheet);
        }
        catch (Throwable throwable) {
            ErrorManager.getDefault().notify(throwable);
        }
        return sheet;
    }

    public void refresh() {
        this.setSheet(this.createSheet());
    }

    protected void setupPropertySheet(Sheet sheet) {
    }

    public void addContent(Object object) {
        this.content.add(object);
    }

    public void removeContent(Object object) {
        this.content.remove(object);
    }

    class SaveCookieDelegate
    implements SaveCookie {
        SaveCookieDelegate() {
        }

        public void save() throws IOException {
            SaveCookie saveCookie;
            CasaDataObject casaDataObject = CasaNode.this.getDataObject();
            if (casaDataObject != null && (saveCookie = (SaveCookie)casaDataObject.getCookie(SaveCookie.class)) != null) {
                saveCookie.save();
            }
        }
    }
}

