/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph.actions;

import java.awt.Point;
import java.util.List;
import org.netbeans.api.visual.action.ConnectDecorator;
import org.netbeans.api.visual.action.ConnectProvider;
import org.netbeans.api.visual.action.ConnectorState;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.anchor.AnchorShape;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphScene;
import org.netbeans.modules.compapp.casaeditor.graph.CasaConnectionWidget;
import org.netbeans.modules.compapp.casaeditor.graph.CasaPinWidget;
import org.netbeans.modules.compapp.casaeditor.graph.actions.ConnectionHintManager;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaComponent;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaConnection;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaConsumes;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaEndpointRef;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaPort;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaProvides;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaServiceEngineServiceUnit;

public class CasaConnectAction
extends WidgetAction.LockedAdapter {
    private static final int MIN_DIFFERENCE = 5;
    private ConnectDecorator decorator;
    private Widget interractionLayer;
    private ConnectProvider provider;
    private ConnectionWidget dragConnectionWidget;
    private Widget connectionSourceWidget;
    private Widget connectionTargetWidget;
    private Widget mLastHoverWidget;
    private Point startingPoint;
    private CasaModelGraphScene mScene;
    private boolean mIsCommitted;
    private boolean mIsConnectionHintsSet;

    public CasaConnectAction(CasaModelGraphScene casaModelGraphScene, Widget widget) {
        this.mScene = casaModelGraphScene;
        this.decorator = new ConnectDecorator(){

            public ConnectionWidget createConnectionWidget(Scene scene) {
                CasaConnectionWidget casaConnectionWidget = new CasaConnectionWidget(scene);
                casaConnectionWidget.setTargetAnchorShape(AnchorShape.TRIANGLE_FILLED);
                return casaConnectionWidget;
            }

            public Anchor createSourceAnchor(Widget widget) {
                assert (widget instanceof CasaPinWidget);
                return ((CasaPinWidget)widget).getAnchor();
            }

            public Anchor createTargetAnchor(Widget widget) {
                assert (widget instanceof CasaPinWidget);
                return ((CasaPinWidget)widget).getAnchor();
            }

            public Anchor createFloatAnchor(Point point) {
                return AnchorFactory.createFixedAnchor((Point)point);
            }
        };
        this.provider = new ConnectProvider(){

            public void createConnection(Widget widget, Widget widget2) {
                ConsumesProvides consumesProvides = new ConsumesProvides(CasaConnectAction.this.mScene, widget, widget2);
                if (consumesProvides.mConsumes != null && consumesProvides.mProvides != null) {
                    for (CasaConnection casaConnection : CasaConnectAction.this.mScene.getModel().getCasaConnectionList(false)) {
                        CasaEndpointRef casaEndpointRef = CasaConnectAction.this.mScene.getModel().getCasaEndpointRef(casaConnection, true);
                        CasaEndpointRef casaEndpointRef2 = CasaConnectAction.this.mScene.getModel().getCasaEndpointRef(casaConnection, false);
                        if (casaEndpointRef == null || casaEndpointRef2 == null || !casaEndpointRef.equals(consumesProvides.mConsumes) || !casaEndpointRef2.equals(consumesProvides.mProvides)) continue;
                        return;
                    }
                    CasaConnectAction.this.mScene.getModel().addConnection(consumesProvides.mConsumes, consumesProvides.mProvides, consumesProvides.getConsumesToProvidesDirection());
                }
            }

            public boolean hasCustomTargetWidgetResolver(Scene scene) {
                return false;
            }

            public boolean isSourceWidget(Widget widget) {
                return widget instanceof CasaPinWidget;
            }

            public ConnectorState isTargetWidget(Widget widget, Widget widget2) {
                if (widget2 instanceof CasaPinWidget && widget != widget2) {
                    return ConnectorState.ACCEPT;
                }
                return ConnectorState.REJECT;
            }

            public Widget resolveTargetWidget(Scene scene, Point point) {
                return null;
            }
        };
        this.interractionLayer = widget;
    }

    protected boolean isLocked() {
        return this.connectionSourceWidget != null;
    }

    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        this.mIsCommitted = false;
        if (widgetMouseEvent.getButton() == 1 && widgetMouseEvent.getClickCount() == 1) {
            if (this.provider.isSourceWidget(widget)) {
                this.connectionSourceWidget = widget;
                this.connectionTargetWidget = null;
                this.startingPoint = new Point(widgetMouseEvent.getPoint());
                this.dragConnectionWidget = this.decorator.createConnectionWidget(this.interractionLayer.getScene());
                assert (this.dragConnectionWidget != null);
                this.dragConnectionWidget.setSourceAnchor(this.decorator.createSourceAnchor(widget));
                return WidgetAction.State.CHAIN_ONLY;
            }
        } else {
            this.cleanup();
        }
        return WidgetAction.State.REJECTED;
    }

    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (this.connectionSourceWidget == null || widget != this.connectionSourceWidget) {
            return WidgetAction.State.REJECTED;
        }
        Point point = widgetMouseEvent.getPoint();
        this.move((CasaPinWidget)widget, point);
        if (Math.abs(this.startingPoint.x - point.x) >= 5 || Math.abs(this.startingPoint.y - point.y) >= 5) {
            this.provider.createConnection(this.connectionSourceWidget, this.connectionTargetWidget);
        }
        this.cleanup();
        return WidgetAction.State.CONSUMED;
    }

    private void cleanup() {
        this.connectionSourceWidget = null;
        this.connectionTargetWidget = null;
        this.startingPoint = null;
        if (this.dragConnectionWidget != null) {
            this.dragConnectionWidget.setSourceAnchor(null);
            this.dragConnectionWidget.setTargetAnchor(null);
            if (this.interractionLayer.getChildren().contains(this.dragConnectionWidget)) {
                this.interractionLayer.removeChild((Widget)this.dragConnectionWidget);
            }
        }
        this.dragConnectionWidget = null;
        this.mIsCommitted = false;
        this.updateConnectionHints();
        ConnectionHintManager.sharedInstance().cleanup();
    }

    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (this.connectionSourceWidget == null || widget != this.connectionSourceWidget) {
            return WidgetAction.State.REJECTED;
        }
        if (!this.mIsCommitted) {
            this.interractionLayer.addChild((Widget)this.dragConnectionWidget);
            this.mIsCommitted = true;
        }
        this.move((CasaPinWidget)widget, widgetMouseEvent.getPoint());
        this.updateConnectionHints();
        return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
    }

    private void move(CasaPinWidget casaPinWidget, Point point) {
        Point point2 = casaPinWidget.convertLocalToScene(point);
        if (point2.x < 0) {
            point2.x = 0;
        }
        if (point2.y < 0) {
            point2.y = 0;
        }
        this.connectionTargetWidget = this.findTargetWidget(casaPinWidget, point2);
        Anchor anchor = null;
        if (this.connectionTargetWidget != null) {
            anchor = this.decorator.createTargetAnchor(this.connectionTargetWidget);
        }
        if (anchor == null) {
            anchor = this.decorator.createFloatAnchor(point2);
        }
        this.dragConnectionWidget.setTargetAnchor(anchor);
    }

    private Widget findTargetWidget(CasaPinWidget casaPinWidget, Point point) {
        CasaPinWidget casaPinWidget2 = (CasaPinWidget)this.resolveTargetWidgetCore(this.interractionLayer.getScene(), point);
        if (casaPinWidget2 != this.mLastHoverWidget) {
            if (this.mLastHoverWidget != null) {
                ConnectionHintManager.sharedInstance().widgetExited();
            }
            if (casaPinWidget2 != null) {
                ConnectionHintManager.sharedInstance().widgetEntered(casaPinWidget, casaPinWidget2);
            }
        }
        if (casaPinWidget2 != null) {
            ConnectionHintManager.sharedInstance().widgetMovedOver(casaPinWidget, casaPinWidget2);
        }
        this.mLastHoverWidget = casaPinWidget2;
        if (casaPinWidget2 != null) {
            ConsumesProvides consumesProvides = new ConsumesProvides(this.mScene, casaPinWidget, casaPinWidget2);
            if (consumesProvides.mConsumes != null && consumesProvides.mProvides != null && this.mScene.getModel().canConnect(consumesProvides.mConsumes, consumesProvides.mProvides)) {
                return casaPinWidget2;
            }
        }
        return null;
    }

    private Widget resolveTargetWidgetCore(Scene scene, Point point) {
        if (this.provider != null && this.provider.hasCustomTargetWidgetResolver(scene)) {
            return this.provider.resolveTargetWidget(scene, point);
        }
        Point point2 = scene.getLocation();
        point = new Point(point.x + point2.x, point.y + point2.y);
        Widget[] widgetArray = new Widget[]{null};
        this.resolveTargetWidgetCoreDive(widgetArray, (Widget)scene, point);
        return widgetArray[0];
    }

    private boolean resolveTargetWidgetCoreDive(Widget[] widgetArray, Widget widget, Point point) {
        if (this.interractionLayer.equals((Object)widget)) {
            return false;
        }
        Point point2 = widget.getLocation();
        Point point3 = new Point(point.x - point2.x, point.y - point2.y);
        if (!widget.getBounds().contains(point3)) {
            return false;
        }
        List list = widget.getChildren();
        for (int i = list.size() - 1; i >= 0; --i) {
            if (!this.resolveTargetWidgetCoreDive(widgetArray, (Widget)list.get(i), point3)) continue;
            return true;
        }
        if (!widget.isHitAt(point3)) {
            return false;
        }
        ConnectorState connectorState = this.provider.isTargetWidget(this.connectionSourceWidget, widget);
        if (connectorState == ConnectorState.REJECT) {
            return false;
        }
        if (connectorState == ConnectorState.ACCEPT) {
            widgetArray[0] = widget;
        }
        return true;
    }

    private void updateConnectionHints() {
        if (this.connectionSourceWidget != null && this.mIsCommitted && !this.mIsConnectionHintsSet) {
            this.mIsConnectionHintsSet = true;
            this.updatePinHighlights((CasaEndpointRef)this.mScene.findObject(this.connectionSourceWidget));
        } else if (this.connectionSourceWidget == null) {
            this.mIsConnectionHintsSet = false;
            this.updatePinHighlights(null);
        }
    }

    private void updatePinHighlights(CasaEndpointRef casaEndpointRef) {
        for (CasaComponent casaComponent : this.mScene.getNodes()) {
            if (!(casaComponent instanceof CasaPort) && !(casaComponent instanceof CasaServiceEngineServiceUnit)) continue;
            for (CasaComponent casaComponent2 : this.mScene.getNodePins(casaComponent)) {
                boolean bl = false;
                CasaPinWidget casaPinWidget = (CasaPinWidget)this.mScene.findWidget(casaComponent2);
                if (casaEndpointRef != null) {
                    CasaEndpointRef casaEndpointRef2 = (CasaEndpointRef)casaComponent2;
                    if (this.mScene.getModel().canConnect(casaEndpointRef, casaEndpointRef2)) {
                        bl = true;
                    }
                }
                casaPinWidget.setHighlighted(bl);
            }
        }
    }

    private static class ConsumesProvides {
        CasaConsumes mConsumes;
        CasaProvides mProvides;
        boolean mConsumesToProvidesDirection = true;

        public ConsumesProvides(CasaModelGraphScene casaModelGraphScene, Widget widget, Widget widget2) {
            if (widget instanceof CasaPinWidget && widget2 instanceof CasaPinWidget) {
                Object object = casaModelGraphScene.findObject(widget);
                Object object2 = casaModelGraphScene.findObject(widget2);
                if (object instanceof CasaConsumes) {
                    this.mConsumes = (CasaConsumes)object;
                    this.mConsumesToProvidesDirection = true;
                } else if (object instanceof CasaProvides) {
                    this.mProvides = (CasaProvides)object;
                    this.mConsumesToProvidesDirection = false;
                }
                if (object2 instanceof CasaConsumes) {
                    this.mConsumes = (CasaConsumes)object2;
                    this.mConsumesToProvidesDirection = false;
                } else if (object2 instanceof CasaProvides) {
                    this.mProvides = (CasaProvides)object2;
                    this.mConsumesToProvidesDirection = true;
                }
            }
        }

        public boolean getConsumesToProvidesDirection() {
            return this.mConsumesToProvidesDirection;
        }
    }
}

