/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.cache;

import java.util.Arrays;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CharSequenceKey
implements CharSequence,
Comparable<CharSequenceKey> {
    private static final CharSequence EMPTY = CharSequenceKey.create("");
    public static final Comparator<CharSequence> Comparator = new CharSequenceComparator();
    public static final Comparator<CharSequence> ComparatorIgnoreCase = new CharSequenceComparatorIgnoreCase();
    private final Object value;
    private int hash;

    public static CharSequence create(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        if (charSequence instanceof CharSequenceKey) {
            return (CharSequenceKey)charSequence;
        }
        if (charSequence instanceof String) {
            return new CharSequenceKey((String)charSequence);
        }
        return new CharSequenceKey(((Object)charSequence).toString());
    }

    public static CharSequence empty() {
        return EMPTY;
    }

    private CharSequenceKey(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            char c = cArray[i];
            if ((c & 0xFF) != c) {
                this.value = cArray;
                return;
            }
            byArray[i] = (byte)c;
        }
        this.value = byArray;
    }

    @Override
    public int length() {
        if (this.value instanceof byte[]) {
            return ((byte[])this.value).length;
        }
        return ((char[])this.value).length;
    }

    @Override
    public char charAt(int n) {
        if (this.value instanceof byte[]) {
            int n2 = ((byte[])this.value)[n] & 0xFF;
            return (char)n2;
        }
        return ((char[])this.value)[n];
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CharSequenceKey) {
            CharSequenceKey charSequenceKey = (CharSequenceKey)object;
            if (this.hash != 0 && charSequenceKey.hash != 0 && this.hash != charSequenceKey.hash) {
                return false;
            }
            if (this.value instanceof byte[] && charSequenceKey.value instanceof byte[]) {
                return Arrays.equals((byte[])this.value, (byte[])charSequenceKey.value);
            }
            if (this.value instanceof char[] && charSequenceKey.value instanceof char[]) {
                return Arrays.equals((char[])this.value, (char[])charSequenceKey.value);
            }
        }
        return false;
    }

    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            if (this.value instanceof byte[]) {
                byte[] byArray = (byte[])this.value;
                int n2 = byArray.length;
                for (int i = 0; i < n2; ++i) {
                    n = 31 * n + byArray[i];
                }
            } else {
                char[] cArray = (char[])this.value;
                int n3 = cArray.length;
                for (int i = 0; i < n3; ++i) {
                    n = 31 * n + cArray[i];
                }
            }
            this.hash = n;
        }
        return n;
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return new CharSequenceKey(this.toString().substring(n, n2));
    }

    @Override
    public String toString() {
        if (this.value instanceof byte[]) {
            byte[] byArray = (byte[])this.value;
            int n = byArray.length;
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                int n2 = byArray[i] & 0xFF;
                cArray[i] = (char)n2;
            }
            return new String(cArray);
        }
        char[] cArray = (char[])this.value;
        return new String(cArray);
    }

    @Override
    public int compareTo(CharSequenceKey charSequenceKey) {
        return Comparator.compare(this, charSequenceKey);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CharSequenceComparatorIgnoreCase
    implements Comparator<CharSequence> {
        private CharSequenceComparatorIgnoreCase() {
        }

        @Override
        public int compare(CharSequence charSequence, CharSequence charSequence2) {
            int n = charSequence.length();
            int n2 = charSequence2.length();
            int n3 = 0;
            for (int i = 0; n3 < n && i < n2; ++n3, ++i) {
                char c;
                char c2 = charSequence.charAt(n3);
                if (c2 == (c = charSequence2.charAt(i)) || (c2 = Character.toUpperCase(c2)) == (c = Character.toUpperCase(c)) || (c2 = Character.toLowerCase(c2)) == (c = Character.toLowerCase(c))) continue;
                return c2 - c;
            }
            return n - n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CharSequenceComparator
    implements Comparator<CharSequence> {
        private CharSequenceComparator() {
        }

        @Override
        public int compare(CharSequence charSequence, CharSequence charSequence2) {
            if (charSequence instanceof CharSequenceKey && charSequence2 instanceof CharSequenceKey) {
                CharSequenceKey charSequenceKey = (CharSequenceKey)charSequence;
                CharSequenceKey charSequenceKey2 = (CharSequenceKey)charSequence2;
                if (charSequenceKey.value instanceof byte[] && charSequenceKey2.value instanceof byte[]) {
                    byte[] byArray = (byte[])charSequenceKey.value;
                    byte[] byArray2 = (byte[])charSequenceKey2.value;
                    int n = byArray.length;
                    int n2 = byArray2.length;
                    int n3 = Math.min(n, n2);
                    for (int i = 0; i < n3; ++i) {
                        if (byArray[i] == byArray2[i]) continue;
                        return (byArray[i] & 0xFF) - (byArray2[i] & 0xFF);
                    }
                    return n - n2;
                }
            }
            int n = charSequence.length();
            int n4 = charSequence2.length();
            int n5 = Math.min(n, n4);
            for (int i = 0; i < n5; ++i) {
                char c;
                char c2 = charSequence.charAt(i);
                if (c2 == (c = charSequence2.charAt(i))) continue;
                return c2 - c;
            }
            return n - n4;
        }
    }
}

