/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.util;

import java.io.File;
import java.util.Set;
import org.netbeans.modules.mercurial.config.HgConfigFiles;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;

public class HgRepositoryContextCache {
    private static boolean hasHistory;
    private static String pushDefault;
    private static String pullDefault;
    private static File root;
    private static VCSContext rootCtx;
    private static Set<File> historyCtxRootFiles;
    private static Set<File> pushCtxRootFiles;
    private static Set<File> pullCtxRootFiles;

    public static boolean hasHistory(VCSContext vCSContext) {
        if (vCSContext == null) {
            return false;
        }
        Set set = vCSContext.getRootFiles();
        if (((Object)set).equals(historyCtxRootFiles)) {
            return hasHistory;
        }
        root = HgRepositoryContextCache.getRoot(vCSContext);
        hasHistory = HgCommand.hasHistory(root);
        historyCtxRootFiles = vCSContext.getRootFiles();
        return hasHistory;
    }

    public static void setHasHistory(VCSContext vCSContext) {
        historyCtxRootFiles = vCSContext.getRootFiles();
        hasHistory = true;
    }

    public static void resetPullDefault() {
        pullCtxRootFiles = null;
    }

    public static String getPullDefault(VCSContext vCSContext) {
        if (vCSContext == null) {
            return null;
        }
        Set set = vCSContext.getRootFiles();
        if (((Object)set).equals(pullCtxRootFiles)) {
            return pullDefault;
        }
        root = HgRepositoryContextCache.getRoot(vCSContext);
        pullDefault = new HgConfigFiles(root).getDefaultPull(true);
        pullCtxRootFiles = vCSContext.getRootFiles();
        return pullDefault;
    }

    public static void resetPushDefault() {
        pushCtxRootFiles = null;
    }

    public static String getPushDefault(VCSContext vCSContext) {
        if (vCSContext == null) {
            return null;
        }
        Set set = vCSContext.getRootFiles();
        if (((Object)set).equals(pushCtxRootFiles)) {
            return pushDefault;
        }
        root = HgRepositoryContextCache.getRoot(vCSContext);
        pushDefault = new HgConfigFiles(root).getDefaultPush(true);
        pushCtxRootFiles = vCSContext.getRootFiles();
        return pushDefault;
    }

    private static File getRoot(VCSContext vCSContext) {
        if (vCSContext == rootCtx && root != null) {
            return root;
        }
        root = HgUtils.getRootFile(vCSContext);
        rootCtx = vCSContext;
        return root;
    }
}

