/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.properties;

import java.awt.Font;
import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.properties.HgPropertiesNode;
import org.netbeans.modules.mercurial.ui.properties.PropertiesPanel;
import org.netbeans.modules.mercurial.ui.properties.PropertiesTable;
import org.netbeans.modules.mercurial.util.HgRepositoryContextCache;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class HgProperties
implements ListSelectionListener {
    public static final String HGPROPNAME_USERNAME = "username";
    public static final String HGPROPNAME_DEFAULT_PULL = "default-pull";
    public static final String HGPROPNAME_DEFAULT_PUSH = "default-push";
    private PropertiesPanel panel;
    private File root;
    private PropertiesTable propTable;
    private HgProgressSupport support;
    private File loadedValueFile;
    private Font fontTextArea;
    private HgPropertiesNode[] initHgProps;
    private int lastIndex = -1;

    public HgProperties(PropertiesPanel propertiesPanel, PropertiesTable propertiesTable, File file) {
        this.panel = propertiesPanel;
        this.propTable = propertiesTable;
        this.root = file;
        propertiesTable.getTable().getSelectionModel().setSelectionMode(0);
        propertiesTable.getTable().getSelectionModel().addListSelectionListener(this);
        this.refreshProperties();
    }

    public PropertiesPanel getPropertiesPanel() {
        return this.panel;
    }

    public void setPropertiesPanel(PropertiesPanel propertiesPanel) {
        this.panel = propertiesPanel;
    }

    public File getRoot() {
        return this.root;
    }

    public void setRoot(File file) {
        this.root = file;
    }

    protected String getPropertyValue() {
        return this.panel.txtAreaValue.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refreshProperties() {
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(this.root.getAbsolutePath());
        try {
            this.support = new HgProgressSupport(){

                protected void perform() {
                    Properties properties = HgModuleConfig.getDefault().getProperties(HgProperties.this.root);
                    HgPropertiesNode[] hgPropertiesNodeArray = new HgPropertiesNode[properties.size()];
                    HgProperties.access$102(HgProperties.this, new HgPropertiesNode[properties.size()]);
                    int n = 0;
                    Enumeration<?> enumeration = properties.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        String string2 = properties.getProperty(string);
                        String string3 = string2 != null ? string2 : "";
                        hgPropertiesNodeArray[n] = new HgPropertiesNode(string, string3);
                        ((HgProperties)HgProperties.this).initHgProps[n] = new HgPropertiesNode(string, string3);
                        ++n;
                    }
                    HgProperties.this.propTable.setNodes(hgPropertiesNodeArray);
                }
            };
            this.support.start(requestProcessor, this.root.getAbsolutePath(), NbBundle.getMessage(HgProperties.class, (String)"LBL_Properties_Progress"));
            Object var3_2 = null;
            this.support = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.support = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties() {
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(this.root.getAbsolutePath());
        try {
            this.support = new HgProgressSupport(){

                protected void perform() {
                    HgPropertiesNode[] hgPropertiesNodeArray = HgProperties.this.propTable.getNodes();
                    for (int i = 0; i < hgPropertiesNodeArray.length; ++i) {
                        boolean bl;
                        String string = hgPropertiesNodeArray[i].getName();
                        String string2 = hgPropertiesNodeArray[i].getValue();
                        boolean bl2 = bl = !HgProperties.this.initHgProps[i].getValue().equals(string2);
                        if (!bl || string2.trim().length() < 0) continue;
                        if (string.equals(HgProperties.HGPROPNAME_USERNAME) && !HgModuleConfig.getDefault().isUserNameValid(string2).booleanValue()) {
                            JOptionPane.showMessageDialog(null, NbBundle.getMessage(HgProperties.class, (String)"MSG_WARN_USER_NAME_TEXT"), NbBundle.getMessage(HgProperties.class, (String)"MSG_WARN_FIELD_TITLE"), 2);
                            continue;
                        }
                        HgModuleConfig.getDefault().setProperty(HgProperties.this.root, string, string2);
                    }
                    HgRepositoryContextCache.resetPullDefault();
                    HgRepositoryContextCache.resetPushDefault();
                }
            };
            this.support.start(requestProcessor, this.root.getAbsolutePath(), NbBundle.getMessage(HgProperties.class, (String)"LBL_Properties_Progress"));
            Object var3_2 = null;
            this.support = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.support = null;
            throw throwable;
        }
    }

    public void updateLastSelection() {
        HgPropertiesNode[] hgPropertiesNodeArray = this.propTable.getNodes();
        if (this.lastIndex >= 0) {
            hgPropertiesNodeArray[this.lastIndex].setValue(this.getPropertyValue());
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.propTable.getTable().getSelectedRow();
        if (n < 0) {
            this.lastIndex = -1;
            return;
        }
        HgPropertiesNode[] hgPropertiesNodeArray = this.propTable.getNodes();
        if (this.lastIndex >= 0) {
            hgPropertiesNodeArray[this.lastIndex].setValue(this.getPropertyValue());
        }
        this.panel.txtAreaValue.setText(hgPropertiesNodeArray[n].getValue());
        this.lastIndex = n;
    }

    static /* synthetic */ HgPropertiesNode[] access$102(HgProperties hgProperties, HgPropertiesNode[] hgPropertiesNodeArray) {
        hgProperties.initHgProps = hgPropertiesNodeArray;
        return hgPropertiesNodeArray;
    }
}

