/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.FieldBreakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.modules.debugger.jpda.projects.DebuggerBreakpointAnnotation;
import org.netbeans.modules.debugger.jpda.projects.EditorContextImpl;
import org.netbeans.modules.debugger.jpda.projects.LineTranslations;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotation;
import org.openide.text.AnnotationProvider;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;

public class BreakpointAnnotationProvider
implements AnnotationProvider,
DebuggerManagerListener {
    private Map<JPDABreakpoint, Annotation[]> breakpointToAnnotations;
    private Set<FileObject> annotatedFiles;
    private Set<PropertyChangeListener> dataObjectListeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(Line.Set set, Lookup lookup) {
        FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
        if (fileObject != null) {
            DataObject dataObject = (DataObject)lookup.lookup(DataObject.class);
            if (dataObject != null) {
                PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("primaryFile".equals(propertyChangeEvent.getPropertyName())) {
                            DataObject dataObject = (DataObject)propertyChangeEvent.getSource();
                            FileObject fileObject = dataObject.getPrimaryFile();
                            BreakpointAnnotationProvider.this.annotate(fileObject);
                        }
                    }
                };
                dataObject.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)propertyChangeListener, (Object)dataObject));
                BreakpointAnnotationProvider breakpointAnnotationProvider = this;
                synchronized (breakpointAnnotationProvider) {
                    if (this.dataObjectListeners == null) {
                        this.dataObjectListeners = new HashSet<PropertyChangeListener>();
                    }
                    this.dataObjectListeners.add(propertyChangeListener);
                }
            }
            this.annotate(fileObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(FileObject fileObject) {
        boolean bl = false;
        Object object = this;
        synchronized (object) {
            if (this.breakpointToAnnotations == null) {
                this.breakpointToAnnotations = new HashMap<JPDABreakpoint, Annotation[]>();
                this.annotatedFiles = new WeakSet();
                bl = true;
            }
        }
        object = this.breakpointToAnnotations;
        synchronized (object) {
            if (this.annotatedFiles.contains(fileObject)) {
                return;
            }
            Set<JPDABreakpoint> set = this.breakpointToAnnotations.keySet();
            for (Breakpoint breakpoint : DebuggerManager.getDebuggerManager().getBreakpoints()) {
                if (!BreakpointAnnotationProvider.isAnnotatable(breakpoint)) continue;
                JPDABreakpoint jPDABreakpoint = (JPDABreakpoint)breakpoint;
                if (!set.contains(jPDABreakpoint)) {
                    jPDABreakpoint.addPropertyChangeListener((PropertyChangeListener)((Object)this));
                    this.breakpointToAnnotations.put(jPDABreakpoint, new Annotation[0]);
                    if (jPDABreakpoint instanceof LineBreakpoint) {
                        LineBreakpoint lineBreakpoint = (LineBreakpoint)jPDABreakpoint;
                        LineTranslations.getTranslations().registerForLineUpdates(lineBreakpoint);
                    }
                }
                this.addAnnotationTo(jPDABreakpoint, fileObject);
            }
            this.annotatedFiles.add(fileObject);
        }
        if (bl) {
            DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)WeakListeners.create(DebuggerManagerListener.class, (EventListener)((Object)this), (Object)DebuggerManager.getDebuggerManager()));
        }
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        if (BreakpointAnnotationProvider.isAnnotatable(breakpoint)) {
            JPDABreakpoint jPDABreakpoint = (JPDABreakpoint)breakpoint;
            jPDABreakpoint.addPropertyChangeListener((PropertyChangeListener)((Object)this));
            RequestProcessor.getDefault().post((Runnable)new AnnotationRefresh(jPDABreakpoint, false, true));
            if (jPDABreakpoint instanceof LineBreakpoint) {
                LineBreakpoint lineBreakpoint = (LineBreakpoint)jPDABreakpoint;
                LineTranslations.getTranslations().registerForLineUpdates(lineBreakpoint);
            }
        }
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        if (BreakpointAnnotationProvider.isAnnotatable(breakpoint)) {
            JPDABreakpoint jPDABreakpoint = (JPDABreakpoint)breakpoint;
            jPDABreakpoint.removePropertyChangeListener((PropertyChangeListener)((Object)this));
            RequestProcessor.getDefault().post((Runnable)new AnnotationRefresh(jPDABreakpoint, true, false));
            if (jPDABreakpoint instanceof LineBreakpoint) {
                LineBreakpoint lineBreakpoint = (LineBreakpoint)jPDABreakpoint;
                LineTranslations.getTranslations().unregisterFromLineUpdates(lineBreakpoint);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == null) {
            return;
        }
        if (!("enabled".equals(string) || "validity".equals(string) || "condition".equals(string) || "url".equals(string) || "lineNumber".equals(string) || "className".equals(string) || "fieldName".equals(string) || "classFilters".equals(string) || "classExclusionFilters".equals(string) || "methodName".equals(string) || "signature".equals(string))) {
            return;
        }
        JPDABreakpoint jPDABreakpoint = (JPDABreakpoint)propertyChangeEvent.getSource();
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        Breakpoint[] breakpointArray = debuggerManager.getBreakpoints();
        boolean bl = false;
        for (int i = 0; i < breakpointArray.length; ++i) {
            if (jPDABreakpoint != breakpointArray[i]) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        RequestProcessor.getDefault().post((Runnable)new AnnotationRefresh(jPDABreakpoint, true, true));
    }

    private static boolean isAnnotatable(Breakpoint breakpoint) {
        return (breakpoint instanceof LineBreakpoint || breakpoint instanceof FieldBreakpoint || breakpoint instanceof MethodBreakpoint) && !((JPDABreakpoint)breakpoint).isHidden();
    }

    private static String getAnnotationType(JPDABreakpoint jPDABreakpoint, boolean bl) {
        String string;
        boolean bl2;
        boolean bl3 = bl2 = jPDABreakpoint.getValidity() == Breakpoint.VALIDITY.INVALID;
        if (jPDABreakpoint instanceof LineBreakpoint) {
            string = jPDABreakpoint.isEnabled() ? (bl ? "CondBreakpoint" : "Breakpoint") : (bl ? "DisabledCondBreakpoint" : "DisabledBreakpoint");
        } else if (jPDABreakpoint instanceof FieldBreakpoint) {
            string = jPDABreakpoint.isEnabled() ? "FieldBreakpoint" : "DisabledFieldBreakpoint";
        } else if (jPDABreakpoint instanceof MethodBreakpoint) {
            string = jPDABreakpoint.isEnabled() ? "MethodBreakpoint" : "DisabledMethodBreakpoint";
        } else {
            throw new IllegalStateException(jPDABreakpoint.toString());
        }
        if (bl2 && jPDABreakpoint.isEnabled()) {
            string = string + "_broken";
        }
        return string;
    }

    private static int[] getAnnotationLines(JPDABreakpoint jPDABreakpoint, FileObject fileObject) {
        if (jPDABreakpoint instanceof LineBreakpoint) {
            LineBreakpoint lineBreakpoint = (LineBreakpoint)jPDABreakpoint;
            try {
                if (fileObject.getURL().equals(new URL(lineBreakpoint.getURL()))) {
                    return new int[]{lineBreakpoint.getLineNumber()};
                }
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
            return null;
        }
        if (jPDABreakpoint instanceof FieldBreakpoint) {
            FieldBreakpoint fieldBreakpoint = (FieldBreakpoint)jPDABreakpoint;
            String string = fieldBreakpoint.getClassName();
            String string2 = fieldBreakpoint.getFieldName();
            int n = EditorContextImpl.getFieldLineNumber(fileObject, string, string2);
            return new int[]{n};
        }
        if (jPDABreakpoint instanceof MethodBreakpoint) {
            MethodBreakpoint methodBreakpoint = (MethodBreakpoint)jPDABreakpoint;
            String[] stringArray = methodBreakpoint.getClassFilters();
            int[] nArray = new int[]{};
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith("*") || stringArray[i].endsWith("*")) continue;
                int[] nArray2 = EditorContextImpl.getMethodLineNumbers(fileObject, stringArray[i], methodBreakpoint.getClassExclusionFilters(), methodBreakpoint.getMethodName(), methodBreakpoint.getMethodSignature());
                if (nArray.length == 0) {
                    nArray = nArray2;
                    continue;
                }
                int[] nArray3 = new int[nArray.length + nArray2.length];
                System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
                System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
                nArray = nArray3;
            }
            return nArray;
        }
        throw new IllegalStateException(jPDABreakpoint.toString());
    }

    private void addAnnotationTo(JPDABreakpoint jPDABreakpoint, FileObject fileObject) {
        int n;
        DataObject dataObject;
        String string;
        int[] nArray = BreakpointAnnotationProvider.getAnnotationLines(jPDABreakpoint, fileObject);
        if (nArray == null || nArray.length == 0) {
            return;
        }
        if (jPDABreakpoint instanceof LineBreakpoint) {
            string = ((LineBreakpoint)jPDABreakpoint).getCondition();
        } else if (jPDABreakpoint instanceof FieldBreakpoint) {
            string = ((FieldBreakpoint)jPDABreakpoint).getCondition();
        } else if (jPDABreakpoint instanceof MethodBreakpoint) {
            string = ((MethodBreakpoint)jPDABreakpoint).getCondition();
        } else {
            throw new IllegalStateException(jPDABreakpoint.toString());
        }
        boolean bl = string != null && string.trim().length() > 0;
        String string2 = BreakpointAnnotationProvider.getAnnotationType(jPDABreakpoint, bl);
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace();
            return;
        }
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        if (lineCookie == null) {
            return;
        }
        ArrayList<DebuggerBreakpointAnnotation> arrayList = new ArrayList<DebuggerBreakpointAnnotation>();
        int[] objectArray = nArray;
        int annotationArray = objectArray.length;
        for (n = 0; n < annotationArray; ++n) {
            int n2 = objectArray[n];
            try {
                Line indexOutOfBoundsException = lineCookie.getLineSet().getCurrent(n2 - 1);
                DebuggerBreakpointAnnotation debuggerBreakpointAnnotation = new DebuggerBreakpointAnnotation(string2, indexOutOfBoundsException, jPDABreakpoint);
                arrayList.add(debuggerBreakpointAnnotation);
                continue;
            }
            catch (IndexOutOfBoundsException illegalArgumentException) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (arrayList.size() == 0) {
            return;
        }
        Object[] objectArray2 = this.breakpointToAnnotations.get(jPDABreakpoint);
        if (objectArray2 == null || objectArray2.length == 0) {
            this.breakpointToAnnotations.put(jPDABreakpoint, arrayList.toArray(new Annotation[0]));
        } else {
            Annotation[] annotationArray2 = new Annotation[objectArray2.length + arrayList.size()];
            System.arraycopy(objectArray2, 0, annotationArray2, 0, objectArray2.length);
            for (n = 0; n < arrayList.size(); ++n) {
                annotationArray2[n + objectArray2.length] = (Annotation)arrayList.get(n);
            }
            this.breakpointToAnnotations.put(jPDABreakpoint, annotationArray2);
        }
    }

    private void removeAnnotations(JPDABreakpoint jPDABreakpoint) {
        Annotation[] annotationArray = this.breakpointToAnnotations.remove(jPDABreakpoint);
        if (annotationArray == null) {
            return;
        }
        for (Annotation annotation : annotationArray) {
            annotation.detach();
        }
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void initWatches() {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void engineAdded(DebuggerEngine debuggerEngine) {
    }

    public void engineRemoved(DebuggerEngine debuggerEngine) {
    }

    private final class AnnotationRefresh
    implements Runnable {
        private JPDABreakpoint b;
        private boolean remove;
        private boolean add;

        public AnnotationRefresh(JPDABreakpoint jPDABreakpoint, boolean bl, boolean bl2) {
            this.b = jPDABreakpoint;
            this.remove = bl;
            this.add = bl2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Map map = BreakpointAnnotationProvider.this.breakpointToAnnotations;
            synchronized (map) {
                if (this.remove) {
                    BreakpointAnnotationProvider.this.removeAnnotations(this.b);
                    if (!this.add) {
                        BreakpointAnnotationProvider.this.breakpointToAnnotations.remove(this.b);
                    }
                }
                if (this.add) {
                    BreakpointAnnotationProvider.this.breakpointToAnnotations.put(this.b, new Annotation[0]);
                    for (FileObject fileObject : BreakpointAnnotationProvider.this.annotatedFiles) {
                        BreakpointAnnotationProvider.this.addAnnotationTo(this.b, fileObject);
                    }
                }
            }
        }
    }
}

