/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.model.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.tools.Diagnostic;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private static final String VALUE = "value";

    public static String getUriTemplate(Element element) {
        return Utils.getAnnotationValue(element, "javax.ws.rs.Path", VALUE);
    }

    public static String getConsumeMime(Element element) {
        return Utils.getAnnotationValue(element, "javax.ws.rs.Consumes", VALUE);
    }

    public static String getProduceMime(Element element) {
        return Utils.getAnnotationValue(element, "javax.ws.rs.Produces", VALUE);
    }

    public static String getHttpMethod(Element element) {
        if (Utils.hasAnnotationType(element, "javax.ws.rs.GET")) {
            return "GET";
        }
        if (Utils.hasAnnotationType(element, "javax.ws.rs.POST")) {
            return "POST";
        }
        if (Utils.hasAnnotationType(element, "javax.ws.rs.PUT")) {
            return "PUT";
        }
        if (Utils.hasAnnotationType(element, "javax.ws.rs.DELETE")) {
            return "DELETE";
        }
        return null;
    }

    public static boolean hasUriTemplate(Element element) {
        return Utils.hasAnnotationType(element, "javax.ws.rs.Path");
    }

    public static boolean hasHttpMethod(Element element) {
        return element.getKind() == ElementKind.METHOD && (Utils.hasAnnotationType(element, "javax.ws.rs.GET") || Utils.hasAnnotationType(element, "javax.ws.rs.POST") || Utils.hasAnnotationType(element, "javax.ws.rs.PUT") || Utils.hasAnnotationType(element, "javax.ws.rs.DELETE"));
    }

    public static boolean hasConsumeMime(Element element) {
        return Utils.hasAnnotationType(element, "javax.ws.rs.Consumes");
    }

    public static boolean hasProduceMime(Element element) {
        return Utils.hasAnnotationType(element, "javax.ws.rs.Produces");
    }

    private static String getAnnotationValue(Element element, String string, String string2) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(string)) continue;
            for (ExecutableElement executableElement : annotationMirror.getElementValues().keySet()) {
                if (!executableElement.getSimpleName().toString().equals(string2)) continue;
                String string3 = ((Object)annotationMirror.getElementValues().get(executableElement)).toString();
                string3 = Utils.stripQuotes(string3);
                return string3;
            }
        }
        return "";
    }

    private static boolean hasAnnotationType(Element element, String string) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(string)) continue;
            return true;
        }
        return false;
    }

    private static String stripQuotes(String string) {
        return string.substring(string.indexOf("\"") + 1, string.lastIndexOf("\""));
    }

    public static boolean checkForJsr311Bootstrap(TypeElement typeElement, Project project) {
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        if (restSupport != null && !restSupport.isRestSupportOn() && Utils.hasJsr311ApiError(typeElement, restSupport)) {
            try {
                restSupport.ensureRestDevelopmentReady();
                return true;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return false;
    }

    private static boolean hasJsr311ApiError(TypeElement typeElement, RestSupport restSupport) {
        TypeElement typeElement2 = SourceUtils.getOutermostEnclosingTypeElement((Element)typeElement);
        ClasspathInfo classpathInfo = Utils.getClassPathInfo(restSupport);
        if (classpathInfo != null) {
            FileObject fileObject = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)typeElement2), (ClasspathInfo)classpathInfo);
            for (String string : Utils.getDiagnostics(fileObject)) {
                if (!string.equals("javax.ws.rs.Path") && !string.equals("javax.ws.rs.GET") && !string.equals("javax.ws.rs.PUT") && !string.equals("javax.ws.rs.POST") && !string.equals("javax.ws.rs.DELETE")) continue;
                return true;
            }
        }
        return false;
    }

    public static ClasspathInfo getClassPathInfo(RestSupport restSupport) {
        FileObject fileObject = restSupport.findSourceRoot();
        if (fileObject != null) {
            return ClasspathInfo.create((FileObject)fileObject);
        }
        return null;
    }

    public static List<String> getDiagnostics(FileObject fileObject) {
        final ArrayList<String> arrayList = new ArrayList<String>();
        if (fileObject == null) {
            return arrayList;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    Document document = compilationController.getDocument();
                    if (document != null) {
                        for (Diagnostic diagnostic : compilationController.getDiagnostics()) {
                            if (Diagnostic.Kind.ERROR != diagnostic.getKind()) continue;
                            try {
                                int n = (int)diagnostic.getStartPosition();
                                int n2 = (int)diagnostic.getEndPosition() - n;
                                String string = document.getText(n, n2);
                                arrayList.add(string);
                            }
                            catch (BadLocationException badLocationException) {}
                        }
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return arrayList;
    }
}

