/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.model.impl;

import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.netbeans.modules.websvc.rest.model.api.HttpMethod;
import org.netbeans.modules.websvc.rest.model.impl.RestMethodDescriptionImpl;
import org.netbeans.modules.websvc.rest.model.impl.RestServicesImpl;
import org.netbeans.modules.websvc.rest.model.impl.Utils;

public class HttpMethodImpl
extends RestMethodDescriptionImpl
implements HttpMethod {
    private String type;
    private String consumeMime;
    private String produceMime;

    public HttpMethodImpl(ExecutableElement executableElement) {
        super(executableElement);
        this.type = Utils.getHttpMethod(executableElement);
        this.consumeMime = Utils.getConsumeMime(executableElement);
        this.produceMime = Utils.getProduceMime(executableElement);
    }

    public String getType() {
        return this.type;
    }

    public String getConsumeMime() {
        return this.consumeMime;
    }

    public String getProduceMime() {
        return this.produceMime;
    }

    public RestServicesImpl.Status refresh(Element element) {
        boolean bl = false;
        if (super.refresh(element) == RestServicesImpl.Status.MODIFIED) {
            bl = true;
        }
        if (!Utils.hasHttpMethod(element)) {
            return RestServicesImpl.Status.REMOVED;
        }
        String string = Utils.getConsumeMime(element);
        if (!this.consumeMime.equals(string)) {
            this.consumeMime = string;
            bl = true;
        }
        if (!this.produceMime.equals(string = Utils.getProduceMime(element))) {
            this.produceMime = string;
            bl = true;
        }
        if (bl) {
            return RestServicesImpl.Status.MODIFIED;
        }
        return RestServicesImpl.Status.UNMODIFIED;
    }
}

