/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class Block {
    private RubyProc proc = null;
    public Type type = Type.NORMAL;
    private final Binding binding;
    private final BlockBody body;
    private boolean[] escaped = new boolean[]{false};
    public static final Block NULL_BLOCK = new Block(){

        public IRubyObject yield(ThreadContext context, IRubyObject value2, IRubyObject self, RubyModule klass, boolean aValue) {
            throw context.getRuntime().newLocalJumpError("noreason", value2, "yield called out of block");
        }

        public IRubyObject call(ThreadContext context, IRubyObject[] args2) {
            throw context.getRuntime().newLocalJumpError("noreason", context.getRuntime().newArrayNoCopy(args2), "yield called out of block");
        }

        public IRubyObject yield(ThreadContext context, IRubyObject value2) {
            throw context.getRuntime().newLocalJumpError("noreason", value2, "yield called out of block");
        }

        public Block cloneBlock() {
            return this;
        }

        public BlockBody getBody() {
            return BlockBody.NULL_BODY;
        }
    };

    protected Block() {
        this(null, null);
    }

    public Block(BlockBody body, Binding binding2) {
        this.body = body;
        this.binding = binding2;
    }

    public IRubyObject call(ThreadContext context, IRubyObject[] args2) {
        return this.body.call(context, args2, this.binding, this.type);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value2) {
        return this.body.yield(context, value2, this.binding, this.type);
    }

    public IRubyObject yield(ThreadContext context, IRubyObject value2, IRubyObject self, RubyModule klass, boolean aValue) {
        return this.body.yield(context, value2, self, klass, aValue, this.binding, this.type);
    }

    public Block cloneBlock() {
        Block newBlock = this.body.cloneBlock(this.binding);
        newBlock.type = this.type;
        newBlock.escaped = this.escaped;
        return newBlock;
    }

    public Arity arity() {
        return this.body.arity();
    }

    public RubyProc getProcObject() {
        return this.proc;
    }

    public void setProcObject(RubyProc procObject) {
        this.proc = procObject;
    }

    public final boolean isGiven() {
        return this != NULL_BLOCK;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public BlockBody getBody() {
        return this.body;
    }

    public Frame getFrame() {
        return this.binding.getFrame();
    }

    public boolean isEscaped() {
        return this.escaped[0];
    }

    public void escape() {
        this.escaped[0] = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        NORMAL,
        PROC,
        LAMBDA,
        THREAD;

    }
}

