/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import java.util.HashSet;
import java.util.Set;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BinaryOperatorNode;
import org.jruby.ast.BlockAcceptingNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.DotNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IArgumentNode;
import org.jruby.ast.IScopingNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.Node;
import org.jruby.ast.NotNode;
import org.jruby.ast.OpAsgnAndNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.PostExeNode;
import org.jruby.ast.PreExeNode;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SplatNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.ToAryNode;
import org.jruby.ast.TrueNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.ast.types.INameNode;
import org.jruby.util.SafePropertyAccessor;

public class ASTInspector {
    private boolean hasBlockArg;
    private boolean hasClosure;
    private boolean hasClass;
    private boolean hasDef;
    private boolean hasEval;
    private boolean hasFrameAwareMethods;
    private boolean hasOptArgs;
    private boolean hasRestArg;
    private boolean hasScopeAwareMethods;
    private boolean noFrame;
    public static Set<String> FRAME_AWARE_METHODS = new HashSet<String>();
    private static Set<String> SCOPE_AWARE_METHODS = new HashSet<String>();
    public static Set<String> PRAGMAS = new HashSet<String>();
    public static final boolean ENABLED;

    public void disable() {
        this.hasClosure = true;
        this.hasClass = true;
        this.hasDef = true;
        this.hasScopeAwareMethods = true;
        this.hasFrameAwareMethods = true;
        this.hasBlockArg = true;
        this.hasOptArgs = true;
        this.hasRestArg = true;
    }

    public static ASTInspector subInspect(Node ... nodes) {
        ASTInspector newInspector = new ASTInspector();
        for (Node node : nodes) {
            newInspector.inspect(node);
        }
        return newInspector;
    }

    public void integrate(ASTInspector other) {
        this.hasBlockArg |= other.hasBlockArg;
        this.hasClass |= other.hasClass;
        this.hasClosure |= other.hasClosure;
        this.hasDef |= other.hasDef;
        this.hasFrameAwareMethods |= other.hasFrameAwareMethods;
        this.hasOptArgs |= other.hasOptArgs;
        this.hasRestArg |= other.hasRestArg;
        this.hasScopeAwareMethods |= other.hasScopeAwareMethods;
    }

    public void inspect(Node node) {
        if (!ENABLED) {
            this.disable();
        }
        if (node == null) {
            return;
        }
        switch (node.nodeId) {
            case ALIASNODE: {
                break;
            }
            case ANDNODE: {
                AndNode andNode = (AndNode)node;
                this.inspect(andNode.getFirstNode());
                this.inspect(andNode.getSecondNode());
                break;
            }
            case ARGSCATNODE: {
                ArgsCatNode argsCatNode = (ArgsCatNode)node;
                this.inspect(argsCatNode.getFirstNode());
                this.inspect(argsCatNode.getSecondNode());
                break;
            }
            case ARGSPUSHNODE: {
                ArgsPushNode argsPushNode = (ArgsPushNode)node;
                this.inspect(argsPushNode.getFirstNode());
                this.inspect(argsPushNode.getSecondNode());
                break;
            }
            case ARGUMENTNODE: {
                break;
            }
            case ARRAYNODE: 
            case BLOCKNODE: 
            case DREGEXPNODE: 
            case DSTRNODE: 
            case DSYMBOLNODE: 
            case DXSTRNODE: 
            case LISTNODE: {
                ListNode listNode = (ListNode)node;
                for (int i = 0; i < listNode.size(); ++i) {
                    this.inspect(listNode.get(i));
                }
                break;
            }
            case ARGSNODE: {
                ArgsNode argsNode = (ArgsNode)node;
                if (argsNode.getBlockArgNode() != null) {
                    this.hasBlockArg = true;
                }
                if (argsNode.getOptArgs() != null) {
                    this.hasOptArgs = true;
                    this.inspect(argsNode.getOptArgs());
                }
                if (argsNode.getRestArg() != -2 && argsNode.getRestArg() < 0) break;
                this.hasRestArg = true;
                break;
            }
            case ATTRASSIGNNODE: {
                AttrAssignNode attrAssignNode = (AttrAssignNode)node;
                this.inspect(attrAssignNode.getArgsNode());
                this.inspect(attrAssignNode.getReceiverNode());
                break;
            }
            case BACKREFNODE: {
                this.hasFrameAwareMethods = true;
                break;
            }
            case BEGINNODE: {
                this.inspect(((BeginNode)node).getBodyNode());
                break;
            }
            case BIGNUMNODE: {
                break;
            }
            case BINARYOPERATORNODE: {
                BinaryOperatorNode binaryOperatorNode = (BinaryOperatorNode)((Object)node);
                this.inspect(binaryOperatorNode.getFirstNode());
                this.inspect(binaryOperatorNode.getSecondNode());
                break;
            }
            case BLOCKARGNODE: {
                break;
            }
            case BLOCKPASSNODE: {
                BlockPassNode blockPassNode = (BlockPassNode)node;
                this.inspect(blockPassNode.getArgsNode());
                this.inspect(blockPassNode.getBodyNode());
                break;
            }
            case BREAKNODE: {
                this.inspect(((BreakNode)node).getValueNode());
                break;
            }
            case CALLNODE: {
                CallNode callNode = (CallNode)node;
                this.inspect(callNode.getReceiverNode());
            }
            case FCALLNODE: {
                this.inspect(((IArgumentNode)((Object)node)).getArgsNode());
                this.inspect(((BlockAcceptingNode)((Object)node)).getIterNode());
            }
            case VCALLNODE: {
                INameNode nameNode = (INameNode)((Object)node);
                if (FRAME_AWARE_METHODS.contains(nameNode.getName())) {
                    this.hasFrameAwareMethods = true;
                    this.hasEval |= nameNode.getName().indexOf("eval") != -1;
                }
                if (!SCOPE_AWARE_METHODS.contains(nameNode.getName())) break;
                this.hasScopeAwareMethods = true;
                break;
            }
            case CASENODE: {
                CaseNode caseNode = (CaseNode)node;
                this.inspect(caseNode.getCaseNode());
                this.inspect(caseNode.getFirstWhenNode());
                break;
            }
            case CLASSNODE: {
                this.hasScopeAwareMethods = true;
                this.hasClass = true;
                break;
            }
            case CLASSVARNODE: {
                this.hasScopeAwareMethods = true;
                break;
            }
            case CONSTDECLNODE: {
                this.inspect(((AssignableNode)node).getValueNode());
                this.hasScopeAwareMethods = true;
                break;
            }
            case CLASSVARASGNNODE: {
                this.inspect(((AssignableNode)node).getValueNode());
                this.hasScopeAwareMethods = true;
                break;
            }
            case CLASSVARDECLNODE: {
                this.inspect(((AssignableNode)node).getValueNode());
                this.hasScopeAwareMethods = true;
                break;
            }
            case COLON2NODE: {
                this.inspect(((Colon2Node)node).getLeftNode());
                break;
            }
            case COLON3NODE: {
                break;
            }
            case CONSTNODE: {
                this.hasScopeAwareMethods = true;
                break;
            }
            case DEFNNODE: 
            case DEFSNODE: {
                this.hasDef = true;
                this.hasScopeAwareMethods = true;
                break;
            }
            case DEFINEDNODE: {
                this.disable();
                break;
            }
            case DOTNODE: {
                DotNode dotNode = (DotNode)node;
                this.inspect(dotNode.getBeginNode());
                this.inspect(dotNode.getEndNode());
                break;
            }
            case DASGNNODE: {
                this.inspect(((AssignableNode)node).getValueNode());
                break;
            }
            case DVARNODE: {
                break;
            }
            case ENSURENODE: {
                this.disable();
                break;
            }
            case EVSTRNODE: {
                this.inspect(((EvStrNode)node).getBody());
                break;
            }
            case FALSENODE: {
                break;
            }
            case FIXNUMNODE: {
                break;
            }
            case FLIPNODE: {
                this.inspect(((FlipNode)node).getBeginNode());
                this.inspect(((FlipNode)node).getEndNode());
                break;
            }
            case FLOATNODE: {
                break;
            }
            case FORNODE: {
                this.hasClosure = true;
                this.hasScopeAwareMethods = true;
                this.hasFrameAwareMethods = true;
                this.inspect(((ForNode)node).getIterNode());
                this.inspect(((ForNode)node).getBodyNode());
                this.inspect(((ForNode)node).getVarNode());
                break;
            }
            case GLOBALASGNNODE: {
                GlobalAsgnNode globalAsgnNode = (GlobalAsgnNode)node;
                if (!globalAsgnNode.getName().equals("$_") && !globalAsgnNode.getName().equals("$~")) break;
                this.hasScopeAwareMethods = true;
                break;
            }
            case GLOBALVARNODE: {
                if (((GlobalVarNode)node).getName().equals("$_")) {
                    this.hasFrameAwareMethods = true;
                    break;
                }
                if (!((GlobalVarNode)node).getName().equals("$~")) break;
                this.hasFrameAwareMethods = true;
                break;
            }
            case HASHNODE: {
                HashNode hashNode = (HashNode)node;
                this.inspect(hashNode.getListNode());
                break;
            }
            case IFNODE: {
                IfNode ifNode = (IfNode)node;
                this.inspect(ifNode.getCondition());
                this.inspect(ifNode.getThenBody());
                this.inspect(ifNode.getElseBody());
                break;
            }
            case INSTASGNNODE: {
                this.inspect(((AssignableNode)node).getValueNode());
                break;
            }
            case INSTVARNODE: {
                break;
            }
            case ISCOPINGNODE: {
                IScopingNode iscopingNode = (IScopingNode)((Object)node);
                this.inspect(iscopingNode.getCPath());
                break;
            }
            case ITERNODE: {
                this.hasClosure = true;
                this.hasFrameAwareMethods = true;
                break;
            }
            case LOCALASGNNODE: {
                LocalAsgnNode localAsgnNode = (LocalAsgnNode)node;
                if (PRAGMAS.contains(localAsgnNode.getName())) {
                    if (!localAsgnNode.getName().equals("__NOFRAME__")) break;
                    this.noFrame = localAsgnNode.getValueNode() instanceof TrueNode;
                    break;
                }
                this.inspect(localAsgnNode.getValueNode());
                break;
            }
            case LOCALVARNODE: {
                break;
            }
            case MATCHNODE: {
                this.inspect(((MatchNode)node).getRegexpNode());
                this.hasFrameAwareMethods = true;
                break;
            }
            case MATCH2NODE: {
                Match2Node match2Node = (Match2Node)node;
                this.inspect(match2Node.getReceiverNode());
                this.inspect(match2Node.getValueNode());
                this.hasFrameAwareMethods = true;
                break;
            }
            case MATCH3NODE: {
                Match3Node match3Node = (Match3Node)node;
                this.inspect(match3Node.getReceiverNode());
                this.inspect(match3Node.getValueNode());
                this.hasFrameAwareMethods = true;
                break;
            }
            case MODULENODE: {
                this.hasClass = true;
                this.hasScopeAwareMethods = true;
                break;
            }
            case MULTIPLEASGNNODE: {
                MultipleAsgnNode multipleAsgnNode = (MultipleAsgnNode)node;
                this.inspect(multipleAsgnNode.getArgsNode());
                this.inspect(multipleAsgnNode.getHeadNode());
                this.inspect(multipleAsgnNode.getValueNode());
                break;
            }
            case NEWLINENODE: {
                this.inspect(((NewlineNode)node).getNextNode());
                break;
            }
            case NEXTNODE: {
                this.inspect(((NextNode)node).getValueNode());
                break;
            }
            case NILNODE: {
                break;
            }
            case NOTNODE: {
                this.inspect(((NotNode)node).getConditionNode());
                break;
            }
            case NTHREFNODE: {
                break;
            }
            case OPASGNANDNODE: {
                OpAsgnAndNode opAsgnAndNode = (OpAsgnAndNode)node;
                this.inspect(opAsgnAndNode.getFirstNode());
                this.inspect(opAsgnAndNode.getSecondNode());
                break;
            }
            case OPASGNNODE: {
                OpAsgnNode opAsgnNode = (OpAsgnNode)node;
                this.inspect(opAsgnNode.getReceiverNode());
                this.inspect(opAsgnNode.getValueNode());
                break;
            }
            case OPASGNORNODE: {
                this.disable();
                break;
            }
            case OPELEMENTASGNNODE: {
                OpElementAsgnNode opElementAsgnNode = (OpElementAsgnNode)node;
                this.inspect(opElementAsgnNode.getArgsNode());
                this.inspect(opElementAsgnNode.getReceiverNode());
                this.inspect(opElementAsgnNode.getValueNode());
                break;
            }
            case ORNODE: {
                OrNode orNode = (OrNode)node;
                this.inspect(orNode.getFirstNode());
                this.inspect(orNode.getSecondNode());
                break;
            }
            case POSTEXENODE: {
                PostExeNode postExeNode = (PostExeNode)node;
                this.hasClosure = true;
                this.hasFrameAwareMethods = true;
                this.hasScopeAwareMethods = true;
                this.inspect(postExeNode.getBodyNode());
                this.inspect(postExeNode.getVarNode());
                break;
            }
            case PREEXENODE: {
                PreExeNode preExeNode = (PreExeNode)node;
                this.hasClosure = true;
                this.hasFrameAwareMethods = true;
                this.hasScopeAwareMethods = true;
                this.inspect(preExeNode.getBodyNode());
                this.inspect(preExeNode.getVarNode());
                break;
            }
            case REDONODE: {
                break;
            }
            case REGEXPNODE: {
                break;
            }
            case ROOTNODE: {
                BlockNode blockNode;
                this.inspect(((RootNode)node).getBodyNode());
                if (!(((RootNode)node).getBodyNode() instanceof BlockNode) || (blockNode = (BlockNode)((RootNode)node).getBodyNode()).size() <= 500) break;
                this.hasScopeAwareMethods = true;
                break;
            }
            case RESCUEBODYNODE: {
                this.disable();
                break;
            }
            case RESCUENODE: {
                this.disable();
                break;
            }
            case RETRYNODE: {
                this.disable();
                break;
            }
            case RETURNNODE: {
                this.inspect(((ReturnNode)node).getValueNode());
                break;
            }
            case SCLASSNODE: {
                this.hasClass = true;
                this.hasScopeAwareMethods = true;
                break;
            }
            case SCOPENODE: {
                break;
            }
            case SELFNODE: {
                break;
            }
            case SPLATNODE: {
                this.inspect(((SplatNode)node).getValue());
                break;
            }
            case STARNODE: {
                break;
            }
            case STRNODE: {
                break;
            }
            case SUPERNODE: {
                SuperNode superNode = (SuperNode)node;
                this.inspect(superNode.getArgsNode());
                this.inspect(superNode.getIterNode());
                break;
            }
            case SVALUENODE: {
                this.inspect(((SValueNode)node).getValue());
                break;
            }
            case SYMBOLNODE: {
                break;
            }
            case TOARYNODE: {
                this.inspect(((ToAryNode)node).getValue());
                break;
            }
            case TRUENODE: {
                break;
            }
            case UNDEFNODE: {
                this.hasScopeAwareMethods = true;
                break;
            }
            case UNTILNODE: {
                UntilNode untilNode = (UntilNode)node;
                ASTInspector untilInspector = ASTInspector.subInspect(untilNode.getConditionNode(), untilNode.getBodyNode());
                if (untilInspector.hasClosure || untilInspector.hasEval) {
                    untilNode.containsNonlocalFlow = true;
                }
                this.hasScopeAwareMethods = true;
                break;
            }
            case VALIASNODE: {
                break;
            }
            case WHENNODE: {
                this.inspect(((WhenNode)node).getBodyNode());
                this.inspect(((WhenNode)node).getExpressionNodes());
                this.inspect(((WhenNode)node).getNextCase());
                break;
            }
            case WHILENODE: {
                WhileNode whileNode = (WhileNode)node;
                ASTInspector whileInspector = ASTInspector.subInspect(whileNode.getConditionNode(), whileNode.getBodyNode());
                if (whileInspector.hasClosure || whileInspector.hasEval || this.hasBlockArg) {
                    whileNode.containsNonlocalFlow = true;
                    this.hasScopeAwareMethods = true;
                }
                this.integrate(whileInspector);
                break;
            }
            case XSTRNODE: {
                break;
            }
            case YIELDNODE: {
                this.inspect(((YieldNode)node).getArgsNode());
                break;
            }
            case ZARRAYNODE: {
                break;
            }
            case ZEROARGNODE: {
                break;
            }
            case ZSUPERNODE: {
                this.hasScopeAwareMethods = true;
                this.hasFrameAwareMethods = true;
                this.inspect(((ZSuperNode)node).getIterNode());
                break;
            }
            default: {
                assert (false) : "All nodes should be accounted for in AST inspector: " + node;
                this.disable();
            }
        }
    }

    public boolean hasClass() {
        return this.hasClass;
    }

    public boolean hasClosure() {
        return this.hasClosure;
    }

    public boolean hasDef() {
        return this.hasDef;
    }

    public boolean hasFrameAwareMethods() {
        return this.hasFrameAwareMethods;
    }

    public boolean hasScopeAwareMethods() {
        return this.hasScopeAwareMethods;
    }

    public boolean hasBlockArg() {
        return this.hasBlockArg;
    }

    public boolean hasOptArgs() {
        return this.hasOptArgs;
    }

    public boolean hasRestArg() {
        return this.hasRestArg;
    }

    public boolean noFrame() {
        return this.noFrame;
    }

    static {
        FRAME_AWARE_METHODS.add("eval");
        FRAME_AWARE_METHODS.add("module_eval");
        FRAME_AWARE_METHODS.add("class_eval");
        FRAME_AWARE_METHODS.add("instance_eval");
        FRAME_AWARE_METHODS.add("binding");
        FRAME_AWARE_METHODS.add("public");
        FRAME_AWARE_METHODS.add("private");
        FRAME_AWARE_METHODS.add("protected");
        FRAME_AWARE_METHODS.add("module_function");
        FRAME_AWARE_METHODS.add("block_given?");
        FRAME_AWARE_METHODS.add("iterator?");
        SCOPE_AWARE_METHODS.add("eval");
        SCOPE_AWARE_METHODS.add("module_eval");
        SCOPE_AWARE_METHODS.add("class_eval");
        SCOPE_AWARE_METHODS.add("instance_eval");
        SCOPE_AWARE_METHODS.add("binding");
        SCOPE_AWARE_METHODS.add("local_variables");
        PRAGMAS.add("__NOFRAME__");
        ENABLED = SafePropertyAccessor.getProperty("jruby.astInspector.enabled", "true").equals("true");
    }
}

